
/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;
DROP TABLE IF EXISTS `account_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_transactions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `account_id` int NOT NULL,
  `type` enum('debit','credit') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sub_type` enum('opening_balance','fund_transfer','deposit') CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `amount` decimal(22,4) NOT NULL,
  `reff_no` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `operation_date` datetime NOT NULL,
  `created_by` int NOT NULL,
  `transaction_id` int DEFAULT NULL,
  `transaction_payment_id` int DEFAULT NULL,
  `transfer_transaction_id` int DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_transactions_account_id_index` (`account_id`),
  KEY `account_transactions_transaction_id_index` (`transaction_id`),
  KEY `account_transactions_transaction_payment_id_index` (`transaction_payment_id`),
  KEY `account_transactions_transfer_transaction_id_index` (`transfer_transaction_id`),
  KEY `account_transactions_created_by_index` (`created_by`),
  KEY `account_transactions_type_index` (`type`),
  KEY `account_transactions_sub_type_index` (`sub_type`),
  KEY `account_transactions_operation_date_index` (`operation_date`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_transactions` WRITE;
/*!40000 ALTER TABLE `account_transactions` DISABLE KEYS */;
INSERT INTO `account_transactions` VALUES (1,1,'credit','opening_balance',500000.0000,NULL,'2023-05-29 18:40:23',1,NULL,NULL,NULL,NULL,NULL,'2023-05-29 12:40:23','2023-05-29 12:40:23'),(2,2,'credit','opening_balance',350000.0000,NULL,'2023-05-29 18:40:58',1,NULL,NULL,NULL,NULL,NULL,'2023-05-29 12:40:58','2023-05-29 12:40:58'),(3,3,'credit','opening_balance',180000.0000,NULL,'2023-05-29 18:41:34',1,NULL,NULL,NULL,NULL,NULL,'2023-05-29 12:41:34','2023-05-29 12:41:34'),(4,4,'credit','opening_balance',100000.0000,NULL,'2023-05-29 18:43:25',1,NULL,NULL,NULL,NULL,NULL,'2023-05-29 12:43:25','2023-05-29 12:43:25'),(5,4,'credit',NULL,1250.0000,NULL,'2023-05-29 16:54:00',1,471,3,NULL,NULL,NULL,'2023-05-29 12:44:09','2023-05-29 12:44:09'),(6,3,'debit',NULL,0.0000,NULL,'2023-05-29 16:48:23',1,10,2,NULL,NULL,NULL,'2023-05-29 12:44:42','2023-05-29 15:44:38'),(7,4,'credit',NULL,1400.0000,NULL,'2023-09-02 13:20:00',1,1053,445,NULL,NULL,NULL,'2024-08-24 16:06:43','2024-08-24 16:06:43'),(8,1,'credit',NULL,5000.0000,NULL,'2024-01-01 13:22:00',1,1609,1320,NULL,NULL,NULL,'2024-09-22 15:04:07','2024-09-22 15:04:07');
/*!40000 ALTER TABLE `account_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `account_types` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `parent_account_type_id` int DEFAULT NULL,
  `business_id` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `account_types_parent_account_type_id_index` (`parent_account_type_id`),
  KEY `account_types_business_id_index` (`business_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `account_types` WRITE;
/*!40000 ALTER TABLE `account_types` DISABLE KEYS */;
/*!40000 ALTER TABLE `account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_acc_trans_mappings`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_acc_trans_mappings` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int NOT NULL,
  `ref_no` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `created_by` int NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_acc_trans_mappings` WRITE;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_acc_trans_mappings` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_account_types`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_account_types` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `business_id` int DEFAULT NULL,
  `created_by` int DEFAULT NULL,
  `account_primary_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `parent_id` bigint DEFAULT NULL,
  `description` text COLLATE utf8mb4_unicode_ci,
  `show_balance` tinyint(1) NOT NULL DEFAULT '1',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=155 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_account_types` WRITE;
/*!40000 ALTER TABLE `accounting_account_types` DISABLE KEYS */;
INSERT INTO `accounting_account_types` VALUES (1,'accounts_receivable',NULL,NULL,'asset','sub_type',NULL,NULL,0,NULL,NULL),(2,'current_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(3,'cash_and_cash_equivalents',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(4,'fixed_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(5,'non_current_assets',NULL,NULL,'asset','sub_type',NULL,NULL,1,NULL,NULL),(6,'accounts_payable',NULL,NULL,'liability','sub_type',NULL,NULL,0,NULL,NULL),(7,'credit_card',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),(8,'current_liabilities',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),(9,'non_current_liabilities',NULL,NULL,'liability','sub_type',NULL,NULL,1,NULL,NULL),(10,'owners_equity',NULL,NULL,'equity','sub_type',NULL,NULL,1,NULL,NULL),(11,'income',NULL,NULL,'income','sub_type',NULL,NULL,0,NULL,NULL),(12,'other_income',NULL,NULL,'income','sub_type',NULL,NULL,0,NULL,NULL),(13,'cost_of_sale',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),(14,'expenses',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),(15,'other_expense',NULL,NULL,'expenses','sub_type',NULL,NULL,0,NULL,NULL),(16,'accounts_receivable',NULL,NULL,NULL,'detail_type',1,'',1,NULL,NULL),(17,'allowance_for_bad_debts',NULL,NULL,NULL,'detail_type',2,'allowance_for_bad_debts_desc',1,NULL,NULL),(18,'assets_available_for_sale',NULL,NULL,NULL,'detail_type',2,'assets_available_for_sale_desc',1,NULL,NULL),(19,'development_costs',NULL,NULL,NULL,'detail_type',2,'development_costs_desc',1,NULL,NULL),(20,'employee_cash_advances',NULL,NULL,NULL,'detail_type',2,'employee_cash_advances_desc',1,NULL,NULL),(21,'inventory',NULL,NULL,NULL,'detail_type',2,'inventory_desc',1,NULL,NULL),(22,'investments_-_other',NULL,NULL,NULL,'detail_type',2,'investments_-_other_desc',1,NULL,NULL),(23,'loans_to_officers',NULL,NULL,NULL,'detail_type',2,'loans_to_officers_desc',1,NULL,NULL),(24,'loans_to_others',NULL,NULL,NULL,'detail_type',2,'loans_to_others_desc',1,NULL,NULL),(25,'loans_to_shareholders',NULL,NULL,NULL,'detail_type',2,'loans_to_shareholders_desc',1,NULL,NULL),(26,'other_current_assets',NULL,NULL,NULL,'detail_type',2,'other_current_assets_desc',1,NULL,NULL),(27,'prepaid_expenses',NULL,NULL,NULL,'detail_type',2,'prepaid_expenses_desc',1,NULL,NULL),(28,'retainage',NULL,NULL,NULL,'detail_type',2,'retainage_desc',1,NULL,NULL),(29,'undeposited_funds',NULL,NULL,NULL,'detail_type',2,'undeposited_funds_desc',1,NULL,NULL),(30,'bank',NULL,NULL,NULL,'detail_type',3,'bank_desc',1,NULL,NULL),(31,'cash_and_cash_equivalents',NULL,NULL,NULL,'detail_type',3,'cash_and_cash_equivalents_desc',1,NULL,NULL),(32,'cash_on_hand',NULL,NULL,NULL,'detail_type',3,'cash_on_hand_desc',1,NULL,NULL),(33,'client_trust_account',NULL,NULL,NULL,'detail_type',3,'client_trust_account_desc',1,NULL,NULL),(34,'money_market',NULL,NULL,NULL,'detail_type',3,'money_market_desc',1,NULL,NULL),(35,'rents_held_in_trust',NULL,NULL,NULL,'detail_type',3,'rents_held_in_trust_desc',1,NULL,NULL),(36,'savings',NULL,NULL,NULL,'detail_type',3,'savings_desc',1,NULL,NULL),(37,'accumulated_depletion',NULL,NULL,NULL,'detail_type',4,'accumulated_depletion_desc',1,NULL,NULL),(38,'accumulated_depreciation_on_property,_plant_and_equipment',NULL,NULL,NULL,'detail_type',4,'accumulated_depreciation_on_property,_plant_and_equipment_desc',1,NULL,NULL),(39,'buildings',NULL,NULL,NULL,'detail_type',4,'buildings_desc',1,NULL,NULL),(40,'depletable_assets',NULL,NULL,NULL,'detail_type',4,'depletable_assets_desc',1,NULL,NULL),(41,'furniture_and_fixtures',NULL,NULL,NULL,'detail_type',4,'furniture_and_fixtures_desc',1,NULL,NULL),(42,'land',NULL,NULL,NULL,'detail_type',4,'land_desc',1,NULL,NULL),(43,'leasehold_improvements',NULL,NULL,NULL,'detail_type',4,'leasehold_improvements_desc',1,NULL,NULL),(44,'machinery_and_equipment',NULL,NULL,NULL,'detail_type',4,'machinery_and_equipment_desc',1,NULL,NULL),(45,'other_fixed_assets',NULL,NULL,NULL,'detail_type',4,'other_fixed_assets_desc',1,NULL,NULL),(46,'vehicles',NULL,NULL,NULL,'detail_type',4,'vehicles_desc',1,NULL,NULL),(47,'accumulated_amortisation_of_non-current_assets',NULL,NULL,NULL,'detail_type',5,'accumulated_amortisation_of_non-current_assets_desc',1,NULL,NULL),(48,'assets_held_for_sale',NULL,NULL,NULL,'detail_type',5,'assets_held_for_sale_desc',1,NULL,NULL),(49,'deferred_tax',NULL,NULL,NULL,'detail_type',5,'deferred_tax_desc',1,NULL,NULL),(50,'goodwill',NULL,NULL,NULL,'detail_type',5,'goodwill_desc',1,NULL,NULL),(51,'intangible_assets',NULL,NULL,NULL,'detail_type',5,'intangible_assets_desc',1,NULL,NULL),(52,'lease_buyout',NULL,NULL,NULL,'detail_type',5,'lease_buyout_desc',1,NULL,NULL),(53,'licences',NULL,NULL,NULL,'detail_type',5,'licences_desc',1,NULL,NULL),(54,'long-term_investments',NULL,NULL,NULL,'detail_type',5,'long-term_investments_desc',1,NULL,NULL),(55,'organisational_costs',NULL,NULL,NULL,'detail_type',5,'organisational_costs_desc',1,NULL,NULL),(56,'other_non-current_assets',NULL,NULL,NULL,'detail_type',5,'other_non-current_assets_desc',1,NULL,NULL),(57,'security_deposits',NULL,NULL,NULL,'detail_type',5,'security_deposits_desc',1,NULL,NULL),(58,'accounts_payable_(a/p)',NULL,NULL,NULL,'detail_type',6,'accounts_payable_(a/p)_desc',1,NULL,NULL),(59,'credit_card',NULL,NULL,NULL,'detail_type',7,'credit_card_desc',1,NULL,NULL),(60,'accrued_liabilities',NULL,NULL,NULL,'detail_type',8,'accrued_liabilities_desc',1,NULL,NULL),(61,'client_trust_accounts_-_liabilities',NULL,NULL,NULL,'detail_type',8,'client_trust_accounts_-_liabilities_desc',1,NULL,NULL),(62,'current_tax_liability',NULL,NULL,NULL,'detail_type',8,'current_tax_liability_desc',1,NULL,NULL),(63,'current_portion_of_obligations_under_finance_leases',NULL,NULL,NULL,'detail_type',8,'current_portion_of_obligations_under_finance_leases_desc',1,NULL,NULL),(64,'dividends_payable',NULL,NULL,NULL,'detail_type',8,'dividends_payable_desc',1,NULL,NULL),(65,'income_tax_payable',NULL,NULL,NULL,'detail_type',8,'income_tax_payable_desc',1,NULL,NULL),(66,'insurance_payable',NULL,NULL,NULL,'detail_type',8,'insurance_payable_desc',1,NULL,NULL),(67,'line_of_credit',NULL,NULL,NULL,'detail_type',8,'line_of_credit_desc',1,NULL,NULL),(68,'loan_payable',NULL,NULL,NULL,'detail_type',8,'loan_payable_desc',1,NULL,NULL),(69,'other_current_liabilities',NULL,NULL,NULL,'detail_type',8,'other_current_liabilities_desc',1,NULL,NULL),(70,'payroll_clearing',NULL,NULL,NULL,'detail_type',8,'payroll_clearing_desc',1,NULL,NULL),(71,'payroll_liabilities',NULL,NULL,NULL,'detail_type',8,'payroll_liabilities_desc',1,NULL,NULL),(72,'prepaid_expenses_payable',NULL,NULL,NULL,'detail_type',8,'prepaid_expenses_payable_desc',1,NULL,NULL),(73,'rents_in_trust_-_liability',NULL,NULL,NULL,'detail_type',8,'rents_in_trust_-_liability_desc',1,NULL,NULL),(74,'sales_and_service_tax_payable',NULL,NULL,NULL,'detail_type',8,'sales_and_service_tax_payable_desc',1,NULL,NULL),(75,'accrued_holiday_payable',NULL,NULL,NULL,'detail_type',9,'accrued_holiday_payable_desc',1,NULL,NULL),(76,'accrued_non-current_liabilities',NULL,NULL,NULL,'detail_type',9,'accrued_non-current_liabilities_desc',1,NULL,NULL),(77,'liabilities_related_to_assets_held_for_sale',NULL,NULL,NULL,'detail_type',9,'liabilities_related_to_assets_held_for_sale_desc',1,NULL,NULL),(78,'long-term_debt',NULL,NULL,NULL,'detail_type',9,'long-term_debt_desc',1,NULL,NULL),(79,'notes_payable',NULL,NULL,NULL,'detail_type',9,'notes_payable_desc',1,NULL,NULL),(80,'other_non-current_liabilities',NULL,NULL,NULL,'detail_type',9,'other_non-current_liabilities_desc',1,NULL,NULL),(81,'shareholder_notes_payable',NULL,NULL,NULL,'detail_type',9,'shareholder_notes_payable_desc',1,NULL,NULL),(82,'accumulated_adjustment',NULL,NULL,NULL,'detail_type',10,'accumulated_adjustment_desc',1,NULL,NULL),(83,'dividend_disbursed',NULL,NULL,NULL,'detail_type',10,'dividend_disbursed_desc',1,NULL,NULL),(84,'equity_in_earnings_of_subsidiaries',NULL,NULL,NULL,'detail_type',10,'equity_in_earnings_of_subsidiaries_desc',1,NULL,NULL),(85,'opening_balance_equity',NULL,NULL,NULL,'detail_type',10,'opening_balance_equity_desc',1,NULL,NULL),(86,'ordinary_shares',NULL,NULL,NULL,'detail_type',10,'ordinary_shares_desc',1,NULL,NULL),(87,'other_comprehensive_income',NULL,NULL,NULL,'detail_type',10,'other_comprehensive_income_desc',1,NULL,NULL),(88,'owner\'s_equity',NULL,NULL,NULL,'detail_type',10,'owner\'s_equity_desc',1,NULL,NULL),(89,'paid-in_capital_or_surplus',NULL,NULL,NULL,'detail_type',10,'paid-in_capital_or_surplus_desc',1,NULL,NULL),(90,'partner_contributions',NULL,NULL,NULL,'detail_type',10,'partner_contributions_desc',1,NULL,NULL),(91,'partner_distributions',NULL,NULL,NULL,'detail_type',10,'partner_distributions_desc',1,NULL,NULL),(92,'partner\'s_equity',NULL,NULL,NULL,'detail_type',10,'partner\'s_equity_desc',1,NULL,NULL),(93,'preferred_shares',NULL,NULL,NULL,'detail_type',10,'preferred_shares_desc',1,NULL,NULL),(94,'retained_earnings',NULL,NULL,NULL,'detail_type',10,'retained_earnings_desc',1,NULL,NULL),(95,'share_capital',NULL,NULL,NULL,'detail_type',10,'share_capital_desc',1,NULL,NULL),(96,'treasury_shares',NULL,NULL,NULL,'detail_type',10,'treasury_shares_desc',1,NULL,NULL),(97,'discounts/refunds_given',NULL,NULL,NULL,'detail_type',11,'discounts/refunds_given_desc',1,NULL,NULL),(98,'non-profit_income',NULL,NULL,NULL,'detail_type',11,'non-profit_income_desc',1,NULL,NULL),(99,'other_primary_income',NULL,NULL,NULL,'detail_type',11,'other_primary_income_desc',1,NULL,NULL),(100,'revenue_-_general',NULL,NULL,NULL,'detail_type',11,'revenue_-_general_desc',1,NULL,NULL),(101,'sales_-_retail',NULL,NULL,NULL,'detail_type',11,'sales_-_retail_desc',1,NULL,NULL),(102,'sales_-_wholesale',NULL,NULL,NULL,'detail_type',11,'sales_-_wholesale_desc',1,NULL,NULL),(103,'sales_of_product_income',NULL,NULL,NULL,'detail_type',11,'sales_of_product_income_desc',1,NULL,NULL),(104,'service/fee_income',NULL,NULL,NULL,'detail_type',11,'service/fee_income_desc',1,NULL,NULL),(105,'unapplied_cash_payment_income',NULL,NULL,NULL,'detail_type',11,'unapplied_cash_payment_income_desc',1,NULL,NULL),(106,'dividend_income',NULL,NULL,NULL,'detail_type',12,'dividend_income_desc',1,NULL,NULL),(107,'interest_earned',NULL,NULL,NULL,'detail_type',12,'interest_earned_desc',1,NULL,NULL),(108,'loss_on_disposal_of_assets',NULL,NULL,NULL,'detail_type',12,'loss_on_disposal_of_assets_desc',1,NULL,NULL),(109,'other_investment_income',NULL,NULL,NULL,'detail_type',12,'other_investment_income_desc',1,NULL,NULL),(110,'other_miscellaneous_income',NULL,NULL,NULL,'detail_type',12,'other_miscellaneous_income_desc',1,NULL,NULL),(111,'other_operating_income',NULL,NULL,NULL,'detail_type',12,'other_operating_income_desc',1,NULL,NULL),(112,'tax-exempt_interest',NULL,NULL,NULL,'detail_type',12,'tax-exempt_interest_desc',1,NULL,NULL),(113,'unrealised_loss_on_securities,_net_of_tax',NULL,NULL,NULL,'detail_type',12,'unrealised_loss_on_securities,_net_of_tax_desc',1,NULL,NULL),(114,'cost_of_labour_-_cos',NULL,NULL,NULL,'detail_type',13,'cost_of_labour_-_cos_desc',1,NULL,NULL),(115,'equipment_rental_-_cos',NULL,NULL,NULL,'detail_type',13,'equipment_rental_-_cos_desc',1,NULL,NULL),(116,'freight_and_delivery_-_cos',NULL,NULL,NULL,'detail_type',13,'freight_and_delivery_-_cos_desc',1,NULL,NULL),(117,'other_costs_of_sales_-_cos',NULL,NULL,NULL,'detail_type',13,'other_costs_of_sales_-_cos_desc',1,NULL,NULL),(118,'supplies_and_materials_-_cos',NULL,NULL,NULL,'detail_type',13,'supplies_and_materials_-_cos_desc',1,NULL,NULL),(119,'advertising/promotional',NULL,NULL,NULL,'detail_type',14,'advertising/promotional_desc',1,NULL,NULL),(120,'amortisation_expense',NULL,NULL,NULL,'detail_type',14,'amortisation_expense_desc',1,NULL,NULL),(121,'auto',NULL,NULL,NULL,'detail_type',14,'auto_desc',1,NULL,NULL),(122,'bad_debts',NULL,NULL,NULL,'detail_type',14,'bad_debts_desc',1,NULL,NULL),(123,'bank_charges',NULL,NULL,NULL,'detail_type',14,'bank_charges_desc',1,NULL,NULL),(124,'charitable_contributions',NULL,NULL,NULL,'detail_type',14,'charitable_contributions_desc',1,NULL,NULL),(125,'commissions_and_fees',NULL,NULL,NULL,'detail_type',14,'commissions_and_fees_desc',1,NULL,NULL),(126,'cost_of_labour',NULL,NULL,NULL,'detail_type',14,'cost_of_labour_desc',1,NULL,NULL),(127,'dues_and_subscriptions',NULL,NULL,NULL,'detail_type',14,'dues_and_subscriptions_desc',1,NULL,NULL),(128,'equipment_rental',NULL,NULL,NULL,'detail_type',14,'equipment_rental_desc',1,NULL,NULL),(129,'finance_costs',NULL,NULL,NULL,'detail_type',14,'finance_costs_desc',1,NULL,NULL),(130,'income_tax_expense',NULL,NULL,NULL,'detail_type',14,'income_tax_expense_desc',1,NULL,NULL),(131,'insurance',NULL,NULL,NULL,'detail_type',14,'insurance_desc',1,NULL,NULL),(132,'interest_paid',NULL,NULL,NULL,'detail_type',14,'interest_paid_desc',1,NULL,NULL),(133,'legal_and_professional_fees',NULL,NULL,NULL,'detail_type',14,'legal_and_professional_fees_desc',1,NULL,NULL),(134,'loss_on_discontinued_operations,_net_of_tax',NULL,NULL,NULL,'detail_type',14,'loss_on_discontinued_operations,_net_of_tax_desc',1,NULL,NULL),(135,'management_compensation',NULL,NULL,NULL,'detail_type',14,'management_compensation_desc',1,NULL,NULL),(136,'meals_and_entertainment',NULL,NULL,NULL,'detail_type',14,'meals_and_entertainment_desc',1,NULL,NULL),(137,'office/general_administrative_expenses',NULL,NULL,NULL,'detail_type',14,'office/general_administrative_expenses_desc',1,NULL,NULL),(138,'other_miscellaneous_service_cost',NULL,NULL,NULL,'detail_type',14,'other_miscellaneous_service_cost_desc',1,NULL,NULL),(139,'other_selling_expenses',NULL,NULL,NULL,'detail_type',14,'other_selling_expenses_desc',1,NULL,NULL),(140,'payroll_expenses',NULL,NULL,NULL,'detail_type',14,'payroll_expenses_desc',1,NULL,NULL),(141,'rent_or_lease_of_buildings',NULL,NULL,NULL,'detail_type',14,'rent_or_lease_of_buildings_desc',1,NULL,NULL),(142,'repair_and_maintenance',NULL,NULL,NULL,'detail_type',14,'repair_and_maintenance_desc',1,NULL,NULL),(143,'shipping_and_delivery_expense',NULL,NULL,NULL,'detail_type',14,'shipping_and_delivery_expense_desc',1,NULL,NULL),(144,'supplies_and_materials',NULL,NULL,NULL,'detail_type',14,'supplies_and_materials_desc',1,NULL,NULL),(145,'taxes_paid',NULL,NULL,NULL,'detail_type',14,'taxes_paid_desc',1,NULL,NULL),(146,'travel_expenses_-_general_and_admin_expenses',NULL,NULL,NULL,'detail_type',14,'travel_expenses_-_general_and_admin_expenses_desc',1,NULL,NULL),(147,'travel_expenses_-_selling_expense',NULL,NULL,NULL,'detail_type',14,'travel_expenses_-_selling_expense_desc',1,NULL,NULL),(148,'unapplied_cash_bill_payment_expense',NULL,NULL,NULL,'detail_type',14,'unapplied_cash_bill_payment_expense_desc',1,NULL,NULL),(149,'utilities',NULL,NULL,NULL,'detail_type',14,'utilities_desc',1,NULL,NULL),(150,'amortisation',NULL,NULL,NULL,'detail_type',15,'amortisation_desc',1,NULL,NULL),(151,'depreciation',NULL,NULL,NULL,'detail_type',15,'depreciation_desc',1,NULL,NULL),(152,'exchange_gain_or_loss',NULL,NULL,NULL,'detail_type',15,'exchange_gain_or_loss_desc',1,NULL,NULL),(153,'other_expense',NULL,NULL,NULL,'detail_type',15,'other_expense_desc',1,NULL,NULL),(154,'penalties_and_settlements',NULL,NULL,NULL,'detail_type',15,'penalties_and_settlements_desc',1,NULL,NULL);
/*!40000 ALTER TABLE `accounting_account_types` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_accounts` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(191) COLLATE utf8mb4_unicode_ci NOT NULL,
  `gl_code` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int NOT NULL,
  `account_primary_type` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `account_sub_type_id` bigint DEFAULT NULL,
  `detail_type_id` bigint DEFAULT NULL,
  `parent_account_id` bigint DEFAULT NULL,
  `description` longtext COLLATE utf8mb4_unicode_ci,
  `status` varchar(191) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts` WRITE;
/*!40000 ALTER TABLE `accounting_accounts` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_accounts_transactions`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_accounts_transactions` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint unsigned NOT NULL,
  `acc_trans_mapping_id` int DEFAULT NULL COMMENT 'id form accounting_acc_trans_mapping table',
  `transaction_id` int DEFAULT NULL COMMENT 'id form transactions table',
  `transaction_payment_id` int DEFAULT NULL COMMENT 'id form transaction_payments table',
  `amount` decimal(22,4) NOT NULL,
  `type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'debit, credit etc',
  `sub_type` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `map_type` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_by` int NOT NULL,
  `operation_date` datetime NOT NULL,
  `note` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_accounts_transactions` WRITE;
/*!40000 ALTER TABLE `accounting_accounts_transactions` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_accounts_transactions` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounting_budgets`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounting_budgets` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `accounting_account_id` bigint unsigned NOT NULL,
  `financial_year` int NOT NULL,
  `jan` decimal(22,4) DEFAULT NULL,
  `feb` decimal(22,4) DEFAULT NULL,
  `mar` decimal(22,4) DEFAULT NULL,
  `apr` decimal(22,4) DEFAULT NULL,
  `may` decimal(22,4) DEFAULT NULL,
  `jun` decimal(22,4) DEFAULT NULL,
  `jul` decimal(22,4) DEFAULT NULL,
  `aug` decimal(22,4) DEFAULT NULL,
  `sep` decimal(22,4) DEFAULT NULL,
  `oct` decimal(22,4) DEFAULT NULL,
  `nov` decimal(22,4) DEFAULT NULL,
  `dec` decimal(22,4) DEFAULT NULL,
  `quarter_1` decimal(22,4) DEFAULT NULL,
  `quarter_2` decimal(22,4) DEFAULT NULL,
  `quarter_3` decimal(22,4) DEFAULT NULL,
  `quarter_4` decimal(22,4) DEFAULT NULL,
  `yearly` decimal(22,4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounting_budgets` WRITE;
/*!40000 ALTER TABLE `accounting_budgets` DISABLE KEYS */;
/*!40000 ALTER TABLE `accounting_budgets` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `accounts`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `accounts` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `business_id` int NOT NULL,
  `name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_number` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `account_details` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `account_type_id` int DEFAULT NULL,
  `note` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `created_by` int NOT NULL,
  `is_closed` tinyint(1) NOT NULL DEFAULT '0',
  `deleted_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `accounts_business_id_index` (`business_id`),
  KEY `accounts_account_type_id_index` (`account_type_id`),
  KEY `accounts_created_by_index` (`created_by`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
INSERT INTO `accounts` VALUES (1,1,'IT Helpline','01822223636','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',0,NULL,1,0,NULL,'2023-05-29 12:40:22','2023-05-29 12:40:22'),(2,1,'Faysal Islam Rupu','01827122858','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',0,NULL,1,0,NULL,'2023-05-29 12:40:58','2023-05-29 12:40:58'),(3,1,'Friends Somity','01700990042','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',0,NULL,1,1,NULL,'2023-05-29 12:41:34','2024-05-01 08:49:55'),(4,1,'Hashem Vai','01711781723','[{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null},{\"label\":null,\"value\":null}]',0,NULL,1,0,NULL,'2023-05-29 12:43:25','2023-05-29 12:43:25');
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
DROP TABLE IF EXISTS `activity_log`;
/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!50503 SET character_set_client = utf8mb4 */;
CREATE TABLE `activity_log` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `log_name` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `subject_id` int DEFAULT NULL,
  `subject_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `event` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `business_id` int DEFAULT NULL,
  `causer_id` int DEFAULT NULL,
  `causer_type` varchar(191) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `properties` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `batch_uuid` char(36) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `activity_log_log_name_index` (`log_name`)
) ENGINE=InnoDB AUTO_INCREMENT=11260 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

LOCK TABLES `activity_log` WRITE;
/*!40000 ALTER TABLE `activity_log` DISABLE KEYS */;
INSERT INTO `activity_log` VALUES (1,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-28 11:08:45','2023-05-28 11:08:45'),(2,'default','added',2,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-28 11:33:49','2023-05-28 11:33:49'),(3,'default','added',10,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18800}}',NULL,'2023-05-28 11:46:05','2023-05-28 11:46:05'),(4,'default','imported',3,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(5,'default','imported',4,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(6,'default','imported',5,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(7,'default','imported',6,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(8,'default','imported',7,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(9,'default','imported',8,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(10,'default','imported',9,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(11,'default','imported',10,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(12,'default','imported',11,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(13,'default','imported',12,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(14,'default','imported',13,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(15,'default','imported',14,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(16,'default','imported',15,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(17,'default','imported',16,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(18,'default','imported',17,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(19,'default','imported',18,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(20,'default','imported',19,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(21,'default','imported',20,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(22,'default','imported',21,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(23,'default','imported',22,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(24,'default','imported',23,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(25,'default','imported',24,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(26,'default','imported',25,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(27,'default','imported',26,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(28,'default','imported',27,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(29,'default','imported',28,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(30,'default','imported',29,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(31,'default','imported',30,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(32,'default','imported',31,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(33,'default','imported',32,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(34,'default','imported',33,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(35,'default','imported',34,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(36,'default','imported',35,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(37,'default','imported',36,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(38,'default','imported',37,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(39,'default','imported',38,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(40,'default','imported',39,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(41,'default','imported',40,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(42,'default','imported',41,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(43,'default','imported',42,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(44,'default','imported',43,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(45,'default','imported',44,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(46,'default','imported',45,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(47,'default','imported',46,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(48,'default','imported',47,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(49,'default','imported',48,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(50,'default','imported',49,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(51,'default','imported',50,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(52,'default','imported',51,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(53,'default','imported',52,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(54,'default','imported',53,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(55,'default','imported',54,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(56,'default','imported',55,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(57,'default','imported',56,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(58,'default','imported',57,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(59,'default','imported',58,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(60,'default','imported',59,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(61,'default','imported',60,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(62,'default','imported',61,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(63,'default','imported',62,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(64,'default','imported',63,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(65,'default','imported',64,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(66,'default','imported',65,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(67,'default','imported',66,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(68,'default','imported',67,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(69,'default','imported',68,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(70,'default','imported',69,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(71,'default','imported',70,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(72,'default','imported',71,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(73,'default','imported',72,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(74,'default','imported',73,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(75,'default','imported',74,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(76,'default','imported',75,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(77,'default','imported',76,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(78,'default','imported',77,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(79,'default','imported',78,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(80,'default','imported',79,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(81,'default','imported',80,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(82,'default','imported',81,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(83,'default','imported',82,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(84,'default','imported',83,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(85,'default','imported',84,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(86,'default','imported',85,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(87,'default','imported',86,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(88,'default','imported',87,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(89,'default','imported',88,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(90,'default','imported',89,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(91,'default','imported',90,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(92,'default','imported',91,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(93,'default','imported',92,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(94,'default','imported',93,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(95,'default','imported',94,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(96,'default','imported',95,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(97,'default','imported',96,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(98,'default','imported',97,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(99,'default','imported',98,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(100,'default','imported',99,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(101,'default','imported',100,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(102,'default','imported',101,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(103,'default','imported',102,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(104,'default','imported',103,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(105,'default','imported',104,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(106,'default','imported',105,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(107,'default','imported',106,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(108,'default','imported',107,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(109,'default','imported',108,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(110,'default','imported',109,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(111,'default','imported',110,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(112,'default','imported',111,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(113,'default','imported',112,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(114,'default','imported',113,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(115,'default','imported',114,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(116,'default','imported',115,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(117,'default','imported',116,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(118,'default','imported',117,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(119,'default','imported',118,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(120,'default','imported',119,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(121,'default','imported',120,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(122,'default','imported',121,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(123,'default','imported',122,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(124,'default','imported',123,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(125,'default','imported',124,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(126,'default','imported',125,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(127,'default','imported',126,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(128,'default','imported',127,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(129,'default','imported',128,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(130,'default','imported',129,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(131,'default','imported',130,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(132,'default','imported',131,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(133,'default','imported',132,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(134,'default','imported',133,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(135,'default','imported',134,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(136,'default','imported',135,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(137,'default','imported',136,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(138,'default','imported',137,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(139,'default','imported',138,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(140,'default','imported',139,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(141,'default','imported',140,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(142,'default','imported',141,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(143,'default','imported',142,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(144,'default','imported',143,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(145,'default','imported',144,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(146,'default','imported',145,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(147,'default','imported',146,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(148,'default','imported',147,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(149,'default','imported',148,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(150,'default','imported',149,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(151,'default','imported',150,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(152,'default','imported',151,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(153,'default','imported',152,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(154,'default','imported',153,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(155,'default','imported',154,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(156,'default','imported',155,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(157,'default','imported',156,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(158,'default','imported',157,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(159,'default','imported',158,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:09','2023-05-29 09:55:09'),(160,'default','imported',159,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(161,'default','imported',160,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(162,'default','imported',161,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(163,'default','imported',162,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(164,'default','imported',163,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(165,'default','imported',164,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(166,'default','imported',165,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(167,'default','imported',166,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(168,'default','imported',167,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(169,'default','imported',168,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(170,'default','imported',169,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(171,'default','imported',170,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(172,'default','imported',171,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(173,'default','imported',172,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(174,'default','imported',173,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(175,'default','imported',174,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(176,'default','imported',175,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(177,'default','imported',176,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(178,'default','imported',177,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(179,'default','imported',178,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(180,'default','imported',179,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(181,'default','imported',180,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(182,'default','imported',181,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(183,'default','imported',182,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(184,'default','imported',183,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(185,'default','imported',184,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(186,'default','imported',185,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(187,'default','imported',186,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(188,'default','imported',187,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(189,'default','imported',188,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(190,'default','imported',189,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(191,'default','imported',190,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(192,'default','imported',191,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(193,'default','imported',192,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(194,'default','imported',193,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(195,'default','imported',194,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(196,'default','imported',195,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(197,'default','imported',196,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(198,'default','imported',197,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(199,'default','imported',198,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(200,'default','imported',199,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(201,'default','imported',200,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(202,'default','imported',201,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(203,'default','imported',202,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(204,'default','imported',203,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(205,'default','imported',204,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(206,'default','imported',205,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(207,'default','imported',206,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(208,'default','imported',207,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(209,'default','imported',208,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(210,'default','imported',209,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(211,'default','imported',210,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(212,'default','imported',211,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(213,'default','imported',212,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(214,'default','imported',213,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(215,'default','imported',214,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(216,'default','imported',215,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(217,'default','imported',216,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(218,'default','imported',217,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(219,'default','imported',218,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(220,'default','imported',219,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(221,'default','imported',220,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(222,'default','imported',221,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(223,'default','imported',222,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(224,'default','imported',223,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(225,'default','imported',224,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(226,'default','imported',225,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(227,'default','imported',226,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(228,'default','imported',227,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(229,'default','imported',228,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(230,'default','imported',229,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(231,'default','imported',230,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(232,'default','imported',231,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(233,'default','imported',232,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(234,'default','imported',233,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(235,'default','imported',234,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(236,'default','imported',235,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(237,'default','imported',236,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(238,'default','imported',237,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(239,'default','imported',238,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(240,'default','imported',239,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(241,'default','imported',240,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(242,'default','imported',241,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(243,'default','imported',242,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(244,'default','imported',243,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(245,'default','imported',244,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(246,'default','imported',245,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(247,'default','imported',246,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(248,'default','imported',247,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(249,'default','imported',248,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(250,'default','imported',249,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(251,'default','imported',250,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(252,'default','imported',251,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(253,'default','imported',252,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(254,'default','imported',253,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(255,'default','imported',254,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(256,'default','imported',255,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(257,'default','imported',256,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(258,'default','imported',257,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(259,'default','imported',258,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(260,'default','imported',259,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(261,'default','imported',260,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(262,'default','imported',261,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(263,'default','imported',262,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(264,'default','imported',263,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(265,'default','imported',264,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(266,'default','imported',265,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(267,'default','imported',266,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(268,'default','imported',267,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(269,'default','imported',268,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(270,'default','imported',269,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(271,'default','imported',270,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(272,'default','imported',271,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(273,'default','imported',272,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(274,'default','imported',273,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(275,'default','imported',274,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(276,'default','imported',275,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(277,'default','imported',276,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(278,'default','imported',277,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(279,'default','imported',278,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(280,'default','imported',279,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(281,'default','imported',280,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(282,'default','imported',281,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(283,'default','imported',282,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(284,'default','imported',283,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(285,'default','imported',284,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(286,'default','imported',285,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(287,'default','imported',286,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(288,'default','imported',287,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(289,'default','imported',288,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(290,'default','imported',289,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(291,'default','imported',290,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(292,'default','imported',291,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(293,'default','imported',292,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(294,'default','imported',293,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(295,'default','imported',294,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(296,'default','imported',295,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(297,'default','imported',296,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(298,'default','imported',297,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(299,'default','imported',298,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(300,'default','imported',299,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(301,'default','imported',300,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(302,'default','imported',301,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(303,'default','imported',302,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(304,'default','imported',303,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(305,'default','imported',304,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(306,'default','imported',305,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(307,'default','imported',306,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(308,'default','imported',307,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(309,'default','imported',308,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(310,'default','imported',309,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(311,'default','imported',310,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(312,'default','imported',311,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(313,'default','imported',312,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(314,'default','imported',313,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(315,'default','imported',314,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(316,'default','imported',315,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(317,'default','imported',316,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(318,'default','imported',317,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(319,'default','imported',318,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(320,'default','imported',319,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(321,'default','imported',320,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(322,'default','imported',321,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(323,'default','imported',322,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(324,'default','imported',323,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(325,'default','imported',324,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(326,'default','imported',325,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(327,'default','imported',326,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(328,'default','imported',327,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(329,'default','imported',328,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(330,'default','imported',329,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(331,'default','imported',330,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(332,'default','imported',331,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(333,'default','imported',332,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(334,'default','imported',333,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(335,'default','imported',334,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(336,'default','imported',335,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(337,'default','imported',336,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(338,'default','imported',337,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(339,'default','imported',338,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(340,'default','imported',339,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(341,'default','imported',340,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(342,'default','imported',341,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(343,'default','imported',342,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(344,'default','imported',343,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(345,'default','imported',344,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(346,'default','imported',345,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(347,'default','imported',346,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(348,'default','imported',347,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(349,'default','imported',348,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(350,'default','imported',349,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(351,'default','imported',350,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(352,'default','imported',351,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(353,'default','imported',352,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(354,'default','imported',353,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(355,'default','imported',354,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(356,'default','imported',355,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(357,'default','imported',356,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(358,'default','imported',357,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(359,'default','imported',358,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(360,'default','imported',359,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(361,'default','imported',360,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(362,'default','imported',361,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(363,'default','imported',362,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(364,'default','imported',363,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(365,'default','imported',364,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(366,'default','imported',365,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(367,'default','imported',366,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(368,'default','imported',367,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(369,'default','imported',368,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(370,'default','imported',369,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(371,'default','imported',370,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(372,'default','imported',371,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(373,'default','imported',372,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(374,'default','imported',373,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(375,'default','imported',374,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(376,'default','imported',375,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(377,'default','imported',376,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(378,'default','imported',377,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(379,'default','imported',378,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(380,'default','imported',379,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(381,'default','imported',380,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(382,'default','imported',381,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(383,'default','imported',382,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(384,'default','imported',383,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(385,'default','imported',384,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(386,'default','imported',385,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(387,'default','imported',386,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(388,'default','imported',387,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(389,'default','imported',388,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(390,'default','imported',389,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(391,'default','imported',390,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(392,'default','imported',391,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(393,'default','imported',392,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(394,'default','imported',393,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(395,'default','imported',394,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(396,'default','imported',395,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(397,'default','imported',396,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(398,'default','imported',397,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(399,'default','imported',398,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(400,'default','imported',399,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(401,'default','imported',400,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(402,'default','imported',401,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(403,'default','imported',402,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(404,'default','imported',403,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(405,'default','imported',404,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(406,'default','imported',405,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(407,'default','imported',406,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(408,'default','imported',407,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(409,'default','imported',408,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(410,'default','imported',409,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(411,'default','imported',410,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(412,'default','imported',411,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(413,'default','imported',412,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(414,'default','imported',413,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(415,'default','imported',414,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(416,'default','imported',415,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(417,'default','imported',416,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(418,'default','imported',417,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(419,'default','imported',418,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(420,'default','imported',419,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(421,'default','imported',420,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(422,'default','imported',421,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(423,'default','imported',422,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(424,'default','imported',423,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(425,'default','imported',424,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(426,'default','imported',425,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(427,'default','imported',426,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(428,'default','imported',427,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(429,'default','imported',428,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(430,'default','imported',429,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(431,'default','imported',430,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(432,'default','imported',431,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(433,'default','imported',432,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(434,'default','imported',433,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(435,'default','imported',434,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(436,'default','imported',435,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:10','2023-05-29 09:55:10'),(437,'default','imported',436,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(438,'default','imported',437,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(439,'default','imported',438,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(440,'default','imported',439,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(441,'default','imported',440,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(442,'default','imported',441,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(443,'default','imported',442,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(444,'default','imported',443,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(445,'default','imported',444,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(446,'default','imported',445,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(447,'default','imported',446,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(448,'default','imported',447,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(449,'default','imported',448,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(450,'default','imported',449,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(451,'default','imported',450,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(452,'default','imported',451,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(453,'default','imported',452,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(454,'default','imported',453,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(455,'default','imported',454,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(456,'default','imported',455,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(457,'default','imported',456,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(458,'default','imported',457,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(459,'default','imported',458,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(460,'default','imported',459,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(461,'default','imported',460,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(462,'default','imported',461,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(463,'default','imported',462,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(464,'default','imported',463,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(465,'default','imported',464,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(466,'default','imported',465,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(467,'default','imported',466,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(468,'default','imported',467,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(469,'default','imported',468,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(470,'default','imported',469,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(471,'default','imported',470,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(472,'default','imported',471,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(473,'default','imported',472,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(474,'default','imported',473,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(475,'default','imported',474,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(476,'default','imported',475,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(477,'default','imported',476,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(478,'default','imported',477,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(479,'default','imported',478,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(480,'default','imported',479,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(481,'default','imported',480,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(482,'default','imported',481,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(483,'default','imported',482,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(484,'default','imported',483,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(485,'default','imported',484,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(486,'default','imported',485,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(487,'default','imported',486,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(488,'default','imported',487,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(489,'default','imported',488,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(490,'default','imported',489,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(491,'default','imported',490,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(492,'default','imported',491,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(493,'default','imported',492,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(494,'default','imported',493,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 09:55:11','2023-05-29 09:55:11'),(495,'default','added',2,'App\\User',NULL,1,1,'App\\User','{\"name\":\" Abdul Ahad Sumon\"}',NULL,'2023-05-29 10:17:54','2023-05-29 10:17:54'),(496,'default','edited',10,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16550},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"18800.0000\"}}',NULL,'2023-05-29 10:48:23','2023-05-29 10:48:23'),(497,'default','added',471,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-05-29 10:56:26','2023-05-29 10:56:26'),(498,'default','added',494,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 10:57:26','2023-05-29 10:57:26'),(499,'default','edited',471,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1250.0000\"}}',NULL,'2023-05-29 10:57:40','2023-05-29 10:57:40'),(500,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-05-29 11:08:52','2023-05-29 11:08:52'),(501,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-05-29 14:24:07','2023-05-29 14:24:07'),(502,'default','added',495,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-05-29 15:31:57','2023-05-29 15:31:57'),(503,'default','added',472,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2025}}',NULL,'2023-05-29 15:34:37','2023-05-29 15:34:37'),(504,'default','edited',10,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"16550.0000\"}}',NULL,'2023-05-29 15:44:38','2023-05-29 15:44:38'),(505,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-05-30 03:46:23','2023-05-30 03:46:23'),(506,'default','added',473,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":18300}}',NULL,'2023-05-30 03:50:12','2023-05-30 03:50:12'),(507,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-05-30 04:06:06','2023-05-30 04:06:06'),(508,'default','added',474,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5100}}',NULL,'2023-05-30 07:56:12','2023-05-30 07:56:12'),(509,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-05-30 08:06:15','2023-05-30 08:06:15'),(510,'default','added',475,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2100}}',NULL,'2023-05-30 08:08:06','2023-05-30 08:08:06'),(511,'default','edited',475,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2100.0000\"}}',NULL,'2023-05-30 08:08:34','2023-05-30 08:08:34'),(512,'default','added',476,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-05-30 09:22:55','2023-05-30 09:22:55'),(513,'default','added',477,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5}}',NULL,'2023-05-30 09:23:58','2023-05-30 09:23:58'),(514,'default','edited',386,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-30 09:27:10','2023-05-30 09:27:10'),(515,'default','edited',261,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-30 09:27:28','2023-05-30 09:27:28'),(516,'default','edited',385,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-30 09:27:43','2023-05-30 09:27:43'),(517,'default','edited',217,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-30 09:27:57','2023-05-30 09:27:57'),(518,'default','added',478,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2}}',NULL,'2023-05-30 09:37:09','2023-05-30 09:37:09'),(519,'default','added',480,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-05-30 10:12:20','2023-05-30 10:12:20'),(520,'default','edited',480,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2750.0000\"}}',NULL,'2023-05-30 10:33:26','2023-05-30 10:33:26'),(521,'default','added',496,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-30 14:10:26','2023-05-30 14:10:26'),(522,'default','added',481,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3700}}',NULL,'2023-05-30 14:12:56','2023-05-30 14:12:56'),(523,'default','edited',481,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3700.0000\"}}',NULL,'2023-05-30 14:14:07','2023-05-30 14:14:07'),(524,'default','payment_edited',480,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2750.0000\"}}',NULL,'2023-05-30 14:32:47','2023-05-30 14:32:47'),(525,'default','edited',480,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2750.0000\"}}',NULL,'2023-05-30 14:33:11','2023-05-30 14:33:11'),(526,'default','added',482,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-05-30 16:17:19','2023-05-30 16:17:19'),(527,'default','added',497,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-31 06:35:39','2023-05-31 06:35:39'),(528,'default','added',483,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1550}}',NULL,'2023-05-31 06:36:50','2023-05-31 06:36:50'),(529,'default','added',484,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-05-31 08:23:49','2023-05-31 08:23:49'),(530,'default','added',485,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2750}}',NULL,'2023-05-31 09:58:56','2023-05-31 09:58:56'),(531,'default','added',498,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-05-31 13:34:17','2023-05-31 13:34:17'),(532,'default','added',486,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4148}}',NULL,'2023-05-31 13:36:55','2023-05-31 13:36:55'),(533,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-01 05:30:11','2023-06-01 05:30:11'),(534,'default','added',487,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":1248}}',NULL,'2023-06-01 05:31:33','2023-06-01 05:31:33'),(535,'default','payment_edited',487,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"1248.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"1248.0000\"}}',NULL,'2023-06-01 05:38:33','2023-06-01 05:38:33'),(536,'default','added',488,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-06-01 06:36:46','2023-06-01 06:36:46'),(537,'default','sell_deleted',488,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":488,\"invoice_no\":\"ITH2023-11016\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-06-01 06:37:27','2023-06-01 06:37:27'),(538,'default','added',489,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2620}}',NULL,'2023-06-01 09:31:08','2023-06-01 09:31:08'),(539,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-06-01 09:32:37','2023-06-01 09:32:37'),(540,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-06-01 09:37:04','2023-06-01 09:37:04'),(541,'default','payment_edited',474,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5100.0000\"}}',NULL,'2023-06-01 10:53:01','2023-06-01 10:53:01'),(542,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-01 15:34:57','2023-06-01 15:34:57'),(543,'default','added',499,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-06-01 15:39:21','2023-06-01 15:39:21'),(544,'default','added',500,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-06-01 15:40:21','2023-06-01 15:40:21'),(545,'default','added',490,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-06-01 15:42:00','2023-06-01 15:42:00'),(546,'default','added',491,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4300}}',NULL,'2023-06-03 06:55:35','2023-06-03 06:55:35'),(547,'default','edited',491,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4300.0000\"}}',NULL,'2023-06-03 06:56:01','2023-06-03 06:56:01'),(548,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-03 14:42:20','2023-06-03 14:42:20'),(549,'default','added',492,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-06-03 14:51:46','2023-06-03 14:51:46'),(550,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-03 14:52:23','2023-06-03 14:52:23'),(551,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-03 15:14:41','2023-06-03 15:14:41'),(552,'default','added',501,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-06-03 15:23:29','2023-06-03 15:23:29'),(553,'default','added',493,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1360}}',NULL,'2023-06-03 15:25:06','2023-06-03 15:25:06'),(554,'default','added',494,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-06-04 06:27:53','2023-06-04 06:27:53'),(555,'default','added',495,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1100}}',NULL,'2023-06-04 06:51:13','2023-06-04 06:51:13'),(556,'default','added',502,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-04 07:33:40','2023-06-04 07:33:40'),(557,'default','added',496,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":32590}}',NULL,'2023-06-04 07:54:50','2023-06-04 07:54:50'),(558,'default','edited',496,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":32590},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"32590.0000\"}}',NULL,'2023-06-04 07:59:33','2023-06-04 07:59:33'),(559,'default','edited',496,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":32990},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"32590.0000\"}}',NULL,'2023-06-04 08:02:47','2023-06-04 08:02:47'),(560,'default','payment_edited',495,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1100.0000\"}}',NULL,'2023-06-04 10:08:21','2023-06-04 10:08:21'),(561,'default','added',497,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-06-04 14:36:37','2023-06-04 14:36:37'),(562,'default','added',499,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-06-04 17:13:47','2023-06-04 17:13:47'),(563,'default','payment_edited',499,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-06-04 17:15:47','2023-06-04 17:15:47'),(564,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-05 04:48:29','2023-06-05 04:48:29'),(565,'default','added',500,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3250}}',NULL,'2023-06-05 04:53:32','2023-06-05 04:53:32'),(566,'default','added',503,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-05 06:11:28','2023-06-05 06:11:28'),(567,'default','added',501,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":20700}}',NULL,'2023-06-05 06:18:15','2023-06-05 06:18:15'),(568,'default','edited',501,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":19950},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"20700.0000\"}}',NULL,'2023-06-05 08:12:33','2023-06-05 08:12:33'),(569,'default','edited',501,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":19875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"19950.0000\"}}',NULL,'2023-06-05 08:18:04','2023-06-05 08:18:04'),(570,'default','payment_edited',501,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"19875.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"19875.0000\"}}',NULL,'2023-06-05 08:25:04','2023-06-05 08:25:04'),(571,'default','edited',501,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":19875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"19875.0000\"}}',NULL,'2023-06-05 08:25:52','2023-06-05 08:25:52'),(572,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-05 09:10:04','2023-06-05 09:10:04'),(573,'default','edited',440,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-06 05:26:47','2023-06-06 05:26:47'),(574,'default','added',503,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1400}}',NULL,'2023-06-06 15:43:44','2023-06-06 15:43:44'),(575,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-06 15:57:05','2023-06-06 15:57:05'),(576,'default','added',504,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-06 18:16:40','2023-06-06 18:16:40'),(577,'default','added',504,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-06-06 18:17:53','2023-06-06 18:17:53'),(578,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-07 05:41:47','2023-06-07 05:41:47'),(579,'default','added',505,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000}}',NULL,'2023-06-07 05:43:27','2023-06-07 05:43:27'),(580,'default','added',505,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-07 08:05:15','2023-06-07 08:05:15'),(581,'default','added',506,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3200}}',NULL,'2023-06-07 08:06:31','2023-06-07 08:06:31'),(582,'default','added',506,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-07 17:50:35','2023-06-07 17:50:35'),(583,'default','added',507,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-06-07 17:51:13','2023-06-07 17:51:13'),(584,'default','edited',505,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1000.0000\"}}',NULL,'2023-06-07 18:19:21','2023-06-07 18:19:21'),(585,'default','payment_edited',505,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-06-07 18:19:37','2023-06-07 18:19:37'),(586,'default','payment_edited',494,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-06-07 18:20:16','2023-06-07 18:20:16'),(587,'default','payment_edited',491,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4300.0000\"}}',NULL,'2023-06-07 18:20:37','2023-06-07 18:20:37'),(588,'default','payment_edited',474,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5100.0000\"}}',NULL,'2023-06-07 18:21:16','2023-06-07 18:21:16'),(589,'default','payment_edited',476,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1.0000\"}}',NULL,'2023-06-07 18:21:40','2023-06-07 18:21:40'),(590,'default','edited',505,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"}}',NULL,'2023-06-07 18:28:35','2023-06-07 18:28:35'),(591,'default','added',507,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-08 06:16:41','2023-06-08 06:16:41'),(592,'default','added',508,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-06-08 06:19:53','2023-06-08 06:19:53'),(593,'default','added',508,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-08 06:39:06','2023-06-08 06:39:06'),(594,'default','added',509,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5500}}',NULL,'2023-06-08 06:41:23','2023-06-08 06:41:23'),(595,'default','edited',509,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5500.0000\"}}',NULL,'2023-06-08 06:42:26','2023-06-08 06:42:26'),(596,'default','edited',509,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6125},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6100.0000\"}}',NULL,'2023-06-08 07:08:32','2023-06-08 07:08:32'),(597,'default','edited',509,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12050},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6125.0000\"}}',NULL,'2023-06-08 14:51:46','2023-06-08 14:51:46'),(598,'default','edited',509,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"12050.0000\"}}',NULL,'2023-06-08 14:53:33','2023-06-08 14:53:33'),(599,'default','payment_edited',509,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11900.0000\"}}',NULL,'2023-06-08 14:53:46','2023-06-08 14:53:46'),(600,'default','payment_edited',500,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3250.0000\"}}',NULL,'2023-06-08 15:39:11','2023-06-08 15:39:11'),(601,'default','added',510,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-06-10 12:46:24','2023-06-10 12:46:24'),(602,'default','added',511,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-06-10 13:30:54','2023-06-10 13:30:54'),(603,'default','edited',511,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"}}',NULL,'2023-06-10 13:31:30','2023-06-10 13:31:30'),(604,'default','added',512,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1800}}',NULL,'2023-06-10 15:28:00','2023-06-10 15:28:00'),(605,'default','added',513,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4800}}',NULL,'2023-06-10 15:30:20','2023-06-10 15:30:20'),(606,'default','added',514,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-06-10 16:22:58','2023-06-10 16:22:58'),(607,'default','payment_edited',512,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1800.0000\"}}',NULL,'2023-06-10 16:46:27','2023-06-10 16:46:27'),(608,'default','added',515,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1350}}',NULL,'2023-06-11 06:40:43','2023-06-11 06:40:43'),(609,'default','edited',515,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1350.0000\"}}',NULL,'2023-06-11 06:41:24','2023-06-11 06:41:24'),(610,'default','edited',515,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1950.0000\"}}',NULL,'2023-06-11 06:59:31','2023-06-11 06:59:31'),(611,'default','added',516,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":31221}}',NULL,'2023-06-11 07:20:55','2023-06-11 07:20:55'),(612,'default','added',517,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2900}}',NULL,'2023-06-11 07:36:20','2023-06-11 07:36:20'),(613,'default','edited',515,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2023-06-11 09:23:37','2023-06-11 09:23:37'),(614,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-11 10:42:54','2023-06-11 10:42:54'),(615,'default','added',509,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-06-11 10:44:52','2023-06-11 10:44:52'),(616,'default','added',510,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-06-11 10:44:54','2023-06-11 10:44:54'),(617,'default','added',518,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-06-11 10:45:37','2023-06-11 10:45:37'),(618,'default','added',520,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5400}}',NULL,'2023-06-11 16:51:10','2023-06-11 16:51:10'),(619,'default','added',521,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2150}}',NULL,'2023-06-12 06:24:18','2023-06-12 06:24:18'),(620,'default','edited',496,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":62090},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"32990.0000\"}}',NULL,'2023-06-12 10:14:20','2023-06-12 10:14:20'),(621,'default','added',525,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2023-06-12 12:23:57','2023-06-12 12:23:57'),(622,'default','edited',525,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-06-12 12:25:51','2023-06-12 12:25:51'),(623,'default','edited',525,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-06-12 12:26:26','2023-06-12 12:26:26'),(624,'default','edited',525,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-06-12 12:27:28','2023-06-12 12:27:28'),(625,'default','edited',516,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":31323},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"31221.0000\"}}',NULL,'2023-06-12 13:09:23','2023-06-12 13:09:23'),(626,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-12 13:49:40','2023-06-12 13:49:40'),(627,'default','payment_edited',513,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4800.0000\"}}',NULL,'2023-06-12 13:56:16','2023-06-12 13:56:16'),(628,'default','payment_edited',525,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-06-12 13:59:39','2023-06-12 13:59:39'),(629,'default','edited',515,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4450},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3250.0000\"}}',NULL,'2023-06-12 14:00:32','2023-06-12 14:00:32'),(630,'default','added',526,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-06-12 14:10:36','2023-06-12 14:10:36'),(631,'default','added',527,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1350}}',NULL,'2023-06-12 14:13:02','2023-06-12 14:13:02'),(632,'default','edited',527,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1350.0000\"}}',NULL,'2023-06-12 14:13:58','2023-06-12 14:13:58'),(633,'default','payment_edited',485,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2750.0000\"}}',NULL,'2023-06-12 14:25:06','2023-06-12 14:25:06'),(634,'default','added',529,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-06-12 15:10:14','2023-06-12 15:10:14'),(635,'default','added',530,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-06-12 16:16:40','2023-06-12 16:16:40'),(636,'default','added',531,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300}}',NULL,'2023-06-13 06:14:57','2023-06-13 06:14:57'),(637,'default','edited',515,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4450.0000\"}}',NULL,'2023-06-13 08:56:58','2023-06-13 08:56:58'),(638,'default','payment_edited',503,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1400.0000\"}}',NULL,'2023-06-13 08:57:39','2023-06-13 08:57:39'),(639,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-13 09:32:54','2023-06-13 09:32:54'),(640,'default','added',532,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":640}}',NULL,'2023-06-13 09:35:24','2023-06-13 09:35:24'),(641,'default','edited',496,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":61890},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"62090.0000\"}}',NULL,'2023-06-13 12:47:47','2023-06-13 12:47:47'),(642,'default','added',533,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750}}',NULL,'2023-06-13 13:01:18','2023-06-13 13:01:18'),(643,'default','edited',533,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"750.0000\"}}',NULL,'2023-06-13 13:01:45','2023-06-13 13:01:45'),(644,'default','edited',533,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"800.0000\"}}',NULL,'2023-06-13 13:02:02','2023-06-13 13:02:02'),(645,'default','edited',533,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"800.0000\"}}',NULL,'2023-06-13 13:03:42','2023-06-13 13:03:42'),(646,'default','added',534,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3800}}',NULL,'2023-06-13 13:13:03','2023-06-13 13:13:03'),(647,'default','added',511,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-13 16:01:11','2023-06-13 16:01:12'),(648,'default','added',535,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-06-13 16:01:41','2023-06-13 16:01:41'),(649,'default','payment_edited',530,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-06-13 17:07:47','2023-06-13 17:07:47'),(650,'default','added',536,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-06-14 09:01:09','2023-06-14 09:01:09'),(651,'default','added',512,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-14 14:51:35','2023-06-14 14:51:36'),(652,'default','added',538,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-06-14 14:52:33','2023-06-14 14:52:33'),(653,'default','added',539,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":22600}}',NULL,'2023-06-14 15:01:43','2023-06-14 15:01:43'),(654,'default','payment_edited',517,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2900.0000\"}}',NULL,'2023-06-14 16:22:01','2023-06-14 16:22:01'),(655,'default','added',513,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-14 17:19:06','2023-06-14 17:19:08'),(656,'default','added',540,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2450}}',NULL,'2023-06-14 17:21:48','2023-06-14 17:21:48'),(657,'default','edited',539,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":22700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"22600.0000\"}}',NULL,'2023-06-14 17:43:28','2023-06-14 17:43:28'),(658,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-06-15 06:13:17','2023-06-15 06:13:17'),(659,'default','added',514,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-15 08:13:59','2023-06-15 08:13:59'),(660,'default','added',541,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-06-15 08:14:34','2023-06-15 08:14:34'),(661,'default','payment_edited',496,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"61890.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"61890.0000\"}}',NULL,'2023-06-15 08:16:34','2023-06-15 08:16:34'),(662,'default','added',543,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":91000}}',NULL,'2023-06-15 11:03:13','2023-06-15 11:03:13'),(663,'default','edited',543,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":94000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"91000.0000\"}}',NULL,'2023-06-15 11:04:14','2023-06-15 11:04:14'),(664,'default','added',515,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-15 12:06:33','2023-06-15 12:06:33'),(665,'default','added',544,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-06-15 12:07:43','2023-06-15 12:07:43'),(666,'default','edited',544,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"}}',NULL,'2023-06-15 12:08:31','2023-06-15 12:08:31'),(667,'default','added',545,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5}}',NULL,'2023-06-15 12:30:23','2023-06-15 12:30:23'),(668,'default','edited',531,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-06-15 13:31:52','2023-06-15 13:31:52'),(669,'default','edited',539,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":22700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"22700.0000\"}}',NULL,'2023-06-15 14:29:49','2023-06-15 14:29:49'),(670,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-15 14:33:28','2023-06-15 14:33:28'),(671,'default','payment_edited',483,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1550.0000\"}}',NULL,'2023-06-15 17:02:34','2023-06-15 17:02:34'),(672,'default','added',516,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-15 17:03:50','2023-06-15 17:03:50'),(673,'default','added',546,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":31280}}',NULL,'2023-06-15 17:22:12','2023-06-15 17:22:12'),(674,'default','payment_edited',546,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"31280.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"31280.0000\"}}',NULL,'2023-06-15 17:22:57','2023-06-15 17:22:57'),(675,'default','payment_edited',546,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"31280.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"31280.0000\"}}',NULL,'2023-06-15 17:23:39','2023-06-15 17:23:39'),(676,'default','edited',546,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":33480},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"31280.0000\"}}',NULL,'2023-06-15 17:28:39','2023-06-15 17:28:39'),(677,'default','added',547,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2023-06-15 17:35:30','2023-06-15 17:35:30'),(678,'default','added',548,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-06-15 18:12:58','2023-06-15 18:12:58'),(679,'default','edited',539,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":24750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"22700.0000\"}}',NULL,'2023-06-15 18:15:35','2023-06-15 18:15:35'),(680,'default','edited',516,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":32623},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"31323.0000\"}}',NULL,'2023-06-15 18:16:26','2023-06-15 18:16:26'),(681,'default','added',550,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2630}}',NULL,'2023-06-17 09:56:43','2023-06-17 09:56:43'),(682,'default','added',517,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-17 11:04:33','2023-06-17 11:04:33'),(683,'default','added',551,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":650}}',NULL,'2023-06-17 12:55:05','2023-06-17 12:55:05'),(684,'default','payment_edited',547,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-06-17 12:55:53','2023-06-17 12:55:53'),(685,'default','added',552,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4400}}',NULL,'2023-06-17 12:57:47','2023-06-17 12:57:47'),(686,'default','added',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":95800}}',NULL,'2023-06-17 14:48:40','2023-06-17 14:48:40'),(687,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":95800},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"95800.0000\"}}',NULL,'2023-06-17 15:19:59','2023-06-17 15:19:59'),(688,'default','added',556,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":850}}',NULL,'2023-06-17 15:21:18','2023-06-17 15:21:18'),(689,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":97000},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"95800.0000\"}}',NULL,'2023-06-17 15:24:17','2023-06-17 15:24:17'),(690,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":108400},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"97000.0000\"}}',NULL,'2023-06-17 15:44:26','2023-06-17 15:44:26'),(691,'default','added',557,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3410}}',NULL,'2023-06-17 15:47:58','2023-06-17 15:47:58'),(692,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":109400},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"108400.0000\"}}',NULL,'2023-06-17 15:57:31','2023-06-17 15:57:31'),(693,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":109400},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"109400.0000\"}}',NULL,'2023-06-17 16:00:51','2023-06-17 16:00:51'),(694,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-18 04:26:23','2023-06-18 04:26:23'),(695,'default','added',558,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":120}}',NULL,'2023-06-18 04:27:46','2023-06-18 04:27:46'),(696,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-18 04:27:58','2023-06-18 04:27:58'),(697,'default','added',559,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-06-18 05:44:36','2023-06-18 05:44:37'),(698,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-18 06:08:14','2023-06-18 06:08:14'),(699,'default','edited',496,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":61890},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"61890.0000\"}}',NULL,'2023-06-18 07:47:34','2023-06-18 07:47:34'),(700,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-18 08:53:35','2023-06-18 08:53:35'),(701,'default','edited',555,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":119900},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"109400.0000\"}}',NULL,'2023-06-18 09:01:57','2023-06-18 09:01:57'),(702,'default','added',560,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-06-18 09:04:48','2023-06-18 09:04:48'),(703,'default','edited',543,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":94000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"94000.0000\"}}',NULL,'2023-06-18 09:55:56','2023-06-18 09:55:56'),(704,'default','edited',559,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-06-18 10:03:51','2023-06-18 10:03:51'),(705,'default','added',561,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4100}}',NULL,'2023-06-18 10:44:40','2023-06-18 10:44:40'),(706,'default','edited',546,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":34520},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"33480.0000\"}}',NULL,'2023-06-18 11:18:10','2023-06-18 11:18:10'),(707,'default','edited',555,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":112700},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"119900.0000\"}}',NULL,'2023-06-18 12:12:19','2023-06-18 12:12:19'),(708,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-18 14:32:45','2023-06-18 14:32:45'),(709,'default','added',563,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900}}',NULL,'2023-06-18 14:44:47','2023-06-18 14:44:47'),(710,'default','payment_edited',552,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4400.0000\"}}',NULL,'2023-06-18 15:45:58','2023-06-18 15:45:58'),(711,'default','edited',561,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5599},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4100.0000\"}}',NULL,'2023-06-18 15:51:18','2023-06-18 15:51:18'),(712,'default','edited',15,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-18 15:53:41','2023-06-18 15:53:41'),(713,'default','edited',560,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-06-18 15:57:49','2023-06-18 15:57:49'),(714,'default','edited',516,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":34362},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"32623.0000\"}}',NULL,'2023-06-18 17:18:35','2023-06-18 17:18:35'),(715,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-18 18:07:00','2023-06-18 18:07:01'),(716,'default','edited',555,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":126690},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"112700.0000\"}}',NULL,'2023-06-18 18:17:22','2023-06-18 18:17:22'),(717,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-19 06:02:03','2023-06-19 06:02:03'),(718,'default','added',564,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3450}}',NULL,'2023-06-19 06:06:14','2023-06-19 06:06:14'),(719,'default','added',565,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2023-06-19 06:54:49','2023-06-19 06:54:49'),(720,'default','edited',565,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-06-19 07:00:20','2023-06-19 07:00:20'),(721,'default','added',518,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-19 07:52:47','2023-06-19 07:52:47'),(722,'default','added',566,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2100}}',NULL,'2023-06-19 07:53:58','2023-06-19 07:53:58'),(723,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-19 08:24:56','2023-06-19 08:24:56'),(724,'default','added',519,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-06-19 08:25:37','2023-06-19 08:25:37'),(725,'default','added',568,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-06-19 08:28:21','2023-06-19 08:28:21'),(726,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-19 10:14:28','2023-06-19 10:14:28'),(727,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-19 10:28:35','2023-06-19 10:28:35'),(728,'default','added',569,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-06-19 10:31:44','2023-06-19 10:31:44'),(729,'default','edited',569,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2700.0000\"}}',NULL,'2023-06-19 10:33:53','2023-06-19 10:33:53'),(730,'default','added',520,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-19 12:45:19','2023-06-19 12:45:19'),(731,'default','added',570,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10500}}',NULL,'2023-06-19 12:49:23','2023-06-19 12:49:23'),(732,'default','added',571,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1100}}',NULL,'2023-06-19 13:13:55','2023-06-19 13:13:55'),(733,'default','edited',516,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":34362},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"34362.0000\"}}',NULL,'2023-06-19 15:35:57','2023-06-19 15:35:57'),(734,'default','added',572,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-06-19 15:40:40','2023-06-19 15:40:40'),(735,'default','added',573,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000}}',NULL,'2023-06-19 15:41:50','2023-06-19 15:41:50'),(736,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":99103},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"126690.0000\"}}',NULL,'2023-06-19 17:01:48','2023-06-19 17:01:48'),(737,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":99103},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"99103.0000\"}}',NULL,'2023-06-19 17:09:27','2023-06-19 17:09:27'),(738,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":99103},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"99103.0000\"}}',NULL,'2023-06-19 17:10:36','2023-06-19 17:10:36'),(739,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":99103},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"99103.0000\"}}',NULL,'2023-06-19 17:11:03','2023-06-19 17:11:03'),(740,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-20 05:02:53','2023-06-20 05:02:53'),(741,'default','added',574,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2023-06-20 05:05:27','2023-06-20 05:05:27'),(742,'default','edited',574,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6500.0000\"}}',NULL,'2023-06-20 05:13:28','2023-06-20 05:13:28'),(743,'default','added',575,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":100}}',NULL,'2023-06-20 06:03:28','2023-06-20 06:03:28'),(744,'default','edited',496,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":63390},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"61890.0000\"}}',NULL,'2023-06-20 06:04:18','2023-06-20 06:04:18'),(745,'default','payment_edited',496,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"63390.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"63390.0000\"}}',NULL,'2023-06-20 06:04:51','2023-06-20 06:04:51'),(746,'default','edited',496,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":63390},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"63390.0000\"}}',NULL,'2023-06-20 06:07:33','2023-06-20 06:07:33'),(747,'default','added',577,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2023-06-20 06:11:16','2023-06-20 06:11:16'),(748,'default','payment_edited',540,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2450.0000\"}}',NULL,'2023-06-20 08:35:24','2023-06-20 08:35:24'),(749,'default','edited',543,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":104100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"94000.0000\"}}',NULL,'2023-06-20 09:38:33','2023-06-20 09:38:33'),(750,'default','edited',543,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":105100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"104100.0000\"}}',NULL,'2023-06-20 09:41:36','2023-06-20 09:41:36'),(751,'default','edited',543,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":105100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"105100.0000\"}}',NULL,'2023-06-20 09:42:32','2023-06-20 09:42:32'),(752,'default','edited',543,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":106199},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"105100.0000\"}}',NULL,'2023-06-20 09:45:00','2023-06-20 09:45:00'),(753,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":99103},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"99103.0000\"}}',NULL,'2023-06-20 11:11:35','2023-06-20 11:11:35'),(754,'default','added',521,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-20 13:50:33','2023-06-20 13:50:33'),(755,'default','added',578,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-06-20 13:51:24','2023-06-20 13:51:24'),(756,'default','edited',574,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6250.0000\"}}',NULL,'2023-06-20 14:15:18','2023-06-20 14:15:18'),(757,'default','added',579,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":750}}',NULL,'2023-06-20 14:21:27','2023-06-20 14:21:27'),(758,'default','edited',543,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":103199},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"106199.0000\"}}',NULL,'2023-06-20 16:33:07','2023-06-20 16:33:07'),(759,'default','payment_edited',543,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"103199.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"103199.0000\"}}',NULL,'2023-06-20 16:33:37','2023-06-20 16:33:37'),(760,'default','edited',543,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":102100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"103199.0000\"}}',NULL,'2023-06-20 16:34:25','2023-06-20 16:34:25'),(761,'default','payment_edited',564,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3450.0000\"}}',NULL,'2023-06-20 17:08:49','2023-06-20 17:08:49'),(762,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-21 05:49:29','2023-06-21 05:49:29'),(763,'default','added',522,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-21 12:36:10','2023-06-21 12:36:10'),(764,'default','added',580,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":27774}}',NULL,'2023-06-21 12:51:09','2023-06-21 12:51:09'),(765,'default','added',581,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-06-21 13:33:05','2023-06-21 13:33:05'),(766,'default','added',582,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-06-21 14:58:47','2023-06-21 14:58:47'),(767,'default','added',583,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4300}}',NULL,'2023-06-21 15:22:45','2023-06-21 15:22:45'),(768,'default','payment_edited',571,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1100.0000\"}}',NULL,'2023-06-21 16:05:23','2023-06-21 16:05:23'),(769,'default','added',523,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-21 16:07:03','2023-06-21 16:07:03'),(770,'default','added',584,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700}}',NULL,'2023-06-21 16:07:47','2023-06-21 16:07:47'),(771,'default','payment_edited',565,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4800.0000\"}}',NULL,'2023-06-21 17:08:30','2023-06-21 17:08:30'),(772,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-22 07:05:03','2023-06-22 07:05:03'),(773,'default','added',585,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000}}',NULL,'2023-06-22 07:05:43','2023-06-22 07:05:43'),(774,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":99103},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"99103.0000\"}}',NULL,'2023-06-22 09:17:23','2023-06-22 09:17:23'),(775,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":99103},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"99103.0000\"}}',NULL,'2023-06-22 09:20:08','2023-06-22 09:20:08'),(776,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":99103},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"99103.0000\"}}',NULL,'2023-06-22 09:27:26','2023-06-22 09:27:26'),(777,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":99103},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"99103.0000\"}}',NULL,'2023-06-22 09:28:33','2023-06-22 09:28:33'),(778,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":99103},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"99103.0000\"}}',NULL,'2023-06-22 09:34:45','2023-06-22 09:34:45'),(779,'default','added',586,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000}}',NULL,'2023-06-22 11:35:03','2023-06-22 11:35:03'),(780,'default','payment_edited',581,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-06-22 11:38:26','2023-06-22 11:38:26'),(781,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":99103},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"99103.0000\"}}',NULL,'2023-06-22 12:48:04','2023-06-22 12:48:04'),(782,'default','edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":99103},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"99103.0000\"}}',NULL,'2023-06-22 12:48:37','2023-06-22 12:48:37'),(783,'default','added',587,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":42858}}',NULL,'2023-06-22 13:22:31','2023-06-22 13:22:31'),(784,'default','payment_edited',587,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"42858.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"42858.0000\"}}',NULL,'2023-06-22 13:47:28','2023-06-22 13:47:28'),(785,'default','edited',587,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":43858},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"42858.0000\"}}',NULL,'2023-06-22 15:58:07','2023-06-22 15:58:07'),(786,'default','edited',587,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":43858},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"43858.0000\"}}',NULL,'2023-06-22 15:58:30','2023-06-22 15:58:30'),(787,'default','payment_edited',574,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6250.0000\"}}',NULL,'2023-06-22 16:05:24','2023-06-22 16:05:24'),(788,'default','added',524,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-22 16:16:01','2023-06-22 16:16:01'),(789,'default','added',588,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-06-22 16:16:51','2023-06-22 16:16:51'),(790,'default','edited',587,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":43700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"43858.0000\"}}',NULL,'2023-06-22 16:26:37','2023-06-22 16:26:37'),(791,'default','added',589,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-06-22 16:40:54','2023-06-22 16:40:54'),(792,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-24 06:52:28','2023-06-24 06:52:28'),(793,'default','added',590,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":710}}',NULL,'2023-06-24 06:53:19','2023-06-24 06:53:19'),(794,'default','added',591,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-06-24 12:40:19','2023-06-24 12:40:19'),(795,'default','added',525,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-24 13:46:27','2023-06-24 13:46:27'),(796,'default','added',592,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1700}}',NULL,'2023-06-24 13:50:20','2023-06-24 13:50:20'),(797,'default','added',593,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1790}}',NULL,'2023-06-24 15:14:41','2023-06-24 15:14:41'),(798,'default','added',594,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-06-24 15:36:58','2023-06-24 15:36:58'),(799,'default','payment_edited',594,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-06-24 16:22:45','2023-06-24 16:22:45'),(800,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-25 04:24:16','2023-06-25 04:24:16'),(801,'default','added',595,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-06-25 04:26:27','2023-06-25 04:26:27'),(802,'default','edited',595,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"}}',NULL,'2023-06-25 04:26:55','2023-06-25 04:26:55'),(803,'default','edited',595,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-06-25 07:53:13','2023-06-25 07:53:13'),(804,'default','added',597,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1450}}',NULL,'2023-06-25 08:43:08','2023-06-25 08:43:08'),(805,'default','added',526,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-25 10:05:25','2023-06-25 10:05:25'),(806,'default','added',598,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-06-25 10:05:55','2023-06-25 10:05:55'),(807,'default','edited',595,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1000.0000\"}}',NULL,'2023-06-25 10:40:45','2023-06-25 10:40:45'),(808,'default','added',599,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4500}}',NULL,'2023-06-25 13:23:11','2023-06-25 13:23:11'),(809,'default','added',527,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-25 14:37:00','2023-06-25 14:37:00'),(810,'default','added',600,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10200}}',NULL,'2023-06-25 14:52:31','2023-06-25 14:52:31'),(811,'default','added',601,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5800}}',NULL,'2023-06-25 15:05:25','2023-06-25 15:05:25'),(812,'default','edited',601,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5800.0000\"}}',NULL,'2023-06-25 15:06:18','2023-06-25 15:06:18'),(813,'default','edited',600,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10200.0000\"}}',NULL,'2023-06-25 15:06:35','2023-06-25 15:06:35'),(814,'default','payment_edited',539,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"24750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"24750.0000\"}}',NULL,'2023-06-25 15:48:20','2023-06-25 15:48:20'),(815,'default','payment_edited',561,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5599.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5599.0000\"}}',NULL,'2023-06-25 15:51:16','2023-06-25 15:51:16'),(816,'default','payment_edited',597,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1450.0000\"}}',NULL,'2023-06-25 15:52:00','2023-06-25 15:52:00'),(817,'default','payment_edited',583,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4300.0000\"}}',NULL,'2023-06-25 16:03:07','2023-06-25 16:03:07'),(818,'default','payment_edited',595,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-06-25 16:03:37','2023-06-25 16:03:37'),(819,'default','payment_edited',601,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5800.0000\"}}',NULL,'2023-06-25 16:08:40','2023-06-25 16:08:40'),(820,'default','payment_edited',581,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1850.0000\"}}',NULL,'2023-06-25 16:12:57','2023-06-25 16:12:57'),(821,'default','payment_edited',586,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1000.0000\"}}',NULL,'2023-06-25 16:13:16','2023-06-25 16:13:16'),(822,'default','edited',599,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4500.0000\"}}',NULL,'2023-06-26 05:32:53','2023-06-26 05:32:53'),(823,'default','edited',599,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11300.0000\"}}',NULL,'2023-06-26 05:34:14','2023-06-26 05:34:14'),(824,'default','edited',599,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"18100.0000\"}}',NULL,'2023-06-26 05:56:39','2023-06-26 05:56:39'),(825,'default','added',603,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13600}}',NULL,'2023-06-26 05:57:42','2023-06-26 05:57:42'),(826,'default','payment_edited',557,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3410.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3410.0000\"}}',NULL,'2023-06-26 07:35:24','2023-06-26 07:35:24'),(827,'default','added',604,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3660}}',NULL,'2023-06-26 07:38:05','2023-06-26 07:38:05'),(828,'default','payment_edited',604,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3660.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3660.0000\"}}',NULL,'2023-06-26 07:42:06','2023-06-26 07:42:06'),(829,'default','edited',543,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":97200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"102100.0000\"}}',NULL,'2023-06-26 08:05:25','2023-06-26 08:05:25'),(830,'default','added',606,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23490}}',NULL,'2023-06-26 14:09:23','2023-06-26 14:09:23'),(831,'default','payment_edited',603,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13600.0000\"}}',NULL,'2023-06-26 16:27:42','2023-06-26 16:27:42'),(832,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-06-27 10:07:44','2023-06-27 10:07:44'),(833,'default','added',528,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-06-27 10:08:28','2023-06-27 10:08:28'),(834,'default','added',607,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2023-06-27 10:09:11','2023-06-27 10:09:11'),(835,'default','edited',592,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1700.0000\"}}',NULL,'2023-06-27 13:57:30','2023-06-27 13:57:30'),(836,'default','payment_edited',592,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1500.0000\"}}',NULL,'2023-06-27 13:57:43','2023-06-27 13:57:43'),(837,'default','payment_edited',520,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5400.0000\"}}',NULL,'2023-06-27 15:35:00','2023-06-27 15:35:00'),(838,'default','added',529,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-06-28 13:38:49','2023-06-28 13:38:49'),(839,'default','added',609,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12925}}',NULL,'2023-06-28 13:46:07','2023-06-28 13:46:07'),(840,'default','edited',609,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":12925},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"12925.0000\"}}',NULL,'2023-06-28 13:46:38','2023-06-28 13:46:38'),(841,'default','payment_edited',600,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10200.0000\"}}',NULL,'2023-06-28 16:34:56','2023-06-28 16:34:56'),(842,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-01 07:17:11','2023-07-01 07:17:11'),(843,'default','added',610,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1250}}',NULL,'2023-07-01 07:21:18','2023-07-01 07:21:19'),(844,'default','sell_deleted',610,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":610,\"invoice_no\":\"ITH2023-11118\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1250.0000\"}}',NULL,'2023-07-01 11:25:23','2023-07-01 11:25:23'),(845,'default','added',530,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-01 16:02:12','2023-07-01 16:02:12'),(846,'default','added',612,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-07-01 16:07:04','2023-07-01 16:07:04'),(847,'default','edited',612,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"}}',NULL,'2023-07-01 16:10:46','2023-07-01 16:10:46'),(848,'default','added',613,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-07-02 08:18:41','2023-07-02 08:18:41'),(849,'default','added',614,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2100}}',NULL,'2023-07-02 08:19:39','2023-07-02 08:19:39'),(850,'default','added',615,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2150}}',NULL,'2023-07-02 08:53:53','2023-07-02 08:53:53'),(851,'default','added',616,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1250}}',NULL,'2023-07-02 08:54:49','2023-07-02 08:54:49'),(852,'default','added',617,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2023-07-02 10:15:49','2023-07-02 10:15:49'),(853,'default','edited',617,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-07-02 10:16:57','2023-07-02 10:16:57'),(854,'default','added',531,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-02 11:40:14','2023-07-02 11:40:14'),(855,'default','added',618,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-07-02 11:41:59','2023-07-02 11:41:59'),(856,'default','payment_edited',617,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-07-02 11:45:40','2023-07-02 11:45:40'),(857,'default','added',619,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2023-07-02 12:31:19','2023-07-02 12:31:19'),(858,'default','added',620,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-07-02 17:12:29','2023-07-02 17:12:29'),(859,'default','edited',616,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1250.0000\"}}',NULL,'2023-07-02 17:49:04','2023-07-02 17:49:04'),(860,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-03 04:53:59','2023-07-03 04:53:59'),(861,'default','payment_edited',620,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3000.0000\"}}',NULL,'2023-07-03 04:55:47','2023-07-03 04:55:47'),(862,'default','payment_edited',619,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-07-03 04:56:04','2023-07-03 04:56:04'),(863,'default','payment_edited',615,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2150.0000\"}}',NULL,'2023-07-03 04:56:20','2023-07-03 04:56:20'),(864,'default','added',532,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-03 09:05:17','2023-07-03 09:05:17'),(865,'default','added',621,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-07-03 09:06:00','2023-07-03 09:06:00'),(866,'default','edited',621,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1600.0000\"}}',NULL,'2023-07-03 09:07:18','2023-07-03 09:07:18'),(867,'default','added',622,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":32400}}',NULL,'2023-07-03 12:43:02','2023-07-03 12:43:02'),(868,'default','added',623,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":21500}}',NULL,'2023-07-03 12:48:01','2023-07-03 12:48:01'),(869,'default','payment_edited',612,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-07-03 14:00:24','2023-07-03 14:00:24'),(870,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-03 14:40:08','2023-07-03 14:40:08'),(871,'default','added',533,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-03 16:18:22','2023-07-03 16:18:22'),(872,'default','added',624,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":50748}}',NULL,'2023-07-03 16:23:24','2023-07-03 16:23:24'),(873,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-04 06:53:58','2023-07-04 06:53:58'),(874,'default','added',534,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-07-04 06:55:12','2023-07-04 06:55:12'),(875,'default','added',625,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":401}}',NULL,'2023-07-04 06:59:56','2023-07-04 06:59:56'),(876,'default','added',626,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7800}}',NULL,'2023-07-04 07:23:43','2023-07-04 07:23:43'),(877,'default','edited',626,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7800.0000\"}}',NULL,'2023-07-04 07:24:33','2023-07-04 07:24:33'),(878,'default','added',535,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-04 08:44:49','2023-07-04 08:44:49'),(879,'default','added',628,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":5250}}',NULL,'2023-07-04 08:46:03','2023-07-04 08:46:03'),(880,'default','added',629,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2023-07-04 08:47:48','2023-07-04 08:47:48'),(881,'default','added',630,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8}}',NULL,'2023-07-04 13:27:53','2023-07-04 13:27:53'),(882,'default','edited',630,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8.0000\"}}',NULL,'2023-07-04 13:28:10','2023-07-04 13:28:10'),(883,'default','added',536,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-04 13:43:48','2023-07-04 13:43:48'),(884,'default','added',631,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-07-04 13:44:51','2023-07-04 13:44:51'),(885,'default','added',632,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-07-04 14:18:02','2023-07-04 14:18:02'),(886,'default','payment_edited',601,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5800.0000\"}}',NULL,'2023-07-04 15:00:41','2023-07-04 15:00:41'),(887,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-05 05:04:09','2023-07-05 05:04:09'),(888,'default','added',537,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-07-05 05:05:00','2023-07-05 05:05:00'),(889,'default','added',633,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-07-05 05:06:02','2023-07-05 05:06:02'),(890,'default','added',634,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-07-05 05:09:35','2023-07-05 05:09:35'),(891,'default','added',636,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3}}',NULL,'2023-07-05 08:03:30','2023-07-05 08:03:30'),(892,'default','added',637,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-07-05 10:52:44','2023-07-05 10:52:44'),(893,'default','added',638,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-07-05 10:54:34','2023-07-05 10:54:34'),(894,'default','edited',638,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1800.0000\"}}',NULL,'2023-07-05 10:54:50','2023-07-05 10:54:50'),(895,'default','added',639,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-07-05 11:21:31','2023-07-05 11:21:31'),(896,'default','added',640,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":450}}',NULL,'2023-07-06 08:06:43','2023-07-06 08:06:43'),(897,'default','added',538,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-06 08:08:29','2023-07-06 08:08:29'),(898,'default','added',641,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2750}}',NULL,'2023-07-06 08:24:05','2023-07-06 08:24:05'),(899,'default','added',642,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5600}}',NULL,'2023-07-06 12:30:11','2023-07-06 12:30:11'),(900,'default','added',539,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-06 12:31:38','2023-07-06 12:31:38'),(901,'default','added',643,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3900}}',NULL,'2023-07-06 12:32:36','2023-07-06 12:32:36'),(902,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-06 12:35:00','2023-07-06 12:35:00'),(903,'default','added',644,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":8250}}',NULL,'2023-07-06 12:37:27','2023-07-06 12:37:27'),(904,'default','added',645,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-07-06 12:39:09','2023-07-06 12:39:09'),(905,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-06 12:40:40','2023-07-06 12:40:40'),(906,'default','added',646,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1110}}',NULL,'2023-07-06 16:18:52','2023-07-06 16:18:52'),(907,'default','payment_edited',640,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"450.0000\"}}',NULL,'2023-07-06 16:22:02','2023-07-06 16:22:02'),(908,'default','payment_edited',616,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-07-06 16:22:33','2023-07-06 16:22:33'),(909,'default','added',647,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-07-06 16:23:48','2023-07-06 16:23:48'),(910,'default','edited',647,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-07-06 16:24:06','2023-07-06 16:24:06'),(911,'default','added',648,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300}}',NULL,'2023-07-06 16:27:58','2023-07-06 16:27:58'),(912,'default','edited',648,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1280},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-07-06 16:29:20','2023-07-06 16:29:20'),(913,'default','added',649,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":300}}',NULL,'2023-07-06 18:23:48','2023-07-06 18:23:48'),(914,'default','added',650,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2023-07-06 18:51:41','2023-07-06 18:51:41'),(915,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-08 04:39:49','2023-07-08 04:39:49'),(916,'default','added',651,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2350}}',NULL,'2023-07-08 04:41:57','2023-07-08 04:41:57'),(917,'default','added',652,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14500}}',NULL,'2023-07-08 06:31:04','2023-07-08 06:31:04'),(918,'default','added',653,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-07-08 06:45:30','2023-07-08 06:45:30'),(919,'default','added',654,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":170}}',NULL,'2023-07-08 06:54:09','2023-07-08 06:54:09'),(920,'default','edited',654,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":170},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"170.0000\"}}',NULL,'2023-07-08 06:55:07','2023-07-08 06:55:07'),(921,'default','added',655,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":850}}',NULL,'2023-07-08 07:35:41','2023-07-08 07:35:41'),(922,'default','added',540,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-08 10:17:40','2023-07-08 10:17:40'),(923,'default','added',657,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7600}}',NULL,'2023-07-08 10:21:47','2023-07-08 10:21:47'),(924,'default','payment_edited',588,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-07-08 11:43:53','2023-07-08 11:43:53'),(925,'default','added',541,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-08 11:55:43','2023-07-08 11:55:43'),(926,'default','edited',652,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"14500.0000\"}}',NULL,'2023-07-08 11:55:46','2023-07-08 11:55:46'),(927,'default','edited',654,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":440},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"170.0000\"}}',NULL,'2023-07-08 11:56:13','2023-07-08 11:56:13'),(928,'default','added',542,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-08 12:20:55','2023-07-08 12:20:55'),(929,'default','added',658,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1679}}',NULL,'2023-07-08 12:21:36','2023-07-08 12:21:36'),(930,'default','added',659,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":260000}}',NULL,'2023-07-08 12:49:35','2023-07-08 12:49:35'),(931,'default','edited',659,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":251200},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"260000.0000\"}}',NULL,'2023-07-08 12:52:06','2023-07-08 12:52:06'),(932,'default','added',660,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-07-08 13:09:04','2023-07-08 13:09:04'),(933,'default','added',661,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}',NULL,'2023-07-08 13:09:32','2023-07-08 13:09:32'),(934,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-08 13:24:54','2023-07-08 13:24:54'),(935,'default','added',662,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":450}}',NULL,'2023-07-08 15:33:36','2023-07-08 15:33:36'),(936,'default','added',663,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2350}}',NULL,'2023-07-09 05:34:40','2023-07-09 05:34:40'),(937,'default','edited',653,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-07-09 05:35:05','2023-07-09 05:35:05'),(938,'default','payment_edited',543,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"97200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"97200.0000\"}}',NULL,'2023-07-09 07:55:46','2023-07-09 07:55:46'),(939,'default','payment_edited',650,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-07-09 16:04:52','2023-07-09 16:04:52'),(940,'default','added',664,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2710}}',NULL,'2023-07-09 16:13:13','2023-07-09 16:13:13'),(941,'default','added',665,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2150}}',NULL,'2023-07-09 16:23:32','2023-07-09 16:23:32'),(942,'default','added',543,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-09 16:24:17','2023-07-09 16:24:17'),(943,'default','added',666,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-07-09 16:25:11','2023-07-09 16:25:11'),(944,'default','edited',666,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1900.0000\"}}',NULL,'2023-07-09 16:25:54','2023-07-09 16:25:54'),(945,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-10 05:22:46','2023-07-10 05:22:46'),(946,'default','added',667,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-07-10 05:24:44','2023-07-10 05:24:44'),(947,'default','added',544,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-07-10 05:42:06','2023-07-10 05:42:06'),(948,'default','added',668,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":810}}',NULL,'2023-07-10 05:44:33','2023-07-10 05:44:33'),(949,'default','added',545,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-07-10 05:52:09','2023-07-10 05:52:09'),(950,'default','added',669,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1280}}',NULL,'2023-07-10 05:53:37','2023-07-10 05:53:37'),(951,'default','added',546,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-07-10 05:58:13','2023-07-10 05:58:13'),(952,'default','added',670,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-07-10 05:58:53','2023-07-10 05:58:53'),(953,'default','added',547,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-07-10 07:34:32','2023-07-10 07:34:32'),(954,'default','added',671,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-07-10 07:35:43','2023-07-10 07:35:43'),(955,'default','added',672,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-07-10 08:07:00','2023-07-10 08:07:00'),(956,'default','added',548,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-10 12:32:57','2023-07-10 12:32:57'),(957,'default','added',673,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2023-07-10 12:34:10','2023-07-10 12:34:10'),(958,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-10 13:48:03','2023-07-10 13:48:03'),(959,'default','added',674,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":170}}',NULL,'2023-07-10 13:49:41','2023-07-10 13:49:41'),(960,'default','added',549,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-11 08:24:07','2023-07-11 08:24:07'),(961,'default','added',675,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-07-11 08:25:33','2023-07-11 08:25:33'),(962,'default','added',676,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3550}}',NULL,'2023-07-11 08:29:21','2023-07-11 08:29:21'),(963,'default','payment_edited',599,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4500.0000\"}}',NULL,'2023-07-11 08:29:40','2023-07-11 08:29:40'),(964,'default','added',550,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-11 09:15:56','2023-07-11 09:15:56'),(965,'default','added',677,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1800}}',NULL,'2023-07-11 09:17:52','2023-07-11 09:17:52'),(966,'default','payment_edited',539,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"24750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"24750.0000\"}}',NULL,'2023-07-11 09:26:46','2023-07-11 09:26:46'),(967,'default','added',551,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-11 13:18:59','2023-07-11 13:18:59'),(968,'default','added',679,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4000}}',NULL,'2023-07-11 13:22:45','2023-07-11 13:22:45'),(969,'default','added',680,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10800}}',NULL,'2023-07-11 13:25:11','2023-07-11 13:25:11'),(970,'default','added',681,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5900}}',NULL,'2023-07-11 13:39:22','2023-07-11 13:39:22'),(971,'default','added',683,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4308}}',NULL,'2023-07-11 15:05:17','2023-07-11 15:05:17'),(972,'default','added',685,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4150}}',NULL,'2023-07-11 16:25:49','2023-07-11 16:25:49'),(973,'default','added',686,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950}}',NULL,'2023-07-11 16:34:22','2023-07-11 16:34:22'),(974,'default','edited',686,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"}}',NULL,'2023-07-11 16:34:47','2023-07-11 16:34:47'),(975,'default','added',552,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-11 16:39:38','2023-07-11 16:39:38'),(976,'default','added',687,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-07-11 16:40:56','2023-07-11 16:40:56'),(977,'default','added',553,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-12 07:25:42','2023-07-12 07:25:42'),(978,'default','added',690,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":27350}}',NULL,'2023-07-12 07:39:14','2023-07-12 07:39:14'),(979,'default','edited',690,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":27350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"27350.0000\"}}',NULL,'2023-07-12 07:39:54','2023-07-12 07:39:54'),(980,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-12 09:11:38','2023-07-12 09:11:38'),(981,'default','added',554,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-07-12 09:14:58','2023-07-12 09:14:58'),(982,'default','added',691,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-07-12 09:16:21','2023-07-12 09:16:21'),(983,'default','added',692,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4800}}',NULL,'2023-07-12 11:02:54','2023-07-12 11:02:54'),(984,'default','sell_deleted',677,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":677,\"invoice_no\":\"ITH2023-11175\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1800.0000\"}}',NULL,'2023-07-12 13:12:41','2023-07-12 13:12:41'),(985,'default','edited',690,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":27350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27350.0000\"}}',NULL,'2023-07-12 13:13:54','2023-07-12 13:13:54'),(986,'default','added',693,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-07-12 13:14:48','2023-07-12 13:14:48'),(987,'default','edited',690,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":24300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"27350.0000\"}}',NULL,'2023-07-12 14:08:55','2023-07-12 14:08:55'),(988,'default','edited',693,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"}}',NULL,'2023-07-12 14:09:25','2023-07-12 14:09:25'),(989,'default','payment_edited',690,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"24300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"24300.0000\"}}',NULL,'2023-07-12 14:09:46','2023-07-12 14:09:46'),(990,'default','added',555,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-12 14:14:29','2023-07-12 14:14:29'),(991,'default','added',694,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":22700}}',NULL,'2023-07-12 14:17:55','2023-07-12 14:17:55'),(992,'default','edited',555,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-12 14:18:53','2023-07-12 14:18:53'),(993,'default','payment_edited',546,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"34520.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"34520.0000\"}}',NULL,'2023-07-12 14:41:54','2023-07-12 14:41:54'),(994,'default','edited',643,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3900.0000\"}}',NULL,'2023-07-12 14:43:18','2023-07-12 14:43:18'),(995,'default','added',695,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-07-12 15:04:18','2023-07-12 15:04:18'),(996,'default','edited',695,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"}}',NULL,'2023-07-12 15:05:49','2023-07-12 15:05:49'),(997,'default','edited',496,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":58390},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"63390.0000\"}}',NULL,'2023-07-12 16:10:54','2023-07-12 16:10:54'),(998,'default','payment_edited',496,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"58390.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"58390.0000\"}}',NULL,'2023-07-12 16:11:15','2023-07-12 16:11:15'),(999,'default','payment_edited',691,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-07-12 16:52:52','2023-07-12 16:52:52'),(1000,'default','edited',659,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":251200},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"251200.0000\"}}',NULL,'2023-07-13 06:01:37','2023-07-13 06:01:37'),(1001,'default','edited',659,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":251200},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"251200.0000\"}}',NULL,'2023-07-13 06:02:31','2023-07-13 06:02:31'),(1002,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-13 06:56:24','2023-07-13 06:56:24'),(1003,'default','added',696,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1150}}',NULL,'2023-07-13 06:58:02','2023-07-13 06:58:02'),(1004,'default','added',697,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500}}',NULL,'2023-07-13 09:19:16','2023-07-13 09:19:16'),(1005,'default','added',699,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23200}}',NULL,'2023-07-13 13:12:44','2023-07-13 13:12:44'),(1006,'default','payment_edited',681,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5900.0000\"}}',NULL,'2023-07-13 13:12:55','2023-07-13 13:12:55'),(1007,'default','payment_edited',695,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-07-13 13:13:04','2023-07-13 13:13:04'),(1008,'default','added',700,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4500}}',NULL,'2023-07-13 13:13:51','2023-07-13 13:13:51'),(1009,'default','added',701,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-07-13 13:19:23','2023-07-13 13:19:23'),(1010,'default','added',702,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-07-13 13:58:21','2023-07-13 13:58:21'),(1011,'default','payment_edited',642,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5600.0000\"}}',NULL,'2023-07-13 14:54:59','2023-07-13 14:54:59'),(1012,'default','added',556,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-13 14:59:21','2023-07-13 14:59:21'),(1013,'default','added',703,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-07-13 15:00:15','2023-07-13 15:00:15'),(1014,'default','added',704,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4000}}',NULL,'2023-07-13 15:03:16','2023-07-13 15:03:16'),(1015,'default','edited',704,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4000.0000\"}}',NULL,'2023-07-13 15:04:03','2023-07-13 15:04:03'),(1016,'default','edited',704,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"}}',NULL,'2023-07-13 15:04:56','2023-07-13 15:04:56'),(1017,'default','added',706,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-07-13 15:42:37','2023-07-13 15:42:37'),(1018,'default','added',707,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-07-13 16:06:54','2023-07-13 16:06:54'),(1019,'default','added',557,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-15 08:57:17','2023-07-15 08:57:17'),(1020,'default','added',708,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-07-15 08:57:58','2023-07-15 08:57:58'),(1021,'default','added',709,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300}}',NULL,'2023-07-15 11:14:07','2023-07-15 11:14:07'),(1022,'default','added',710,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2023-07-15 11:16:40','2023-07-15 11:16:40'),(1023,'default','added',711,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-07-15 11:27:44','2023-07-15 11:27:44'),(1024,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-15 12:01:47','2023-07-15 12:01:47'),(1025,'default','added',712,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6300}}',NULL,'2023-07-15 12:03:52','2023-07-15 12:03:52'),(1026,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-15 16:41:26','2023-07-15 16:41:26'),(1027,'default','added',558,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-16 06:48:33','2023-07-16 06:48:33'),(1028,'default','added',713,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14750}}',NULL,'2023-07-16 06:52:26','2023-07-16 06:52:26'),(1029,'default','added',714,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":800}}',NULL,'2023-07-16 07:05:50','2023-07-16 07:05:50'),(1030,'default','added',715,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6}}',NULL,'2023-07-16 07:51:19','2023-07-16 07:51:19'),(1031,'default','added',716,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-07-16 07:53:58','2023-07-16 07:53:58'),(1032,'default','added',717,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":100}}',NULL,'2023-07-16 08:19:17','2023-07-16 08:19:17'),(1033,'default','payment_edited',589,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-07-16 08:25:25','2023-07-16 08:25:25'),(1034,'default','payment_edited',701,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3000.0000\"}}',NULL,'2023-07-16 08:46:46','2023-07-16 08:46:46'),(1035,'default','added',718,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-07-16 10:34:24','2023-07-16 10:34:24'),(1036,'default','payment_edited',548,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-07-16 10:35:05','2023-07-16 10:35:05'),(1037,'default','added',719,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-07-16 10:37:02','2023-07-16 10:37:02'),(1038,'default','added',720,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-07-16 10:49:01','2023-07-16 10:49:01'),(1039,'default','edited',720,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-07-16 10:49:30','2023-07-16 10:49:30'),(1040,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-16 11:18:00','2023-07-16 11:18:00'),(1041,'default','edited',718,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-07-16 13:24:09','2023-07-16 13:24:09'),(1042,'default','edited',715,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6.0000\"}}',NULL,'2023-07-16 13:30:27','2023-07-16 13:30:27'),(1043,'default','added',721,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":400}}',NULL,'2023-07-16 14:00:01','2023-07-16 14:00:01'),(1044,'default','added',722,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-07-16 14:48:46','2023-07-16 14:48:46'),(1045,'default','payment_edited',516,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"34362.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"34362.0000\"}}',NULL,'2023-07-16 15:03:05','2023-07-16 15:03:05'),(1046,'default','payment_edited',710,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-07-16 15:08:19','2023-07-16 15:08:19'),(1047,'default','edited',711,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-07-16 15:26:19','2023-07-16 15:26:19'),(1048,'default','payment_edited',700,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4500.0000\"}}',NULL,'2023-07-16 15:37:32','2023-07-16 15:37:32'),(1049,'default','payment_edited',711,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-07-16 15:37:42','2023-07-16 15:37:42'),(1050,'default','added',723,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11200}}',NULL,'2023-07-16 15:38:49','2023-07-16 15:38:49'),(1051,'default','edited',723,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11200.0000\"}}',NULL,'2023-07-16 15:39:14','2023-07-16 15:39:14'),(1052,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-07-17 06:36:12','2023-07-17 06:36:12'),(1053,'default','added',724,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-07-17 06:40:36','2023-07-17 06:40:36'),(1054,'default','added',725,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-07-17 07:50:53','2023-07-17 07:50:53'),(1055,'default','payment_edited',724,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-07-17 08:37:44','2023-07-17 08:37:44'),(1056,'default','added',726,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-07-17 08:58:43','2023-07-17 08:58:43'),(1057,'default','edited',726,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3400.0000\"}}',NULL,'2023-07-17 08:59:02','2023-07-17 08:59:02'),(1058,'default','added',559,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-17 11:35:58','2023-07-17 11:35:58'),(1059,'default','added',727,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-07-17 11:36:24','2023-07-17 11:36:24'),(1060,'default','added',728,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":350}}',NULL,'2023-07-17 11:53:00','2023-07-17 11:53:00'),(1061,'default','added',729,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":450}}',NULL,'2023-07-17 12:59:52','2023-07-17 12:59:52'),(1062,'default','sell_deleted',728,'App\\Transaction',NULL,1,2,'App\\User','{\"id\":728,\"invoice_no\":\"ITH2023-11219\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"350.0000\"}}',NULL,'2023-07-17 13:23:16','2023-07-17 13:23:16'),(1063,'default','added',731,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":11860}}',NULL,'2023-07-17 13:42:57','2023-07-17 13:42:57'),(1064,'default','edited',731,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":11860},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"11860.0000\"}}',NULL,'2023-07-17 13:45:40','2023-07-17 13:45:40'),(1065,'default','added',732,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":450}}',NULL,'2023-07-17 13:50:26','2023-07-17 13:50:26'),(1066,'default','payment_edited',707,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-07-17 14:42:59','2023-07-17 14:42:59'),(1067,'default','added',560,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-18 05:38:14','2023-07-18 05:38:14'),(1068,'default','added',734,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":9900}}',NULL,'2023-07-18 05:42:49','2023-07-18 05:42:49'),(1069,'default','added',735,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-07-18 05:54:35','2023-07-18 05:54:35'),(1070,'default','added',736,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2600}}',NULL,'2023-07-18 06:06:47','2023-07-18 06:06:47'),(1071,'default','edited',697,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2500.0000\"}}',NULL,'2023-07-18 06:08:03','2023-07-18 06:08:03'),(1072,'default','added',561,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-18 09:39:51','2023-07-18 09:39:51'),(1073,'default','added',737,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-07-18 09:40:38','2023-07-18 09:40:38'),(1074,'default','added',562,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-18 12:20:08','2023-07-18 12:20:08'),(1075,'default','added',738,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-07-18 12:21:01','2023-07-18 12:21:01'),(1076,'default','edited',738,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"}}',NULL,'2023-07-18 12:31:34','2023-07-18 12:31:34'),(1077,'default','added',739,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-07-18 12:39:00','2023-07-18 12:39:00'),(1078,'default','added',563,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-18 13:26:34','2023-07-18 13:26:34'),(1079,'default','added',740,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300}}',NULL,'2023-07-18 13:27:34','2023-07-18 13:27:34'),(1080,'default','payment_edited',731,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11860.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"11860.0000\"}}',NULL,'2023-07-18 13:41:42','2023-07-18 13:41:42'),(1081,'default','added',741,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2550}}',NULL,'2023-07-18 14:42:18','2023-07-18 14:42:18'),(1082,'default','edited',741,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2550.0000\"}}',NULL,'2023-07-18 14:58:02','2023-07-18 14:58:02'),(1083,'default','sell_deleted',741,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":741,\"invoice_no\":\"ITH2023-11230\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-07-18 16:23:01','2023-07-18 16:23:01'),(1084,'default','added',564,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-07-19 05:31:12','2023-07-19 05:31:12'),(1085,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-19 06:50:29','2023-07-19 06:50:29'),(1086,'default','added',742,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":19210}}',NULL,'2023-07-19 07:02:50','2023-07-19 07:02:50'),(1087,'default','added',743,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":15900}}',NULL,'2023-07-19 07:12:02','2023-07-19 07:12:02'),(1088,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-19 07:16:09','2023-07-19 07:16:09'),(1089,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-19 08:14:39','2023-07-19 08:14:39'),(1090,'default','added',744,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":850}}',NULL,'2023-07-19 08:17:49','2023-07-19 08:17:49'),(1091,'default','added',745,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4600}}',NULL,'2023-07-19 08:37:30','2023-07-19 08:37:30'),(1092,'default','added',746,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300}}',NULL,'2023-07-19 08:40:15','2023-07-19 08:40:15'),(1093,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-19 09:44:03','2023-07-19 09:44:03'),(1094,'default','edited',692,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4800.0000\"}}',NULL,'2023-07-19 10:23:15','2023-07-19 10:23:15'),(1095,'default','payment_edited',692,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5000.0000\"}}',NULL,'2023-07-19 10:23:36','2023-07-19 10:23:36'),(1096,'default','added',565,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-19 12:24:27','2023-07-19 12:24:27'),(1097,'default','added',748,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-07-19 12:26:20','2023-07-19 12:26:20'),(1098,'default','added',749,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4300}}',NULL,'2023-07-19 12:31:11','2023-07-19 12:31:11'),(1099,'default','added',566,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-19 12:59:00','2023-07-19 12:59:00'),(1100,'default','added',750,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300}}',NULL,'2023-07-19 12:59:33','2023-07-19 12:59:33'),(1101,'default','payment_edited',651,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2350.0000\"}}',NULL,'2023-07-19 13:07:00','2023-07-19 13:07:00'),(1102,'default','payment_edited',648,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1280.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1280.0000\"}}',NULL,'2023-07-19 14:10:07','2023-07-19 14:10:07'),(1103,'default','added',751,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7900}}',NULL,'2023-07-19 14:12:49','2023-07-19 14:12:49'),(1104,'default','payment_edited',667,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2023-07-19 14:21:56','2023-07-19 14:21:56'),(1105,'default','payment_edited',727,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-07-19 14:22:24','2023-07-19 14:22:24'),(1106,'default','payment_edited',745,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4600.0000\"}}',NULL,'2023-07-19 14:36:03','2023-07-19 14:36:03'),(1107,'default','payment_edited',729,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"450.0000\"}}',NULL,'2023-07-19 14:45:41','2023-07-19 14:45:41'),(1108,'default','payment_edited',751,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7900.0000\"}}',NULL,'2023-07-19 16:14:44','2023-07-19 16:14:44'),(1109,'default','payment_edited',723,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11200.0000\"}}',NULL,'2023-07-19 16:42:45','2023-07-19 16:42:45'),(1110,'default','added',752,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2050}}',NULL,'2023-07-19 16:45:17','2023-07-19 16:45:17'),(1111,'default','edited',683,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6084},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4308.0000\"}}',NULL,'2023-07-20 05:57:19','2023-07-20 05:57:19'),(1112,'default','added',754,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-07-20 06:55:17','2023-07-20 06:55:17'),(1113,'default','added',567,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-20 08:25:02','2023-07-20 08:25:02'),(1114,'default','added',755,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-07-20 08:25:58','2023-07-20 08:25:58'),(1115,'default','added',568,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-20 10:12:41','2023-07-20 10:12:41'),(1116,'default','added',756,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9000}}',NULL,'2023-07-20 10:17:46','2023-07-20 10:17:46'),(1117,'default','added',569,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-20 12:45:59','2023-07-20 12:45:59'),(1118,'default','added',757,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-07-20 12:46:50','2023-07-20 12:46:50'),(1119,'default','edited',757,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3200.0000\"}}',NULL,'2023-07-20 12:48:43','2023-07-20 12:48:43'),(1120,'default','added',570,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-20 13:04:57','2023-07-20 13:04:57'),(1121,'default','added',758,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-07-20 13:06:26','2023-07-20 13:06:26'),(1122,'default','edited',758,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"}}',NULL,'2023-07-20 13:06:41','2023-07-20 13:06:41'),(1123,'default','edited',758,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1600.0000\"}}',NULL,'2023-07-20 13:08:38','2023-07-20 13:08:38'),(1124,'default','payment_edited',585,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1000.0000\"}}',NULL,'2023-07-20 14:39:08','2023-07-20 14:39:08'),(1125,'default','edited',642,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":8200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5600.0000\"}}',NULL,'2023-07-20 15:25:45','2023-07-20 15:25:45'),(1126,'default','added',759,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3000}}',NULL,'2023-07-20 15:37:08','2023-07-20 15:37:08'),(1127,'default','edited',757,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3900.0000\"}}',NULL,'2023-07-20 15:37:21','2023-07-20 15:37:21'),(1128,'default','payment_edited',749,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4300.0000\"}}',NULL,'2023-07-20 16:18:39','2023-07-20 16:18:39'),(1129,'default','edited',744,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":510},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"850.0000\"}}',NULL,'2023-07-20 16:19:34','2023-07-20 16:19:34'),(1130,'default','added',760,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7400}}',NULL,'2023-07-20 16:57:18','2023-07-20 16:57:18'),(1131,'default','edited',760,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7400.0000\"}}',NULL,'2023-07-20 16:58:19','2023-07-20 16:58:19'),(1132,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-20 20:04:18','2023-07-20 20:04:18'),(1133,'default','payment_edited',735,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2023-07-20 20:04:39','2023-07-20 20:04:39'),(1134,'default','payment_edited',712,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6300.0000\"}}',NULL,'2023-07-20 20:05:16','2023-07-20 20:05:16'),(1135,'default','added',761,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4700}}',NULL,'2023-07-22 07:04:35','2023-07-22 07:04:35'),(1136,'default','added',762,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-07-22 09:05:17','2023-07-22 09:05:17'),(1137,'default','payment_edited',739,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-07-22 09:10:20','2023-07-22 09:10:20'),(1138,'default','added',763,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2350}}',NULL,'2023-07-22 11:32:30','2023-07-22 11:32:30'),(1139,'default','added',765,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1100}}',NULL,'2023-07-22 11:42:55','2023-07-22 11:42:55'),(1140,'default','payment_edited',763,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2350.0000\"}}',NULL,'2023-07-22 11:45:15','2023-07-22 11:45:15'),(1141,'default','edited',752,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2050.0000\"}}',NULL,'2023-07-22 13:25:27','2023-07-22 13:25:27'),(1142,'default','added',766,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2023-07-23 07:58:05','2023-07-23 07:58:05'),(1143,'default','payment_edited',765,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1100.0000\"}}',NULL,'2023-07-23 07:58:12','2023-07-23 07:58:12'),(1144,'default','edited',761,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3150},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4700.0000\"}}',NULL,'2023-07-23 07:58:27','2023-07-23 07:58:27'),(1145,'default','added',767,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3700}}',NULL,'2023-07-23 08:51:10','2023-07-23 08:51:10'),(1146,'default','added',768,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-07-23 09:21:26','2023-07-23 09:21:26'),(1147,'default','edited',768,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5700.0000\"}}',NULL,'2023-07-23 09:22:24','2023-07-23 09:22:24'),(1148,'default','payment_edited',638,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1800.0000\"}}',NULL,'2023-07-23 09:24:15','2023-07-23 09:24:15'),(1149,'default','payment_edited',676,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3550.0000\"}}',NULL,'2023-07-23 09:24:22','2023-07-23 09:24:22'),(1150,'default','added',769,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3800}}',NULL,'2023-07-23 09:25:50','2023-07-23 09:25:50'),(1151,'default','added',770,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":0}}',NULL,'2023-07-23 13:24:39','2023-07-23 13:24:39'),(1152,'default','added',771,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1375}}',NULL,'2023-07-23 13:27:19','2023-07-23 13:27:19'),(1153,'default','added',571,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-07-23 13:51:22','2023-07-23 13:51:22'),(1154,'default','added',772,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":11600}}',NULL,'2023-07-23 13:51:48','2023-07-23 13:51:48'),(1155,'default','payment_edited',772,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"11600.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"11600.0000\"}}',NULL,'2023-07-23 13:53:02','2023-07-23 13:53:02'),(1156,'default','payment_edited',734,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"9900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"9900.0000\"}}',NULL,'2023-07-23 14:32:38','2023-07-23 14:32:38'),(1157,'default','payment_edited',736,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2600.0000\"}}',NULL,'2023-07-23 14:33:06','2023-07-23 14:33:06'),(1158,'default','payment_edited',752,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4100.0000\"}}',NULL,'2023-07-23 14:42:01','2023-07-23 14:42:01'),(1159,'default','payment_edited',761,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3150.0000\"}}',NULL,'2023-07-23 14:42:09','2023-07-23 14:42:09'),(1160,'default','added',773,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2850}}',NULL,'2023-07-23 14:45:57','2023-07-23 14:45:57'),(1161,'default','payment_edited',746,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-07-23 15:57:14','2023-07-23 15:57:14'),(1162,'default','payment_edited',643,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3700.0000\"}}',NULL,'2023-07-23 15:58:07','2023-07-23 15:58:07'),(1163,'default','payment_edited',485,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2750.0000\"}}',NULL,'2023-07-23 16:01:10','2023-07-23 16:01:10'),(1164,'default','added',774,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700}}',NULL,'2023-07-23 16:02:09','2023-07-23 16:02:09'),(1165,'default','payment_edited',697,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2500.0000\"}}',NULL,'2023-07-23 16:04:20','2023-07-23 16:04:20'),(1166,'default','added',775,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2350}}',NULL,'2023-07-23 16:08:25','2023-07-23 16:08:25'),(1167,'default','edited',775,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2350.0000\"}}',NULL,'2023-07-23 16:08:51','2023-07-23 16:08:51'),(1168,'default','added',776,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-07-24 04:53:14','2023-07-24 04:53:14'),(1169,'default','added',777,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1140}}',NULL,'2023-07-24 06:32:32','2023-07-24 06:32:32'),(1170,'default','edited',694,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":10900},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"22700.0000\"}}',NULL,'2023-07-24 08:39:57','2023-07-24 08:39:57'),(1171,'default','added',572,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-24 08:45:20','2023-07-24 08:45:20'),(1172,'default','added',778,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-07-24 08:46:05','2023-07-24 08:46:05'),(1173,'default','added',779,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":300}}',NULL,'2023-07-24 10:19:11','2023-07-24 10:19:11'),(1174,'default','added',781,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4500}}',NULL,'2023-07-24 10:23:07','2023-07-24 10:23:07'),(1175,'default','edited',781,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4500.0000\"}}',NULL,'2023-07-24 10:23:25','2023-07-24 10:23:25'),(1176,'default','added',573,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-24 10:28:11','2023-07-24 10:28:11'),(1177,'default','added',783,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11950}}',NULL,'2023-07-24 10:37:56','2023-07-24 10:37:56'),(1178,'default','added',784,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5000}}',NULL,'2023-07-24 12:03:14','2023-07-24 12:03:14'),(1179,'default','edited',783,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":14630},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11950.0000\"}}',NULL,'2023-07-24 12:05:44','2023-07-24 12:05:44'),(1180,'default','edited',783,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":16850},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"14630.0000\"}}',NULL,'2023-07-24 12:26:24','2023-07-24 12:26:24'),(1181,'default','added',785,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400}}',NULL,'2023-07-24 12:44:26','2023-07-24 12:44:26'),(1182,'default','added',574,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-24 12:49:18','2023-07-24 12:49:18'),(1183,'default','added',786,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":570}}',NULL,'2023-07-24 12:49:42','2023-07-24 12:49:42'),(1184,'default','payment_edited',751,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7900.0000\"}}',NULL,'2023-07-24 12:52:57','2023-07-24 12:52:57'),(1185,'default','payment_edited',775,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2350.0000\"}}',NULL,'2023-07-24 13:11:26','2023-07-24 13:11:26'),(1186,'default','payment_edited',774,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"700.0000\"}}',NULL,'2023-07-24 13:11:36','2023-07-24 13:11:36'),(1187,'default','added',787,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-07-24 13:59:44','2023-07-24 13:59:44'),(1188,'default','payment_edited',784,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5000.0000\"}}',NULL,'2023-07-24 15:21:40','2023-07-24 15:21:40'),(1189,'default','payment_edited',744,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"510.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"510.0000\"}}',NULL,'2023-07-24 15:25:05','2023-07-24 15:25:05'),(1190,'default','payment_edited',771,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1375.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1375.0000\"}}',NULL,'2023-07-24 15:30:01','2023-07-24 15:30:01'),(1191,'default','payment_edited',759,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3000.0000\"}}',NULL,'2023-07-24 15:30:19','2023-07-24 15:30:19'),(1192,'default','added',788,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-07-24 15:35:24','2023-07-24 15:35:24'),(1193,'default','payment_edited',788,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-07-24 15:37:21','2023-07-24 15:37:21'),(1194,'default','added',575,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-25 08:45:42','2023-07-25 08:45:42'),(1195,'default','added',789,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":600}}',NULL,'2023-07-25 08:46:11','2023-07-25 08:46:11'),(1196,'default','edited',789,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":600},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"600.0000\"}}',NULL,'2023-07-25 08:52:34','2023-07-25 08:52:34'),(1197,'default','added',790,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15200}}',NULL,'2023-07-25 10:23:13','2023-07-25 10:23:13'),(1198,'default','added',791,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7400}}',NULL,'2023-07-25 10:27:12','2023-07-25 10:27:12'),(1199,'default','added',576,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-25 10:28:22','2023-07-25 10:28:22'),(1200,'default','edited',790,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":15200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"15200.0000\"}}',NULL,'2023-07-25 10:28:25','2023-07-25 10:28:25'),(1201,'default','added',792,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2350}}',NULL,'2023-07-25 11:08:19','2023-07-25 11:08:19'),(1202,'default','added',793,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900}}',NULL,'2023-07-25 11:12:17','2023-07-25 11:12:17'),(1203,'default','payment_edited',785,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"400.0000\"}}',NULL,'2023-07-25 11:12:44','2023-07-25 11:12:44'),(1204,'default','payment_edited',771,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1375.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1375.0000\"}}',NULL,'2023-07-25 11:13:51','2023-07-25 11:13:51'),(1205,'default','added',794,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":265}}',NULL,'2023-07-25 11:18:21','2023-07-25 11:18:21'),(1206,'default','edited',792,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2350.0000\"}}',NULL,'2023-07-25 12:10:11','2023-07-25 12:10:11'),(1207,'default','added',795,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1350}}',NULL,'2023-07-25 15:25:57','2023-07-25 15:25:57'),(1208,'default','payment_edited',721,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"400.0000\"}}',NULL,'2023-07-25 15:58:28','2023-07-25 15:58:28'),(1209,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-25 16:32:41','2023-07-25 16:32:41'),(1210,'default','added',796,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1650}}',NULL,'2023-07-25 16:36:25','2023-07-25 16:36:25'),(1211,'default','added',797,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-07-26 07:21:21','2023-07-26 07:21:21'),(1212,'default','added',577,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-26 08:30:24','2023-07-26 08:30:24'),(1213,'default','added',798,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6700}}',NULL,'2023-07-26 08:35:20','2023-07-26 08:35:20'),(1214,'default','edited',787,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1.0000\"}}',NULL,'2023-07-26 12:37:28','2023-07-26 12:37:28'),(1215,'default','added',799,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2023-07-26 12:48:07','2023-07-26 12:48:07'),(1216,'default','added',800,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-07-26 12:50:26','2023-07-26 12:50:26'),(1217,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-26 13:23:57','2023-07-26 13:23:57'),(1218,'default','added',801,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1100}}',NULL,'2023-07-26 13:43:44','2023-07-26 13:43:44'),(1219,'default','edited',801,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1050},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1100.0000\"}}',NULL,'2023-07-26 13:52:53','2023-07-26 13:52:53'),(1220,'default','payment_edited',801,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1050.0000\"}}',NULL,'2023-07-26 13:53:14','2023-07-26 13:53:14'),(1221,'default','added',802,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2320}}',NULL,'2023-07-26 15:20:29','2023-07-26 15:20:29'),(1222,'default','added',578,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-07-26 15:37:21','2023-07-26 15:37:21'),(1223,'default','added',803,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-07-26 15:38:07','2023-07-26 15:38:07'),(1224,'default','edited',802,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2320},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2320.0000\"}}',NULL,'2023-07-26 16:20:51','2023-07-26 16:20:51'),(1225,'default','added',804,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3700}}',NULL,'2023-07-27 06:18:29','2023-07-27 06:18:29'),(1226,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-27 10:06:22','2023-07-27 10:06:22'),(1227,'default','added',579,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-27 10:09:09','2023-07-27 10:09:09'),(1228,'default','added',805,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5500}}',NULL,'2023-07-27 10:10:04','2023-07-27 10:10:04'),(1229,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-27 12:32:05','2023-07-27 12:32:05'),(1230,'default','added',580,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-27 14:28:37','2023-07-27 14:28:37'),(1231,'default','added',806,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}',NULL,'2023-07-27 14:30:11','2023-07-27 14:30:11'),(1232,'default','payment_edited',773,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2850.0000\"}}',NULL,'2023-07-27 15:45:02','2023-07-27 15:45:02'),(1233,'default','added',807,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-07-27 16:04:44','2023-07-27 16:04:44'),(1234,'default','edited',807,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-07-27 16:05:01','2023-07-27 16:05:01'),(1235,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-27 17:02:41','2023-07-27 17:02:41'),(1236,'default','added',808,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":100}}',NULL,'2023-07-27 17:04:21','2023-07-27 17:04:21'),(1237,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-07-27 17:40:39','2023-07-27 17:40:39'),(1238,'default','added',581,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-29 08:52:16','2023-07-29 08:52:16'),(1239,'default','added',582,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-29 08:56:11','2023-07-29 08:56:11'),(1240,'default','added',809,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-07-29 08:58:11','2023-07-29 08:58:11'),(1241,'default','edited',809,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"}}',NULL,'2023-07-29 09:09:43','2023-07-29 09:09:43'),(1242,'default','added',810,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5800}}',NULL,'2023-07-29 09:13:25','2023-07-29 09:13:25'),(1243,'default','payment_edited',804,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3700.0000\"}}',NULL,'2023-07-29 10:07:53','2023-07-29 10:07:53'),(1244,'default','added',812,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-07-29 10:13:52','2023-07-29 10:13:52'),(1245,'default','added',813,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2}}',NULL,'2023-07-29 10:23:40','2023-07-29 10:23:40'),(1246,'default','added',814,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13900}}',NULL,'2023-07-29 11:30:22','2023-07-29 11:30:22'),(1247,'default','edited',814,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13900.0000\"}}',NULL,'2023-07-29 11:31:08','2023-07-29 11:31:08'),(1248,'default','edited',814,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13900.0000\"}}',NULL,'2023-07-29 11:32:10','2023-07-29 11:32:10'),(1249,'default','added',816,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":200}}',NULL,'2023-07-29 13:29:26','2023-07-29 13:29:26'),(1250,'default','edited',808,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}',NULL,'2023-07-29 13:29:54','2023-07-29 13:29:54'),(1251,'default','payment_edited',769,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3800.0000\"}}',NULL,'2023-07-29 13:34:50','2023-07-29 13:34:50'),(1252,'default','added',817,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5800}}',NULL,'2023-07-29 14:14:34','2023-07-29 14:14:34'),(1253,'default','added',818,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2050}}',NULL,'2023-07-29 14:17:35','2023-07-29 14:17:35'),(1254,'default','edited',768,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":5700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5700.0000\"}}',NULL,'2023-07-29 14:26:06','2023-07-29 14:26:06'),(1255,'default','added',819,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-07-29 14:28:09','2023-07-29 14:28:09'),(1256,'default','payment_edited',527,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-07-29 14:30:30','2023-07-29 14:30:30'),(1257,'default','payment_edited',560,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1000.0000\"}}',NULL,'2023-07-29 14:30:50','2023-07-29 14:30:50'),(1258,'default','payment_edited',564,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3450.0000\"}}',NULL,'2023-07-29 14:31:26','2023-07-29 14:31:26'),(1259,'default','payment_edited',647,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-07-29 14:45:28','2023-07-29 14:45:28'),(1260,'default','payment_edited',795,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1350.0000\"}}',NULL,'2023-07-29 16:23:37','2023-07-29 16:23:37'),(1261,'default','added',820,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":370}}',NULL,'2023-07-29 16:35:09','2023-07-29 16:35:09'),(1262,'default','sell_deleted',779,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":779,\"invoice_no\":\"ITH2023-11261\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"300.0000\"}}',NULL,'2023-07-29 16:55:39','2023-07-29 16:55:39'),(1263,'default','edited',797,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-07-29 17:09:18','2023-07-29 17:09:18'),(1264,'default','added',821,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-07-30 05:06:59','2023-07-30 05:06:59'),(1265,'default','added',822,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1800}}',NULL,'2023-07-30 05:08:11','2023-07-30 05:08:11'),(1266,'default','added',823,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3150}}',NULL,'2023-07-30 07:09:14','2023-07-30 07:09:14'),(1267,'default','added',829,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":76800}}',NULL,'2023-07-30 08:04:02','2023-07-30 08:04:02'),(1268,'default','edited',829,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":76800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"76800.0000\"}}',NULL,'2023-07-30 08:16:42','2023-07-30 08:16:42'),(1269,'default','edited',821,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-07-30 08:29:35','2023-07-30 08:29:35'),(1270,'default','added',583,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-30 11:19:28','2023-07-30 11:19:28'),(1271,'default','added',830,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3502}}',NULL,'2023-07-30 11:20:21','2023-07-30 11:20:21'),(1272,'default','added',584,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-30 11:45:56','2023-07-30 11:45:56'),(1273,'default','added',831,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-07-30 11:46:46','2023-07-30 11:46:46'),(1274,'default','added',832,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2130}}',NULL,'2023-07-30 12:31:08','2023-07-30 12:31:08'),(1275,'default','payment_edited',830,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3502.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3502.0000\"}}',NULL,'2023-07-30 12:32:14','2023-07-30 12:32:14'),(1276,'default','added',585,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-30 13:43:09','2023-07-30 13:43:09'),(1277,'default','added',833,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3800}}',NULL,'2023-07-30 13:45:08','2023-07-30 13:45:08'),(1278,'default','edited',833,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3800.0000\"}}',NULL,'2023-07-30 13:45:56','2023-07-30 13:45:56'),(1279,'default','payment_edited',817,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5800.0000\"}}',NULL,'2023-07-30 14:19:21','2023-07-30 14:19:21'),(1280,'default','added',834,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4200}}',NULL,'2023-07-30 16:28:44','2023-07-30 16:28:44'),(1281,'default','added',586,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-07-30 16:48:07','2023-07-30 16:48:07'),(1282,'default','added',841,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":117350}}',NULL,'2023-07-30 17:07:58','2023-07-30 17:07:58'),(1283,'default','edited',809,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"}}',NULL,'2023-07-30 17:31:44','2023-07-30 17:31:44'),(1284,'default','added',842,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":130}}',NULL,'2023-07-31 05:44:50','2023-07-31 05:44:50'),(1285,'default','added',843,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":420}}',NULL,'2023-07-31 05:53:05','2023-07-31 05:53:05'),(1286,'default','added',844,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"final_total\":0}}',NULL,'2023-07-31 06:17:09','2023-07-31 06:17:09'),(1287,'default','added',845,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4200}}',NULL,'2023-07-31 06:23:00','2023-07-31 06:23:00'),(1288,'default','added',846,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900}}',NULL,'2023-07-31 06:27:05','2023-07-31 06:27:05'),(1289,'default','payment_edited',846,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"900.0000\"}}',NULL,'2023-07-31 06:29:22','2023-07-31 06:29:22'),(1290,'default','edited',846,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"}}',NULL,'2023-07-31 06:51:42','2023-07-31 06:51:42'),(1291,'default','edited',736,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2600},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"}}',NULL,'2023-07-31 06:51:50','2023-07-31 06:51:50'),(1292,'default','edited',843,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1920},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"420.0000\"}}',NULL,'2023-07-31 07:24:18','2023-07-31 07:24:18'),(1293,'default','added',847,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2300}}',NULL,'2023-07-31 09:09:06','2023-07-31 09:09:06'),(1294,'default','edited',820,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"370.0000\"}}',NULL,'2023-07-31 10:28:44','2023-07-31 10:28:44'),(1295,'default','payment_edited',820,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"400.0000\"}}',NULL,'2023-07-31 10:29:23','2023-07-31 10:29:23'),(1296,'default','edited',816,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"200.0000\"}}',NULL,'2023-07-31 11:00:14','2023-07-31 11:00:14'),(1297,'default','added',848,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3500}}',NULL,'2023-07-31 16:09:38','2023-07-31 16:09:38'),(1298,'default','edited',848,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4150},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3500.0000\"}}',NULL,'2023-07-31 16:12:09','2023-07-31 16:12:09'),(1299,'default','added',587,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-01 07:49:38','2023-08-01 07:49:38'),(1300,'default','added',849,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-08-01 07:51:22','2023-08-01 07:51:22'),(1301,'default','edited',830,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":8002},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3502.0000\"}}',NULL,'2023-08-01 08:25:14','2023-08-01 08:25:14'),(1302,'default','payment_edited',830,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8002.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8002.0000\"}}',NULL,'2023-08-01 08:26:07','2023-08-01 08:26:07'),(1303,'default','payment_edited',847,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2300.0000\"}}',NULL,'2023-08-01 09:35:51','2023-08-01 09:35:51'),(1304,'default','added',850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000}}',NULL,'2023-08-01 10:23:52','2023-08-01 10:23:52'),(1305,'default','added',588,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-01 14:18:53','2023-08-01 14:18:53'),(1306,'default','added',851,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":92100}}',NULL,'2023-08-01 14:18:58','2023-08-01 14:18:58'),(1307,'default','edited',851,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":83700},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"92100.0000\"}}',NULL,'2023-08-01 14:21:00','2023-08-01 14:21:00'),(1308,'default','added',852,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":52080}}',NULL,'2023-08-01 14:29:42','2023-08-01 14:29:42'),(1309,'default','edited',852,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"paid\",\"final_total\":52080},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"52080.0000\"}}',NULL,'2023-08-01 14:30:17','2023-08-01 14:30:17'),(1310,'default','added',853,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-08-01 14:45:31','2023-08-01 14:45:31'),(1311,'default','payment_edited',768,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5700.0000\"}}',NULL,'2023-08-01 14:46:31','2023-08-01 14:46:31'),(1312,'default','payment_edited',796,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1650.0000\"}}',NULL,'2023-08-01 14:46:47','2023-08-01 14:46:47'),(1313,'default','added',855,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-08-01 14:59:37','2023-08-01 14:59:37'),(1314,'default','added',856,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":12500}}',NULL,'2023-08-01 15:00:11','2023-08-01 15:00:11'),(1315,'default','added',857,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300}}',NULL,'2023-08-01 15:53:17','2023-08-01 15:53:17'),(1316,'default','payment_edited',757,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3900.0000\"}}',NULL,'2023-08-02 05:22:21','2023-08-02 05:22:22'),(1317,'default','added',860,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":24922}}',NULL,'2023-08-02 05:50:55','2023-08-02 05:50:55'),(1318,'default','edited',860,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":25300},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"24922.0000\"}}',NULL,'2023-08-02 05:52:12','2023-08-02 05:52:12'),(1319,'default','edited',860,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":25300},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"25300.0000\"}}',NULL,'2023-08-02 05:56:44','2023-08-02 05:56:44'),(1320,'default','added',861,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300}}',NULL,'2023-08-02 07:49:04','2023-08-02 07:49:04'),(1321,'default','edited',850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1000.0000\"}}',NULL,'2023-08-02 07:49:20','2023-08-02 07:49:20'),(1322,'default','edited',841,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":117350},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"117350.0000\"}}',NULL,'2023-08-02 10:08:29','2023-08-02 10:08:29'),(1323,'default','added',863,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500}}',NULL,'2023-08-02 11:57:57','2023-08-02 11:57:57'),(1324,'default','payment_edited',750,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-08-02 12:53:57','2023-08-02 12:53:57'),(1325,'default','added',589,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-02 13:00:29','2023-08-02 13:00:29'),(1326,'default','added',864,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-08-02 13:01:02','2023-08-02 13:01:02'),(1327,'default','added',865,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-08-02 13:07:28','2023-08-02 13:07:28'),(1328,'default','added',590,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-08-02 13:22:10','2023-08-02 13:22:10'),(1329,'default','added',867,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2400}}',NULL,'2023-08-02 13:24:17','2023-08-02 13:24:17'),(1330,'default','edited',845,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4200.0000\"}}',NULL,'2023-08-02 13:37:33','2023-08-02 13:37:33'),(1331,'default','payment_edited',784,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5000.0000\"}}',NULL,'2023-08-02 14:54:24','2023-08-02 14:54:24'),(1332,'default','added',591,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-03 05:38:12','2023-08-03 05:38:12'),(1333,'default','added',868,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-08-03 05:38:14','2023-08-03 05:38:14'),(1334,'default','added',869,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-08-03 05:54:48','2023-08-03 05:54:48'),(1335,'default','edited',869,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"}}',NULL,'2023-08-03 05:55:12','2023-08-03 05:55:12'),(1336,'default','edited',841,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":111200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"117350.0000\"}}',NULL,'2023-08-03 10:23:58','2023-08-03 10:23:58'),(1337,'default','payment_edited',869,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"400.0000\"}}',NULL,'2023-08-03 10:29:47','2023-08-03 10:29:47'),(1338,'default','payment_edited',693,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"700.0000\"}}',NULL,'2023-08-03 10:30:00','2023-08-03 10:30:00'),(1339,'default','payment_edited',845,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3000.0000\"}}',NULL,'2023-08-03 12:55:04','2023-08-03 12:55:04'),(1340,'default','payment_edited',821,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-08-03 12:55:15','2023-08-03 12:55:15'),(1341,'default','payment_edited',863,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2500.0000\"}}',NULL,'2023-08-03 13:01:41','2023-08-03 13:01:41'),(1342,'default','added',871,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2023-08-03 13:47:43','2023-08-03 13:47:43'),(1343,'default','added',872,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-08-03 15:28:48','2023-08-03 15:28:48'),(1344,'default','added',592,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-08-05 05:54:27','2023-08-05 05:54:27'),(1345,'default','added',874,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-08-05 05:55:25','2023-08-05 05:55:25'),(1346,'default','added',875,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":14}}',NULL,'2023-08-05 06:29:09','2023-08-05 06:29:09'),(1347,'default','added',876,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6900}}',NULL,'2023-08-05 12:26:18','2023-08-05 12:26:18'),(1348,'default','edited',876,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6900.0000\"}}',NULL,'2023-08-05 14:32:11','2023-08-05 14:32:11'),(1349,'default','added',877,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":350}}',NULL,'2023-08-05 14:40:12','2023-08-05 14:40:12'),(1350,'default','edited',876,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2300.0000\"}}',NULL,'2023-08-05 14:42:26','2023-08-05 14:42:26'),(1351,'default','added',878,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2350}}',NULL,'2023-08-05 16:15:34','2023-08-05 16:15:34'),(1352,'default','payment_edited',878,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2350.0000\"}}',NULL,'2023-08-05 16:25:20','2023-08-05 16:25:20'),(1353,'default','payment_edited',819,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-08-05 16:28:07','2023-08-05 16:28:07'),(1354,'default','payment_edited',796,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1650.0000\"}}',NULL,'2023-08-05 16:28:20','2023-08-05 16:28:20'),(1355,'default','added',879,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2700}}',NULL,'2023-08-06 09:39:38','2023-08-06 09:39:38'),(1356,'default','added',880,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3700}}',NULL,'2023-08-06 11:30:06','2023-08-06 11:30:06'),(1357,'default','added',881,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300}}',NULL,'2023-08-06 14:07:03','2023-08-06 14:07:03'),(1358,'default','payment_edited',846,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"900.0000\"}}',NULL,'2023-08-06 14:21:45','2023-08-06 14:21:45'),(1359,'default','payment_edited',736,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2600.0000\"}}',NULL,'2023-08-06 14:21:54','2023-08-06 14:21:54'),(1360,'default','payment_edited',536,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2023-08-06 14:22:09','2023-08-06 14:22:09'),(1361,'default','added',882,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700}}',NULL,'2023-08-06 14:23:17','2023-08-06 14:23:17'),(1362,'default','added',593,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-07 06:24:32','2023-08-07 06:24:32'),(1363,'default','added',883,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":20082}}',NULL,'2023-08-07 06:32:39','2023-08-07 06:32:39'),(1364,'default','edited',883,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":22082},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"20082.0000\"}}',NULL,'2023-08-07 06:35:20','2023-08-07 06:35:20'),(1365,'default','added',594,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-08-07 11:32:11','2023-08-07 11:32:11'),(1366,'default','added',885,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":280}}',NULL,'2023-08-07 11:34:41','2023-08-07 11:34:41'),(1367,'default','added',595,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-07 13:00:09','2023-08-07 13:00:09'),(1368,'default','added',886,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3}}',NULL,'2023-08-07 13:01:08','2023-08-07 13:01:08'),(1369,'default','added',887,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5500}}',NULL,'2023-08-07 13:11:27','2023-08-07 13:11:27'),(1370,'default','added',888,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2800}}',NULL,'2023-08-08 10:41:53','2023-08-08 10:41:53'),(1371,'default','edited',776,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-08-08 10:42:30','2023-08-08 10:42:30'),(1372,'default','payment_edited',834,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4200.0000\"}}',NULL,'2023-08-08 14:35:00','2023-08-08 14:35:00'),(1373,'default','payment_edited',881,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-08-08 14:36:57','2023-08-08 14:36:57'),(1374,'default','edited',809,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"}}',NULL,'2023-08-08 14:37:58','2023-08-08 14:37:58'),(1375,'default','added',889,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12550}}',NULL,'2023-08-09 04:27:38','2023-08-09 04:27:38'),(1376,'default','edited',889,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12571},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"12550.0000\"}}',NULL,'2023-08-09 04:29:50','2023-08-09 04:29:50'),(1377,'default','edited',889,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12571},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"12571.0000\"}}',NULL,'2023-08-09 04:30:50','2023-08-09 04:30:50'),(1378,'default','added',596,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-08-09 06:29:01','2023-08-09 06:29:01'),(1379,'default','added',890,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-08-09 06:29:48','2023-08-09 06:29:48'),(1380,'default','added',891,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-08-09 08:23:06','2023-08-09 08:23:06'),(1381,'default','payment_edited',877,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"350.0000\"}}',NULL,'2023-08-09 08:25:37','2023-08-09 08:25:37'),(1382,'default','added',894,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5400}}',NULL,'2023-08-09 09:00:31','2023-08-09 09:00:31'),(1383,'default','edited',894,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5400.0000\"}}',NULL,'2023-08-09 09:01:41','2023-08-09 09:01:41'),(1384,'default','payment_edited',781,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4500.0000\"}}',NULL,'2023-08-09 09:03:04','2023-08-09 09:03:04'),(1385,'default','payment_edited',769,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3800.0000\"}}',NULL,'2023-08-09 09:04:02','2023-08-09 09:04:02'),(1386,'default','edited',888,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2800.0000\"}}',NULL,'2023-08-09 09:15:19','2023-08-09 09:15:19'),(1387,'default','added',597,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-08-09 10:20:47','2023-08-09 10:20:47'),(1388,'default','added',895,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":600}}',NULL,'2023-08-09 10:21:40','2023-08-09 10:21:40'),(1389,'default','payment_edited',894,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5400.0000\"}}',NULL,'2023-08-09 10:29:20','2023-08-09 10:29:20'),(1390,'default','payment_edited',754,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-08-09 12:35:44','2023-08-09 12:35:44'),(1391,'default','payment_edited',584,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"700.0000\"}}',NULL,'2023-08-09 12:47:40','2023-08-09 12:47:40'),(1392,'default','edited',186,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-09 12:55:42','2023-08-09 12:55:42'),(1393,'default','contact_deleted',186,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-09 12:56:33','2023-08-09 12:56:33'),(1394,'default','added',896,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":380}}',NULL,'2023-08-09 12:58:08','2023-08-09 12:58:08'),(1395,'default','added',897,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-08-09 12:59:25','2023-08-09 12:59:25'),(1396,'default','payment_edited',647,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1500.0000\"}}',NULL,'2023-08-09 13:04:30','2023-08-09 13:04:30'),(1397,'default','payment_edited',655,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"850.0000\"}}',NULL,'2023-08-09 13:05:35','2023-08-09 13:05:35'),(1398,'default','added',598,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-09 13:07:33','2023-08-09 13:07:33'),(1399,'default','added',898,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4700}}',NULL,'2023-08-09 13:10:58','2023-08-09 13:10:58'),(1400,'default','added',899,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2050}}',NULL,'2023-08-09 13:11:51','2023-08-09 13:11:51'),(1401,'default','payment_edited',776,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-08-09 13:46:08','2023-08-09 13:46:08'),(1402,'default','payment_edited',807,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2800.0000\"}}',NULL,'2023-08-09 13:46:19','2023-08-09 13:46:19'),(1403,'default','edited',841,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":118100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"111200.0000\"}}',NULL,'2023-08-09 15:07:18','2023-08-09 15:07:18'),(1404,'default','added',902,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300}}',NULL,'2023-08-09 15:43:56','2023-08-09 15:43:56'),(1405,'default','payment_edited',887,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5500.0000\"}}',NULL,'2023-08-09 15:52:12','2023-08-09 15:52:12'),(1406,'default','added',903,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-08-10 05:01:15','2023-08-10 05:01:15'),(1407,'default','added',904,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1280}}',NULL,'2023-08-10 05:21:25','2023-08-10 05:21:25'),(1408,'default','sell_deleted',889,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":889,\"invoice_no\":\"ITH2023-11343\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"12571.0000\"}}',NULL,'2023-08-10 06:44:36','2023-08-10 06:44:36'),(1409,'default','edited',898,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4520},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4700.0000\"}}',NULL,'2023-08-10 07:58:57','2023-08-10 07:58:57'),(1410,'default','added',905,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000}}',NULL,'2023-08-10 08:33:22','2023-08-10 08:33:22'),(1411,'default','added',599,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-10 14:57:21','2023-08-10 14:57:21'),(1412,'default','added',906,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5800}}',NULL,'2023-08-10 14:57:48','2023-08-10 14:57:48'),(1413,'default','added',600,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-08-10 15:32:31','2023-08-10 15:32:31'),(1414,'default','added',907,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-08-10 15:33:12','2023-08-10 15:33:12'),(1415,'default','added',908,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4600}}',NULL,'2023-08-10 19:56:16','2023-08-10 19:56:16'),(1416,'default','added',909,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1259}}',NULL,'2023-08-12 06:28:42','2023-08-12 06:28:42'),(1417,'default','payment_edited',902,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3300.0000\"}}',NULL,'2023-08-12 08:29:08','2023-08-12 08:29:08'),(1418,'default','added',910,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-08-12 09:02:47','2023-08-12 09:02:47'),(1419,'default','added',912,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3}}',NULL,'2023-08-12 09:49:45','2023-08-12 09:49:45'),(1420,'default','added',913,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2}}',NULL,'2023-08-12 10:17:16','2023-08-12 10:17:16'),(1421,'default','edited',913,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2.0000\"}}',NULL,'2023-08-12 10:19:27','2023-08-12 10:19:27'),(1422,'default','added',601,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-12 10:37:38','2023-08-12 10:37:38'),(1423,'default','added',914,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":17810}}',NULL,'2023-08-12 10:48:07','2023-08-12 10:48:07'),(1424,'default','added',915,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4200}}',NULL,'2023-08-12 10:50:00','2023-08-12 10:50:00'),(1425,'default','added',916,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2418}}',NULL,'2023-08-12 13:41:21','2023-08-12 13:41:21'),(1426,'default','sell_deleted',909,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":909,\"invoice_no\":\"ITH2023-11359\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1259.0000\"}}',NULL,'2023-08-12 13:41:35','2023-08-12 13:41:35'),(1427,'default','payment_edited',910,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-08-12 14:23:48','2023-08-12 14:23:48'),(1428,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-08-12 15:18:37','2023-08-12 15:18:37'),(1429,'default','edited',915,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2550},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4200.0000\"}}',NULL,'2023-08-12 15:19:51','2023-08-12 15:19:51'),(1430,'default','added',602,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-12 16:25:26','2023-08-12 16:25:26'),(1431,'default','added',917,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-08-12 16:26:20','2023-08-12 16:26:20'),(1432,'default','added',918,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-08-13 05:20:27','2023-08-13 05:20:27'),(1433,'default','added',603,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-08-13 05:28:08','2023-08-13 05:28:08'),(1434,'default','added',919,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1980}}',NULL,'2023-08-13 05:31:39','2023-08-13 05:31:39'),(1435,'default','added',920,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13500}}',NULL,'2023-08-13 07:10:14','2023-08-13 07:10:14'),(1436,'default','added',921,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3650}}',NULL,'2023-08-13 13:12:50','2023-08-13 13:12:50'),(1437,'default','payment_edited',898,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4520.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4520.0000\"}}',NULL,'2023-08-13 14:09:35','2023-08-13 14:09:35'),(1438,'default','payment_edited',905,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1000.0000\"}}',NULL,'2023-08-13 14:27:00','2023-08-13 14:27:00'),(1439,'default','payment_edited',891,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-08-13 14:27:22','2023-08-13 14:27:22'),(1440,'default','added',922,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-08-13 14:57:53','2023-08-13 14:57:53'),(1441,'default','sell_deleted',915,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":915,\"invoice_no\":\"ITH2023-11363\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2550.0000\"}}',NULL,'2023-08-13 16:37:07','2023-08-13 16:37:07'),(1442,'default','payment_edited',871,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-08-13 16:37:37','2023-08-13 16:37:37'),(1443,'default','added',923,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3500}}',NULL,'2023-08-14 07:20:36','2023-08-14 07:20:36'),(1444,'default','edited',489,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":6420},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2620.0000\"}}',NULL,'2023-08-14 07:26:02','2023-08-14 07:26:02'),(1445,'default','edited',922,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-08-14 07:26:18','2023-08-14 07:26:18'),(1446,'default','added',924,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":600}}',NULL,'2023-08-14 08:45:41','2023-08-14 08:45:41'),(1447,'default','added',925,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":79700}}',NULL,'2023-08-14 08:47:21','2023-08-14 08:47:21'),(1448,'default','edited',925,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"paid\",\"final_total\":79700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"79700.0000\"}}',NULL,'2023-08-14 08:47:48','2023-08-14 08:47:48'),(1449,'default','edited',925,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"paid\",\"final_total\":79700},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"paid\",\"final_total\":\"79700.0000\"}}',NULL,'2023-08-14 08:48:10','2023-08-14 08:48:10'),(1450,'default','added',604,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-14 09:06:39','2023-08-14 09:06:39'),(1451,'default','added',926,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-08-14 09:09:31','2023-08-14 09:09:31'),(1452,'default','edited',926,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"}}',NULL,'2023-08-14 09:10:39','2023-08-14 09:10:39'),(1453,'default','edited',925,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"partial\",\"final_total\":101200},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"paid\",\"final_total\":\"79700.0000\"}}',NULL,'2023-08-14 10:01:37','2023-08-14 10:01:37'),(1454,'default','edited',925,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"partial\",\"final_total\":101200},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"partial\",\"final_total\":\"101200.0000\"}}',NULL,'2023-08-14 10:02:12','2023-08-14 10:02:12'),(1455,'default','edited',925,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"partial\",\"final_total\":101200},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"partial\",\"final_total\":\"101200.0000\"}}',NULL,'2023-08-14 10:06:14','2023-08-14 10:06:14'),(1456,'default','added',927,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2}}',NULL,'2023-08-14 10:28:43','2023-08-14 10:28:43'),(1457,'default','added',928,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-08-14 10:30:27','2023-08-14 10:30:27'),(1458,'default','added',929,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2300}}',NULL,'2023-08-14 12:06:08','2023-08-14 12:06:08'),(1459,'default','added',930,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-08-14 12:35:20','2023-08-14 12:35:20'),(1460,'default','added',605,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-14 14:36:28','2023-08-14 14:36:28'),(1461,'default','added',932,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000}}',NULL,'2023-08-14 14:39:20','2023-08-14 14:39:20'),(1462,'default','payment_edited',922,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-08-14 15:13:10','2023-08-14 15:13:10'),(1463,'default','sell_deleted',903,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":903,\"invoice_no\":\"ITH2023-11353\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-08-14 15:19:32','2023-08-14 15:19:32'),(1464,'default','payment_edited',823,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3150.0000\"}}',NULL,'2023-08-14 15:19:44','2023-08-14 15:19:44'),(1465,'default','added',606,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-14 15:42:22','2023-08-14 15:42:22'),(1466,'default','added',934,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4800}}',NULL,'2023-08-14 15:44:08','2023-08-14 15:44:08'),(1467,'default','added',935,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400}}',NULL,'2023-08-15 13:45:11','2023-08-15 13:45:11'),(1468,'default','added',607,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-15 16:00:15','2023-08-15 16:00:15'),(1469,'default','added',936,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4000}}',NULL,'2023-08-15 16:00:55','2023-08-15 16:00:55'),(1470,'default','added',608,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-08-16 03:49:59','2023-08-16 03:49:59'),(1471,'default','added',937,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}',NULL,'2023-08-16 03:51:35','2023-08-16 03:51:35'),(1472,'default','added',938,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}',NULL,'2023-08-16 03:54:06','2023-08-16 03:54:06'),(1473,'default','added',939,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4700}}',NULL,'2023-08-16 06:06:02','2023-08-16 06:06:02'),(1474,'default','edited',939,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4700.0000\"}}',NULL,'2023-08-16 06:06:41','2023-08-16 06:06:41'),(1475,'default','added',940,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000}}',NULL,'2023-08-16 06:10:44','2023-08-16 06:10:44'),(1476,'default','added',609,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-08-16 13:21:18','2023-08-16 13:21:18'),(1477,'default','added',941,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5300}}',NULL,'2023-08-16 13:25:01','2023-08-16 13:25:01'),(1478,'default','added',942,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300}}',NULL,'2023-08-17 06:16:31','2023-08-17 06:16:31'),(1479,'default','added',610,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-17 06:47:28','2023-08-17 06:47:28'),(1480,'default','added',943,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-08-17 06:48:08','2023-08-17 06:48:08'),(1481,'default','added',944,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-08-17 06:52:57','2023-08-17 06:52:57'),(1482,'default','added',611,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-17 07:00:00','2023-08-17 07:00:00'),(1483,'default','added',945,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-08-17 07:01:15','2023-08-17 07:01:15'),(1484,'default','edited',945,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1450.0000\"}}',NULL,'2023-08-17 07:04:54','2023-08-17 07:04:54'),(1485,'default','added',946,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-08-17 07:17:53','2023-08-17 07:17:53'),(1486,'default','added',947,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-08-17 07:29:56','2023-08-17 07:29:56'),(1487,'default','added',948,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400}}',NULL,'2023-08-17 07:45:00','2023-08-17 07:45:00'),(1488,'default','added',612,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-17 07:51:37','2023-08-17 07:51:37'),(1489,'default','added',949,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550}}',NULL,'2023-08-17 07:52:53','2023-08-17 07:52:53'),(1490,'default','edited',949,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2550},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2550.0000\"}}',NULL,'2023-08-17 07:53:53','2023-08-17 07:53:53'),(1491,'default','added',613,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-17 08:02:39','2023-08-17 08:02:39'),(1492,'default','added',950,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-08-17 08:05:19','2023-08-17 08:05:19'),(1493,'default','edited',613,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-17 08:07:33','2023-08-17 08:07:33'),(1494,'default','added',951,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700}}',NULL,'2023-08-17 11:31:39','2023-08-17 11:31:39'),(1495,'default','added',952,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3350}}',NULL,'2023-08-17 12:15:08','2023-08-17 12:15:08'),(1496,'default','added',953,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1150}}',NULL,'2023-08-17 12:53:25','2023-08-17 12:53:25'),(1497,'default','added',614,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-17 13:15:51','2023-08-17 13:15:51'),(1498,'default','added',954,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-08-17 13:16:30','2023-08-17 13:16:30'),(1499,'default','edited',946,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":510},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-08-17 13:37:17','2023-08-17 13:37:17'),(1500,'default','edited',939,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4700.0000\"}}',NULL,'2023-08-17 13:38:18','2023-08-17 13:38:18'),(1501,'default','added',955,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2600}}',NULL,'2023-08-17 13:46:44','2023-08-17 13:46:44'),(1502,'default','edited',664,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2710.0000\"}}',NULL,'2023-08-17 13:49:10','2023-08-17 13:49:10'),(1503,'default','payment_edited',664,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-08-17 13:50:06','2023-08-17 13:50:06'),(1504,'default','added',956,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4800}}',NULL,'2023-08-17 13:59:08','2023-08-17 13:59:08'),(1505,'default','payment_edited',939,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-08-17 13:59:40','2023-08-17 13:59:40'),(1506,'default','payment_edited',923,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3500.0000\"}}',NULL,'2023-08-17 15:28:59','2023-08-17 15:28:59'),(1507,'default','payment_edited',952,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3350.0000\"}}',NULL,'2023-08-17 15:29:56','2023-08-17 15:29:56'),(1508,'default','added',957,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-08-17 15:35:00','2023-08-17 15:35:00'),(1509,'default','edited',947,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3320},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3000.0000\"}}',NULL,'2023-08-17 16:04:39','2023-08-17 16:04:39'),(1510,'default','edited',841,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":121500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"118100.0000\"}}',NULL,'2023-08-19 14:10:34','2023-08-19 14:10:34'),(1511,'default','payment_edited',841,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"121500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"121500.0000\"}}',NULL,'2023-08-19 14:11:12','2023-08-19 14:11:12'),(1512,'default','added',958,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":18070}}',NULL,'2023-08-19 14:24:15','2023-08-19 14:24:15'),(1513,'default','added',959,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5700}}',NULL,'2023-08-19 16:36:45','2023-08-19 16:36:45'),(1514,'default','added',960,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300}}',NULL,'2023-08-19 16:56:03','2023-08-19 16:56:03'),(1515,'default','payment_edited',929,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2300.0000\"}}',NULL,'2023-08-19 17:10:50','2023-08-19 17:10:50'),(1516,'default','added',961,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1498}}',NULL,'2023-08-19 17:13:06','2023-08-19 17:13:06'),(1517,'default','added',962,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2750}}',NULL,'2023-08-20 07:01:12','2023-08-20 07:01:12'),(1518,'default','added',963,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-08-20 10:30:37','2023-08-20 10:30:37'),(1519,'default','edited',963,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1.0000\"}}',NULL,'2023-08-20 10:44:33','2023-08-20 10:44:33'),(1520,'default','added',964,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3}}',NULL,'2023-08-20 10:53:04','2023-08-20 10:53:04'),(1521,'default','payment_edited',642,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8200.0000\"}}',NULL,'2023-08-20 11:37:31','2023-08-20 11:37:31'),(1522,'default','added',965,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-08-20 11:45:24','2023-08-20 11:45:24'),(1523,'default','payment_edited',841,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"121500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"121500.0000\"}}',NULL,'2023-08-20 13:18:12','2023-08-20 13:18:12'),(1524,'default','payment_edited',880,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3700.0000\"}}',NULL,'2023-08-20 15:08:58','2023-08-20 15:08:58'),(1525,'default','edited',822,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1840},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1800.0000\"}}',NULL,'2023-08-20 15:10:32','2023-08-20 15:10:32'),(1526,'default','payment_edited',822,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1840.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1840.0000\"}}',NULL,'2023-08-20 15:11:19','2023-08-20 15:11:19'),(1527,'default','edited',955,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2600.0000\"}}',NULL,'2023-08-20 15:26:38','2023-08-20 15:26:38'),(1528,'default','edited',962,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2750.0000\"}}',NULL,'2023-08-20 15:27:36','2023-08-20 15:27:36'),(1529,'default','added',966,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1850}}',NULL,'2023-08-20 16:10:10','2023-08-20 16:10:10'),(1530,'default','edited',962,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2023-08-21 06:33:55','2023-08-21 06:33:55'),(1531,'default','edited',946,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"510.0000\"}}',NULL,'2023-08-21 06:34:08','2023-08-21 06:34:08'),(1532,'default','added',967,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7300}}',NULL,'2023-08-21 06:36:14','2023-08-21 06:36:14'),(1533,'default','payment_edited',946,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-08-21 06:36:35','2023-08-21 06:36:35'),(1534,'default','payment_edited',959,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5700.0000\"}}',NULL,'2023-08-21 06:36:45','2023-08-21 06:36:45'),(1535,'default','payment_edited',962,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2750.0000\"}}',NULL,'2023-08-21 06:36:54','2023-08-21 06:36:54'),(1536,'default','added',968,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1550}}',NULL,'2023-08-21 06:49:45','2023-08-21 06:49:45'),(1537,'default','added',615,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-21 06:56:49','2023-08-21 06:56:49'),(1538,'default','added',969,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3424}}',NULL,'2023-08-21 07:02:08','2023-08-21 07:02:08'),(1539,'default','added',970,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2023-08-21 07:06:55','2023-08-21 07:06:55'),(1540,'default','payment_edited',477,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5.0000\"}}',NULL,'2023-08-21 07:37:56','2023-08-21 07:37:56'),(1541,'default','added',971,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1260}}',NULL,'2023-08-21 08:10:54','2023-08-21 08:10:54'),(1542,'default','edited',971,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1260},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1260.0000\"}}',NULL,'2023-08-21 08:24:11','2023-08-21 08:24:11'),(1543,'default','added',616,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-08-21 09:24:39','2023-08-21 09:24:39'),(1544,'default','added',972,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-08-21 09:26:59','2023-08-21 09:26:59'),(1545,'default','added',973,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":120}}',NULL,'2023-08-21 11:46:53','2023-08-21 11:46:53'),(1546,'default','added',617,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-21 12:01:33','2023-08-21 12:01:33'),(1547,'default','added',974,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-08-21 12:02:12','2023-08-21 12:02:12'),(1548,'default','added',618,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-21 13:44:55','2023-08-21 13:44:55'),(1549,'default','added',975,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3850}}',NULL,'2023-08-21 13:45:41','2023-08-21 13:45:41'),(1550,'default','payment_edited',960,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-08-21 13:50:37','2023-08-21 13:50:37'),(1551,'default','edited',618,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-21 13:54:52','2023-08-21 13:54:52'),(1552,'default','added',619,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-21 14:20:08','2023-08-21 14:20:08'),(1553,'default','added',976,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3600}}',NULL,'2023-08-21 14:21:12','2023-08-21 14:21:12'),(1554,'default','added',978,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":41700}}',NULL,'2023-08-21 15:14:02','2023-08-21 15:14:02'),(1555,'default','edited',978,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":41800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"41700.0000\"}}',NULL,'2023-08-21 15:20:58','2023-08-21 15:20:58'),(1556,'default','added',620,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-21 15:39:23','2023-08-21 15:39:23'),(1557,'default','added',979,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2023-08-21 15:40:41','2023-08-21 15:40:41'),(1558,'default','added',621,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-21 15:58:57','2023-08-21 15:58:57'),(1559,'default','added',980,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":39300}}',NULL,'2023-08-21 16:09:16','2023-08-21 16:09:16'),(1560,'default','added',981,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":34900}}',NULL,'2023-08-21 16:20:35','2023-08-21 16:20:35'),(1561,'default','added',982,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":300}}',NULL,'2023-08-21 16:28:47','2023-08-21 16:28:47'),(1562,'default','added',983,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":780}}',NULL,'2023-08-21 16:29:50','2023-08-21 16:29:50'),(1563,'default','payment_edited',976,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3600.0000\"}}',NULL,'2023-08-21 16:32:15','2023-08-21 16:32:15'),(1564,'default','added',984,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5700}}',NULL,'2023-08-21 16:49:04','2023-08-21 16:49:04'),(1565,'default','sell_deleted',984,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":984,\"invoice_no\":\"ITH2023-11426\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5700.0000\"}}',NULL,'2023-08-21 16:53:50','2023-08-21 16:53:50'),(1566,'default','payment_edited',642,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8200.0000\"}}',NULL,'2023-08-21 16:54:50','2023-08-21 16:54:50'),(1567,'default','payment_edited',951,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"700.0000\"}}',NULL,'2023-08-21 16:57:51','2023-08-21 16:57:51'),(1568,'default','payment_edited',704,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"}}',NULL,'2023-08-21 16:58:08','2023-08-21 16:58:08'),(1569,'default','payment_edited',924,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"600.0000\"}}',NULL,'2023-08-21 16:58:54','2023-08-21 16:58:54'),(1570,'default','payment_edited',921,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3650.0000\"}}',NULL,'2023-08-21 16:59:07','2023-08-21 16:59:07'),(1571,'default','added',622,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-22 06:40:28','2023-08-22 06:40:28'),(1572,'default','added',985,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23000}}',NULL,'2023-08-22 06:44:46','2023-08-22 06:44:46'),(1573,'default','added',623,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-22 14:14:14','2023-08-22 14:14:14'),(1574,'default','added',986,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4300}}',NULL,'2023-08-22 14:14:57','2023-08-22 14:14:57'),(1575,'default','payment_edited',982,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"300.0000\"}}',NULL,'2023-08-22 14:52:05','2023-08-22 14:52:05'),(1576,'default','added',624,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-22 15:42:54','2023-08-22 15:42:54'),(1577,'default','added',987,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5200}}',NULL,'2023-08-22 15:43:38','2023-08-22 15:43:38'),(1578,'default','edited',980,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":39300},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"39300.0000\"}}',NULL,'2023-08-22 15:57:53','2023-08-22 15:57:53'),(1579,'default','added',988,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1050}}',NULL,'2023-08-23 04:57:25','2023-08-23 04:57:25'),(1580,'default','added',625,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-23 06:55:00','2023-08-23 06:55:00'),(1581,'default','added',989,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-08-23 06:55:18','2023-08-23 06:55:18'),(1582,'default','added',990,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-08-23 14:13:01','2023-08-23 14:13:01'),(1583,'default','edited',990,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"}}',NULL,'2023-08-23 14:13:29','2023-08-23 14:13:29'),(1584,'default','added',626,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-23 16:47:35','2023-08-23 16:47:35'),(1585,'default','added',991,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3250}}',NULL,'2023-08-23 16:49:35','2023-08-23 16:49:35'),(1586,'default','payment_edited',978,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"41800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"41800.0000\"}}',NULL,'2023-08-23 17:09:23','2023-08-23 17:09:23'),(1587,'default','edited',988,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1050.0000\"}}',NULL,'2023-08-24 05:00:19','2023-08-24 05:00:19'),(1588,'default','payment_edited',894,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5400.0000\"}}',NULL,'2023-08-24 05:02:54','2023-08-24 05:02:54'),(1589,'default','added',992,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-08-24 05:05:05','2023-08-24 05:05:05'),(1590,'default','added',993,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":6500}}',NULL,'2023-08-24 06:30:27','2023-08-24 06:30:27'),(1591,'default','edited',993,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":6500},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"6500.0000\"}}',NULL,'2023-08-24 06:31:41','2023-08-24 06:31:41'),(1592,'default','edited',993,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":20700},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"6500.0000\"}}',NULL,'2023-08-24 06:45:54','2023-08-24 06:45:54'),(1593,'default','edited',993,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":41400},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"20700.0000\"}}',NULL,'2023-08-24 06:51:15','2023-08-24 06:51:15'),(1594,'default','added',994,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250}}',NULL,'2023-08-24 07:49:57','2023-08-24 07:49:57'),(1595,'default','payment_edited',683,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6084.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6084.0000\"}}',NULL,'2023-08-24 08:17:26','2023-08-24 08:17:26'),(1596,'default','added',996,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":81500}}',NULL,'2023-08-24 09:06:05','2023-08-24 09:06:05'),(1597,'default','added',997,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":64500}}',NULL,'2023-08-24 09:12:01','2023-08-24 09:12:01'),(1598,'default','payment_edited',655,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"850.0000\"}}',NULL,'2023-08-24 12:20:44','2023-08-24 12:20:44'),(1599,'default','payment_edited',696,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1150.0000\"}}',NULL,'2023-08-24 12:22:09','2023-08-24 12:22:09'),(1600,'default','payment_edited',871,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2400.0000\"}}',NULL,'2023-08-24 12:22:43','2023-08-24 12:22:43'),(1601,'default','edited',971,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1260},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1260.0000\"}}',NULL,'2023-08-24 12:23:59','2023-08-24 12:23:59'),(1602,'default','payment_edited',818,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2050.0000\"}}',NULL,'2023-08-24 12:25:00','2023-08-24 12:25:00'),(1603,'default','payment_edited',898,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4520.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4520.0000\"}}',NULL,'2023-08-24 12:29:47','2023-08-24 12:29:47'),(1604,'default','added',998,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":200}}',NULL,'2023-08-24 12:42:28','2023-08-24 12:42:28'),(1605,'default','added',999,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2350}}',NULL,'2023-08-24 13:46:43','2023-08-24 13:46:43'),(1606,'default','payment_edited',967,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7300.0000\"}}',NULL,'2023-08-24 14:12:37','2023-08-24 14:12:37'),(1607,'default','payment_edited',988,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-08-24 14:12:49','2023-08-24 14:12:49'),(1608,'default','added',1000,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3200}}',NULL,'2023-08-24 14:36:45','2023-08-24 14:36:45'),(1609,'default','edited',1000,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3200.0000\"}}',NULL,'2023-08-24 14:37:38','2023-08-24 14:37:38'),(1610,'default','added',1001,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2023-08-24 14:46:11','2023-08-24 14:46:11'),(1611,'default','added',1002,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":46248}}',NULL,'2023-08-24 15:06:52','2023-08-24 15:06:52'),(1612,'default','edited',1002,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":47248},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"46248.0000\"}}',NULL,'2023-08-24 15:21:43','2023-08-24 15:21:43'),(1613,'default','added',1004,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500}}',NULL,'2023-08-26 09:47:08','2023-08-26 09:47:08'),(1614,'default','edited',1002,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":47248},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"47248.0000\"}}',NULL,'2023-08-26 11:54:27','2023-08-26 11:54:27'),(1615,'default','edited',1002,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":47248},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"47248.0000\"}}',NULL,'2023-08-26 11:54:39','2023-08-26 11:54:39'),(1616,'default','added',627,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-26 12:12:41','2023-08-26 12:12:41'),(1617,'default','added',1005,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-08-26 12:15:27','2023-08-26 12:15:27'),(1618,'default','edited',1005,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-08-26 12:16:20','2023-08-26 12:16:20'),(1619,'default','added',1007,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-08-26 12:24:52','2023-08-26 12:24:52'),(1620,'default','payment_edited',1005,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-08-26 12:53:24','2023-08-26 12:53:24'),(1621,'default','added',1008,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":240}}',NULL,'2023-08-26 15:44:39','2023-08-26 15:44:39'),(1622,'default','added',1009,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1550}}',NULL,'2023-08-26 15:55:22','2023-08-26 15:55:22'),(1623,'default','added',628,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-08-27 05:39:55','2023-08-27 05:39:55'),(1624,'default','added',1010,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2000}}',NULL,'2023-08-27 05:41:01','2023-08-27 05:41:01'),(1625,'default','added',1011,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5500}}',NULL,'2023-08-27 07:25:53','2023-08-27 07:25:53'),(1626,'default','added',1012,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-08-27 10:38:58','2023-08-27 10:38:58'),(1627,'default','payment_edited',1010,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2000.0000\"}}',NULL,'2023-08-27 10:39:19','2023-08-27 10:39:19'),(1628,'default','edited',1011,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5500.0000\"}}',NULL,'2023-08-27 10:42:21','2023-08-27 10:42:21'),(1629,'default','added',629,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-27 11:04:59','2023-08-27 11:04:59'),(1630,'default','added',1014,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-08-27 11:05:32','2023-08-27 11:05:32'),(1631,'default','payment_edited',1002,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"47248.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"47248.0000\"}}',NULL,'2023-08-27 11:11:09','2023-08-27 11:11:09'),(1632,'default','added',630,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-08-27 13:21:00','2023-08-27 13:21:00'),(1633,'default','added',1015,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2700}}',NULL,'2023-08-27 13:23:55','2023-08-27 13:23:55'),(1634,'default','added',1016,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4000}}',NULL,'2023-08-27 15:19:23','2023-08-27 15:19:23'),(1635,'default','added',1017,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2000}}',NULL,'2023-08-28 04:14:41','2023-08-28 04:14:41'),(1636,'default','payment_edited',1017,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2000.0000\"}}',NULL,'2023-08-28 04:40:27','2023-08-28 04:40:27'),(1637,'default','added',1018,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7900}}',NULL,'2023-08-28 05:54:13','2023-08-28 05:54:13'),(1638,'default','edited',1018,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7900.0000\"}}',NULL,'2023-08-28 05:54:29','2023-08-28 05:54:29'),(1639,'default','added',1019,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300}}',NULL,'2023-08-28 06:00:57','2023-08-28 06:00:57'),(1640,'default','added',1020,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-08-28 06:27:59','2023-08-28 06:27:59'),(1641,'default','added',1021,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2}}',NULL,'2023-08-28 06:32:35','2023-08-28 06:32:35'),(1642,'default','added',1023,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6600}}',NULL,'2023-08-28 06:51:42','2023-08-28 06:51:42'),(1643,'default','payment_edited',1012,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3000.0000\"}}',NULL,'2023-08-28 11:39:21','2023-08-28 11:39:21'),(1644,'default','added',1024,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-08-28 12:44:20','2023-08-28 12:44:20'),(1645,'default','payment_edited',961,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1498.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1498.0000\"}}',NULL,'2023-08-28 15:21:28','2023-08-28 15:21:28'),(1646,'default','added',631,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-29 07:25:23','2023-08-29 07:25:23'),(1647,'default','added',1025,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-08-29 07:26:39','2023-08-29 07:26:39'),(1648,'default','added',632,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-29 08:18:29','2023-08-29 08:18:29'),(1649,'default','added',1026,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":67040}}',NULL,'2023-08-29 08:49:16','2023-08-29 08:49:16'),(1650,'default','edited',1026,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":73840},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"67040.0000\"}}',NULL,'2023-08-29 08:50:21','2023-08-29 08:50:21'),(1651,'default','payment_edited',992,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2023-08-29 08:54:19','2023-08-29 08:54:19'),(1652,'default','edited',1016,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4000.0000\"}}',NULL,'2023-08-29 08:54:58','2023-08-29 08:54:58'),(1653,'default','added',1027,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2023-08-29 08:56:18','2023-08-29 08:56:18'),(1654,'default','edited',1027,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"}}',NULL,'2023-08-29 08:56:36','2023-08-29 08:56:36'),(1655,'default','added',1028,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":600}}',NULL,'2023-08-29 09:01:27','2023-08-29 09:01:27'),(1656,'default','added',633,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-29 10:29:28','2023-08-29 10:29:28'),(1657,'default','added',1029,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-08-29 10:31:51','2023-08-29 10:31:51'),(1658,'default','added',1030,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700}}',NULL,'2023-08-29 11:28:12','2023-08-29 11:28:12'),(1659,'default','added',1031,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4500}}',NULL,'2023-08-29 13:53:49','2023-08-29 13:53:49'),(1660,'default','payment_edited',1024,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-08-29 14:30:36','2023-08-29 14:30:36'),(1661,'default','added',1032,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2000}}',NULL,'2023-08-29 14:58:04','2023-08-29 14:58:04'),(1662,'default','added',1033,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400}}',NULL,'2023-08-29 15:34:11','2023-08-29 15:34:11'),(1663,'default','payment_edited',1028,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"600.0000\"}}',NULL,'2023-08-29 15:52:53','2023-08-29 15:52:53'),(1664,'default','payment_edited',947,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3320.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3320.0000\"}}',NULL,'2023-08-29 16:03:48','2023-08-29 16:03:48'),(1665,'default','payment_edited',935,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"400.0000\"}}',NULL,'2023-08-29 16:04:37','2023-08-29 16:04:37'),(1666,'default','added',1034,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":100}}',NULL,'2023-08-29 16:12:49','2023-08-29 16:12:49'),(1667,'default','added',634,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-29 16:40:40','2023-08-29 16:40:40'),(1668,'default','added',1035,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":6600}}',NULL,'2023-08-29 16:43:34','2023-08-29 16:43:34'),(1669,'default','added',1037,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3200}}',NULL,'2023-08-29 16:47:18','2023-08-29 16:47:18'),(1670,'default','added',635,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-08-30 04:47:08','2023-08-30 04:47:09'),(1671,'default','added',1038,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4000}}',NULL,'2023-08-30 04:49:30','2023-08-30 04:49:30'),(1672,'default','added',1039,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-08-30 08:34:37','2023-08-30 08:34:37'),(1673,'default','added',636,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-08-30 08:35:26','2023-08-30 08:35:26'),(1674,'default','added',1040,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2023-08-30 08:36:31','2023-08-30 08:36:31'),(1675,'default','edited',1027,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"900.0000\"}}',NULL,'2023-08-30 09:21:17','2023-08-30 09:21:17'),(1676,'default','payment_edited',1016,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4400.0000\"}}',NULL,'2023-08-30 09:21:34','2023-08-30 09:21:34'),(1677,'default','edited',1032,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2000.0000\"}}',NULL,'2023-08-30 09:49:11','2023-08-30 09:49:11'),(1678,'default','payment_edited',930,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-08-30 09:50:21','2023-08-30 09:50:21'),(1679,'default','payment_edited',999,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2350.0000\"}}',NULL,'2023-08-30 09:50:32','2023-08-30 09:50:32'),(1680,'default','payment_edited',1019,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-08-30 09:50:48','2023-08-30 09:50:48'),(1681,'default','payment_edited',1032,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-08-30 09:51:26','2023-08-30 09:51:26'),(1682,'default','payment_edited',738,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2500.0000\"}}',NULL,'2023-08-30 10:03:21','2023-08-30 10:03:21'),(1683,'default','added',1041,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2350}}',NULL,'2023-08-30 10:28:02','2023-08-30 10:28:02'),(1684,'default','edited',1026,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":73840},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"73840.0000\"}}',NULL,'2023-08-30 10:31:42','2023-08-30 10:31:42'),(1685,'default','added',1042,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3750}}',NULL,'2023-08-30 11:47:23','2023-08-30 11:47:23'),(1686,'default','payment_edited',848,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4150.0000\"}}',NULL,'2023-08-30 12:04:47','2023-08-30 12:04:47'),(1687,'default','added',1043,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2}}',NULL,'2023-08-30 12:33:16','2023-08-30 12:33:16'),(1688,'default','edited',1043,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2.0000\"}}',NULL,'2023-08-30 12:33:30','2023-08-30 12:33:30'),(1689,'default','added',637,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-30 12:49:14','2023-08-30 12:49:14'),(1690,'default','added',1044,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-08-30 12:49:39','2023-08-30 12:49:39'),(1691,'default','edited',1021,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2.0000\"}}',NULL,'2023-08-30 13:04:10','2023-08-30 13:04:10'),(1692,'default','added',638,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-30 14:21:26','2023-08-30 14:21:26'),(1693,'default','added',1045,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300}}',NULL,'2023-08-30 14:23:04','2023-08-30 14:23:04'),(1694,'default','edited',1045,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2300.0000\"}}',NULL,'2023-08-30 14:27:58','2023-08-30 14:27:58'),(1695,'default','payment_edited',1016,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4400.0000\"}}',NULL,'2023-08-30 14:29:23','2023-08-30 14:29:23'),(1696,'default','payment_edited',1027,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3800.0000\"}}',NULL,'2023-08-30 14:29:49','2023-08-30 14:29:49'),(1697,'default','edited',1021,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4.0000\"}}',NULL,'2023-08-30 14:49:57','2023-08-30 14:49:57'),(1698,'default','payment_edited',1011,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3300.0000\"}}',NULL,'2023-08-30 15:20:31','2023-08-30 15:20:31'),(1699,'default','payment_edited',1039,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-08-30 15:35:44','2023-08-30 15:35:44'),(1700,'default','payment_edited',993,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"41400.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"41400.0000\"}}',NULL,'2023-08-30 15:35:56','2023-08-30 15:35:56'),(1701,'default','added',1046,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-08-31 05:23:18','2023-08-31 05:23:18'),(1702,'default','edited',1026,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":73840},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"73840.0000\"}}',NULL,'2023-08-31 05:54:55','2023-08-31 05:54:55'),(1703,'default','sell_deleted',1041,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1041,\"invoice_no\":\"ITH2023-11473\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2350.0000\"}}',NULL,'2023-08-31 06:07:35','2023-08-31 06:07:35'),(1704,'default','edited',1026,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":73840},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"73840.0000\"}}',NULL,'2023-08-31 06:30:30','2023-08-31 06:30:30'),(1705,'default','edited',1025,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"}}',NULL,'2023-08-31 07:03:20','2023-08-31 07:03:20'),(1706,'default','edited',1021,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5.0000\"}}',NULL,'2023-08-31 07:21:39','2023-08-31 07:21:39'),(1707,'default','edited',1021,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6.0000\"}}',NULL,'2023-08-31 07:27:25','2023-08-31 07:27:25'),(1708,'default','payment_edited',1042,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3750.0000\"}}',NULL,'2023-08-31 07:30:47','2023-08-31 07:30:47'),(1709,'default','edited',1037,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3150},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3200.0000\"}}',NULL,'2023-08-31 07:31:21','2023-08-31 07:31:21'),(1710,'default','payment_edited',1037,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3150.0000\"}}',NULL,'2023-08-31 07:32:10','2023-08-31 07:32:10'),(1711,'default','added',1047,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8650}}',NULL,'2023-08-31 11:52:35','2023-08-31 11:52:35'),(1712,'default','added',639,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-08-31 13:07:06','2023-08-31 13:07:06'),(1713,'default','added',1048,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-08-31 13:07:30','2023-08-31 13:07:30'),(1714,'default','added',1049,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-08-31 13:10:03','2023-08-31 13:10:03'),(1715,'default','added',1050,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5200}}',NULL,'2023-08-31 16:45:06','2023-08-31 16:45:06'),(1716,'default','added',1051,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":720}}',NULL,'2023-09-02 04:32:37','2023-09-02 04:32:37'),(1717,'default','edited',1026,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":77830},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"73840.0000\"}}',NULL,'2023-09-02 04:40:10','2023-09-02 04:40:10'),(1718,'default','added',1052,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-09-02 06:47:12','2023-09-02 06:47:12'),(1719,'default','added',640,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-02 07:23:20','2023-09-02 07:23:20'),(1720,'default','added',1053,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-09-02 07:24:25','2023-09-02 07:24:25'),(1721,'default','added',641,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-02 07:42:57','2023-09-02 07:42:57'),(1722,'default','added',1054,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2850}}',NULL,'2023-09-02 07:51:57','2023-09-02 07:51:57'),(1723,'default','added',1055,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":17215}}',NULL,'2023-09-02 08:32:05','2023-09-02 08:32:05'),(1724,'default','added',642,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-02 09:20:14','2023-09-02 09:20:14'),(1725,'default','added',1056,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3900}}',NULL,'2023-09-02 09:21:47','2023-09-02 09:21:47'),(1726,'default','edited',1054,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2850.0000\"}}',NULL,'2023-09-02 09:23:44','2023-09-02 09:23:44'),(1727,'default','added',1057,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-09-02 11:20:13','2023-09-02 11:20:13'),(1728,'default','added',1058,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-09-02 13:41:49','2023-09-02 13:41:49'),(1729,'default','added',1059,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-09-02 13:48:07','2023-09-02 13:48:07'),(1730,'default','edited',1021,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6.0000\"}}',NULL,'2023-09-02 14:10:19','2023-09-02 14:10:19'),(1731,'default','sell_deleted',1048,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1048,\"invoice_no\":\"ITH2023-11481\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1.0000\"}}',NULL,'2023-09-02 14:14:48','2023-09-02 14:14:48'),(1732,'default','payment_edited',994,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2023-09-02 14:16:23','2023-09-02 14:16:23'),(1733,'default','added',1060,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2300}}',NULL,'2023-09-02 14:17:23','2023-09-02 14:17:23'),(1734,'default','edited',1020,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1.0000\"}}',NULL,'2023-09-02 14:20:46','2023-09-02 14:20:46'),(1735,'default','payment_edited',516,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"34362.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"34362.0000\"}}',NULL,'2023-09-02 14:30:40','2023-09-02 14:30:40'),(1736,'default','edited',1026,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":76940},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"77830.0000\"}}',NULL,'2023-09-02 15:14:30','2023-09-02 15:14:30'),(1737,'default','payment_edited',1026,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"76940.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"76940.0000\"}}',NULL,'2023-09-02 15:14:48','2023-09-02 15:14:48'),(1738,'default','added',1061,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7500}}',NULL,'2023-09-03 04:58:39','2023-09-03 04:58:39'),(1739,'default','edited',1061,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7500.0000\"}}',NULL,'2023-09-03 05:01:49','2023-09-03 05:01:49'),(1740,'default','added',643,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-09-03 05:47:43','2023-09-03 05:47:43'),(1741,'default','added',1062,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-09-03 05:48:45','2023-09-03 05:48:45'),(1742,'default','added',1063,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1330}}',NULL,'2023-09-03 06:58:55','2023-09-03 06:58:55'),(1743,'default','added',1064,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-09-03 07:52:56','2023-09-03 07:52:56'),(1744,'default','added',1065,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-09-03 08:37:16','2023-09-03 08:37:16'),(1745,'default','added',644,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-03 09:15:33','2023-09-03 09:15:33'),(1746,'default','added',1066,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-09-03 09:17:34','2023-09-03 09:17:34'),(1747,'default','edited',1055,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18180},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"17215.0000\"}}',NULL,'2023-09-03 10:51:17','2023-09-03 10:51:17'),(1748,'default','sell_deleted',668,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":668,\"invoice_no\":\"ITH2023-11166\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"810.0000\"}}',NULL,'2023-09-03 13:26:39','2023-09-03 13:26:39'),(1749,'default','payment_edited',659,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"251200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"251200.0000\"}}',NULL,'2023-09-03 13:31:55','2023-09-03 13:31:55'),(1750,'default','payment_edited',680,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10800.0000\"}}',NULL,'2023-09-03 13:32:58','2023-09-03 13:32:58'),(1751,'default','sell_deleted',680,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":680,\"invoice_no\":\"ITH2023-11177\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10800.0000\"}}',NULL,'2023-09-03 13:33:08','2023-09-03 13:33:08'),(1752,'default','payment_edited',800,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1.0000\"}}',NULL,'2023-09-03 13:33:14','2023-09-03 13:33:14'),(1753,'default','payment_edited',631,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1.0000\"}}',NULL,'2023-09-03 13:33:22','2023-09-03 13:33:22'),(1754,'default','payment_edited',833,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4300.0000\"}}',NULL,'2023-09-03 13:39:26','2023-09-03 13:39:26'),(1755,'default','payment_edited',1055,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"18180.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"18180.0000\"}}',NULL,'2023-09-03 13:46:06','2023-09-03 13:46:06'),(1756,'default','payment_edited',1063,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1330.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1330.0000\"}}',NULL,'2023-09-03 14:06:57','2023-09-03 14:06:57'),(1757,'default','payment_edited',1018,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7900.0000\"}}',NULL,'2023-09-03 14:20:48','2023-09-03 14:20:48'),(1758,'default','edited',760,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7400.0000\"}}',NULL,'2023-09-03 14:32:33','2023-09-03 14:32:33'),(1759,'default','added',1067,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1150}}',NULL,'2023-09-03 14:36:35','2023-09-03 14:36:35'),(1760,'default','added',1069,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3650}}',NULL,'2023-09-03 15:20:20','2023-09-03 15:20:20'),(1761,'default','edited',1069,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3650},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3650.0000\"}}',NULL,'2023-09-03 15:20:58','2023-09-03 15:20:58'),(1762,'default','payment_edited',1067,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1150.0000\"}}',NULL,'2023-09-03 15:24:46','2023-09-03 15:24:46'),(1763,'default','payment_edited',1047,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8650.0000\"}}',NULL,'2023-09-03 15:29:15','2023-09-03 15:29:15'),(1764,'default','edited',1061,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7500.0000\"}}',NULL,'2023-09-03 15:33:36','2023-09-03 15:33:36'),(1765,'default','edited',1047,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8650.0000\"}}',NULL,'2023-09-03 15:34:25','2023-09-03 15:34:25'),(1766,'default','added',1070,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":270}}',NULL,'2023-09-04 05:38:07','2023-09-04 05:38:07'),(1767,'default','edited',1055,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17940},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"18180.0000\"}}',NULL,'2023-09-04 05:41:34','2023-09-04 05:41:34'),(1768,'default','added',1071,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":400}}',NULL,'2023-09-04 07:58:35','2023-09-04 07:58:35'),(1769,'default','payment_edited',1057,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-09-04 14:08:11','2023-09-04 14:08:11'),(1770,'default','payment_edited',1061,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4100.0000\"}}',NULL,'2023-09-04 14:08:37','2023-09-04 14:08:37'),(1771,'default','added',1072,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":300}}',NULL,'2023-09-04 15:46:04','2023-09-04 15:46:04'),(1772,'default','added',1073,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-09-04 16:44:45','2023-09-04 16:44:45'),(1773,'default','payment_edited',1070,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"270.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"270.0000\"}}',NULL,'2023-09-04 16:47:49','2023-09-04 16:47:49'),(1774,'default','payment_edited',1042,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3750.0000\"}}',NULL,'2023-09-04 16:48:12','2023-09-04 16:48:12'),(1775,'default','payment_edited',714,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"800.0000\"}}',NULL,'2023-09-05 05:32:15','2023-09-05 05:32:15'),(1776,'default','added',1074,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500}}',NULL,'2023-09-05 05:36:55','2023-09-05 05:36:55'),(1777,'default','added',1075,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-09-05 05:59:59','2023-09-05 05:59:59'),(1778,'default','payment_edited',1073,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-09-05 06:00:09','2023-09-05 06:00:09'),(1779,'default','sell_deleted',1060,'App\\Transaction',NULL,1,2,'App\\User','{\"id\":1060,\"invoice_no\":\"ITH2023-11493\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2300.0000\"}}',NULL,'2023-09-05 06:00:59','2023-09-05 06:00:59'),(1780,'default','edited',1046,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2023-09-05 06:05:09','2023-09-05 06:05:09'),(1781,'default','added',645,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-09-05 06:47:53','2023-09-05 06:47:53'),(1782,'default','added',1076,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":850}}',NULL,'2023-09-05 06:48:06','2023-09-05 06:48:06'),(1783,'default','added',1077,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2023-09-05 09:15:28','2023-09-05 09:15:28'),(1784,'default','added',1078,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":83640}}',NULL,'2023-09-05 10:24:04','2023-09-05 10:24:04'),(1785,'default','added',1079,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16800}}',NULL,'2023-09-05 10:34:20','2023-09-05 10:34:20'),(1786,'default','added',646,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-05 11:59:27','2023-09-05 11:59:27'),(1787,'default','added',1080,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":22990}}',NULL,'2023-09-05 12:04:25','2023-09-05 12:04:25'),(1788,'default','added',1081,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9930}}',NULL,'2023-09-05 13:05:38','2023-09-05 13:05:38'),(1789,'default','edited',1081,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9930},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"9930.0000\"}}',NULL,'2023-09-05 13:06:34','2023-09-05 13:06:34'),(1790,'default','payment_edited',1074,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2500.0000\"}}',NULL,'2023-09-05 13:21:46','2023-09-05 13:21:46'),(1791,'default','payment_edited',1027,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3800.0000\"}}',NULL,'2023-09-05 13:22:32','2023-09-05 13:22:32'),(1792,'default','added',1082,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1900}}',NULL,'2023-09-06 06:02:29','2023-09-06 06:02:29'),(1793,'default','added',1083,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-09-06 07:14:02','2023-09-06 07:14:02'),(1794,'default','edited',1082,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1900.0000\"}}',NULL,'2023-09-06 09:31:41','2023-09-06 09:31:41'),(1795,'default','payment_edited',986,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4300.0000\"}}',NULL,'2023-09-06 10:21:24','2023-09-06 10:21:24'),(1796,'default','added',1084,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-09-06 10:41:12','2023-09-06 10:41:12'),(1797,'default','added',1086,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1450}}',NULL,'2023-09-06 11:16:51','2023-09-06 11:16:51'),(1798,'default','added',1087,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300}}',NULL,'2023-09-06 15:26:46','2023-09-06 15:26:46'),(1799,'default','added',1088,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":480}}',NULL,'2023-09-06 15:27:57','2023-09-06 15:27:57'),(1800,'default','added',1089,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250}}',NULL,'2023-09-07 05:42:10','2023-09-07 05:42:10'),(1801,'default','added',1090,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1380}}',NULL,'2023-09-07 07:21:59','2023-09-07 07:21:59'),(1802,'default','added',1091,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":150}}',NULL,'2023-09-07 07:34:34','2023-09-07 07:34:34'),(1803,'default','added',1092,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4100}}',NULL,'2023-09-07 08:21:37','2023-09-07 08:21:37'),(1804,'default','added',647,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-07 12:32:02','2023-09-07 12:32:02'),(1805,'default','added',1094,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-09-07 12:32:16','2023-09-07 12:32:16'),(1806,'default','edited',1092,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4100.0000\"}}',NULL,'2023-09-07 12:51:21','2023-09-07 12:51:21'),(1807,'default','edited',1082,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3800.0000\"}}',NULL,'2023-09-07 13:55:52','2023-09-07 13:55:52'),(1808,'default','added',648,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-07 14:18:30','2023-09-07 14:18:30'),(1809,'default','added',1095,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5200}}',NULL,'2023-09-07 14:19:56','2023-09-07 14:19:56'),(1810,'default','added',1097,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9200}}',NULL,'2023-09-07 14:26:41','2023-09-07 14:26:41'),(1811,'default','payment_edited',1082,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3300.0000\"}}',NULL,'2023-09-07 14:43:55','2023-09-07 14:43:55'),(1812,'default','payment_edited',1086,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1450.0000\"}}',NULL,'2023-09-07 14:44:12','2023-09-07 14:44:12'),(1813,'default','added',649,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-07 15:10:18','2023-09-07 15:10:18'),(1814,'default','added',1098,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-09-07 15:11:50','2023-09-07 15:11:50'),(1815,'default','edited',1092,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3750.0000\"}}',NULL,'2023-09-07 17:10:05','2023-09-07 17:10:05'),(1816,'default','payment_edited',1089,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2023-09-07 17:10:15','2023-09-07 17:10:15'),(1817,'default','added',1099,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}',NULL,'2023-09-09 07:41:41','2023-09-09 07:41:41'),(1818,'default','added',1100,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":51100}}',NULL,'2023-09-09 09:07:51','2023-09-09 09:07:51'),(1819,'default','edited',1100,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":68800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"51100.0000\"}}',NULL,'2023-09-09 09:26:48','2023-09-09 09:26:48'),(1820,'default','added',1102,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-09-09 09:55:37','2023-09-09 09:55:37'),(1821,'default','payment_edited',646,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1110.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1110.0000\"}}',NULL,'2023-09-09 09:56:33','2023-09-09 09:56:33'),(1822,'default','added',650,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-09-09 10:07:15','2023-09-09 10:07:15'),(1823,'default','added',1103,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-09-09 10:07:43','2023-09-09 10:07:43'),(1824,'default','added',1104,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2100}}',NULL,'2023-09-09 11:21:02','2023-09-09 11:21:02'),(1825,'default','added',1106,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2023-09-09 13:23:40','2023-09-09 13:23:40'),(1826,'default','edited',1106,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"}}',NULL,'2023-09-09 13:24:57','2023-09-09 13:24:57'),(1827,'default','edited',1106,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"}}',NULL,'2023-09-09 13:26:29','2023-09-09 13:26:29'),(1828,'default','edited',980,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":40850},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"39300.0000\"}}',NULL,'2023-09-09 17:49:23','2023-09-09 17:49:23'),(1829,'default','edited',980,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":44050},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"40850.0000\"}}',NULL,'2023-09-09 17:54:02','2023-09-09 17:54:02'),(1830,'default','payment_edited',980,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"44050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"44050.0000\"}}',NULL,'2023-09-09 18:06:02','2023-09-09 18:06:02'),(1831,'default','added',651,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-09 18:19:59','2023-09-09 18:19:59'),(1832,'default','added',1108,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":31500}}',NULL,'2023-09-09 18:23:44','2023-09-09 18:23:44'),(1833,'default','added',1109,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":480}}',NULL,'2023-09-09 19:25:35','2023-09-09 19:25:35'),(1834,'default','added',1110,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400}}',NULL,'2023-09-09 19:26:56','2023-09-09 19:26:56'),(1835,'default','edited',980,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":44050},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"44050.0000\"}}',NULL,'2023-09-09 19:27:25','2023-09-09 19:27:25'),(1836,'default','added',1111,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-09-10 06:01:21','2023-09-10 06:01:21'),(1837,'default','added',1112,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2350}}',NULL,'2023-09-10 06:10:46','2023-09-10 06:10:46'),(1838,'default','payment_edited',1027,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3800.0000\"}}',NULL,'2023-09-10 06:56:22','2023-09-10 06:56:22'),(1839,'default','payment_edited',1090,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1380.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1380.0000\"}}',NULL,'2023-09-10 06:56:37','2023-09-10 06:56:37'),(1840,'default','added',1113,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400}}',NULL,'2023-09-10 07:05:25','2023-09-10 07:05:25'),(1841,'default','added',1114,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-09-10 08:09:40','2023-09-10 08:09:40'),(1842,'default','added',1115,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-09-10 09:49:30','2023-09-10 09:49:30'),(1843,'default','added',1117,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2800}}',NULL,'2023-09-10 10:59:49','2023-09-10 10:59:49'),(1844,'default','added',1118,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":600}}',NULL,'2023-09-10 11:08:48','2023-09-10 11:08:48'),(1845,'default','added',1119,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":800}}',NULL,'2023-09-10 11:38:32','2023-09-10 11:38:32'),(1846,'default','payment_edited',818,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2050.0000\"}}',NULL,'2023-09-10 12:54:32','2023-09-10 12:54:32'),(1847,'default','payment_edited',899,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2050.0000\"}}',NULL,'2023-09-10 12:56:00','2023-09-10 12:56:00'),(1848,'default','added',1120,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2300}}',NULL,'2023-09-10 15:27:34','2023-09-10 15:27:34'),(1849,'default','edited',980,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":43500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"44050.0000\"}}',NULL,'2023-09-10 15:29:44','2023-09-10 15:29:44'),(1850,'default','payment_edited',980,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"43500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"43500.0000\"}}',NULL,'2023-09-10 15:30:01','2023-09-10 15:30:01'),(1851,'default','payment_edited',1092,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4200.0000\"}}',NULL,'2023-09-10 15:42:46','2023-09-10 15:42:46'),(1852,'default','sell_deleted',843,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":843,\"invoice_no\":\"ITH2023-11309\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1920.0000\"}}',NULL,'2023-09-10 15:51:31','2023-09-10 15:51:31'),(1853,'default','payment_edited',916,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2418.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2418.0000\"}}',NULL,'2023-09-10 15:53:38','2023-09-10 15:53:38'),(1854,'default','added',1121,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4140}}',NULL,'2023-09-11 06:49:43','2023-09-11 06:49:43'),(1855,'default','added',1122,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250}}',NULL,'2023-09-11 07:58:55','2023-09-11 07:58:55'),(1856,'default','added',1123,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-09-11 08:22:11','2023-09-11 08:22:11'),(1857,'default','payment_edited',1123,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-09-11 08:22:18','2023-09-11 08:22:18'),(1858,'default','payment_edited',1075,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-09-11 09:29:37','2023-09-11 09:29:37'),(1859,'default','payment_edited',1088,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"480.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"480.0000\"}}',NULL,'2023-09-11 09:29:37','2023-09-11 09:29:37'),(1860,'default','added',1124,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-09-11 10:11:38','2023-09-11 10:11:38'),(1861,'default','added',1125,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-09-11 12:07:01','2023-09-11 12:07:01'),(1862,'default','payment_edited',1120,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2300.0000\"}}',NULL,'2023-09-11 13:36:12','2023-09-11 13:36:12'),(1863,'default','added',1126,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6500}}',NULL,'2023-09-11 13:37:43','2023-09-11 13:37:43'),(1864,'default','payment_edited',649,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"300.0000\"}}',NULL,'2023-09-11 13:46:32','2023-09-11 13:46:32'),(1865,'default','payment_edited',1018,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7900.0000\"}}',NULL,'2023-09-11 13:46:32','2023-09-11 13:46:32'),(1866,'default','added',1127,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2600}}',NULL,'2023-09-11 15:42:01','2023-09-11 15:42:01'),(1867,'default','edited',1127,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2600.0000\"}}',NULL,'2023-09-11 17:11:44','2023-09-11 17:11:44'),(1868,'default','added',1128,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-09-12 07:42:35','2023-09-12 07:42:35'),(1869,'default','payment_edited',1117,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2800.0000\"}}',NULL,'2023-09-12 08:17:32','2023-09-12 08:17:32'),(1870,'default','added',1129,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-09-12 08:26:38','2023-09-12 08:26:38'),(1871,'default','added',1130,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-09-12 08:40:41','2023-09-12 08:40:41'),(1872,'default','added',1131,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2300}}',NULL,'2023-09-12 09:04:31','2023-09-12 09:04:31'),(1873,'default','added',652,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-12 10:49:47','2023-09-12 10:49:47'),(1874,'default','added',1132,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5100}}',NULL,'2023-09-12 10:51:48','2023-09-12 10:51:48'),(1875,'default','edited',1131,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2300.0000\"}}',NULL,'2023-09-12 12:51:12','2023-09-12 12:51:12'),(1876,'default','edited',1128,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-09-12 12:53:50','2023-09-12 12:53:50'),(1877,'default','edited',1009,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1550.0000\"}}',NULL,'2023-09-12 13:15:50','2023-09-12 13:15:50'),(1878,'default','payment_edited',1009,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-09-12 13:16:52','2023-09-12 13:16:52'),(1879,'default','added',1133,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3700}}',NULL,'2023-09-12 13:36:02','2023-09-12 13:36:02'),(1880,'default','added',1134,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-09-12 14:48:31','2023-09-12 14:48:31'),(1881,'default','edited',1128,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3700.0000\"}}',NULL,'2023-09-12 15:13:42','2023-09-12 15:13:42'),(1882,'default','sell_deleted',1133,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1133,\"invoice_no\":\"ITH2023-11556\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3700.0000\"}}',NULL,'2023-09-12 15:13:50','2023-09-12 15:13:50'),(1883,'default','payment_edited',818,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2050.0000\"}}',NULL,'2023-09-12 15:14:37','2023-09-12 15:14:37'),(1884,'default','payment_edited',899,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2050.0000\"}}',NULL,'2023-09-12 15:14:37','2023-09-12 15:14:37'),(1885,'default','payment_edited',971,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1260.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1260.0000\"}}',NULL,'2023-09-12 15:14:37','2023-09-12 15:14:37'),(1886,'default','payment_edited',1128,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-09-12 15:14:37','2023-09-12 15:14:37'),(1887,'default','added',1135,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2023-09-12 17:03:32','2023-09-12 17:03:32'),(1888,'default','added',1136,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-09-13 06:19:42','2023-09-13 06:19:42'),(1889,'default','edited',1136,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"}}',NULL,'2023-09-13 06:20:00','2023-09-13 06:20:00'),(1890,'default','edited',1134,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-09-13 06:25:01','2023-09-13 06:25:01'),(1891,'default','edited',1127,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-09-13 06:29:04','2023-09-13 06:29:04'),(1892,'default','added',1137,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":35500}}',NULL,'2023-09-13 13:30:37','2023-09-13 13:30:37'),(1893,'default','payment_edited',1004,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2500.0000\"}}',NULL,'2023-09-13 13:59:53','2023-09-13 13:59:53'),(1894,'default','added',653,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-13 14:04:16','2023-09-13 14:04:16'),(1895,'default','added',1138,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-09-13 14:05:19','2023-09-13 14:05:19'),(1896,'default','added',654,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-09-13 16:12:13','2023-09-13 16:12:13'),(1897,'default','added',1139,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":450}}',NULL,'2023-09-13 16:12:53','2023-09-13 16:12:53'),(1898,'default','added',1140,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14130}}',NULL,'2023-09-14 08:07:41','2023-09-14 08:07:41'),(1899,'default','added',1141,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-09-14 11:55:12','2023-09-14 11:55:12'),(1900,'default','added',1143,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":8440}}',NULL,'2023-09-14 12:41:35','2023-09-14 12:41:35'),(1901,'default','added',1144,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300}}',NULL,'2023-09-14 12:44:43','2023-09-14 12:44:43'),(1902,'default','added',1145,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-09-14 13:24:37','2023-09-14 13:24:37'),(1903,'default','added',1146,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3600}}',NULL,'2023-09-14 13:26:56','2023-09-14 13:26:56'),(1904,'default','added',1147,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-09-14 13:28:36','2023-09-14 13:28:36'),(1905,'default','edited',1140,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":14830},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"14130.0000\"}}',NULL,'2023-09-14 16:03:52','2023-09-14 16:03:52'),(1906,'default','added',1148,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":690}}',NULL,'2023-09-14 16:07:36','2023-09-14 16:07:36'),(1907,'default','added',1149,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1950}}',NULL,'2023-09-14 16:49:10','2023-09-14 16:49:10'),(1908,'default','added',1150,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1200}}',NULL,'2023-09-14 16:50:22','2023-09-14 16:50:22'),(1909,'default','added',655,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-09-16 09:04:43','2023-09-16 09:04:43'),(1910,'default','added',1151,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":949}}',NULL,'2023-09-16 09:06:38','2023-09-16 09:06:38'),(1911,'default','added',656,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-09-16 09:44:18','2023-09-16 09:44:18'),(1912,'default','added',1152,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":7500}}',NULL,'2023-09-16 09:44:31','2023-09-16 09:44:31'),(1913,'default','payment_edited',1152,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"7500.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"7500.0000\"}}',NULL,'2023-09-16 09:46:12','2023-09-16 09:46:12'),(1914,'default','added',1153,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7500}}',NULL,'2023-09-16 10:17:28','2023-09-16 10:17:28'),(1915,'default','added',1154,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4700}}',NULL,'2023-09-16 10:38:48','2023-09-16 10:38:48'),(1916,'default','added',657,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-16 11:54:00','2023-09-16 11:54:00'),(1917,'default','added',1156,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":16350}}',NULL,'2023-09-16 12:02:35','2023-09-16 12:02:35'),(1918,'default','sell_deleted',1130,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1130,\"invoice_no\":\"ITH2023-11553\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-09-16 13:56:44','2023-09-16 13:56:44'),(1919,'default','added',658,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-16 14:43:02','2023-09-16 14:43:02'),(1920,'default','added',1157,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400}}',NULL,'2023-09-16 14:48:43','2023-09-16 14:48:43'),(1921,'default','added',659,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-16 15:23:12','2023-09-16 15:23:12'),(1922,'default','added',1158,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-09-16 15:26:45','2023-09-16 15:26:45'),(1923,'default','edited',1154,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4700.0000\"}}',NULL,'2023-09-16 15:31:16','2023-09-16 15:31:16'),(1924,'default','added',1159,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2025}}',NULL,'2023-09-16 15:36:31','2023-09-16 15:36:31'),(1925,'default','payment_edited',1125,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-09-16 15:38:05','2023-09-16 15:38:05'),(1926,'default','payment_edited',1127,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-09-16 15:38:28','2023-09-16 15:38:28'),(1927,'default','payment_edited',1154,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7300.0000\"}}',NULL,'2023-09-16 15:39:28','2023-09-16 15:39:28'),(1928,'default','payment_edited',848,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4150.0000\"}}',NULL,'2023-09-16 16:07:16','2023-09-16 16:07:16'),(1929,'default','edited',783,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"16850.0000\"}}',NULL,'2023-09-16 16:09:37','2023-09-16 16:09:37'),(1930,'default','edited',798,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6700.0000\"}}',NULL,'2023-09-16 16:10:12','2023-09-16 16:10:12'),(1931,'default','payment_edited',1141,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-09-16 16:23:37','2023-09-16 16:23:37'),(1932,'default','added',660,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-16 17:47:52','2023-09-16 17:47:52'),(1933,'default','added',1160,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500}}',NULL,'2023-09-16 17:53:11','2023-09-16 17:53:11'),(1934,'default','payment_edited',1160,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2500.0000\"}}',NULL,'2023-09-16 17:53:32','2023-09-16 17:53:32'),(1935,'default','edited',1153,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7500.0000\"}}',NULL,'2023-09-16 17:55:05','2023-09-16 17:55:05'),(1936,'default','edited',1148,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":360},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"690.0000\"}}',NULL,'2023-09-17 05:58:36','2023-09-17 05:58:36'),(1937,'default','added',1161,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-09-17 05:59:25','2023-09-17 05:59:25'),(1938,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-09-17 10:14:54','2023-09-17 10:14:54'),(1939,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-09-17 10:14:57','2023-09-17 10:14:57'),(1940,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-09-17 10:15:37','2023-09-17 10:15:37'),(1941,'default','payment_edited',1160,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2500.0000\"}}',NULL,'2023-09-17 13:01:58','2023-09-17 13:01:58'),(1942,'default','added',1162,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250}}',NULL,'2023-09-18 06:33:56','2023-09-18 06:33:56'),(1943,'default','edited',406,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-18 06:36:09','2023-09-18 06:36:09'),(1944,'default','added',1163,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-09-18 06:38:55','2023-09-18 06:38:55'),(1945,'default','added',1164,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8600}}',NULL,'2023-09-18 07:07:19','2023-09-18 07:07:19'),(1946,'default','added',1165,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13950}}',NULL,'2023-09-18 07:09:28','2023-09-18 07:09:28'),(1947,'default','added',1166,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1100}}',NULL,'2023-09-18 08:10:03','2023-09-18 08:10:03'),(1948,'default','added',1167,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":300}}',NULL,'2023-09-18 08:34:00','2023-09-18 08:34:00'),(1949,'default','edited',1167,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"300.0000\"}}',NULL,'2023-09-18 08:35:28','2023-09-18 08:35:28'),(1950,'default','added',1168,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-09-18 11:55:10','2023-09-18 11:55:10'),(1951,'default','payment_edited',1134,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-09-18 11:55:41','2023-09-18 11:55:41'),(1952,'default','payment_edited',1147,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-09-18 11:55:41','2023-09-18 11:55:41'),(1953,'default','payment_edited',1153,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4100.0000\"}}',NULL,'2023-09-18 11:55:41','2023-09-18 11:55:41'),(1954,'default','added',661,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-18 11:56:54','2023-09-18 11:56:54'),(1955,'default','added',1169,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":40500}}',NULL,'2023-09-18 12:18:58','2023-09-18 12:18:58'),(1956,'default','edited',1169,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":40500},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"40500.0000\"}}',NULL,'2023-09-18 12:33:53','2023-09-18 12:33:53'),(1957,'default','added',1170,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5200}}',NULL,'2023-09-18 12:58:02','2023-09-18 12:58:02'),(1958,'default','edited',1169,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":42000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"40500.0000\"}}',NULL,'2023-09-18 14:24:07','2023-09-18 14:24:07'),(1959,'default','payment_edited',1169,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"42000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"42000.0000\"}}',NULL,'2023-09-18 14:38:07','2023-09-18 14:38:07'),(1960,'default','payment_edited',1090,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1380.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1380.0000\"}}',NULL,'2023-09-18 15:09:48','2023-09-18 15:09:48'),(1961,'default','payment_edited',1112,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2350.0000\"}}',NULL,'2023-09-18 15:09:48','2023-09-18 15:09:48'),(1962,'default','payment_edited',1136,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"700.0000\"}}',NULL,'2023-09-18 15:09:48','2023-09-18 15:09:48'),(1963,'default','payment_edited',1018,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7900.0000\"}}',NULL,'2023-09-18 15:18:00','2023-09-18 15:18:00'),(1964,'default','sell_deleted',1163,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1163,\"invoice_no\":\"ITH2023-11581\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-09-18 15:19:22','2023-09-18 15:19:22'),(1965,'default','sell_deleted',1144,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1144,\"invoice_no\":\"ITH2023-11565\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3300.0000\"}}',NULL,'2023-09-18 15:19:33','2023-09-18 15:19:33'),(1966,'default','payment_edited',1122,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2023-09-18 15:19:59','2023-09-18 15:19:59'),(1967,'default','payment_edited',1126,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6500.0000\"}}',NULL,'2023-09-18 15:28:36','2023-09-18 15:28:36'),(1968,'default','payment_edited',1126,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6500.0000\"}}',NULL,'2023-09-18 15:28:48','2023-09-18 15:28:48'),(1969,'default','added',1176,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-09-18 16:27:33','2023-09-18 16:27:33'),(1970,'default','payment_edited',1154,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7300.0000\"}}',NULL,'2023-09-18 16:32:41','2023-09-18 16:32:41'),(1971,'default','edited',1165,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13950.0000\"}}',NULL,'2023-09-19 05:56:57','2023-09-19 05:56:57'),(1972,'default','payment_edited',1165,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13950.0000\"}}',NULL,'2023-09-19 05:57:42','2023-09-19 05:57:42'),(1973,'default','edited',1156,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":18650},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"16350.0000\"}}',NULL,'2023-09-19 06:10:46','2023-09-19 06:10:46'),(1974,'default','edited',1156,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18650},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"18650.0000\"}}',NULL,'2023-09-19 06:14:50','2023-09-19 06:14:50'),(1975,'default','edited',1156,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18650},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"18650.0000\"}}',NULL,'2023-09-19 06:15:09','2023-09-19 06:15:09'),(1976,'default','edited',1156,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18650},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"18650.0000\"}}',NULL,'2023-09-19 06:21:21','2023-09-19 06:21:21'),(1977,'default','edited',1170,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5200.0000\"}}',NULL,'2023-09-19 07:59:52','2023-09-19 07:59:52'),(1978,'default','sell_deleted',882,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":882,\"invoice_no\":\"ITH2023-11338\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"700.0000\"}}',NULL,'2023-09-19 08:01:28','2023-09-19 08:01:28'),(1979,'default','edited',1170,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8400.0000\"}}',NULL,'2023-09-19 08:01:53','2023-09-19 08:01:53'),(1980,'default','added',1179,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":12000}}',NULL,'2023-09-19 08:32:25','2023-09-19 08:32:25'),(1981,'default','edited',1179,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":15000},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"12000.0000\"}}',NULL,'2023-09-19 08:33:47','2023-09-19 08:33:47'),(1982,'default','added',1180,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-09-19 09:48:04','2023-09-19 09:48:04'),(1983,'default','edited',1180,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"}}',NULL,'2023-09-19 09:48:42','2023-09-19 09:48:42'),(1984,'default','added',1181,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2800}}',NULL,'2023-09-19 11:29:21','2023-09-19 11:29:21'),(1985,'default','edited',1156,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":19126},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"18650.0000\"}}',NULL,'2023-09-19 11:48:10','2023-09-19 11:48:10'),(1986,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-09-19 12:38:50','2023-09-19 12:38:50'),(1987,'default','added',1182,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4000}}',NULL,'2023-09-19 12:42:07','2023-09-19 12:42:07'),(1988,'default','sell_deleted',1056,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1056,\"invoice_no\":\"ITH2023-11489\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3900.0000\"}}',NULL,'2023-09-19 16:41:28','2023-09-19 16:41:28'),(1989,'default','added',1183,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14500}}',NULL,'2023-09-20 06:32:25','2023-09-20 06:32:25'),(1990,'default','added',1185,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-09-20 07:09:15','2023-09-20 07:09:15'),(1991,'default','added',662,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-20 09:34:43','2023-09-20 09:34:43'),(1992,'default','added',1186,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4600}}',NULL,'2023-09-20 09:35:59','2023-09-20 09:35:59'),(1993,'default','added',1187,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2023-09-20 12:24:55','2023-09-20 12:24:55'),(1994,'default','added',1188,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1950}}',NULL,'2023-09-20 12:59:46','2023-09-20 12:59:46'),(1995,'default','payment_edited',1149,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1950.0000\"}}',NULL,'2023-09-20 13:09:33','2023-09-20 13:09:33'),(1996,'default','payment_edited',1150,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1200.0000\"}}',NULL,'2023-09-20 13:09:33','2023-09-20 13:09:33'),(1997,'default','payment_edited',1188,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1950.0000\"}}',NULL,'2023-09-20 13:09:33','2023-09-20 13:09:33'),(1998,'default','added',1190,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-09-20 13:24:32','2023-09-20 13:24:32'),(1999,'default','added',663,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-20 13:38:42','2023-09-20 13:38:42'),(2000,'default','added',1191,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":18023}}',NULL,'2023-09-20 13:44:40','2023-09-20 13:44:40'),(2001,'default','edited',1191,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":18023},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"18023.0000\"}}',NULL,'2023-09-20 13:46:27','2023-09-20 13:46:27'),(2002,'default','payment_edited',1156,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"19126.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"19126.0000\"}}',NULL,'2023-09-20 15:55:16','2023-09-20 15:55:16'),(2003,'default','added',664,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-20 16:20:02','2023-09-20 16:20:02'),(2004,'default','added',1192,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-09-20 16:21:08','2023-09-20 16:21:08'),(2005,'default','edited',1192,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"}}',NULL,'2023-09-20 16:24:08','2023-09-20 16:24:08'),(2006,'default','edited',1191,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":18023},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"18023.0000\"}}',NULL,'2023-09-21 05:22:07','2023-09-21 05:22:07'),(2007,'default','sell_deleted',1187,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1187,\"invoice_no\":\"ITH2023-11597\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-09-21 05:31:17','2023-09-21 05:31:17'),(2008,'default','added',665,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-21 10:43:10','2023-09-21 10:43:10'),(2009,'default','added',1193,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-09-21 10:43:45','2023-09-21 10:43:45'),(2010,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-09-21 11:47:04','2023-09-21 11:47:04'),(2011,'default','added',666,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-21 11:58:54','2023-09-21 11:58:54'),(2012,'default','added',1194,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":39900}}',NULL,'2023-09-21 12:15:06','2023-09-21 12:15:06'),(2013,'default','edited',1194,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":39300},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"39900.0000\"}}',NULL,'2023-09-21 12:16:47','2023-09-21 12:16:47'),(2014,'default','edited',120,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-21 12:47:39','2023-09-21 12:47:39'),(2015,'default','added',1195,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-09-21 12:48:21','2023-09-21 12:48:21'),(2016,'default','added',1196,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":38638}}',NULL,'2023-09-21 14:23:26','2023-09-21 14:23:26'),(2017,'default','edited',1196,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":37238},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"38638.0000\"}}',NULL,'2023-09-21 14:25:15','2023-09-21 14:25:15'),(2018,'default','edited',1191,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":18943},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"18023.0000\"}}',NULL,'2023-09-21 14:44:40','2023-09-21 14:44:40'),(2019,'default','added',1197,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250}}',NULL,'2023-09-21 15:40:23','2023-09-21 15:40:23'),(2020,'default','edited',1197,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2023-09-21 15:42:29','2023-09-21 15:42:29'),(2021,'default','edited',1176,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-09-21 15:46:13','2023-09-21 15:46:13'),(2022,'default','payment_edited',1154,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7300.0000\"}}',NULL,'2023-09-21 15:47:25','2023-09-21 15:47:25'),(2023,'default','payment_edited',1159,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2025.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2025.0000\"}}',NULL,'2023-09-21 15:47:25','2023-09-21 15:47:25'),(2024,'default','payment_edited',1161,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-09-21 15:47:25','2023-09-21 15:47:25'),(2025,'default','payment_edited',1176,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5950.0000\"}}',NULL,'2023-09-21 15:47:25','2023-09-21 15:47:25'),(2026,'default','added',1198,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-09-21 16:49:50','2023-09-21 16:49:50'),(2027,'default','added',1199,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1950}}',NULL,'2023-09-21 17:27:57','2023-09-21 17:27:57'),(2028,'default','edited',1194,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":39300},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"39300.0000\"}}',NULL,'2023-09-23 06:46:18','2023-09-23 06:46:18'),(2029,'default','edited',1194,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":39300},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"39300.0000\"}}',NULL,'2023-09-23 09:07:57','2023-09-23 09:07:57'),(2030,'default','edited',1194,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":39300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"39300.0000\"}}',NULL,'2023-09-23 09:08:12','2023-09-23 09:08:12'),(2031,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-09-23 12:18:59','2023-09-23 12:18:59'),(2032,'default','added',667,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-23 14:13:42','2023-09-23 14:13:42'),(2033,'default','added',1201,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5200}}',NULL,'2023-09-23 14:16:37','2023-09-23 14:16:37'),(2034,'default','added',1202,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-09-23 14:29:45','2023-09-23 14:29:45'),(2035,'default','edited',1194,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":58300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"39300.0000\"}}',NULL,'2023-09-23 14:31:09','2023-09-23 14:31:09'),(2036,'default','added',1203,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-09-24 05:14:13','2023-09-24 05:14:13'),(2037,'default','payment_edited',1176,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5950.0000\"}}',NULL,'2023-09-24 05:15:40','2023-09-24 05:15:40'),(2038,'default','payment_edited',1203,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2023-09-24 05:15:40','2023-09-24 05:15:40'),(2039,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-09-24 07:08:52','2023-09-24 07:08:52'),(2040,'default','added',668,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-09-24 07:09:47','2023-09-24 07:09:47'),(2041,'default','added',669,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-09-24 08:55:14','2023-09-24 08:55:14'),(2042,'default','added',1204,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":300}}',NULL,'2023-09-24 08:56:28','2023-09-24 08:56:28'),(2043,'default','added',1205,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4180}}',NULL,'2023-09-24 11:13:01','2023-09-24 11:13:01'),(2044,'default','added',1206,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-09-24 11:39:59','2023-09-24 11:39:59'),(2045,'default','added',1207,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3800}}',NULL,'2023-09-24 11:44:25','2023-09-24 11:44:25'),(2046,'default','added',670,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-09-24 12:17:43','2023-09-24 12:17:43'),(2047,'default','added',1208,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":520}}',NULL,'2023-09-24 12:19:04','2023-09-24 12:19:04'),(2048,'default','payment_edited',1199,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1950.0000\"}}',NULL,'2023-09-24 12:39:03','2023-09-24 12:39:03'),(2049,'default','payment_edited',1205,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4180.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4180.0000\"}}',NULL,'2023-09-24 12:39:03','2023-09-24 12:39:03'),(2050,'default','added',1209,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000}}',NULL,'2023-09-24 12:44:45','2023-09-24 12:44:45'),(2051,'default','edited',1194,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":58800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"58300.0000\"}}',NULL,'2023-09-24 12:45:40','2023-09-24 12:45:40'),(2052,'default','edited',1194,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":58000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"58800.0000\"}}',NULL,'2023-09-24 12:50:41','2023-09-24 12:50:41'),(2053,'default','payment_edited',1194,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"58000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"58000.0000\"}}',NULL,'2023-09-24 12:50:55','2023-09-24 12:50:55'),(2054,'default','edited',1191,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":19343},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"18943.0000\"}}',NULL,'2023-09-24 12:55:11','2023-09-24 12:55:11'),(2055,'default','edited',1143,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":6530},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"8440.0000\"}}',NULL,'2023-09-24 13:05:35','2023-09-24 13:05:35'),(2056,'default','edited',1179,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":22842},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"15000.0000\"}}',NULL,'2023-09-24 13:12:46','2023-09-24 13:12:46'),(2057,'default','payment_edited',1191,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"19343.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"19343.0000\"}}',NULL,'2023-09-24 13:34:53','2023-09-24 13:34:53'),(2058,'default','edited',1191,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":19343},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"19343.0000\"}}',NULL,'2023-09-24 13:38:04','2023-09-24 13:38:04'),(2059,'default','added',671,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-24 15:06:49','2023-09-24 15:06:49'),(2060,'default','added',1210,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-09-24 15:07:48','2023-09-24 15:07:48'),(2061,'default','added',1211,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2500}}',NULL,'2023-09-24 16:45:03','2023-09-24 16:45:03'),(2062,'default','payment_edited',1180,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-09-25 07:56:56','2023-09-25 07:56:56'),(2063,'default','payment_edited',1207,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3800.0000\"}}',NULL,'2023-09-25 07:56:56','2023-09-25 07:56:56'),(2064,'default','edited',1046,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3400.0000\"}}',NULL,'2023-09-25 08:59:19','2023-09-25 08:59:19'),(2065,'default','added',672,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-25 12:40:42','2023-09-25 12:40:42'),(2066,'default','added',1213,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9500}}',NULL,'2023-09-25 12:42:00','2023-09-25 12:42:00'),(2067,'default','added',1214,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5300}}',NULL,'2023-09-25 13:19:49','2023-09-25 13:19:49'),(2068,'default','added',1215,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-09-25 14:11:13','2023-09-25 14:11:13'),(2069,'default','added',1216,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400}}',NULL,'2023-09-25 14:20:54','2023-09-25 14:20:54'),(2070,'default','added',673,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-25 14:46:51','2023-09-25 14:46:51'),(2071,'default','added',1217,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2600}}',NULL,'2023-09-25 14:47:49','2023-09-25 14:47:49'),(2072,'default','payment_edited',1211,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2500.0000\"}}',NULL,'2023-09-25 15:41:44','2023-09-25 15:41:44'),(2073,'default','added',1218,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-09-25 16:04:47','2023-09-25 16:04:47'),(2074,'default','payment_edited',1140,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"14830.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"14830.0000\"}}',NULL,'2023-09-25 16:10:49','2023-09-25 16:10:49'),(2075,'default','payment_edited',1162,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2023-09-25 16:12:27','2023-09-25 16:12:27'),(2076,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-09-26 04:40:28','2023-09-26 04:40:28'),(2077,'default','added',1219,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":200}}',NULL,'2023-09-26 11:46:08','2023-09-26 11:46:08'),(2078,'default','added',1220,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-09-26 11:55:56','2023-09-26 11:55:56'),(2079,'default','added',1221,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-09-26 12:00:40','2023-09-26 12:00:40'),(2080,'default','added',1222,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-09-26 12:03:58','2023-09-26 12:03:58'),(2081,'default','edited',1196,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":21414},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"37238.0000\"}}',NULL,'2023-09-26 13:00:26','2023-09-26 13:00:26'),(2082,'default','payment_edited',1196,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"21414.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"21414.0000\"}}',NULL,'2023-09-26 13:00:52','2023-09-26 13:00:52'),(2083,'default','edited',1196,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":21414},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"21414.0000\"}}',NULL,'2023-09-26 13:02:56','2023-09-26 13:02:56'),(2084,'default','added',674,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-26 13:08:26','2023-09-26 13:08:26'),(2085,'default','added',1223,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":800}}',NULL,'2023-09-26 13:08:48','2023-09-26 13:08:48'),(2086,'default','added',1225,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":4000}}',NULL,'2023-09-26 13:13:14','2023-09-26 13:13:14'),(2087,'default','edited',1225,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4000},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"4000.0000\"}}',NULL,'2023-09-26 13:34:46','2023-09-26 13:34:46'),(2088,'default','added',1227,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-09-26 13:59:40','2023-09-26 13:59:40'),(2089,'default','edited',1227,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3180},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-09-26 14:00:09','2023-09-26 14:00:09'),(2090,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-09-27 06:24:23','2023-09-27 06:24:23'),(2091,'default','added',1228,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-09-27 06:25:57','2023-09-27 06:25:57'),(2092,'default','payment_edited',1132,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5100.0000\"}}',NULL,'2023-09-27 07:58:42','2023-09-27 07:58:42'),(2093,'default','payment_edited',1217,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2600.0000\"}}',NULL,'2023-09-27 08:22:20','2023-09-27 08:22:20'),(2094,'default','edited',1217,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"}}',NULL,'2023-09-27 08:23:26','2023-09-27 08:23:26'),(2095,'default','payment_edited',1207,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3800.0000\"}}',NULL,'2023-09-27 09:05:10','2023-09-27 09:05:10'),(2096,'default','added',1229,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-09-27 09:12:11','2023-09-27 09:12:11'),(2097,'default','added',1230,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3200}}',NULL,'2023-09-27 10:29:06','2023-09-27 10:29:06'),(2098,'default','payment_edited',1146,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3600.0000\"}}',NULL,'2023-09-27 10:49:04','2023-09-27 10:49:04'),(2099,'default','edited',1221,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1.0000\"}}',NULL,'2023-09-27 13:28:42','2023-09-27 13:28:42'),(2100,'default','added',1231,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-09-27 13:29:59','2023-09-27 13:29:59'),(2101,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-09-27 14:57:43','2023-09-27 14:57:43'),(2102,'default','added',1232,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-09-27 15:00:58','2023-09-27 15:00:58'),(2103,'default','payment_edited',1018,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7900.0000\"}}',NULL,'2023-09-27 15:18:28','2023-09-27 15:18:28'),(2104,'default','payment_edited',1052,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-09-27 15:18:28','2023-09-27 15:18:28'),(2105,'default','added',1233,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2800}}',NULL,'2023-09-27 15:24:32','2023-09-27 15:24:32'),(2106,'default','payment_edited',1230,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3200.0000\"}}',NULL,'2023-09-27 15:45:14','2023-09-27 15:45:14'),(2107,'default','payment_edited',1128,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1850.0000\"}}',NULL,'2023-09-27 15:47:46','2023-09-27 15:47:46'),(2108,'default','payment_edited',1131,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2023-09-27 15:47:46','2023-09-27 15:47:46'),(2109,'default','payment_edited',1121,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4140.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4140.0000\"}}',NULL,'2023-09-27 16:01:19','2023-09-27 16:01:19'),(2110,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-09-28 04:47:37','2023-09-28 04:47:37'),(2111,'default','added',1234,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7500}}',NULL,'2023-09-28 04:48:43','2023-09-28 04:48:43'),(2112,'default','edited',1234,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7500.0000\"}}',NULL,'2023-09-28 07:28:30','2023-09-28 07:28:30'),(2113,'default','edited',1233,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2800.0000\"}}',NULL,'2023-09-28 07:30:23','2023-09-28 07:30:23'),(2114,'default','edited',1196,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":22101},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"21414.0000\"}}',NULL,'2023-09-28 11:14:25','2023-09-28 11:14:25'),(2115,'default','payment_edited',1218,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-09-28 13:32:55','2023-09-28 13:32:55'),(2116,'default','added',675,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-28 14:15:26','2023-09-28 14:15:26'),(2117,'default','added',1235,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-09-28 14:18:20','2023-09-28 14:18:20'),(2118,'default','added',1236,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2320}}',NULL,'2023-09-28 14:28:29','2023-09-28 14:28:29'),(2119,'default','added',1237,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":46418}}',NULL,'2023-09-28 14:46:38','2023-09-28 14:46:38'),(2120,'default','edited',1237,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":46018},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"46418.0000\"}}',NULL,'2023-09-28 14:47:29','2023-09-28 14:47:29'),(2121,'default','edited',1214,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5620},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5300.0000\"}}',NULL,'2023-09-28 14:55:21','2023-09-28 14:55:21'),(2122,'default','payment_edited',1233,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4750.0000\"}}',NULL,'2023-09-28 16:13:36','2023-09-28 16:13:36'),(2123,'default','payment_edited',1153,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4100.0000\"}}',NULL,'2023-09-28 16:17:17','2023-09-28 16:17:17'),(2124,'default','payment_edited',1168,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-09-28 16:17:17','2023-09-28 16:17:17'),(2125,'default','payment_edited',1181,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2800.0000\"}}',NULL,'2023-09-28 16:17:17','2023-09-28 16:17:17'),(2126,'default','payment_edited',1202,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-09-28 16:17:17','2023-09-28 16:17:17'),(2127,'default','payment_edited',1234,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-09-28 16:17:18','2023-09-28 16:17:18'),(2128,'default','added',1238,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2300}}',NULL,'2023-09-28 16:28:48','2023-09-28 16:28:48'),(2129,'default','payment_edited',1196,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"22101.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"22101.0000\"}}',NULL,'2023-09-28 16:55:00','2023-09-28 16:55:00'),(2130,'default','edited',1196,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":22101},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"22101.0000\"}}',NULL,'2023-09-28 16:56:36','2023-09-28 16:56:36'),(2131,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-09-30 05:50:34','2023-09-30 05:50:34'),(2132,'default','added',1239,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-09-30 05:54:01','2023-09-30 05:54:01'),(2133,'default','added',1240,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8000}}',NULL,'2023-09-30 06:11:52','2023-09-30 06:11:52'),(2134,'default','added',1241,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-09-30 06:35:38','2023-09-30 06:35:38'),(2135,'default','added',1242,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1350}}',NULL,'2023-09-30 08:45:17','2023-09-30 08:45:17'),(2136,'default','added',1243,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-09-30 11:24:46','2023-09-30 11:24:46'),(2137,'default','payment_edited',1191,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"19343.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"19343.0000\"}}',NULL,'2023-09-30 11:34:33','2023-09-30 11:34:33'),(2138,'default','edited',1191,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":21543},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"19343.0000\"}}',NULL,'2023-09-30 11:34:59','2023-09-30 11:34:59'),(2139,'default','added',676,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-30 11:36:16','2023-09-30 11:36:16'),(2140,'default','added',1245,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":23828}}',NULL,'2023-09-30 11:46:12','2023-09-30 11:46:12'),(2141,'default','added',677,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-30 11:47:07','2023-09-30 11:47:07'),(2142,'default','added',1246,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-09-30 11:48:18','2023-09-30 11:48:18'),(2143,'default','edited',1243,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-09-30 11:51:10','2023-09-30 11:51:10'),(2144,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-09-30 12:34:50','2023-09-30 12:34:50'),(2145,'default','added',1247,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":100}}',NULL,'2023-09-30 12:36:10','2023-09-30 12:36:10'),(2146,'default','sell_deleted',1246,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1246,\"invoice_no\":\"ITH2023-11650\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"}}',NULL,'2023-09-30 14:48:51','2023-09-30 14:48:51'),(2147,'default','sell_deleted',1245,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1245,\"invoice_no\":\"ITH2023-11649\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"23828.0000\"}}',NULL,'2023-09-30 14:49:32','2023-09-30 14:49:32'),(2148,'default','edited',1196,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":20101},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"22101.0000\"}}',NULL,'2023-09-30 14:52:46','2023-09-30 14:52:46'),(2149,'default','added',1248,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1800}}',NULL,'2023-09-30 14:54:24','2023-09-30 14:54:24'),(2150,'default','edited',1240,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8000.0000\"}}',NULL,'2023-09-30 14:54:54','2023-09-30 14:54:54'),(2151,'default','payment_edited',1234,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3100.0000\"}}',NULL,'2023-09-30 14:55:21','2023-09-30 14:55:21'),(2152,'default','payment_edited',1240,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6400.0000\"}}',NULL,'2023-09-30 14:55:21','2023-09-30 14:55:21'),(2153,'default','payment_edited',1243,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-09-30 14:55:21','2023-09-30 14:55:21'),(2154,'default','added',678,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-09-30 15:32:33','2023-09-30 15:32:33'),(2155,'default','added',1249,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}',NULL,'2023-09-30 15:32:57','2023-09-30 15:32:57'),(2156,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-01 05:29:26','2023-10-01 05:29:26'),(2157,'default','edited',1239,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"}}',NULL,'2023-10-01 05:30:52','2023-10-01 05:30:52'),(2158,'default','added',679,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-01 06:19:30','2023-10-01 06:19:30'),(2159,'default','added',1250,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":28872}}',NULL,'2023-10-01 06:31:03','2023-10-01 06:31:03'),(2160,'default','payment_edited',1214,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5620.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5620.0000\"}}',NULL,'2023-10-01 07:38:44','2023-10-01 07:38:44'),(2161,'default','added',1251,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3660}}',NULL,'2023-10-01 11:02:26','2023-10-01 11:02:26'),(2162,'default','payment_edited',1214,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5620.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5620.0000\"}}',NULL,'2023-10-01 11:36:50','2023-10-01 11:36:50'),(2163,'default','payment_edited',1191,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"21543.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"21543.0000\"}}',NULL,'2023-10-01 11:37:25','2023-10-01 11:37:25'),(2164,'default','payment_edited',628,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"5250.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"5250.0000\"}}',NULL,'2023-10-01 14:38:48','2023-10-01 14:38:48'),(2165,'default','payment_edited',660,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-10-01 14:42:01','2023-10-01 14:42:01'),(2166,'default','payment_edited',665,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2150.0000\"}}',NULL,'2023-10-01 14:42:01','2023-10-01 14:42:01'),(2167,'default','payment_edited',685,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4150.0000\"}}',NULL,'2023-10-01 14:42:01','2023-10-01 14:42:01'),(2168,'default','payment_edited',1238,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2300.0000\"}}',NULL,'2023-10-01 14:42:01','2023-10-01 14:42:01'),(2169,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-02 05:46:36','2023-10-02 05:46:36'),(2170,'default','edited',1239,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"}}',NULL,'2023-10-02 05:48:08','2023-10-02 05:48:08'),(2171,'default','added',1252,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-10-02 06:32:24','2023-10-02 06:32:24'),(2172,'default','added',680,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-02 07:26:19','2023-10-02 07:26:19'),(2173,'default','added',1253,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-10-02 07:26:33','2023-10-02 07:26:33'),(2174,'default','edited',1253,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2600.0000\"}}',NULL,'2023-10-02 07:27:29','2023-10-02 07:27:29'),(2175,'default','edited',1251,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3660},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3660.0000\"}}',NULL,'2023-10-02 07:29:08','2023-10-02 07:29:08'),(2176,'default','added',1254,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4700}}',NULL,'2023-10-02 09:56:02','2023-10-02 09:56:02'),(2177,'default','edited',1254,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4700.0000\"}}',NULL,'2023-10-02 09:59:53','2023-10-02 09:59:53'),(2178,'default','added',1255,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2651}}',NULL,'2023-10-02 10:45:58','2023-10-02 10:45:58'),(2179,'default','added',1256,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2300}}',NULL,'2023-10-02 10:55:04','2023-10-02 10:55:04'),(2180,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-02 11:49:26','2023-10-02 11:49:26'),(2181,'default','added',1257,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":800}}',NULL,'2023-10-02 11:51:52','2023-10-02 11:51:52'),(2182,'default','added',1258,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3500}}',NULL,'2023-10-02 12:43:07','2023-10-02 12:43:07'),(2183,'default','edited',760,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":14900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13000.0000\"}}',NULL,'2023-10-02 12:44:16','2023-10-02 12:44:16'),(2184,'default','edited',1228,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-10-02 13:17:06','2023-10-02 13:17:06'),(2185,'default','added',1259,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3100}}',NULL,'2023-10-02 13:18:20','2023-10-02 13:18:20'),(2186,'default','payment_edited',1225,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4000.0000\"}}',NULL,'2023-10-02 13:19:34','2023-10-02 13:19:34'),(2187,'default','added',1260,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1100}}',NULL,'2023-10-02 15:13:57','2023-10-02 15:13:57'),(2188,'default','edited',1259,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3100.0000\"}}',NULL,'2023-10-02 15:55:21','2023-10-02 15:55:21'),(2189,'default','payment_edited',1259,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4100.0000\"}}',NULL,'2023-10-02 15:55:40','2023-10-02 15:55:40'),(2190,'default','added',1261,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1720}}',NULL,'2023-10-02 16:01:28','2023-10-02 16:01:28'),(2191,'default','added',1262,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-10-02 16:14:50','2023-10-02 16:14:50'),(2192,'default','edited',1262,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"}}',NULL,'2023-10-02 16:16:54','2023-10-02 16:16:54'),(2193,'default','edited',1239,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"}}',NULL,'2023-10-02 16:21:26','2023-10-02 16:21:26'),(2194,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-03 05:38:11','2023-10-03 05:38:11'),(2195,'default','added',1263,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1280}}',NULL,'2023-10-03 05:48:13','2023-10-03 05:48:13'),(2196,'default','payment_edited',1262,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1100.0000\"}}',NULL,'2023-10-03 07:00:10','2023-10-03 07:00:10'),(2197,'default','payment_edited',1254,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4700.0000\"}}',NULL,'2023-10-03 07:01:33','2023-10-03 07:01:33'),(2198,'default','payment_edited',1256,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2300.0000\"}}',NULL,'2023-10-03 07:01:47','2023-10-03 07:01:47'),(2199,'default','edited',1255,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2504},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2651.0000\"}}',NULL,'2023-10-03 07:03:21','2023-10-03 07:03:21'),(2200,'default','added',681,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-03 07:36:05','2023-10-03 07:36:05'),(2201,'default','added',1264,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-10-03 07:36:59','2023-10-03 07:36:59'),(2202,'default','added',1265,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":16800}}',NULL,'2023-10-03 08:31:32','2023-10-03 08:31:32'),(2203,'default','added',682,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-03 12:04:15','2023-10-03 12:04:15'),(2204,'default','added',1266,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300}}',NULL,'2023-10-03 12:05:29','2023-10-03 12:05:29'),(2205,'default','added',1267,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4150}}',NULL,'2023-10-03 12:14:23','2023-10-03 12:14:23'),(2206,'default','payment_edited',1267,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4150.0000\"}}',NULL,'2023-10-03 12:18:13','2023-10-03 12:18:13'),(2207,'default','added',683,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-03 12:26:20','2023-10-03 12:26:20'),(2208,'default','added',1268,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-10-03 12:27:02','2023-10-03 12:27:02'),(2209,'default','added',1269,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":450}}',NULL,'2023-10-03 12:35:44','2023-10-03 12:35:44'),(2210,'default','added',1270,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3050}}',NULL,'2023-10-03 12:36:23','2023-10-03 12:36:23'),(2211,'default','added',1271,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-10-03 14:46:05','2023-10-03 14:46:05'),(2212,'default','added',684,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-03 15:02:51','2023-10-03 15:02:51'),(2213,'default','added',1272,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-10-03 15:03:01','2023-10-03 15:03:01'),(2214,'default','added',1273,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-10-04 07:21:17','2023-10-04 07:21:17'),(2215,'default','added',1274,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16850}}',NULL,'2023-10-04 09:40:27','2023-10-04 09:40:27'),(2216,'default','added',1276,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":41000}}',NULL,'2023-10-04 10:42:10','2023-10-04 10:42:10'),(2217,'default','added',685,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-10-04 12:55:56','2023-10-04 12:55:56'),(2218,'default','added',1277,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-10-04 12:57:55','2023-10-04 12:57:55'),(2219,'default','added',1278,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":150}}',NULL,'2023-10-04 12:59:23','2023-10-04 12:59:23'),(2220,'default','edited',1274,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":14000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"16850.0000\"}}',NULL,'2023-10-04 14:19:06','2023-10-04 14:19:06'),(2221,'default','edited',453,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-04 14:22:29','2023-10-04 14:22:29'),(2222,'default','added',1279,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":3360}}',NULL,'2023-10-04 14:24:29','2023-10-04 14:24:29'),(2223,'default','edited',1279,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":3360},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"3360.0000\"}}',NULL,'2023-10-04 14:25:03','2023-10-04 14:25:03'),(2224,'default','edited',453,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-04 14:32:37','2023-10-04 14:32:37'),(2225,'default','added',1280,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-10-04 15:57:04','2023-10-04 15:57:04'),(2226,'default','added',1281,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6288}}',NULL,'2023-10-05 04:48:06','2023-10-05 04:48:06'),(2227,'default','edited',1281,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8475},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6288.0000\"}}',NULL,'2023-10-05 04:48:48','2023-10-05 04:48:48'),(2228,'default','edited',1281,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10175},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8475.0000\"}}',NULL,'2023-10-05 04:53:50','2023-10-05 04:53:50'),(2229,'default','added',1282,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":550}}',NULL,'2023-10-05 05:09:34','2023-10-05 05:09:34'),(2230,'default','payment_edited',1255,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2504.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2504.0000\"}}',NULL,'2023-10-05 07:51:39','2023-10-05 07:51:39'),(2231,'default','added',1283,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900}}',NULL,'2023-10-05 07:51:44','2023-10-05 07:51:44'),(2232,'default','added',1284,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1280}}',NULL,'2023-10-05 07:59:31','2023-10-05 07:59:31'),(2233,'default','added',1286,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-10-05 08:21:40','2023-10-05 08:21:40'),(2234,'default','added',686,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-10-05 08:51:43','2023-10-05 08:51:43'),(2235,'default','added',1287,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-10-05 08:52:53','2023-10-05 08:52:53'),(2236,'default','edited',686,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-10-05 08:56:49','2023-10-05 08:56:49'),(2237,'default','added',687,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-05 09:07:06','2023-10-05 09:07:06'),(2238,'default','added',1288,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-10-05 09:09:21','2023-10-05 09:09:21'),(2239,'default','added',1289,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2350}}',NULL,'2023-10-05 11:21:59','2023-10-05 11:21:59'),(2240,'default','edited',1274,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":14200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"14000.0000\"}}',NULL,'2023-10-05 14:49:23','2023-10-05 14:49:23'),(2241,'default','edited',1281,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10175.0000\"}}',NULL,'2023-10-05 14:56:01','2023-10-05 14:56:01'),(2242,'default','edited',1281,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7100.0000\"}}',NULL,'2023-10-05 15:05:13','2023-10-05 15:05:13'),(2243,'default','added',1290,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13900}}',NULL,'2023-10-05 15:12:05','2023-10-05 15:12:05'),(2244,'default','edited',1281,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7900.0000\"}}',NULL,'2023-10-05 15:13:24','2023-10-05 15:13:24'),(2245,'default','edited',1274,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"14200.0000\"}}',NULL,'2023-10-05 15:16:45','2023-10-05 15:16:45'),(2246,'default','payment_edited',1274,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11800.0000\"}}',NULL,'2023-10-05 15:19:05','2023-10-05 15:19:05'),(2247,'default','edited',1281,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7800.0000\"}}',NULL,'2023-10-05 15:20:05','2023-10-05 15:20:05'),(2248,'default','payment_edited',1281,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7800.0000\"}}',NULL,'2023-10-05 15:21:17','2023-10-05 15:21:17'),(2249,'default','edited',1290,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13900.0000\"}}',NULL,'2023-10-05 15:37:10','2023-10-05 15:37:10'),(2250,'default','added',688,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-05 15:57:29','2023-10-05 15:57:29'),(2251,'default','added',1291,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2300}}',NULL,'2023-10-05 15:58:28','2023-10-05 15:58:28'),(2252,'default','edited',1291,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2300.0000\"}}',NULL,'2023-10-05 15:59:43','2023-10-05 15:59:43'),(2253,'default','added',1292,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300}}',NULL,'2023-10-07 04:34:52','2023-10-07 04:34:52'),(2254,'default','added',1293,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3500}}',NULL,'2023-10-07 08:21:03','2023-10-07 08:21:03'),(2255,'default','added',1294,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":600}}',NULL,'2023-10-07 09:36:26','2023-10-07 09:36:26'),(2256,'default','edited',1222,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1.0000\"}}',NULL,'2023-10-07 09:49:39','2023-10-07 09:49:40'),(2257,'default','edited',1221,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2.0000\"}}',NULL,'2023-10-07 09:59:36','2023-10-07 09:59:36'),(2258,'default','payment_edited',1276,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"41000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"41000.0000\"}}',NULL,'2023-10-07 09:59:47','2023-10-07 09:59:47'),(2259,'default','added',1295,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5900}}',NULL,'2023-10-07 11:13:09','2023-10-07 11:13:09'),(2260,'default','added',1296,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7500}}',NULL,'2023-10-07 12:13:28','2023-10-07 12:13:28'),(2261,'default','edited',1296,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7500.0000\"}}',NULL,'2023-10-07 12:47:26','2023-10-07 12:47:26'),(2262,'default','edited',1295,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5900.0000\"}}',NULL,'2023-10-07 12:48:00','2023-10-07 12:48:00'),(2263,'default','payment_edited',1293,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3500.0000\"}}',NULL,'2023-10-07 12:48:12','2023-10-07 12:48:12'),(2264,'default','edited',1292,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3300.0000\"}}',NULL,'2023-10-07 12:48:48','2023-10-07 12:48:48'),(2265,'default','edited',1289,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2350.0000\"}}',NULL,'2023-10-07 12:50:12','2023-10-07 12:50:12'),(2266,'default','added',1297,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-10-07 14:41:48','2023-10-07 14:41:48'),(2267,'default','payment_edited',1260,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1100.0000\"}}',NULL,'2023-10-07 14:42:13','2023-10-07 14:42:13'),(2268,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-07 16:33:25','2023-10-07 16:33:25'),(2269,'default','payment_edited',1289,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2350.0000\"}}',NULL,'2023-10-07 16:34:06','2023-10-07 16:34:06'),(2270,'default','edited',1295,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5900.0000\"}}',NULL,'2023-10-07 16:54:15','2023-10-07 16:54:15'),(2271,'default','edited',1295,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8500.0000\"}}',NULL,'2023-10-07 16:55:25','2023-10-07 16:55:25'),(2272,'default','added',1298,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5500}}',NULL,'2023-10-08 07:55:16','2023-10-08 07:55:16'),(2273,'default','payment_edited',1295,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8500.0000\"}}',NULL,'2023-10-08 09:14:45','2023-10-08 09:14:45'),(2274,'default','edited',1205,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":5080},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4180.0000\"}}',NULL,'2023-10-08 09:16:06','2023-10-08 09:16:06'),(2275,'default','added',1299,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-10-08 12:11:51','2023-10-08 12:11:51'),(2276,'default','added',689,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-08 13:58:53','2023-10-08 13:58:53'),(2277,'default','added',1300,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2}}',NULL,'2023-10-08 13:59:58','2023-10-08 13:59:58'),(2278,'default','added',1301,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":250}}',NULL,'2023-10-08 14:48:52','2023-10-08 14:48:52'),(2279,'default','added',1302,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700}}',NULL,'2023-10-08 14:53:16','2023-10-08 14:53:16'),(2280,'default','added',1303,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":773}}',NULL,'2023-10-09 04:56:07','2023-10-09 04:56:07'),(2281,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-09 08:45:35','2023-10-09 08:45:35'),(2282,'default','added',1304,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900}}',NULL,'2023-10-09 08:46:33','2023-10-09 08:46:33'),(2283,'default','added',690,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-09 10:00:41','2023-10-09 10:00:41'),(2284,'default','added',1305,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3050}}',NULL,'2023-10-09 10:02:45','2023-10-09 10:02:45'),(2285,'default','added',691,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-09 10:12:20','2023-10-09 10:12:20'),(2286,'default','added',1309,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16700}}',NULL,'2023-10-09 10:20:57','2023-10-09 10:20:57'),(2287,'default','edited',1309,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"16700.0000\"}}',NULL,'2023-10-09 10:22:08','2023-10-09 10:22:08'),(2288,'default','added',692,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-09 11:36:21','2023-10-09 11:36:21'),(2289,'default','added',1311,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3500}}',NULL,'2023-10-09 11:38:08','2023-10-09 11:38:08'),(2290,'default','added',1312,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-10-09 13:42:50','2023-10-09 13:42:50'),(2291,'default','edited',1290,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13900.0000\"}}',NULL,'2023-10-09 15:33:33','2023-10-09 15:33:33'),(2292,'default','added',1313,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5000}}',NULL,'2023-10-09 15:42:17','2023-10-09 15:42:17'),(2293,'default','added',1314,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-10-10 06:20:35','2023-10-10 06:20:35'),(2294,'default','payment_edited',1205,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5080.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5080.0000\"}}',NULL,'2023-10-10 09:41:23','2023-10-10 09:41:23'),(2295,'default','added',1315,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-10-10 09:43:40','2023-10-10 09:43:40'),(2296,'default','added',1316,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-10-10 10:28:16','2023-10-10 10:28:16'),(2297,'default','payment_edited',1315,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1600.0000\"}}',NULL,'2023-10-10 10:49:52','2023-10-10 10:49:52'),(2298,'default','added',1317,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-10-10 11:32:54','2023-10-10 11:32:54'),(2299,'default','added',1318,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":480}}',NULL,'2023-10-10 12:30:25','2023-10-10 12:30:25'),(2300,'default','added',693,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-10 13:35:01','2023-10-10 13:35:01'),(2301,'default','added',1319,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3500}}',NULL,'2023-10-10 13:35:38','2023-10-10 13:35:38'),(2302,'default','added',1320,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2800}}',NULL,'2023-10-10 13:49:30','2023-10-10 13:49:30'),(2303,'default','logout',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-10 13:55:46','2023-10-10 13:55:46'),(2304,'default','edited',1311,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3500.0000\"}}',NULL,'2023-10-10 14:25:49','2023-10-10 14:25:49'),(2305,'default','edited',1320,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2800.0000\"}}',NULL,'2023-10-10 14:55:07','2023-10-10 14:55:07'),(2306,'default','added',1321,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":33760}}',NULL,'2023-10-10 15:25:09','2023-10-10 15:25:09'),(2307,'default','payment_edited',1196,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"20101.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"20101.0000\"}}',NULL,'2023-10-10 15:48:47','2023-10-10 15:48:47'),(2308,'default','edited',1196,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":20101},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"20101.0000\"}}',NULL,'2023-10-10 15:54:21','2023-10-10 15:54:21'),(2309,'default','edited',1313,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5000.0000\"}}',NULL,'2023-10-10 16:10:11','2023-10-10 16:10:11'),(2310,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-11 04:21:06','2023-10-11 04:21:06'),(2311,'default','added',1322,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-10-11 04:55:30','2023-10-11 04:55:30'),(2312,'default','edited',1322,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-10-11 08:11:13','2023-10-11 08:11:13'),(2313,'default','edited',1261,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1620},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1720.0000\"}}',NULL,'2023-10-11 08:45:10','2023-10-11 08:45:10'),(2314,'default','sell_deleted',1228,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1228,\"invoice_no\":\"ITH2023-11634\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2300.0000\"}}',NULL,'2023-10-11 08:46:45','2023-10-11 08:46:45'),(2315,'default','payment_edited',1261,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1620.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1620.0000\"}}',NULL,'2023-10-11 08:47:32','2023-10-11 08:47:32'),(2316,'default','payment_edited',1267,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4150.0000\"}}',NULL,'2023-10-11 08:47:32','2023-10-11 08:47:32'),(2317,'default','payment_edited',1322,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-10-11 08:47:32','2023-10-11 08:47:32'),(2318,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-11 11:44:50','2023-10-11 11:44:50'),(2319,'default','added',1323,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4700}}',NULL,'2023-10-11 12:24:04','2023-10-11 12:24:04'),(2320,'default','edited',1323,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4700.0000\"}}',NULL,'2023-10-11 12:24:21','2023-10-11 12:24:21'),(2321,'default','added',1324,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2023-10-11 12:33:24','2023-10-11 12:33:24'),(2322,'default','added',1325,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-10-11 14:27:16','2023-10-11 14:27:16'),(2323,'default','sell_deleted',1303,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1303,\"invoice_no\":\"ITH2023-11703\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"773.0000\"}}',NULL,'2023-10-11 16:00:40','2023-10-11 16:00:40'),(2324,'default','added',694,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-11 16:30:17','2023-10-11 16:30:17'),(2325,'default','added',1326,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-10-11 16:30:41','2023-10-11 16:30:41'),(2326,'default','payment_edited',1321,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"33760.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"33760.0000\"}}',NULL,'2023-10-12 06:50:29','2023-10-12 06:50:29'),(2327,'default','edited',1321,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":32810},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"33760.0000\"}}',NULL,'2023-10-12 06:52:20','2023-10-12 06:52:20'),(2328,'default','edited',1321,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":32810},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"32810.0000\"}}',NULL,'2023-10-12 07:28:43','2023-10-12 07:28:43'),(2329,'default','added',1327,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3900}}',NULL,'2023-10-12 08:16:51','2023-10-12 08:16:51'),(2330,'default','added',695,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-12 09:40:31','2023-10-12 09:40:31'),(2331,'default','added',1328,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-10-12 09:41:01','2023-10-12 09:41:01'),(2332,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-12 09:44:04','2023-10-12 09:44:04'),(2333,'default','added',1329,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6100}}',NULL,'2023-10-12 13:31:37','2023-10-12 13:31:37'),(2334,'default','added',1330,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1360}}',NULL,'2023-10-12 13:56:02','2023-10-12 13:56:02'),(2335,'default','edited',1330,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1360},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1360.0000\"}}',NULL,'2023-10-12 13:56:25','2023-10-12 13:56:25'),(2336,'default','added',1331,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-10-12 14:10:44','2023-10-12 14:10:44'),(2337,'default','added',1332,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4550}}',NULL,'2023-10-12 14:59:41','2023-10-12 14:59:41'),(2338,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-12 15:17:04','2023-10-12 15:17:04'),(2339,'default','edited',1330,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1280},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1360.0000\"}}',NULL,'2023-10-12 16:00:45','2023-10-12 16:00:45'),(2340,'default','payment_edited',1323,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4700.0000\"}}',NULL,'2023-10-12 16:02:04','2023-10-12 16:02:04'),(2341,'default','added',1333,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1050}}',NULL,'2023-10-12 16:19:30','2023-10-12 16:19:30'),(2342,'default','added',1334,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2000}}',NULL,'2023-10-12 16:22:47','2023-10-12 16:22:47'),(2343,'default','payment_edited',1290,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10200.0000\"}}',NULL,'2023-10-12 16:24:18','2023-10-12 16:24:18'),(2344,'default','payment_edited',1332,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4550.0000\"}}',NULL,'2023-10-12 17:14:56','2023-10-12 17:14:56'),(2345,'default','added',1335,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2220}}',NULL,'2023-10-14 08:21:23','2023-10-14 08:21:23'),(2346,'default','payment_edited',1265,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"16800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"16800.0000\"}}',NULL,'2023-10-14 08:35:39','2023-10-14 08:35:39'),(2347,'default','added',1336,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8400}}',NULL,'2023-10-14 09:51:16','2023-10-14 09:51:16'),(2348,'default','added',696,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-14 13:11:10','2023-10-14 13:11:10'),(2349,'default','added',1337,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13600}}',NULL,'2023-10-14 13:13:00','2023-10-14 13:13:00'),(2350,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-14 15:05:36','2023-10-14 15:05:36'),(2351,'default','added',1338,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3350}}',NULL,'2023-10-14 15:07:19','2023-10-14 15:07:19'),(2352,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-15 05:49:29','2023-10-15 05:49:29'),(2353,'default','added',1339,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":320}}',NULL,'2023-10-15 05:50:13','2023-10-15 05:50:13'),(2354,'default','edited',1338,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3350.0000\"}}',NULL,'2023-10-15 07:03:15','2023-10-15 07:03:15'),(2355,'default','added',1340,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1050}}',NULL,'2023-10-15 09:26:01','2023-10-15 09:26:01'),(2356,'default','added',1341,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-10-15 09:26:25','2023-10-15 09:26:25'),(2357,'default','payment_edited',1336,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8400.0000\"}}',NULL,'2023-10-15 09:26:44','2023-10-15 09:26:44'),(2358,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-15 09:41:01','2023-10-15 09:41:01'),(2359,'default','payment_edited',1335,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2220.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2220.0000\"}}',NULL,'2023-10-15 09:42:38','2023-10-15 09:42:38'),(2360,'default','payment_edited',1205,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5080.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5080.0000\"}}',NULL,'2023-10-15 09:43:40','2023-10-15 09:43:40'),(2361,'default','added',1343,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11150}}',NULL,'2023-10-15 12:44:39','2023-10-15 12:44:39'),(2362,'default','added',1344,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400}}',NULL,'2023-10-15 12:58:31','2023-10-15 12:58:31'),(2363,'default','added',1345,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3450}}',NULL,'2023-10-15 14:06:04','2023-10-15 14:06:04'),(2364,'default','payment_edited',1170,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8400.0000\"}}',NULL,'2023-10-15 14:31:00','2023-10-15 14:31:00'),(2365,'default','payment_edited',587,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"43700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"43700.0000\"}}',NULL,'2023-10-15 14:31:48','2023-10-15 14:31:48'),(2366,'default','payment_edited',555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"99103.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"99103.0000\"}}',NULL,'2023-10-15 14:32:01','2023-10-15 14:32:01'),(2367,'default','payment_edited',1344,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"400.0000\"}}',NULL,'2023-10-15 15:18:19','2023-10-15 15:18:19'),(2368,'default','added',697,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-15 15:50:30','2023-10-15 15:50:30'),(2369,'default','added',1346,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-10-15 15:51:20','2023-10-15 15:51:20'),(2370,'default','payment_edited',1345,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3450.0000\"}}',NULL,'2023-10-15 16:19:07','2023-10-15 16:19:07'),(2371,'default','added',1347,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-10-15 16:25:51','2023-10-15 16:25:51'),(2372,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-16 04:37:32','2023-10-16 04:37:32'),(2373,'default','added',1348,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4700}}',NULL,'2023-10-16 04:39:15','2023-10-16 04:39:15'),(2374,'default','added',1349,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1350}}',NULL,'2023-10-16 04:41:25','2023-10-16 04:41:25'),(2375,'default','edited',83,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-16 06:22:58','2023-10-16 06:22:58'),(2376,'default','added',1351,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10400}}',NULL,'2023-10-16 06:31:10','2023-10-16 06:31:10'),(2377,'default','payment_edited',1341,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-10-16 07:04:15','2023-10-16 07:04:15'),(2378,'default','payment_edited',1340,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1050.0000\"}}',NULL,'2023-10-16 07:26:06','2023-10-16 07:26:06'),(2379,'default','added',1352,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-10-16 10:19:24','2023-10-16 10:19:24'),(2380,'default','added',698,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-16 11:13:07','2023-10-16 11:13:07'),(2381,'default','added',1353,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-10-16 11:16:18','2023-10-16 11:16:18'),(2382,'default','added',1354,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-10-16 11:21:46','2023-10-16 11:21:46'),(2383,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-10-16 11:36:07','2023-10-16 11:36:07'),(2384,'default','payment_edited',1349,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1350.0000\"}}',NULL,'2023-10-16 11:36:42','2023-10-16 11:36:42'),(2385,'default','added',699,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-16 11:40:50','2023-10-16 11:40:50'),(2386,'default','added',1355,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":380}}',NULL,'2023-10-16 11:41:25','2023-10-16 11:41:25'),(2387,'default','added',1356,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-10-16 12:22:49','2023-10-16 12:22:49'),(2388,'default','edited',1356,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-10-16 12:24:15','2023-10-16 12:24:15'),(2389,'default','added',700,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-16 12:50:04','2023-10-16 12:50:04'),(2390,'default','added',1357,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17050}}',NULL,'2023-10-16 12:53:45','2023-10-16 12:53:45'),(2391,'default','edited',1357,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"paid\",\"final_total\":17050},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"17050.0000\"}}',NULL,'2023-10-16 12:54:00','2023-10-16 12:54:00'),(2392,'default','edited',1348,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4700.0000\"}}',NULL,'2023-10-16 14:21:59','2023-10-16 14:21:59'),(2393,'default','added',701,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-16 15:14:48','2023-10-16 15:14:48'),(2394,'default','added',1358,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6500}}',NULL,'2023-10-16 15:17:34','2023-10-16 15:17:34'),(2395,'default','payment_edited',1319,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3500.0000\"}}',NULL,'2023-10-16 15:28:13','2023-10-16 15:28:13'),(2396,'default','payment_edited',1321,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"32810.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"32810.0000\"}}',NULL,'2023-10-16 15:28:13','2023-10-16 15:28:13'),(2397,'default','added',1359,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-10-16 15:45:32','2023-10-16 15:45:32'),(2398,'default','payment_edited',1030,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"700.0000\"}}',NULL,'2023-10-16 15:59:44','2023-10-16 15:59:44'),(2399,'default','payment_edited',1219,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"200.0000\"}}',NULL,'2023-10-16 15:59:44','2023-10-16 15:59:44'),(2400,'default','payment_edited',1353,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-10-16 15:59:44','2023-10-16 15:59:44'),(2401,'default','payment_edited',1283,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"900.0000\"}}',NULL,'2023-10-16 16:02:43','2023-10-16 16:02:43'),(2402,'default','added',1360,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8600}}',NULL,'2023-10-16 16:20:58','2023-10-16 16:20:58'),(2403,'default','payment_edited',1352,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-10-16 16:25:02','2023-10-16 16:25:02'),(2404,'default','edited',1348,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3050},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-10-16 16:33:39','2023-10-16 16:33:39'),(2405,'default','added',1361,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4830}}',NULL,'2023-10-16 16:43:36','2023-10-16 16:43:36'),(2406,'default','sell_deleted',1359,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1359,\"invoice_no\":\"ITH2023-11753\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-10-16 16:50:03','2023-10-16 16:50:03'),(2407,'default','payment_edited',1072,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"300.0000\"}}',NULL,'2023-10-16 16:51:16','2023-10-16 16:51:16'),(2408,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-17 04:56:20','2023-10-17 04:56:20'),(2409,'default','added',1362,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8050}}',NULL,'2023-10-17 04:57:28','2023-10-17 04:57:28'),(2410,'default','added',1363,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":150}}',NULL,'2023-10-17 05:20:38','2023-10-17 05:20:38'),(2411,'default','added',1364,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4400}}',NULL,'2023-10-17 06:32:36','2023-10-17 06:32:36'),(2412,'default','added',1365,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-10-17 08:48:35','2023-10-17 08:48:35'),(2413,'default','added',1366,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900}}',NULL,'2023-10-17 10:57:28','2023-10-17 10:57:28'),(2414,'default','added',1369,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}',NULL,'2023-10-17 11:03:46','2023-10-17 11:03:46'),(2415,'default','added',702,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-17 11:13:42','2023-10-17 11:13:42'),(2416,'default','added',1371,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":63000}}',NULL,'2023-10-17 11:16:16','2023-10-17 11:16:16'),(2417,'default','edited',1371,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":63000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"63000.0000\"}}',NULL,'2023-10-17 11:16:59','2023-10-17 11:16:59'),(2418,'default','payment_edited',1258,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3500.0000\"}}',NULL,'2023-10-17 11:19:19','2023-10-17 11:19:19'),(2419,'default','login',2,'App\\User',NULL,1,2,'App\\User','[]',NULL,'2023-10-17 12:21:02','2023-10-17 12:21:02'),(2420,'default','added',1373,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1050}}',NULL,'2023-10-17 12:58:08','2023-10-17 12:58:08'),(2421,'default','payment_edited',1373,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1050.0000\"}}',NULL,'2023-10-17 15:33:46','2023-10-17 15:33:46'),(2422,'default','payment_edited',1327,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3900.0000\"}}',NULL,'2023-10-17 15:35:58','2023-10-17 15:35:58'),(2423,'default','edited',697,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-17 16:05:47','2023-10-17 16:05:47'),(2424,'default','added',1374,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6900}}',NULL,'2023-10-17 16:09:49','2023-10-17 16:09:49'),(2425,'default','payment_edited',1356,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3300.0000\"}}',NULL,'2023-10-17 16:17:26','2023-10-17 16:17:26'),(2426,'default','edited',1366,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"900.0000\"}}',NULL,'2023-10-17 16:18:55','2023-10-17 16:18:55'),(2427,'default','payment_edited',1366,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-10-17 16:20:35','2023-10-17 16:20:35'),(2428,'default','edited',1362,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8050.0000\"}}',NULL,'2023-10-17 16:26:00','2023-10-17 16:26:00'),(2429,'default','edited',1374,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6900.0000\"}}',NULL,'2023-10-17 16:26:21','2023-10-17 16:26:21'),(2430,'default','payment_edited',1296,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4100.0000\"}}',NULL,'2023-10-17 17:13:00','2023-10-17 17:13:00'),(2431,'default','payment_edited',1348,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3050.0000\"}}',NULL,'2023-10-17 17:13:00','2023-10-17 17:13:00'),(2432,'default','payment_edited',1362,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4100.0000\"}}',NULL,'2023-10-17 17:13:00','2023-10-17 17:13:00'),(2433,'default','added',1376,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":180}}',NULL,'2023-10-17 17:16:33','2023-10-17 17:16:33'),(2434,'default','edited',1376,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1980},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"180.0000\"}}',NULL,'2023-10-17 17:18:08','2023-10-17 17:18:08'),(2435,'default','added',1377,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2350}}',NULL,'2023-10-18 05:18:29','2023-10-18 05:18:29'),(2436,'default','added',1378,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-10-18 05:38:54','2023-10-18 05:38:54'),(2437,'default','added',1379,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4100}}',NULL,'2023-10-18 05:40:10','2023-10-18 05:40:10'),(2438,'default','added',1380,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3150}}',NULL,'2023-10-18 06:51:14','2023-10-18 06:51:14'),(2439,'default','added',1381,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":10050}}',NULL,'2023-10-18 07:04:01','2023-10-18 07:04:01'),(2440,'default','added',1383,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700}}',NULL,'2023-10-18 07:08:21','2023-10-18 07:08:21'),(2441,'default','added',1384,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":180}}',NULL,'2023-10-18 09:44:48','2023-10-18 09:44:48'),(2442,'default','added',1385,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-10-18 10:45:58','2023-10-18 10:45:58'),(2443,'default','payment_edited',1385,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-10-18 10:48:43','2023-10-18 10:48:43'),(2444,'default','added',1386,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3800}}',NULL,'2023-10-18 12:15:40','2023-10-18 12:15:40'),(2445,'default','edited',1385,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"}}',NULL,'2023-10-18 12:29:05','2023-10-18 12:29:05'),(2446,'default','payment_edited',1364,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4400.0000\"}}',NULL,'2023-10-18 12:31:19','2023-10-18 12:31:19'),(2447,'default','payment_edited',1378,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-10-18 12:31:19','2023-10-18 12:31:19'),(2448,'default','payment_edited',1380,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3150.0000\"}}',NULL,'2023-10-18 12:31:19','2023-10-18 12:31:19'),(2449,'default','payment_edited',1385,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-10-18 12:31:19','2023-10-18 12:31:19'),(2450,'default','added',703,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-18 12:51:56','2023-10-18 12:51:56'),(2451,'default','added',1387,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-10-18 12:52:31','2023-10-18 12:52:31'),(2452,'default','added',1388,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-10-18 13:05:35','2023-10-18 13:05:35'),(2453,'default','sell_deleted',1388,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1388,\"invoice_no\":\"ITH2023-11776\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"}}',NULL,'2023-10-18 13:07:49','2023-10-18 13:07:49'),(2454,'default','added',1389,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-10-18 13:08:35','2023-10-18 13:08:35'),(2455,'default','payment_edited',1118,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"600.0000\"}}',NULL,'2023-10-18 13:27:46','2023-10-18 13:27:46'),(2456,'default','payment_edited',1257,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"800.0000\"}}',NULL,'2023-10-18 13:27:46','2023-10-18 13:27:46'),(2457,'default','payment_edited',1263,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1280.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1280.0000\"}}',NULL,'2023-10-18 13:27:46','2023-10-18 13:27:46'),(2458,'default','payment_edited',1323,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4700.0000\"}}',NULL,'2023-10-18 13:27:46','2023-10-18 13:27:46'),(2459,'default','payment_edited',1383,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"700.0000\"}}',NULL,'2023-10-18 13:27:46','2023-10-18 13:27:46'),(2460,'default','added',1390,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1350}}',NULL,'2023-10-18 13:28:32','2023-10-18 13:28:32'),(2461,'default','payment_edited',1365,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-10-18 14:21:01','2023-10-18 14:21:01'),(2462,'default','payment_edited',1366,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1400.0000\"}}',NULL,'2023-10-18 14:21:19','2023-10-18 14:21:19'),(2463,'default','sell_deleted',1384,'App\\Transaction',NULL,1,2,'App\\User','{\"id\":1384,\"invoice_no\":\"ITH2023-11772\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"180.0000\"}}',NULL,'2023-10-18 15:46:32','2023-10-18 15:46:32'),(2464,'default','payment_edited',1376,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1980.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1980.0000\"}}',NULL,'2023-10-18 15:48:25','2023-10-18 15:48:25'),(2465,'default','payment_edited',1360,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8600.0000\"}}',NULL,'2023-10-18 15:49:41','2023-10-18 15:49:41'),(2466,'default','added',1391,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-10-18 16:25:58','2023-10-18 16:25:58'),(2467,'default','added',1392,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2625}}',NULL,'2023-10-19 05:13:10','2023-10-19 05:13:10'),(2468,'default','added',1393,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-10-19 06:38:33','2023-10-19 06:38:33'),(2469,'default','edited',1393,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"}}',NULL,'2023-10-19 06:39:58','2023-10-19 06:39:58'),(2470,'default','added',704,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 06:45:21','2023-10-19 06:45:21'),(2471,'default','added',1394,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-10-19 06:46:19','2023-10-19 06:46:19'),(2472,'default','added',705,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-19 06:48:40','2023-10-19 06:48:40'),(2473,'default','added',1395,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-10-19 06:50:25','2023-10-19 06:50:25'),(2474,'default','edited',1395,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"}}',NULL,'2023-10-19 06:52:08','2023-10-19 06:52:08'),(2475,'default','edited',1395,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"}}',NULL,'2023-10-19 06:58:25','2023-10-19 06:58:25'),(2476,'default','edited',1395,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"}}',NULL,'2023-10-19 07:00:14','2023-10-19 07:00:14'),(2477,'default','payment_edited',751,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7900.0000\"}}',NULL,'2023-10-19 07:17:32','2023-10-19 07:17:32'),(2478,'default','sell_deleted',1227,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1227,\"invoice_no\":\"ITH2023-11633\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3180.0000\"}}',NULL,'2023-10-19 09:06:04','2023-10-19 09:06:04'),(2479,'default','payment_edited',1209,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3000.0000\"}}',NULL,'2023-10-19 09:10:46','2023-10-19 09:10:46'),(2480,'default','payment_edited',1148,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"360.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"360.0000\"}}',NULL,'2023-10-19 09:11:10','2023-10-19 09:11:10'),(2481,'default','payment_edited',1270,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3050.0000\"}}',NULL,'2023-10-19 09:11:46','2023-10-19 09:11:46'),(2482,'default','added',1396,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-10-19 09:16:49','2023-10-19 09:16:49'),(2483,'default','payment_edited',1393,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-10-19 12:59:55','2023-10-19 12:59:55'),(2484,'default','edited',1391,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2850},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"950.0000\"}}',NULL,'2023-10-19 13:00:25','2023-10-19 13:00:25'),(2485,'default','added',1397,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3250}}',NULL,'2023-10-19 13:25:04','2023-10-19 13:25:04'),(2486,'default','edited',1392,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2625.0000\"}}',NULL,'2023-10-19 13:26:17','2023-10-19 13:26:17'),(2487,'default','payment_edited',1320,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2800.0000\"}}',NULL,'2023-10-19 13:50:25','2023-10-19 13:50:25'),(2488,'default','payment_edited',1397,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3250.0000\"}}',NULL,'2023-10-19 15:44:13','2023-10-19 15:44:13'),(2489,'default','payment_edited',1390,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1350.0000\"}}',NULL,'2023-10-19 16:04:01','2023-10-19 16:04:01'),(2490,'default','payment_edited',1023,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6600.0000\"}}',NULL,'2023-10-19 17:23:57','2023-10-19 17:23:57'),(2491,'default','payment_edited',1291,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2023-10-19 17:27:23','2023-10-19 17:27:23'),(2492,'default','payment_edited',760,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"14900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"14900.0000\"}}',NULL,'2023-10-19 17:28:25','2023-10-19 17:28:25'),(2493,'default','payment_edited',998,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"200.0000\"}}',NULL,'2023-10-19 17:30:31','2023-10-19 17:30:31'),(2494,'default','payment_edited',983,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"780.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"780.0000\"}}',NULL,'2023-10-19 17:32:31','2023-10-19 17:32:31'),(2495,'default','added',1398,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-10-21 05:54:45','2023-10-21 05:54:45'),(2496,'default','added',1399,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3800}}',NULL,'2023-10-21 06:22:41','2023-10-21 06:22:41'),(2497,'default','added',1400,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":17000}}',NULL,'2023-10-21 06:56:19','2023-10-21 06:56:19'),(2498,'default','added',706,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 14:07:05','2023-10-21 14:07:05'),(2499,'default','added',1401,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2350}}',NULL,'2023-10-21 14:07:51','2023-10-21 14:07:51'),(2500,'default','added',707,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-21 15:22:38','2023-10-21 15:22:38'),(2501,'default','added',1402,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":15296}}',NULL,'2023-10-21 15:27:34','2023-10-21 15:27:34'),(2502,'default','edited',1402,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":20496},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"15296.0000\"}}',NULL,'2023-10-21 15:57:50','2023-10-21 15:57:50'),(2503,'default','edited',1402,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":20496},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"20496.0000\"}}',NULL,'2023-10-21 15:58:22','2023-10-21 15:58:22'),(2504,'default','added',1403,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4700}}',NULL,'2023-10-22 05:43:35','2023-10-22 05:43:35'),(2505,'default','edited',1403,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4700.0000\"}}',NULL,'2023-10-22 06:03:38','2023-10-22 06:03:38'),(2506,'default','edited',1400,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"17000.0000\"}}',NULL,'2023-10-22 07:45:37','2023-10-22 07:45:37'),(2507,'default','added',1404,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5200}}',NULL,'2023-10-22 07:46:32','2023-10-22 07:46:32'),(2508,'default','edited',1404,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5200.0000\"}}',NULL,'2023-10-22 07:54:24','2023-10-22 07:54:24'),(2509,'default','edited',1402,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":24419},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"20496.0000\"}}',NULL,'2023-10-22 07:59:11','2023-10-22 07:59:11'),(2510,'default','edited',1404,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10200.0000\"}}',NULL,'2023-10-22 08:02:17','2023-10-22 08:02:17'),(2511,'default','payment_edited',1402,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"24419.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"24419.0000\"}}',NULL,'2023-10-22 08:27:45','2023-10-22 08:27:45'),(2512,'default','added',1406,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1350}}',NULL,'2023-10-22 08:40:38','2023-10-22 08:40:38'),(2513,'default','added',1407,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6000}}',NULL,'2023-10-22 09:00:22','2023-10-22 09:00:22'),(2514,'default','payment_edited',1407,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6000.0000\"}}',NULL,'2023-10-22 11:12:28','2023-10-22 11:12:28'),(2515,'default','added',1408,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7700}}',NULL,'2023-10-22 11:43:24','2023-10-22 11:43:24'),(2516,'default','edited',1392,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-10-22 13:22:11','2023-10-22 13:22:11'),(2517,'default','payment_edited',1408,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7700.0000\"}}',NULL,'2023-10-22 14:11:23','2023-10-22 14:11:23'),(2518,'default','edited',599,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-22 14:51:07','2023-10-22 14:51:07'),(2519,'default','added',1409,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8010}}',NULL,'2023-10-22 14:58:59','2023-10-22 14:58:59'),(2520,'default','payment_edited',1362,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4100.0000\"}}',NULL,'2023-10-22 15:52:01','2023-10-22 15:52:01'),(2521,'default','payment_edited',1379,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4100.0000\"}}',NULL,'2023-10-22 15:52:01','2023-10-22 15:52:01'),(2522,'default','payment_edited',1392,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1350.0000\"}}',NULL,'2023-10-22 15:52:01','2023-10-22 15:52:01'),(2523,'default','payment_edited',1403,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-10-22 15:52:01','2023-10-22 15:52:01'),(2524,'default','added',1410,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-10-23 05:25:33','2023-10-23 05:25:33'),(2525,'default','added',1411,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":750}}',NULL,'2023-10-23 05:27:14','2023-10-23 05:27:14'),(2526,'default','added',1412,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650}}',NULL,'2023-10-23 07:58:22','2023-10-23 07:58:22'),(2527,'default','added',1413,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":420}}',NULL,'2023-10-23 07:59:27','2023-10-23 07:59:27'),(2528,'default','added',1414,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-10-23 10:17:37','2023-10-23 10:17:37'),(2529,'default','added',1415,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":800}}',NULL,'2023-10-23 11:08:11','2023-10-23 11:08:11'),(2530,'default','added',1416,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-10-23 11:10:41','2023-10-23 11:10:41'),(2531,'default','added',1417,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300}}',NULL,'2023-10-23 13:26:59','2023-10-23 13:26:59'),(2532,'default','added',1419,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4400}}',NULL,'2023-10-23 14:30:12','2023-10-23 14:30:12'),(2533,'default','added',708,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-23 16:26:51','2023-10-23 16:26:51'),(2534,'default','added',1420,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-10-23 16:27:20','2023-10-23 16:27:20'),(2535,'default','added',1421,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":29500}}',NULL,'2023-10-24 08:48:55','2023-10-24 08:48:55'),(2536,'default','added',1422,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}',NULL,'2023-10-24 08:49:46','2023-10-24 08:49:46'),(2537,'default','added',1423,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-10-24 10:43:33','2023-10-24 10:43:33'),(2538,'default','edited',288,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-24 14:43:29','2023-10-24 14:43:29'),(2539,'default','added',1424,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12200}}',NULL,'2023-10-24 14:48:21','2023-10-24 14:48:21'),(2540,'default','edited',1424,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"12200.0000\"}}',NULL,'2023-10-24 14:50:13','2023-10-24 14:50:13'),(2541,'default','added',709,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-24 16:12:42','2023-10-24 16:12:42'),(2542,'default','added',1425,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":28430}}',NULL,'2023-10-24 16:36:06','2023-10-24 16:36:06'),(2543,'default','edited',1425,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":40480},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"28430.0000\"}}',NULL,'2023-10-24 16:39:16','2023-10-24 16:39:16'),(2544,'default','added',710,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-25 05:51:22','2023-10-25 05:51:22'),(2545,'default','added',1428,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":24700}}',NULL,'2023-10-25 06:02:41','2023-10-25 06:02:41'),(2546,'default','added',711,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-25 08:31:40','2023-10-25 08:31:40'),(2547,'default','added',1429,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3000}}',NULL,'2023-10-25 08:33:17','2023-10-25 08:33:17'),(2548,'default','edited',1428,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":29171},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"24700.0000\"}}',NULL,'2023-10-25 09:02:31','2023-10-25 09:02:31'),(2549,'default','edited',1428,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":30270},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"29171.0000\"}}',NULL,'2023-10-25 09:10:04','2023-10-25 09:10:04'),(2550,'default','added',1431,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-10-25 09:24:49','2023-10-25 09:24:49'),(2551,'default','added',1432,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3450}}',NULL,'2023-10-25 10:44:54','2023-10-25 10:44:54'),(2552,'default','payment_edited',1432,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3450.0000\"}}',NULL,'2023-10-25 10:47:25','2023-10-25 10:47:25'),(2553,'default','payment_edited',1334,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2000.0000\"}}',NULL,'2023-10-25 10:56:56','2023-10-25 10:56:56'),(2554,'default','edited',1334,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2000.0000\"}}',NULL,'2023-10-25 10:59:36','2023-10-25 10:59:36'),(2555,'default','added',1433,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":26240}}',NULL,'2023-10-25 12:44:28','2023-10-25 12:44:28'),(2556,'default','edited',1433,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6740},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"26240.0000\"}}',NULL,'2023-10-25 13:09:57','2023-10-25 13:09:57'),(2557,'default','edited',1433,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6740},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6740.0000\"}}',NULL,'2023-10-25 13:10:11','2023-10-25 13:10:11'),(2558,'default','added',1434,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":19500}}',NULL,'2023-10-25 13:12:42','2023-10-25 13:12:42'),(2559,'default','payment_edited',1433,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6740.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6740.0000\"}}',NULL,'2023-10-25 13:14:02','2023-10-25 13:14:02'),(2560,'default','payment_edited',1434,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"19500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"19500.0000\"}}',NULL,'2023-10-25 13:14:02','2023-10-25 13:14:02'),(2561,'default','added',1435,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8700}}',NULL,'2023-10-25 13:21:05','2023-10-25 13:21:05'),(2562,'default','payment_edited',1435,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8700.0000\"}}',NULL,'2023-10-25 13:23:13','2023-10-25 13:23:13'),(2563,'default','edited',1435,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":9000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8700.0000\"}}',NULL,'2023-10-25 13:24:39','2023-10-25 13:24:39'),(2564,'default','added',1436,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-10-25 13:27:53','2023-10-25 13:27:53'),(2565,'default','payment_edited',1434,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"19500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"19500.0000\"}}',NULL,'2023-10-25 13:41:57','2023-10-25 13:41:57'),(2566,'default','added',1437,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-10-25 13:56:58','2023-10-25 13:56:58'),(2567,'default','sell_deleted',1269,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1269,\"invoice_no\":\"ITH2023-11672\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"450.0000\"}}',NULL,'2023-10-25 14:54:47','2023-10-25 14:54:47'),(2568,'default','added',1438,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2100}}',NULL,'2023-10-25 15:00:21','2023-10-25 15:00:21'),(2569,'default','added',1439,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4000}}',NULL,'2023-10-26 08:09:28','2023-10-26 08:09:28'),(2570,'default','added',1440,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5200}}',NULL,'2023-10-26 09:15:34','2023-10-26 09:15:34'),(2571,'default','added',1441,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4800}}',NULL,'2023-10-26 10:58:06','2023-10-26 10:58:06'),(2572,'default','added',1442,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":950}}',NULL,'2023-10-26 12:40:28','2023-10-26 12:40:28'),(2573,'default','added',1443,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":350}}',NULL,'2023-10-26 12:46:28','2023-10-26 12:46:28'),(2574,'default','added',1444,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-10-26 14:41:40','2023-10-26 14:41:40'),(2575,'default','added',1446,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7500}}',NULL,'2023-10-26 15:30:10','2023-10-26 15:30:10'),(2576,'default','edited',1446,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7500.0000\"}}',NULL,'2023-10-26 15:30:36','2023-10-26 15:30:36'),(2577,'default','edited',1446,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7500.0000\"}}',NULL,'2023-10-26 15:31:10','2023-10-26 15:31:10'),(2578,'default','added',1447,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900}}',NULL,'2023-10-26 15:35:03','2023-10-26 15:35:03'),(2579,'default','added',1448,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8500}}',NULL,'2023-10-26 15:40:24','2023-10-26 15:40:24'),(2580,'default','edited',1440,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5200.0000\"}}',NULL,'2023-10-28 05:04:57','2023-10-28 05:04:57'),(2581,'default','added',1449,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2023-10-28 05:46:34','2023-10-28 05:46:34'),(2582,'default','edited',1449,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":650},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"}}',NULL,'2023-10-28 05:48:03','2023-10-28 05:48:03'),(2583,'default','added',1450,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5150}}',NULL,'2023-10-28 06:07:09','2023-10-28 06:07:09'),(2584,'default','edited',1449,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"650.0000\"}}',NULL,'2023-10-28 06:19:39','2023-10-28 06:19:39'),(2585,'default','edited',1446,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7500.0000\"}}',NULL,'2023-10-28 09:55:59','2023-10-28 09:55:59'),(2586,'default','edited',1450,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5150.0000\"}}',NULL,'2023-10-28 09:56:28','2023-10-28 09:56:28'),(2587,'default','edited',1425,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":28490},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"40480.0000\"}}',NULL,'2023-10-28 10:02:04','2023-10-28 10:02:04'),(2588,'default','edited',1425,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":28490},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"28490.0000\"}}',NULL,'2023-10-28 10:04:46','2023-10-28 10:04:46'),(2589,'default','edited',1425,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":28790},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"28490.0000\"}}',NULL,'2023-10-28 10:05:38','2023-10-28 10:05:38'),(2590,'default','edited',851,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":102300},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"83700.0000\"}}',NULL,'2023-10-28 13:19:19','2023-10-28 13:19:19'),(2591,'default','added',1451,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-10-28 13:20:27','2023-10-28 13:20:27'),(2592,'default','added',1452,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5}}',NULL,'2023-10-28 13:23:31','2023-10-28 13:23:31'),(2593,'default','edited',851,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":123100},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"102300.0000\"}}',NULL,'2023-10-28 13:37:08','2023-10-28 13:37:08'),(2594,'default','sell_deleted',1441,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1441,\"invoice_no\":\"ITH2023-11823\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4800.0000\"}}',NULL,'2023-10-28 13:39:13','2023-10-28 13:39:13'),(2595,'default','added',1453,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3050}}',NULL,'2023-10-28 13:41:07','2023-10-28 13:41:07'),(2596,'default','edited',1452,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5.0000\"}}',NULL,'2023-10-28 13:46:07','2023-10-28 13:46:07'),(2597,'default','edited',851,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":123100},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"123100.0000\"}}',NULL,'2023-10-28 13:50:25','2023-10-28 13:50:25'),(2598,'default','sell_deleted',1453,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1453,\"invoice_no\":\"ITH2023-11835\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3050.0000\"}}',NULL,'2023-10-28 13:55:14','2023-10-28 13:55:14'),(2599,'default','edited',1452,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6.0000\"}}',NULL,'2023-10-28 14:08:13','2023-10-28 14:08:13'),(2600,'default','payment_edited',1390,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1350.0000\"}}',NULL,'2023-10-28 14:51:53','2023-10-28 14:51:53'),(2601,'default','payment_edited',1406,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1350.0000\"}}',NULL,'2023-10-28 14:51:53','2023-10-28 14:51:53'),(2602,'default','payment_edited',1419,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4400.0000\"}}',NULL,'2023-10-28 14:51:53','2023-10-28 14:51:53'),(2603,'default','payment_edited',1329,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6100.0000\"}}',NULL,'2023-10-28 15:31:11','2023-10-28 15:31:11'),(2604,'default','edited',1425,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":29165},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"28790.0000\"}}',NULL,'2023-10-28 16:38:22','2023-10-28 16:38:22'),(2605,'default','added',1454,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1800}}',NULL,'2023-10-29 08:18:24','2023-10-29 08:18:24'),(2606,'default','edited',1428,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":35990},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"30270.0000\"}}',NULL,'2023-10-29 08:27:41','2023-10-29 08:27:41'),(2607,'default','added',1456,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":76000}}',NULL,'2023-10-29 08:32:03','2023-10-29 08:32:03'),(2608,'default','added',1457,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1100}}',NULL,'2023-10-29 11:52:02','2023-10-29 11:52:02'),(2609,'default','added',1458,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3}}',NULL,'2023-10-29 12:24:28','2023-10-29 12:24:28'),(2610,'default','added',712,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-29 12:50:23','2023-10-29 12:50:23'),(2611,'default','added',1459,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}',NULL,'2023-10-29 12:51:09','2023-10-29 12:51:09'),(2612,'default','payment_edited',1454,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1800.0000\"}}',NULL,'2023-10-29 13:36:23','2023-10-29 13:36:23'),(2613,'default','payment_edited',1448,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8500.0000\"}}',NULL,'2023-10-29 13:36:37','2023-10-29 13:36:37'),(2614,'default','added',713,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-29 13:40:01','2023-10-29 13:40:01'),(2615,'default','added',1460,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":119950}}',NULL,'2023-10-29 13:47:55','2023-10-29 13:47:55'),(2616,'default','edited',713,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-29 13:51:08','2023-10-29 13:51:08'),(2617,'default','edited',713,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-29 13:51:09','2023-10-29 13:51:09'),(2618,'default','edited',713,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-29 13:51:43','2023-10-29 13:51:43'),(2619,'default','edited',713,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-29 13:52:33','2023-10-29 13:52:33'),(2620,'default','edited',1460,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":119950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"119950.0000\"}}',NULL,'2023-10-29 14:20:04','2023-10-29 14:20:04'),(2621,'default','added',1461,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-10-29 14:38:26','2023-10-29 14:38:26'),(2622,'default','edited',1460,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":119960},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"119950.0000\"}}',NULL,'2023-10-29 14:52:34','2023-10-29 14:52:34'),(2623,'default','added',1462,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12510}}',NULL,'2023-10-30 06:20:09','2023-10-30 06:20:09'),(2624,'default','added',1463,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-10-30 07:46:46','2023-10-30 07:46:46'),(2625,'default','added',714,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-30 07:50:49','2023-10-30 07:50:49'),(2626,'default','added',1464,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2620}}',NULL,'2023-10-30 07:51:57','2023-10-30 07:51:57'),(2627,'default','added',1465,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-10-30 08:29:16','2023-10-30 08:29:16'),(2628,'default','added',715,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-30 09:22:19','2023-10-30 09:22:19'),(2629,'default','added',1466,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-10-30 09:22:53','2023-10-30 09:22:53'),(2630,'default','edited',1466,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-10-30 09:23:16','2023-10-30 09:23:16'),(2631,'default','payment_edited',948,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"400.0000\"}}',NULL,'2023-10-30 09:26:04','2023-10-30 09:26:04'),(2632,'default','added',1467,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":200}}',NULL,'2023-10-30 10:39:59','2023-10-30 10:39:59'),(2633,'default','added',1468,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2375}}',NULL,'2023-10-30 10:53:20','2023-10-30 10:53:20'),(2634,'default','added',1469,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300}}',NULL,'2023-10-30 11:00:28','2023-10-30 11:00:28'),(2635,'default','edited',1469,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3300.0000\"}}',NULL,'2023-10-30 11:19:58','2023-10-30 11:19:58'),(2636,'default','edited',1468,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2375.0000\"}}',NULL,'2023-10-30 11:20:56','2023-10-30 11:20:56'),(2637,'default','payment_edited',1439,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4000.0000\"}}',NULL,'2023-10-30 12:38:56','2023-10-30 12:38:56'),(2638,'default','payment_edited',1461,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-10-30 12:56:28','2023-10-30 12:56:28'),(2639,'default','payment_edited',1391,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2850.0000\"}}',NULL,'2023-10-30 14:41:22','2023-10-30 14:41:22'),(2640,'default','payment_edited',1404,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"12100.0000\"}}',NULL,'2023-10-30 14:41:22','2023-10-30 14:41:22'),(2641,'default','payment_edited',1404,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12100.0000\"}}',NULL,'2023-10-30 14:42:53','2023-10-30 14:42:53'),(2642,'default','payment_edited',1457,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1100.0000\"}}',NULL,'2023-10-30 14:48:15','2023-10-30 14:48:15'),(2643,'default','payment_edited',1064,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-10-30 15:17:54','2023-10-30 15:17:54'),(2644,'default','added',716,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-10-31 06:02:55','2023-10-31 06:02:55'),(2645,'default','added',1470,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2023-10-31 06:03:41','2023-10-31 06:03:41'),(2646,'default','added',717,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-31 07:24:38','2023-10-31 07:24:38'),(2647,'default','added',1471,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-10-31 07:25:36','2023-10-31 07:25:36'),(2648,'default','added',1472,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2023-10-31 09:43:20','2023-10-31 09:43:20'),(2649,'default','added',1473,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2100}}',NULL,'2023-10-31 09:43:42','2023-10-31 09:43:42'),(2650,'default','added',1474,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":800}}',NULL,'2023-10-31 09:47:07','2023-10-31 09:47:07'),(2651,'default','edited',1472,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-10-31 10:03:23','2023-10-31 10:03:23'),(2652,'default','added',1475,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300}}',NULL,'2023-10-31 11:25:53','2023-10-31 11:25:53'),(2653,'default','payment_edited',1472,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4800.0000\"}}',NULL,'2023-10-31 11:56:55','2023-10-31 11:56:55'),(2654,'default','payment_edited',1416,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-10-31 12:01:54','2023-10-31 12:01:54'),(2655,'default','payment_edited',1327,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3900.0000\"}}',NULL,'2023-10-31 12:02:02','2023-10-31 12:02:02'),(2656,'default','added',718,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-31 12:04:52','2023-10-31 12:04:52'),(2657,'default','edited',1475,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3300.0000\"}}',NULL,'2023-10-31 12:04:54','2023-10-31 12:04:54'),(2658,'default','edited',1473,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2100.0000\"}}',NULL,'2023-10-31 12:05:11','2023-10-31 12:05:11'),(2659,'default','payment_edited',1414,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-10-31 12:28:48','2023-10-31 12:28:48'),(2660,'default','added',719,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-10-31 13:06:27','2023-10-31 13:06:27'),(2661,'default','added',1476,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14200}}',NULL,'2023-10-31 13:09:56','2023-10-31 13:09:56'),(2662,'default','added',1477,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-10-31 16:00:18','2023-10-31 16:00:18'),(2663,'default','edited',1450,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3500.0000\"}}',NULL,'2023-10-31 16:13:47','2023-10-31 16:13:47'),(2664,'default','payment_edited',1403,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2200.0000\"}}',NULL,'2023-10-31 16:14:34','2023-10-31 16:14:34'),(2665,'default','payment_edited',1450,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-10-31 16:14:34','2023-10-31 16:14:34'),(2666,'default','added',1478,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":16100}}',NULL,'2023-11-01 05:00:35','2023-11-01 05:00:35'),(2667,'default','added',720,'App\\Contact',NULL,1,2,'App\\User','[]',NULL,'2023-11-01 05:57:38','2023-11-01 05:57:38'),(2668,'default','added',1479,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1000}}',NULL,'2023-11-01 05:57:50','2023-11-01 05:57:50'),(2669,'default','added',1480,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":350}}',NULL,'2023-11-01 06:09:24','2023-11-01 06:09:24'),(2670,'default','added',1481,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3050}}',NULL,'2023-11-01 07:23:53','2023-11-01 07:23:53'),(2671,'default','edited',1478,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"16100.0000\"}}',NULL,'2023-11-01 07:26:53','2023-11-01 07:26:53'),(2672,'default','added',721,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-01 08:16:53','2023-11-01 08:16:53'),(2673,'default','added',1482,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6028}}',NULL,'2023-11-01 08:19:56','2023-11-01 08:19:56'),(2674,'default','edited',1100,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":79500},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"68800.0000\"}}',NULL,'2023-11-01 10:27:42','2023-11-01 10:27:42'),(2675,'default','payment_edited',1482,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6028.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6028.0000\"}}',NULL,'2023-11-01 10:49:58','2023-11-01 10:49:58'),(2676,'default','added',1483,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":600}}',NULL,'2023-11-01 10:57:13','2023-11-01 10:57:13'),(2677,'default','added',1484,'App\\Transaction',NULL,1,2,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2023-11-01 11:08:00','2023-11-01 11:08:00'),(2678,'default','payment_edited',896,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"380.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"380.0000\"}}',NULL,'2023-11-01 13:30:45','2023-11-01 13:30:45'),(2679,'default','added',1485,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-01 13:46:50','2023-11-01 13:46:50'),(2680,'default','added',1487,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":370}}',NULL,'2023-11-01 16:26:13','2023-11-01 16:26:13'),(2681,'default','added',1488,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-11-01 16:27:16','2023-11-01 16:27:16'),(2682,'default','payment_edited',1474,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"800.0000\"}}',NULL,'2023-11-01 16:30:16','2023-11-01 16:30:16'),(2683,'default','payment_edited',1481,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-01 16:30:34','2023-11-01 16:30:34'),(2684,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-02 04:30:36','2023-11-02 04:30:36'),(2685,'default','edited',1479,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"}}',NULL,'2023-11-02 04:32:45','2023-11-02 04:32:45'),(2686,'default','edited',1473,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"750.0000\"}}',NULL,'2023-11-02 05:46:06','2023-11-02 05:46:06'),(2687,'default','edited',1473,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4850},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2800.0000\"}}',NULL,'2023-11-02 06:24:29','2023-11-02 06:24:29'),(2688,'default','added',1489,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":3850}}',NULL,'2023-11-02 06:36:00','2023-11-02 06:36:00'),(2689,'default','payment_edited',1489,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"3850.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"3850.0000\"}}',NULL,'2023-11-02 06:36:26','2023-11-02 06:36:26'),(2690,'default','edited',1473,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4850.0000\"}}',NULL,'2023-11-02 06:39:01','2023-11-02 06:39:01'),(2691,'default','edited',1473,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6400.0000\"}}',NULL,'2023-11-02 06:40:01','2023-11-02 06:40:01'),(2692,'default','added',722,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-02 08:27:12','2023-11-02 08:27:12'),(2693,'default','added',1490,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-11-02 08:28:30','2023-11-02 08:28:30'),(2694,'default','added',1491,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450}}',NULL,'2023-11-02 08:28:38','2023-11-02 08:28:38'),(2695,'default','payment_edited',783,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2500.0000\"}}',NULL,'2023-11-02 10:12:04','2023-11-02 10:12:04'),(2696,'default','added',1492,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2400}}',NULL,'2023-11-02 11:14:29','2023-11-02 11:14:29'),(2697,'default','sell_deleted',1302,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1302,\"invoice_no\":\"ITH2023-11702\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"700.0000\"}}',NULL,'2023-11-02 11:19:45','2023-11-02 11:19:45'),(2698,'default','added',1493,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8500}}',NULL,'2023-11-02 11:29:30','2023-11-02 11:29:30'),(2699,'default','added',1494,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1950}}',NULL,'2023-11-02 12:25:59','2023-11-02 12:25:59'),(2700,'default','added',1495,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4100}}',NULL,'2023-11-02 13:00:25','2023-11-02 13:00:25'),(2701,'default','edited',1495,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4100.0000\"}}',NULL,'2023-11-02 13:00:40','2023-11-02 13:00:40'),(2702,'default','payment_edited',1494,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1950.0000\"}}',NULL,'2023-11-02 14:05:07','2023-11-02 14:05:07'),(2703,'default','payment_edited',1492,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-11-02 14:05:17','2023-11-02 14:05:17'),(2704,'default','edited',1490,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":1350},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-11-02 14:16:00','2023-11-02 14:16:00'),(2705,'default','added',1496,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":2300}}',NULL,'2023-11-02 14:17:18','2023-11-02 14:17:18'),(2706,'default','added',1497,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1350}}',NULL,'2023-11-02 16:31:38','2023-11-02 16:31:38'),(2707,'default','payment_edited',551,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"650.0000\"}}',NULL,'2023-11-02 16:37:51','2023-11-02 16:37:51'),(2708,'default','payment_edited',616,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1850.0000\"}}',NULL,'2023-11-02 16:37:51','2023-11-02 16:37:51'),(2709,'default','payment_edited',766,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-11-02 16:37:51','2023-11-02 16:37:51'),(2710,'default','edited',1091,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"150.0000\"}}',NULL,'2023-11-02 16:57:37','2023-11-02 16:57:37'),(2711,'default','edited',770,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":2400},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-11-02 17:03:58','2023-11-02 17:03:58'),(2712,'default','added',1498,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5600}}',NULL,'2023-11-04 07:18:38','2023-11-04 07:18:38'),(2713,'default','edited',1498,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5600.0000\"}}',NULL,'2023-11-04 07:24:33','2023-11-04 07:24:33'),(2714,'default','added',1499,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900}}',NULL,'2023-11-04 09:41:29','2023-11-04 09:41:29'),(2715,'default','payment_edited',1478,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8200.0000\"}}',NULL,'2023-11-04 11:01:33','2023-11-04 11:01:33'),(2716,'default','added',1500,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2800}}',NULL,'2023-11-04 11:02:29','2023-11-04 11:02:29'),(2717,'default','added',1501,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":480}}',NULL,'2023-11-04 13:01:10','2023-11-04 13:01:10'),(2718,'default','added',1502,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10500}}',NULL,'2023-11-04 13:26:20','2023-11-04 13:26:20'),(2719,'default','edited',1498,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8700.0000\"}}',NULL,'2023-11-04 13:43:55','2023-11-04 13:43:55'),(2720,'default','edited',656,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-04 16:39:20','2023-11-04 16:39:20'),(2721,'default','payment_edited',1404,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"12100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12100.0000\"}}',NULL,'2023-11-04 16:41:03','2023-11-04 16:41:03'),(2722,'default','payment_edited',1410,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-11-04 16:41:03','2023-11-04 16:41:03'),(2723,'default','payment_edited',1498,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5350.0000\"}}',NULL,'2023-11-04 16:41:03','2023-11-04 16:41:03'),(2724,'default','edited',536,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-04 16:53:18','2023-11-04 16:53:18'),(2725,'default','edited',536,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-04 16:53:31','2023-11-04 16:53:31'),(2726,'default','added',1503,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":20200}}',NULL,'2023-11-04 16:59:11','2023-11-04 16:59:11'),(2727,'default','edited',1498,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":8700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5350.0000\"}}',NULL,'2023-11-04 17:45:37','2023-11-04 17:45:37'),(2728,'default','edited',1473,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4350.0000\"}}',NULL,'2023-11-05 06:46:30','2023-11-05 06:46:30'),(2729,'default','added',1504,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":450}}',NULL,'2023-11-05 07:03:40','2023-11-05 07:03:40'),(2730,'default','payment_edited',1415,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"800.0000\"}}',NULL,'2023-11-05 07:50:03','2023-11-05 07:50:03'),(2731,'default','payment_edited',1473,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4500.0000\"}}',NULL,'2023-11-05 07:50:03','2023-11-05 07:50:03'),(2732,'default','added',1505,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3050}}',NULL,'2023-11-05 09:21:33','2023-11-05 09:21:33'),(2733,'default','added',1506,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-11-05 09:24:29','2023-11-05 09:24:29'),(2734,'default','added',723,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-05 09:41:22','2023-11-05 09:41:22'),(2735,'default','added',1507,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":37700}}',NULL,'2023-11-05 10:10:16','2023-11-05 10:10:16'),(2736,'default','added',1508,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1215}}',NULL,'2023-11-05 11:20:00','2023-11-05 11:20:00'),(2737,'default','added',1511,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":37000}}',NULL,'2023-11-05 11:51:49','2023-11-05 11:51:49'),(2738,'default','edited',1511,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":38050},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"37000.0000\"}}',NULL,'2023-11-05 12:03:48','2023-11-05 12:03:48'),(2739,'default','edited',1511,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":38050},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"38050.0000\"}}',NULL,'2023-11-05 12:04:01','2023-11-05 12:04:01'),(2740,'default','payment_edited',1511,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"38050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"38050.0000\"}}',NULL,'2023-11-05 12:11:32','2023-11-05 12:11:32'),(2741,'default','added',1513,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3330}}',NULL,'2023-11-05 12:54:49','2023-11-05 12:54:49'),(2742,'default','added',724,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-05 14:18:21','2023-11-05 14:18:21'),(2743,'default','added',1514,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2023-11-05 14:18:48','2023-11-05 14:18:48'),(2744,'default','added',1515,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3200}}',NULL,'2023-11-05 15:13:04','2023-11-05 15:13:04'),(2745,'default','added',1516,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":9000}}',NULL,'2023-11-05 15:48:12','2023-11-05 15:48:12'),(2746,'default','payment_edited',1478,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8200.0000\"}}',NULL,'2023-11-05 15:54:36','2023-11-05 15:54:36'),(2747,'default','payment_edited',1500,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2800.0000\"}}',NULL,'2023-11-05 15:54:36','2023-11-05 15:54:36'),(2748,'default','payment_edited',1506,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-11-05 15:54:36','2023-11-05 15:54:36'),(2749,'default','edited',1513,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3330.0000\"}}',NULL,'2023-11-05 15:55:14','2023-11-05 15:55:14'),(2750,'default','payment_edited',1498,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8700.0000\"}}',NULL,'2023-11-05 15:55:33','2023-11-05 15:55:33'),(2751,'default','added',1517,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":750}}',NULL,'2023-11-06 06:08:19','2023-11-06 06:08:19'),(2752,'default','added',1518,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":313}}',NULL,'2023-11-06 10:20:26','2023-11-06 10:20:26'),(2753,'default','added',1519,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3350}}',NULL,'2023-11-06 12:40:29','2023-11-06 12:40:29'),(2754,'default','added',1520,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1100}}',NULL,'2023-11-06 12:42:56','2023-11-06 12:42:56'),(2755,'default','added',1521,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":17000}}',NULL,'2023-11-06 12:55:37','2023-11-06 12:55:37'),(2756,'default','edited',1425,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":13665},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"29165.0000\"}}',NULL,'2023-11-06 12:58:00','2023-11-06 12:58:00'),(2757,'default','payment_edited',1425,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13665.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"13665.0000\"}}',NULL,'2023-11-06 12:59:41','2023-11-06 12:59:41'),(2758,'default','payment_edited',1521,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"17000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"17000.0000\"}}',NULL,'2023-11-06 12:59:41','2023-11-06 12:59:41'),(2759,'default','payment_edited',1519,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3350.0000\"}}',NULL,'2023-11-06 13:04:10','2023-11-06 13:04:10'),(2760,'default','added',1522,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-11-06 13:40:25','2023-11-06 13:40:25'),(2761,'default','added',725,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-06 15:26:00','2023-11-06 15:26:00'),(2762,'default','payment_edited',1515,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3200.0000\"}}',NULL,'2023-11-06 15:42:24','2023-11-06 15:42:24'),(2763,'default','sell_deleted',1522,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1522,\"invoice_no\":\"ITH2023-11893\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2023-11-06 15:42:57','2023-11-06 15:42:57'),(2764,'default','added',1523,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":52155}}',NULL,'2023-11-06 16:00:34','2023-11-06 16:00:34'),(2765,'default','added',1524,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2023-11-06 16:20:04','2023-11-06 16:20:04'),(2766,'default','added',1525,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6200}}',NULL,'2023-11-07 04:47:57','2023-11-07 04:47:57'),(2767,'default','edited',1525,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6200.0000\"}}',NULL,'2023-11-07 04:56:47','2023-11-07 04:56:47'),(2768,'default','added',1526,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4390}}',NULL,'2023-11-07 05:06:45','2023-11-07 05:06:45'),(2769,'default','added',1527,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4}}',NULL,'2023-11-07 05:42:03','2023-11-07 05:42:03'),(2770,'default','added',726,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-07 06:39:37','2023-11-07 06:39:37'),(2771,'default','added',1528,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":690}}',NULL,'2023-11-07 06:43:30','2023-11-07 06:43:30'),(2772,'default','edited',1518,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"313.0000\"}}',NULL,'2023-11-07 08:36:20','2023-11-07 08:36:20'),(2773,'default','added',727,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-07 09:04:04','2023-11-07 09:04:04'),(2774,'default','added',1531,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4720}}',NULL,'2023-11-07 09:16:16','2023-11-07 09:16:16'),(2775,'default','added',728,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-07 09:55:44','2023-11-07 09:55:44'),(2776,'default','added',1532,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1450}}',NULL,'2023-11-07 09:56:18','2023-11-07 09:56:18'),(2777,'default','added',1533,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2023-11-07 11:12:16','2023-11-07 11:12:16'),(2778,'default','edited',1526,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3060},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4390.0000\"}}',NULL,'2023-11-07 11:22:36','2023-11-07 11:22:36'),(2779,'default','added',1534,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4815}}',NULL,'2023-11-07 11:32:19','2023-11-07 11:32:19'),(2780,'default','edited',1534,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4815.0000\"}}',NULL,'2023-11-07 13:43:44','2023-11-07 13:43:44'),(2781,'default','edited',1534,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6800.0000\"}}',NULL,'2023-11-07 15:11:30','2023-11-07 15:11:30'),(2782,'default','edited',1534,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5600},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6800.0000\"}}',NULL,'2023-11-07 15:19:35','2023-11-07 15:19:35'),(2783,'default','payment_edited',766,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2400.0000\"}}',NULL,'2023-11-07 15:20:32','2023-11-07 15:20:32'),(2784,'default','payment_edited',792,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2350.0000\"}}',NULL,'2023-11-07 15:20:32','2023-11-07 15:20:32'),(2785,'default','added',1535,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-11-08 05:27:07','2023-11-08 05:27:07'),(2786,'default','added',1536,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":16500}}',NULL,'2023-11-08 08:04:16','2023-11-08 08:04:16'),(2787,'default','added',1537,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-11-08 08:21:20','2023-11-08 08:21:20'),(2788,'default','added',729,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-08 08:29:00','2023-11-08 08:29:00'),(2789,'default','added',1538,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-11-08 08:31:11','2023-11-08 08:31:11'),(2790,'default','edited',1537,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":20000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-11-08 08:34:11','2023-11-08 08:34:11'),(2791,'default','added',730,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-08 10:38:55','2023-11-08 10:38:55'),(2792,'default','added',1539,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-08 10:40:03','2023-11-08 10:40:03'),(2793,'default','added',1540,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":476}}',NULL,'2023-11-08 11:41:00','2023-11-08 11:41:00'),(2794,'default','payment_edited',1537,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"20000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"20000.0000\"}}',NULL,'2023-11-08 11:42:06','2023-11-08 11:42:06'),(2795,'default','added',1541,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":880}}',NULL,'2023-11-08 15:50:02','2023-11-08 15:50:02'),(2796,'default','edited',1541,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1760},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"880.0000\"}}',NULL,'2023-11-08 15:55:50','2023-11-08 15:55:50'),(2797,'default','edited',1541,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1760},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1760.0000\"}}',NULL,'2023-11-08 15:56:11','2023-11-08 15:56:11'),(2798,'default','added',1542,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5900}}',NULL,'2023-11-09 04:27:36','2023-11-09 04:27:36'),(2799,'default','added',1543,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1125}}',NULL,'2023-11-09 04:46:22','2023-11-09 04:46:22'),(2800,'default','edited',706,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-11-09 05:56:48','2023-11-09 05:56:48'),(2801,'default','payment_edited',1104,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2100.0000\"}}',NULL,'2023-11-09 05:57:51','2023-11-09 05:57:51'),(2802,'default','added',1544,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":405}}',NULL,'2023-11-09 06:28:30','2023-11-09 06:28:30'),(2803,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-09 09:05:39','2023-11-09 09:05:39'),(2804,'default','edited',1502,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10500.0000\"}}',NULL,'2023-11-09 09:07:10','2023-11-09 09:07:10'),(2805,'default','sell_deleted',875,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":875,\"invoice_no\":\"ITH2023-11331\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"14.0000\"}}',NULL,'2023-11-09 09:08:50','2023-11-09 09:08:50'),(2806,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-09 09:14:19','2023-11-09 09:14:19'),(2807,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-09 09:14:44','2023-11-09 09:14:44'),(2808,'default','payment_edited',614,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2100.0000\"}}',NULL,'2023-11-09 09:15:57','2023-11-09 09:15:57'),(2809,'default','payment_edited',726,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3400.0000\"}}',NULL,'2023-11-09 09:15:57','2023-11-09 09:15:57'),(2810,'default','payment_edited',1286,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2023-11-09 09:15:57','2023-11-09 09:15:57'),(2811,'default','payment_edited',1324,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-11-09 09:15:57','2023-11-09 09:15:57'),(2812,'default','payment_edited',1502,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8700.0000\"}}',NULL,'2023-11-09 09:15:57','2023-11-09 09:15:57'),(2813,'default','payment_edited',1508,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1215.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1215.0000\"}}',NULL,'2023-11-09 09:15:57','2023-11-09 09:15:57'),(2814,'default','payment_edited',1544,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"405.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"405.0000\"}}',NULL,'2023-11-09 09:15:57','2023-11-09 09:15:57'),(2815,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-09 09:16:27','2023-11-09 09:16:27'),(2816,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-09 10:01:14','2023-11-09 10:01:14'),(2817,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-09 10:07:42','2023-11-09 10:07:42'),(2818,'default','payment_edited',897,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-11-09 10:14:28','2023-11-09 10:14:28'),(2819,'default','payment_edited',948,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"400.0000\"}}',NULL,'2023-11-09 10:14:28','2023-11-09 10:14:28'),(2820,'default','payment_edited',1126,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6500.0000\"}}',NULL,'2023-11-09 10:14:28','2023-11-09 10:14:28'),(2821,'default','payment_edited',1525,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6200.0000\"}}',NULL,'2023-11-09 10:16:28','2023-11-09 10:16:28'),(2822,'default','edited',2,'App\\User',NULL,1,1,'App\\User','{\"name\":\" abdul ahad\"}',NULL,'2023-11-09 10:16:59','2023-11-09 10:16:59'),(2823,'default','edited',1542,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5900.0000\"}}',NULL,'2023-11-09 10:17:32','2023-11-09 10:17:32'),(2824,'default','edited',1543,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1125.0000\"}}',NULL,'2023-11-09 10:17:54','2023-11-09 10:17:54'),(2825,'default','payment_edited',792,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2350.0000\"}}',NULL,'2023-11-09 10:25:12','2023-11-09 10:25:12'),(2826,'default','payment_edited',808,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"200.0000\"}}',NULL,'2023-11-09 10:25:12','2023-11-09 10:25:12'),(2827,'default','payment_edited',816,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"300.0000\"}}',NULL,'2023-11-09 10:25:12','2023-11-09 10:25:12'),(2828,'default','payment_edited',823,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3150.0000\"}}',NULL,'2023-11-09 10:25:12','2023-11-09 10:25:12'),(2829,'default','added',1545,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":100}}',NULL,'2023-11-09 10:26:25','2023-11-09 10:26:25'),(2830,'default','payment_edited',1532,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1450.0000\"}}',NULL,'2023-11-09 10:26:41','2023-11-09 10:26:41'),(2831,'default','payment_edited',1526,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3060.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3060.0000\"}}',NULL,'2023-11-09 10:27:01','2023-11-09 10:27:01'),(2832,'default','payment_edited',1520,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1100.0000\"}}',NULL,'2023-11-09 10:27:18','2023-11-09 10:27:18'),(2833,'default','payment_edited',706,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1100.0000\"}}',NULL,'2023-11-09 10:27:37','2023-11-09 10:27:37'),(2834,'default','payment_edited',1104,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2100.0000\"}}',NULL,'2023-11-09 10:31:55','2023-11-09 10:31:55'),(2835,'default','edited',1516,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":5000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"9000.0000\"}}',NULL,'2023-11-09 10:32:20','2023-11-09 10:32:20'),(2836,'default','edited',1523,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":54355},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"52155.0000\"}}',NULL,'2023-11-09 10:36:42','2023-11-09 10:36:42'),(2837,'default','payment_edited',1435,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"9000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"9000.0000\"}}',NULL,'2023-11-09 11:52:24','2023-11-09 11:52:24'),(2838,'default','added',1546,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":550}}',NULL,'2023-11-11 07:23:14','2023-11-11 07:23:14'),(2839,'default','added',1547,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5050}}',NULL,'2023-11-11 07:24:52','2023-11-11 07:24:52'),(2840,'default','added',731,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-11 08:04:08','2023-11-11 08:04:08'),(2841,'default','added',1548,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3200}}',NULL,'2023-11-11 08:08:56','2023-11-11 08:08:56'),(2842,'default','added',732,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-11 11:09:31','2023-11-11 11:09:31'),(2843,'default','added',1549,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":28700}}',NULL,'2023-11-11 11:26:43','2023-11-11 11:26:43'),(2844,'default','edited',1549,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":29800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"28700.0000\"}}',NULL,'2023-11-11 11:33:54','2023-11-11 11:33:54'),(2845,'default','edited',1549,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":29400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"29800.0000\"}}',NULL,'2023-11-11 11:45:58','2023-11-11 11:45:58'),(2846,'default','payment_edited',1549,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"29400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"29400.0000\"}}',NULL,'2023-11-11 12:00:27','2023-11-11 12:00:27'),(2847,'default','added',733,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-11 12:17:19','2023-11-11 12:17:19'),(2848,'default','added',1550,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-11-11 12:18:18','2023-11-11 12:18:18'),(2849,'default','added',734,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-12 06:23:58','2023-11-12 06:23:58'),(2850,'default','added',1551,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-12 06:25:12','2023-11-12 06:25:12'),(2851,'default','edited',1551,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1250.0000\"}}',NULL,'2023-11-12 06:34:02','2023-11-12 06:34:02'),(2852,'default','added',1552,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2700}}',NULL,'2023-11-12 10:36:57','2023-11-12 10:36:57'),(2853,'default','added',1553,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2450}}',NULL,'2023-11-12 12:34:00','2023-11-12 12:34:00'),(2854,'default','edited',1525,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":6100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6200.0000\"}}',NULL,'2023-11-12 12:41:37','2023-11-12 12:41:37'),(2855,'default','added',1554,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4100}}',NULL,'2023-11-12 12:52:23','2023-11-12 12:52:23'),(2856,'default','payment_edited',1525,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6100.0000\"}}',NULL,'2023-11-12 12:53:52','2023-11-12 12:53:52'),(2857,'default','payment_edited',1542,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4100.0000\"}}',NULL,'2023-11-12 12:53:52','2023-11-12 12:53:52'),(2858,'default','payment_edited',1553,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2450.0000\"}}',NULL,'2023-11-12 13:14:24','2023-11-12 13:14:24'),(2859,'default','added',735,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-12 13:24:31','2023-11-12 13:24:31'),(2860,'default','added',1555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6070}}',NULL,'2023-11-12 13:43:23','2023-11-12 13:43:23'),(2861,'default','edited',1555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7590},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6070.0000\"}}',NULL,'2023-11-12 14:12:56','2023-11-12 14:12:56'),(2862,'default','edited',1555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7590.0000\"}}',NULL,'2023-11-12 14:15:46','2023-11-12 14:15:46'),(2863,'default','edited',1555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":7750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7500.0000\"}}',NULL,'2023-11-12 14:26:36','2023-11-12 14:26:36'),(2864,'default','payment_edited',1555,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7750.0000\"}}',NULL,'2023-11-12 15:19:08','2023-11-12 15:19:08'),(2865,'default','sell_deleted',1546,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1546,\"invoice_no\":\"ITH2023-11915\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"550.0000\"}}',NULL,'2023-11-12 16:01:50','2023-11-12 16:01:50'),(2866,'default','added',1556,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":14}}',NULL,'2023-11-13 06:21:52','2023-11-13 06:21:52'),(2867,'default','added',736,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-13 06:50:04','2023-11-13 06:50:04'),(2868,'default','added',1557,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-11-13 06:50:54','2023-11-13 06:50:54'),(2869,'default','added',1558,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":550}}',NULL,'2023-11-13 08:20:32','2023-11-13 08:20:32'),(2870,'default','edited',1556,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":216},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"14.0000\"}}',NULL,'2023-11-13 09:00:31','2023-11-13 09:00:31'),(2871,'default','added',1559,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":125}}',NULL,'2023-11-13 12:38:24','2023-11-13 12:38:24'),(2872,'default','added',1560,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4700}}',NULL,'2023-11-13 13:32:18','2023-11-13 13:32:18'),(2873,'default','edited',1560,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4700.0000\"}}',NULL,'2023-11-13 13:44:43','2023-11-13 13:44:43'),(2874,'default','edited',1552,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2700.0000\"}}',NULL,'2023-11-13 13:49:05','2023-11-13 13:49:05'),(2875,'default','payment_edited',1236,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2320.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2320.0000\"}}',NULL,'2023-11-13 14:13:22','2023-11-13 14:13:22'),(2876,'default','payment_edited',1534,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5600.0000\"}}',NULL,'2023-11-13 14:47:46','2023-11-13 14:47:46'),(2877,'default','added',1561,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":800}}',NULL,'2023-11-13 14:50:15','2023-11-13 14:50:15'),(2878,'default','payment_edited',1547,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5050.0000\"}}',NULL,'2023-11-13 14:50:59','2023-11-13 14:50:59'),(2879,'default','added',1562,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":26100}}',NULL,'2023-11-13 16:14:27','2023-11-13 16:14:27'),(2880,'default','edited',1562,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":25500},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"26100.0000\"}}',NULL,'2023-11-13 16:18:16','2023-11-13 16:18:16'),(2881,'default','added',1563,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":21850}}',NULL,'2023-11-13 16:22:05','2023-11-13 16:22:05'),(2882,'default','edited',1563,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"paid\",\"final_total\":21850},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"21850.0000\"}}',NULL,'2023-11-13 16:23:21','2023-11-13 16:23:21'),(2883,'default','added',737,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-14 05:06:59','2023-11-14 05:06:59'),(2884,'default','added',1564,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":18000}}',NULL,'2023-11-14 05:31:41','2023-11-14 05:31:41'),(2885,'default','added',1565,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250}}',NULL,'2023-11-14 06:29:09','2023-11-14 06:29:09'),(2886,'default','added',1566,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3800}}',NULL,'2023-11-14 08:29:59','2023-11-14 08:29:59'),(2887,'default','added',1567,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":240}}',NULL,'2023-11-14 08:50:52','2023-11-14 08:50:52'),(2888,'default','added',1568,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":420}}',NULL,'2023-11-14 08:51:42','2023-11-14 08:51:42'),(2889,'default','added',738,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-14 13:21:51','2023-11-14 13:21:51'),(2890,'default','added',1569,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6700}}',NULL,'2023-11-14 13:23:56','2023-11-14 13:23:56'),(2891,'default','added',1570,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5200}}',NULL,'2023-11-14 13:36:16','2023-11-14 13:36:16'),(2892,'default','payment_edited',1542,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4100.0000\"}}',NULL,'2023-11-14 13:37:48','2023-11-14 13:37:48'),(2893,'default','payment_edited',1554,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4100.0000\"}}',NULL,'2023-11-14 13:37:48','2023-11-14 13:37:48'),(2894,'default','payment_edited',1560,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-11-14 13:37:48','2023-11-14 13:37:48'),(2895,'default','payment_edited',1570,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5200.0000\"}}',NULL,'2023-11-14 13:37:48','2023-11-14 13:37:48'),(2896,'default','added',1571,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000}}',NULL,'2023-11-14 15:52:09','2023-11-14 15:52:09'),(2897,'default','added',1572,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":600}}',NULL,'2023-11-14 16:15:29','2023-11-14 16:15:29'),(2898,'default','payment_edited',1561,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"800.0000\"}}',NULL,'2023-11-14 16:19:42','2023-11-14 16:19:42'),(2899,'default','payment_edited',1496,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"2300.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"2300.0000\"}}',NULL,'2023-11-14 16:19:49','2023-11-14 16:19:49'),(2900,'default','payment_edited',1488,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2023-11-14 16:19:56','2023-11-14 16:19:56'),(2901,'default','payment_edited',770,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell_return\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"},\"old\":{\"type\":\"sell_return\",\"payment_status\":\"due\",\"final_total\":\"2400.0000\"}}',NULL,'2023-11-14 16:20:44','2023-11-14 16:20:44'),(2902,'default','payment_edited',823,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3150.0000\"}}',NULL,'2023-11-14 16:22:27','2023-11-14 16:22:27'),(2903,'default','payment_edited',832,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2130.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2130.0000\"}}',NULL,'2023-11-14 16:22:27','2023-11-14 16:22:27'),(2904,'default','sell_deleted',1568,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1568,\"invoice_no\":\"ITH2023-11934\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"420.0000\"}}',NULL,'2023-11-14 16:25:56','2023-11-14 16:25:56'),(2905,'default','added',1573,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":800}}',NULL,'2023-11-14 16:28:54','2023-11-14 16:28:54'),(2906,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-15 05:22:11','2023-11-15 05:22:11'),(2907,'default','added',1574,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-11-15 06:58:49','2023-11-15 06:58:49'),(2908,'default','payment_edited',1536,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"16500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"16500.0000\"}}',NULL,'2023-11-15 06:59:21','2023-11-15 06:59:21'),(2909,'default','added',1575,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2023-11-15 07:04:17','2023-11-15 07:04:17'),(2910,'default','edited',1417,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3300.0000\"}}',NULL,'2023-11-15 08:01:18','2023-11-15 08:01:18'),(2911,'default','payment_edited',1417,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4200.0000\"}}',NULL,'2023-11-15 08:01:40','2023-11-15 08:01:40'),(2912,'default','payment_edited',1247,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}',NULL,'2023-11-15 08:01:53','2023-11-15 08:01:53'),(2913,'default','added',1576,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13450}}',NULL,'2023-11-15 09:42:26','2023-11-15 09:42:26'),(2914,'default','edited',1576,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13450},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13450.0000\"}}',NULL,'2023-11-15 09:44:23','2023-11-15 09:44:23'),(2915,'default','payment_edited',1566,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3800.0000\"}}',NULL,'2023-11-15 09:44:49','2023-11-15 09:44:49'),(2916,'default','added',1577,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5550}}',NULL,'2023-11-15 09:48:32','2023-11-15 09:48:32'),(2917,'default','added',1579,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1000}}',NULL,'2023-11-15 09:54:58','2023-11-15 09:54:58'),(2918,'default','edited',1576,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":14350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13450.0000\"}}',NULL,'2023-11-15 10:42:04','2023-11-15 10:42:04'),(2919,'default','added',1580,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4700}}',NULL,'2023-11-15 10:45:19','2023-11-15 10:45:19'),(2920,'default','edited',1577,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5550.0000\"}}',NULL,'2023-11-15 10:45:40','2023-11-15 10:45:40'),(2921,'default','added',1581,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1950}}',NULL,'2023-11-15 12:25:27','2023-11-15 12:25:27'),(2922,'default','edited',1577,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2023-11-15 12:27:31','2023-11-15 12:27:31'),(2923,'default','edited',1577,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3300.0000\"}}',NULL,'2023-11-15 12:28:25','2023-11-15 12:28:25'),(2924,'default','added',1582,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2050}}',NULL,'2023-11-15 14:30:57','2023-11-15 14:30:57'),(2925,'default','added',1583,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":30718}}',NULL,'2023-11-16 05:06:35','2023-11-16 05:06:35'),(2926,'default','added',739,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-16 05:08:31','2023-11-16 05:08:31'),(2927,'default','edited',1583,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":30718},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"30718.0000\"}}',NULL,'2023-11-16 05:09:00','2023-11-16 05:09:00'),(2928,'default','added',1584,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2050}}',NULL,'2023-11-16 05:43:10','2023-11-16 05:43:10'),(2929,'default','edited',1582,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2050.0000\"}}',NULL,'2023-11-16 05:46:32','2023-11-16 05:46:32'),(2930,'default','added',1585,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":600}}',NULL,'2023-11-16 05:52:43','2023-11-16 05:52:43'),(2931,'default','edited',1576,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"14350.0000\"}}',NULL,'2023-11-16 06:40:29','2023-11-16 06:40:29'),(2932,'default','added',1586,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6548}}',NULL,'2023-11-16 06:49:39','2023-11-16 06:49:39'),(2933,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-16 07:01:35','2023-11-16 07:01:35'),(2934,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-16 07:03:14','2023-11-16 07:03:14'),(2935,'default','added',1587,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900}}',NULL,'2023-11-16 08:41:20','2023-11-16 08:41:20'),(2936,'default','added',1588,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2430}}',NULL,'2023-11-16 08:42:48','2023-11-16 08:42:48'),(2937,'default','added',1589,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2150}}',NULL,'2023-11-16 09:54:50','2023-11-16 09:54:50'),(2938,'default','added',740,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-16 11:28:22','2023-11-16 11:28:22'),(2939,'default','added',1590,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3800}}',NULL,'2023-11-16 11:28:53','2023-11-16 11:28:53'),(2940,'default','added',1591,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":950}}',NULL,'2023-11-16 12:02:41','2023-11-16 12:02:41'),(2941,'default','added',1592,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4500}}',NULL,'2023-11-16 12:13:19','2023-11-16 12:13:19'),(2942,'default','edited',1592,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4500.0000\"}}',NULL,'2023-11-16 13:25:44','2023-11-16 13:25:44'),(2943,'default','payment_edited',1574,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-11-16 13:36:12','2023-11-16 13:36:12'),(2944,'default','edited',1589,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2150.0000\"}}',NULL,'2023-11-16 13:50:24','2023-11-16 13:50:24'),(2945,'default','added',1593,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900}}',NULL,'2023-11-16 15:10:34','2023-11-16 15:10:34'),(2946,'default','added',1594,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":650}}',NULL,'2023-11-16 15:11:11','2023-11-16 15:11:11'),(2947,'default','payment_edited',1499,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"900.0000\"}}',NULL,'2023-11-16 15:37:55','2023-11-16 15:37:55'),(2948,'default','payment_edited',1447,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"900.0000\"}}',NULL,'2023-11-16 15:38:10','2023-11-16 15:38:10'),(2949,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-18 05:16:58','2023-11-18 05:16:58'),(2950,'default','added',1595,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-11-18 05:18:19','2023-11-18 05:18:19'),(2951,'default','sell_deleted',1505,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1505,\"invoice_no\":\"ITH2023-11880\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-18 05:21:02','2023-11-18 05:21:02'),(2952,'default','payment_edited',1279,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"3360.0000\"},\"old\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"due\",\"final_total\":\"3360.0000\"}}',NULL,'2023-11-18 05:27:20','2023-11-18 05:27:20'),(2953,'default','purchase_deleted',1279,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"purchase\",\"status\":\"received\",\"payment_status\":\"paid\",\"final_total\":\"3360.0000\"}}',NULL,'2023-11-18 05:33:40','2023-11-18 05:33:40'),(2954,'default','added',1597,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300}}',NULL,'2023-11-18 05:58:21','2023-11-18 05:58:21'),(2955,'default','payment_edited',1595,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-11-18 07:57:00','2023-11-18 07:57:00'),(2956,'default','edited',1447,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"}}',NULL,'2023-11-18 08:56:33','2023-11-18 08:56:33'),(2957,'default','payment_edited',1587,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"900.0000\"}}',NULL,'2023-11-18 08:56:55','2023-11-18 08:56:55'),(2958,'default','added',1598,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-11-18 09:50:14','2023-11-18 09:50:14'),(2959,'default','added',1600,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":28800}}',NULL,'2023-11-18 12:38:21','2023-11-18 12:38:21'),(2960,'default','edited',1600,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":29520},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"28800.0000\"}}',NULL,'2023-11-18 12:39:04','2023-11-18 12:39:04'),(2961,'default','added',1601,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":41720}}',NULL,'2023-11-18 13:00:47','2023-11-18 13:00:47'),(2962,'default','added',1605,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":78000}}',NULL,'2023-11-18 17:28:26','2023-11-18 17:28:26'),(2963,'default','payment_edited',1605,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"78000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"78000.0000\"}}',NULL,'2023-11-18 17:31:19','2023-11-18 17:31:19'),(2964,'default','edited',1560,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3050},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"}}',NULL,'2023-11-19 05:32:25','2023-11-19 05:32:25'),(2965,'default','payment_edited',712,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6300.0000\"}}',NULL,'2023-11-19 05:35:17','2023-11-19 05:35:17'),(2966,'default','payment_edited',1592,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3400.0000\"}}',NULL,'2023-11-19 05:35:17','2023-11-19 05:35:17'),(2967,'default','payment_edited',1598,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-11-19 05:35:17','2023-11-19 05:35:17'),(2968,'default','added',1607,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400}}',NULL,'2023-11-19 05:39:24','2023-11-19 05:39:24'),(2969,'default','added',1609,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5000}}',NULL,'2023-11-19 05:48:50','2023-11-19 05:48:50'),(2970,'default','added',1610,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2595}}',NULL,'2023-11-19 06:03:09','2023-11-19 06:03:09'),(2971,'default','edited',1610,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3195},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2595.0000\"}}',NULL,'2023-11-19 06:04:12','2023-11-19 06:04:12'),(2972,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-11-19 06:58:49','2023-11-19 06:58:49'),(2973,'default','payment_edited',1498,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8700.0000\"}}',NULL,'2023-11-19 07:10:03','2023-11-19 07:10:03'),(2974,'default','payment_edited',1513,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2023-11-19 07:10:03','2023-11-19 07:10:03'),(2975,'default','payment_edited',1581,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1950.0000\"}}',NULL,'2023-11-19 07:10:03','2023-11-19 07:10:03'),(2976,'default','payment_edited',1607,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"400.0000\"}}',NULL,'2023-11-19 07:10:03','2023-11-19 07:10:03'),(2977,'default','payment_edited',1594,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"650.0000\"}}',NULL,'2023-11-19 07:10:03','2023-11-19 07:10:03'),(2978,'default','added',1611,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250}}',NULL,'2023-11-19 07:37:09','2023-11-19 07:37:09'),(2979,'default','added',741,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-19 08:05:57','2023-11-19 08:05:57'),(2980,'default','added',1613,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-19 08:07:58','2023-11-19 08:07:58'),(2981,'default','added',1614,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2150}}',NULL,'2023-11-19 08:23:57','2023-11-19 08:23:57'),(2982,'default','payment_edited',1611,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2023-11-19 09:09:28','2023-11-19 09:09:28'),(2983,'default','payment_edited',1614,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2150.0000\"}}',NULL,'2023-11-19 09:09:28','2023-11-19 09:09:28'),(2984,'default','edited',1576,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":33068},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"18750.0000\"}}',NULL,'2023-11-19 10:09:07','2023-11-19 10:09:07'),(2985,'default','sell_deleted',1586,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1586,\"invoice_no\":\"ITH2023-11950\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6548.0000\"}}',NULL,'2023-11-19 10:10:04','2023-11-19 10:10:04'),(2986,'default','edited',1576,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":33068},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"33068.0000\"}}',NULL,'2023-11-19 10:19:40','2023-11-19 10:19:40'),(2987,'default','added',1615,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":750}}',NULL,'2023-11-19 10:55:38','2023-11-19 10:55:38'),(2988,'default','payment_edited',516,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"34362.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"34362.0000\"}}',NULL,'2023-11-19 15:06:39','2023-11-19 15:06:39'),(2989,'default','added',1616,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2023-11-20 05:23:20','2023-11-20 05:23:20'),(2990,'default','edited',1576,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":34068},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"33068.0000\"}}',NULL,'2023-11-20 05:50:07','2023-11-20 05:50:07'),(2991,'default','added',1617,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3500}}',NULL,'2023-11-20 07:19:04','2023-11-20 07:19:04'),(2992,'default','added',1618,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1600}}',NULL,'2023-11-20 09:37:44','2023-11-20 09:37:44'),(2993,'default','edited',1617,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3500.0000\"}}',NULL,'2023-11-20 09:40:42','2023-11-20 09:40:42'),(2994,'default','payment_edited',1580,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4700.0000\"}}',NULL,'2023-11-20 09:41:59','2023-11-20 09:41:59'),(2995,'default','payment_edited',1552,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2100.0000\"}}',NULL,'2023-11-20 09:43:04','2023-11-20 09:43:04'),(2996,'default','added',1619,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":7500}}',NULL,'2023-11-20 09:48:31','2023-11-20 09:48:31'),(2997,'default','added',1620,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3050}}',NULL,'2023-11-20 11:17:21','2023-11-20 11:17:21'),(2998,'default','added',1621,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":100}}',NULL,'2023-11-20 11:21:53','2023-11-20 11:21:53'),(2999,'default','added',1622,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1050}}',NULL,'2023-11-20 11:22:39','2023-11-20 11:22:39'),(3000,'default','payment_edited',1535,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2023-11-20 14:47:55','2023-11-20 14:47:55'),(3001,'default','edited',1610,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3195.0000\"}}',NULL,'2023-11-20 15:21:14','2023-11-20 15:21:14'),(3002,'default','sell_deleted',1483,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1483,\"invoice_no\":\"ITH2023-11864\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"600.0000\"}}',NULL,'2023-11-20 15:37:29','2023-11-20 15:37:29'),(3003,'default','payment_edited',1622,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1050.0000\"}}',NULL,'2023-11-20 15:39:18','2023-11-20 15:39:18'),(3004,'default','edited',1620,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3050.0000\"}}',NULL,'2023-11-21 06:47:00','2023-11-21 06:47:00'),(3005,'default','payment_edited',1614,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2150.0000\"}}',NULL,'2023-11-21 06:49:11','2023-11-21 06:49:11'),(3006,'default','payment_edited',1620,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3700.0000\"}}',NULL,'2023-11-21 06:49:11','2023-11-21 06:49:11'),(3007,'default','edited',1617,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4900.0000\"}}',NULL,'2023-11-21 06:57:00','2023-11-21 06:57:00'),(3008,'default','added',1623,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":100}}',NULL,'2023-11-21 08:22:34','2023-11-21 08:22:34'),(3009,'default','edited',1619,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":5300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7500.0000\"}}',NULL,'2023-11-21 08:42:34','2023-11-21 08:42:34'),(3010,'default','payment_edited',1619,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5300.0000\"}}',NULL,'2023-11-21 08:42:50','2023-11-21 08:42:50'),(3011,'default','payment_edited',1580,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4700.0000\"}}',NULL,'2023-11-21 08:43:23','2023-11-21 08:43:23'),(3012,'default','payment_edited',1573,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"800.0000\"}}',NULL,'2023-11-21 08:44:31','2023-11-21 08:44:31'),(3013,'default','payment_edited',832,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2130.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2130.0000\"}}',NULL,'2023-11-21 08:44:31','2023-11-21 08:44:31'),(3014,'default','payment_edited',1456,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"76000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"76000.0000\"}}',NULL,'2023-11-21 08:48:58','2023-11-21 08:48:58'),(3015,'default','payment_edited',1428,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"35990.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"35990.0000\"}}',NULL,'2023-11-21 08:49:10','2023-11-21 08:49:10'),(3016,'default','added',742,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-21 09:37:56','2023-11-21 09:37:56'),(3017,'default','added',1624,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-11-21 09:39:09','2023-11-21 09:39:09'),(3018,'default','edited',1624,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1350.0000\"}}',NULL,'2023-11-21 09:39:25','2023-11-21 09:39:25'),(3019,'default','added',1625,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-11-21 10:27:48','2023-11-21 10:27:48'),(3020,'default','added',1626,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1350}}',NULL,'2023-11-21 11:03:19','2023-11-21 11:03:19'),(3021,'default','payment_edited',1588,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2430.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2430.0000\"}}',NULL,'2023-11-21 11:48:22','2023-11-21 11:48:22'),(3022,'default','edited',1626,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2225},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1350.0000\"}}',NULL,'2023-11-21 12:53:56','2023-11-21 12:53:56'),(3023,'default','added',743,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-21 15:11:00','2023-11-21 15:11:00'),(3024,'default','added',1627,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2023-11-21 15:12:27','2023-11-21 15:12:27'),(3025,'default','edited',1626,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2225},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2225.0000\"}}',NULL,'2023-11-21 16:47:37','2023-11-21 16:47:37'),(3026,'default','added',1629,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":200}}',NULL,'2023-11-22 06:24:04','2023-11-22 06:24:04'),(3027,'default','payment_edited',1629,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"200.0000\"}}',NULL,'2023-11-22 06:27:12','2023-11-22 06:27:12'),(3028,'default','added',744,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-22 07:00:18','2023-11-22 07:00:18'),(3029,'default','added',1630,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7500}}',NULL,'2023-11-22 07:01:54','2023-11-22 07:01:54'),(3030,'default','edited',1626,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2225.0000\"}}',NULL,'2023-11-22 07:03:55','2023-11-22 07:03:55'),(3031,'default','edited',1576,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":36668},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"34068.0000\"}}',NULL,'2023-11-22 07:21:00','2023-11-22 07:21:00'),(3032,'default','added',1631,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2023-11-22 08:11:06','2023-11-22 08:11:06'),(3033,'default','added',745,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-22 11:06:29','2023-11-22 11:06:29'),(3034,'default','added',1632,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1250}}',NULL,'2023-11-22 11:06:54','2023-11-22 11:06:54'),(3035,'default','added',746,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-22 11:19:39','2023-11-22 11:19:39'),(3036,'default','added',1633,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-22 11:19:59','2023-11-22 11:19:59'),(3037,'default','payment_edited',1627,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2023-11-22 13:12:11','2023-11-22 13:12:11'),(3038,'default','added',747,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-22 14:17:53','2023-11-22 14:17:53'),(3039,'default','added',1634,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-11-22 14:21:01','2023-11-22 14:21:01'),(3040,'default','edited',1634,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-11-22 14:23:07','2023-11-22 14:23:07'),(3041,'default','added',748,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-22 14:36:57','2023-11-22 14:36:57'),(3042,'default','added',1635,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-22 14:37:27','2023-11-22 14:37:27'),(3043,'default','edited',1635,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1450},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"}}',NULL,'2023-11-22 14:38:28','2023-11-22 14:38:28'),(3044,'default','added',1636,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2360}}',NULL,'2023-11-22 14:52:46','2023-11-22 14:52:46'),(3045,'default','edited',1636,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2360},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2360.0000\"}}',NULL,'2023-11-22 14:53:13','2023-11-22 14:53:13'),(3046,'default','added',749,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-23 08:17:17','2023-11-23 08:17:17'),(3047,'default','added',1637,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300}}',NULL,'2023-11-23 08:37:10','2023-11-23 08:37:10'),(3048,'default','edited',1637,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-11-23 08:38:31','2023-11-23 08:38:31'),(3049,'default','edited',1637,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-11-23 08:39:46','2023-11-23 08:39:46'),(3050,'default','added',1638,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3}}',NULL,'2023-11-23 11:14:23','2023-11-23 11:14:23'),(3051,'default','added',1639,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4}}',NULL,'2023-11-23 11:23:19','2023-11-23 11:23:19'),(3052,'default','edited',1638,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3.0000\"}}',NULL,'2023-11-23 11:23:40','2023-11-23 11:23:40'),(3053,'default','edited',1639,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4.0000\"}}',NULL,'2023-11-23 11:35:44','2023-11-23 11:35:44'),(3054,'default','edited',1638,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3.0000\"}}',NULL,'2023-11-23 11:36:22','2023-11-23 11:36:22'),(3055,'default','edited',1639,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4.0000\"}}',NULL,'2023-11-23 11:38:34','2023-11-23 11:38:34'),(3056,'default','added',750,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-23 11:42:09','2023-11-23 11:42:09'),(3057,'default','added',1640,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500}}',NULL,'2023-11-23 11:43:28','2023-11-23 11:43:28'),(3058,'default','added',1641,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":360}}',NULL,'2023-11-23 12:23:16','2023-11-23 12:23:16'),(3059,'default','payment_edited',1582,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4100.0000\"}}',NULL,'2023-11-23 12:33:54','2023-11-23 12:33:54'),(3060,'default','payment_edited',1584,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2050.0000\"}}',NULL,'2023-11-23 12:33:54','2023-11-23 12:33:54'),(3061,'default','edited',1636,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2860},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2360.0000\"}}',NULL,'2023-11-23 12:34:27','2023-11-23 12:34:27'),(3062,'default','payment_edited',1626,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1750.0000\"}}',NULL,'2023-11-23 16:09:29','2023-11-23 16:09:29'),(3063,'default','payment_edited',1598,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3100.0000\"}}',NULL,'2023-11-23 17:03:06','2023-11-23 17:03:06'),(3064,'default','payment_edited',1636,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2860.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2860.0000\"}}',NULL,'2023-11-23 17:03:06','2023-11-23 17:03:06'),(3065,'default','payment_edited',832,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2130.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2130.0000\"}}',NULL,'2023-11-23 17:13:09','2023-11-23 17:13:09'),(3066,'default','payment_edited',842,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"130.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"130.0000\"}}',NULL,'2023-11-23 17:13:09','2023-11-23 17:13:09'),(3067,'default','payment_edited',965,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-11-23 17:13:09','2023-11-23 17:13:09'),(3068,'default','payment_edited',968,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1550.0000\"}}',NULL,'2023-11-23 17:13:09','2023-11-23 17:13:09'),(3069,'default','payment_edited',1008,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"240.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"240.0000\"}}',NULL,'2023-11-23 17:13:09','2023-11-23 17:13:09'),(3070,'default','payment_edited',1011,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3300.0000\"}}',NULL,'2023-11-23 17:13:09','2023-11-23 17:13:09'),(3071,'default','payment_edited',1011,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3300.0000\"}}',NULL,'2023-11-23 17:13:44','2023-11-23 17:13:44'),(3072,'default','payment_edited',1091,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}',NULL,'2023-11-23 17:13:44','2023-11-23 17:13:44'),(3073,'default','payment_edited',1113,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"400.0000\"}}',NULL,'2023-11-23 17:13:44','2023-11-23 17:13:44'),(3074,'default','payment_edited',1487,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"370.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"370.0000\"}}',NULL,'2023-11-23 17:13:44','2023-11-23 17:13:44'),(3075,'default','payment_edited',1467,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"200.0000\"}}',NULL,'2023-11-23 17:13:44','2023-11-23 17:13:44'),(3076,'default','payment_edited',1467,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"200.0000\"}}',NULL,'2023-11-23 17:14:08','2023-11-23 17:14:08'),(3077,'default','payment_edited',1477,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-11-23 17:14:08','2023-11-23 17:14:08'),(3078,'default','payment_edited',1517,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"750.0000\"}}',NULL,'2023-11-23 17:14:08','2023-11-23 17:14:08'),(3079,'default','added',1642,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":800}}',NULL,'2023-11-23 17:22:22','2023-11-23 17:22:22'),(3080,'default','edited',1637,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-11-23 17:23:36','2023-11-23 17:23:36'),(3081,'default','added',1643,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-11-25 06:14:44','2023-11-25 06:14:44'),(3082,'default','added',1644,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2100}}',NULL,'2023-11-25 07:05:09','2023-11-25 07:05:09'),(3083,'default','edited',1644,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2100.0000\"}}',NULL,'2023-11-25 07:05:55','2023-11-25 07:05:55'),(3084,'default','added',751,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-25 07:52:55','2023-11-25 07:52:55'),(3085,'default','added',1645,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2213}}',NULL,'2023-11-25 07:55:56','2023-11-25 07:55:56'),(3086,'default','added',752,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-25 09:08:49','2023-11-25 09:08:49'),(3087,'default','added',1646,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12000}}',NULL,'2023-11-25 09:16:56','2023-11-25 09:16:56'),(3088,'default','added',1647,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":20}}',NULL,'2023-11-25 09:49:43','2023-11-25 09:49:43'),(3089,'default','added',1648,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2300}}',NULL,'2023-11-25 12:19:09','2023-11-25 12:19:09'),(3090,'default','added',1649,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-11-25 14:25:17','2023-11-25 14:25:17'),(3091,'default','added',1651,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-11-25 14:26:59','2023-11-25 14:26:59'),(3092,'default','added',753,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-25 14:55:22','2023-11-25 14:55:22'),(3093,'default','added',1652,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}',NULL,'2023-11-25 14:55:57','2023-11-25 14:55:57'),(3094,'default','added',1653,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-11-26 09:00:56','2023-11-26 09:00:56'),(3095,'default','payment_edited',1597,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-11-26 09:01:07','2023-11-26 09:01:07'),(3096,'default','payment_edited',1119,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"800.0000\"}}',NULL,'2023-11-26 09:02:32','2023-11-26 09:02:32'),(3097,'default','added',1654,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1100}}',NULL,'2023-11-26 09:03:18','2023-11-26 09:03:18'),(3098,'default','added',754,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-26 13:20:17','2023-11-26 13:20:17'),(3099,'default','added',1655,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2950}}',NULL,'2023-11-26 13:21:00','2023-11-26 13:21:00'),(3100,'default','edited',1647,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":540},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"20.0000\"}}',NULL,'2023-11-26 13:38:10','2023-11-26 13:38:10'),(3101,'default','added',1656,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":200}}',NULL,'2023-11-26 15:57:51','2023-11-26 15:57:51'),(3102,'default','edited',1396,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-11-27 07:08:39','2023-11-27 07:08:39'),(3103,'default','added',1657,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":460}}',NULL,'2023-11-27 07:09:16','2023-11-27 07:09:16'),(3104,'default','sell_deleted',1656,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1656,\"invoice_no\":\"ITH2023-12008\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"200.0000\"}}',NULL,'2023-11-27 09:01:24','2023-11-27 09:01:24'),(3105,'default','added',1658,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3500}}',NULL,'2023-11-27 09:03:24','2023-11-27 09:03:24'),(3106,'default','added',755,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-27 10:57:22','2023-11-27 10:57:22'),(3107,'default','edited',755,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-27 10:58:29','2023-11-27 10:58:29'),(3108,'default','payment_edited',1658,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3500.0000\"}}',NULL,'2023-11-27 11:10:24','2023-11-27 11:10:24'),(3109,'default','added',1659,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":43820}}',NULL,'2023-11-27 11:15:00','2023-11-27 11:15:00'),(3110,'default','added',1661,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":59322}}',NULL,'2023-11-27 11:26:56','2023-11-27 11:26:56'),(3111,'default','edited',1661,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":59324},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"59322.0000\"}}',NULL,'2023-11-27 11:29:28','2023-11-27 11:29:28'),(3112,'default','edited',1659,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":42034},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"43820.0000\"}}',NULL,'2023-11-27 11:29:34','2023-11-27 11:29:34'),(3113,'default','added',1662,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":5950}}',NULL,'2023-11-27 11:32:21','2023-11-27 11:32:21'),(3114,'default','added',1664,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":530}}',NULL,'2023-11-27 11:44:24','2023-11-27 11:44:24'),(3115,'default','added',756,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-28 14:07:40','2023-11-28 14:07:40'),(3116,'default','added',1666,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":13000}}',NULL,'2023-11-28 14:11:37','2023-11-28 14:11:37'),(3117,'default','added',1667,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2870}}',NULL,'2023-11-28 14:14:08','2023-11-28 14:14:08'),(3118,'default','payment_edited',1605,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"78000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"78000.0000\"}}',NULL,'2023-11-28 14:39:32','2023-11-28 14:39:32'),(3119,'default','payment_edited',1321,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"32810.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"32810.0000\"}}',NULL,'2023-11-28 14:40:09','2023-11-28 14:40:09'),(3120,'default','payment_edited',1054,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1100.0000\"}}',NULL,'2023-11-28 14:41:24','2023-11-28 14:41:24'),(3121,'default','payment_edited',1115,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-11-28 14:42:10','2023-11-28 14:42:10'),(3122,'default','edited',1576,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":36488},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"36668.0000\"}}',NULL,'2023-11-28 15:24:10','2023-11-28 15:24:10'),(3123,'default','added',1668,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":49844}}',NULL,'2023-11-29 06:22:21','2023-11-29 06:22:21'),(3124,'default','edited',1662,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5950},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"5950.0000\"}}',NULL,'2023-11-29 06:23:19','2023-11-29 06:23:19'),(3125,'default','edited',1657,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":586},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"460.0000\"}}',NULL,'2023-11-29 06:25:21','2023-11-29 06:25:21'),(3126,'default','edited',1662,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5950.0000\"}}',NULL,'2023-11-29 06:26:15','2023-11-29 06:26:15'),(3127,'default','payment_edited',1536,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"16500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"16500.0000\"}}',NULL,'2023-11-29 11:11:56','2023-11-29 11:11:56'),(3128,'default','payment_edited',1579,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1000.0000\"}}',NULL,'2023-11-29 11:11:56','2023-11-29 11:11:56'),(3129,'default','added',1669,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3050}}',NULL,'2023-11-29 12:00:39','2023-11-29 12:00:39'),(3130,'default','added',757,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-30 06:52:05','2023-11-30 06:52:05'),(3131,'default','added',1670,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300}}',NULL,'2023-11-30 07:01:44','2023-11-30 07:01:44'),(3132,'default','added',1672,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7800}}',NULL,'2023-11-30 07:07:22','2023-11-30 07:07:22'),(3133,'default','payment_edited',1517,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"750.0000\"}}',NULL,'2023-11-30 09:37:15','2023-11-30 09:37:15'),(3134,'default','payment_edited',1534,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5600.0000\"}}',NULL,'2023-11-30 09:37:15','2023-11-30 09:37:15'),(3135,'default','payment_edited',1540,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"476.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"476.0000\"}}',NULL,'2023-11-30 09:37:15','2023-11-30 09:37:15'),(3136,'default','payment_edited',1545,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}',NULL,'2023-11-30 09:37:15','2023-11-30 09:37:15'),(3137,'default','payment_edited',1547,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5050.0000\"}}',NULL,'2023-11-30 09:37:15','2023-11-30 09:37:15'),(3138,'default','added',1673,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-11-30 10:30:46','2023-11-30 10:30:46'),(3139,'default','added',758,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-11-30 11:14:47','2023-11-30 11:14:47'),(3140,'default','added',1674,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1600}}',NULL,'2023-11-30 11:16:02','2023-11-30 11:16:02'),(3141,'default','payment_edited',1497,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1350.0000\"}}',NULL,'2023-11-30 12:16:28','2023-11-30 12:16:28'),(3142,'default','payment_edited',1570,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5200.0000\"}}',NULL,'2023-11-30 15:33:46','2023-11-30 15:33:46'),(3143,'default','payment_edited',1504,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"450.0000\"}}',NULL,'2023-11-30 15:34:50','2023-11-30 15:34:50'),(3144,'default','payment_edited',1673,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-11-30 15:34:50','2023-11-30 15:34:50'),(3145,'default','payment_edited',1670,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3300.0000\"}}',NULL,'2023-11-30 15:38:03','2023-11-30 15:38:03'),(3146,'default','payment_edited',1132,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5100.0000\"}}',NULL,'2023-11-30 16:22:47','2023-11-30 16:22:47'),(3147,'default','added',1675,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2050}}',NULL,'2023-11-30 16:32:46','2023-11-30 16:32:46'),(3148,'default','payment_edited',1106,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2500.0000\"}}',NULL,'2023-12-01 14:15:48','2023-12-01 14:15:48'),(3149,'default','added',1676,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-02 05:22:37','2023-12-02 05:22:37'),(3150,'default','added',1677,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":880}}',NULL,'2023-12-02 06:35:10','2023-12-02 06:35:10'),(3151,'default','added',1678,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":200}}',NULL,'2023-12-02 07:10:05','2023-12-02 07:10:05'),(3152,'default','added',759,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-02 08:49:07','2023-12-02 08:49:07'),(3153,'default','added',1679,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-02 08:49:52','2023-12-02 08:49:52'),(3154,'default','added',1680,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1100}}',NULL,'2023-12-02 10:45:51','2023-12-02 10:45:51'),(3155,'default','added',1681,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2300}}',NULL,'2023-12-02 12:48:04','2023-12-02 12:48:04'),(3156,'default','payment_edited',732,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"450.0000\"}}',NULL,'2023-12-02 13:45:39','2023-12-02 13:45:39'),(3157,'default','payment_edited',953,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1150.0000\"}}',NULL,'2023-12-02 13:45:39','2023-12-02 13:45:39'),(3158,'default','payment_edited',956,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4800.0000\"}}',NULL,'2023-12-02 13:45:39','2023-12-02 13:45:39'),(3159,'default','added',1682,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":720}}',NULL,'2023-12-03 04:56:25','2023-12-03 04:56:25'),(3160,'default','edited',1682,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1395},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"720.0000\"}}',NULL,'2023-12-03 04:59:16','2023-12-03 04:59:16'),(3161,'default','edited',1682,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2115},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1395.0000\"}}',NULL,'2023-12-03 05:31:23','2023-12-03 05:31:23'),(3162,'default','added',1683,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2023-12-03 05:44:28','2023-12-03 05:44:28'),(3163,'default','added',1684,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-12-03 07:20:43','2023-12-03 07:20:43'),(3164,'default','added',1686,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5200}}',NULL,'2023-12-03 07:24:31','2023-12-03 07:24:31'),(3165,'default','added',760,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-03 09:26:48','2023-12-03 09:26:48'),(3166,'default','added',1687,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3050}}',NULL,'2023-12-03 09:27:29','2023-12-03 09:27:29'),(3167,'default','added',1688,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2023-12-03 11:19:09','2023-12-03 11:19:09'),(3168,'default','added',761,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-03 13:13:13','2023-12-03 13:13:13'),(3169,'default','added',1690,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":15650}}',NULL,'2023-12-03 13:16:36','2023-12-03 13:16:36'),(3170,'default','added',1691,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":9770}}',NULL,'2023-12-03 13:20:21','2023-12-03 13:20:21'),(3171,'default','edited',1691,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":10070},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"9770.0000\"}}',NULL,'2023-12-03 13:35:07','2023-12-03 13:35:07'),(3172,'default','edited',1691,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":10070},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"10070.0000\"}}',NULL,'2023-12-03 13:37:07','2023-12-03 13:37:07'),(3173,'default','payment_edited',1437,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-12-03 15:49:21','2023-12-03 15:49:21'),(3174,'default','payment_edited',1547,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5050.0000\"}}',NULL,'2023-12-03 16:02:02','2023-12-03 16:02:02'),(3175,'default','added',762,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-03 17:41:58','2023-12-03 17:41:58'),(3176,'default','added',1692,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-03 17:42:55','2023-12-03 17:42:55'),(3177,'default','edited',1692,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"}}',NULL,'2023-12-03 17:43:19','2023-12-03 17:43:19'),(3178,'default','payment_edited',1576,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"36488.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"36488.0000\"}}',NULL,'2023-12-04 05:56:01','2023-12-04 05:56:01'),(3179,'default','added',1693,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700}}',NULL,'2023-12-04 06:04:43','2023-12-04 06:04:43'),(3180,'default','edited',1693,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"700.0000\"}}',NULL,'2023-12-04 06:04:57','2023-12-04 06:04:57'),(3181,'default','payment_edited',1570,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5200.0000\"}}',NULL,'2023-12-04 06:05:49','2023-12-04 06:05:49'),(3182,'default','payment_edited',1571,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1000.0000\"}}',NULL,'2023-12-04 06:05:49','2023-12-04 06:05:49'),(3183,'default','payment_edited',1615,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"750.0000\"}}',NULL,'2023-12-04 06:05:49','2023-12-04 06:05:49'),(3184,'default','payment_edited',1677,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"880.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"880.0000\"}}',NULL,'2023-12-04 06:05:49','2023-12-04 06:05:49'),(3185,'default','payment_edited',1684,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-12-04 06:05:49','2023-12-04 06:05:49'),(3186,'default','added',1694,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-12-04 06:08:44','2023-12-04 06:08:44'),(3187,'default','added',763,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-04 07:39:21','2023-12-04 07:39:21'),(3188,'default','payment_edited',1686,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5200.0000\"}}',NULL,'2023-12-04 08:24:32','2023-12-04 08:24:32'),(3189,'default','added',1696,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2050}}',NULL,'2023-12-04 09:27:32','2023-12-04 09:27:32'),(3190,'default','added',1698,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-12-04 09:31:35','2023-12-04 09:31:35'),(3191,'default','edited',1696,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2150},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2050.0000\"}}',NULL,'2023-12-04 10:16:36','2023-12-04 10:16:36'),(3192,'default','added',1699,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":9550}}',NULL,'2023-12-04 10:55:55','2023-12-04 10:55:55'),(3193,'default','added',1700,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13950}}',NULL,'2023-12-04 11:25:37','2023-12-04 11:25:37'),(3194,'default','added',764,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-04 11:44:26','2023-12-04 11:44:26'),(3195,'default','added',1701,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-12-04 11:44:58','2023-12-04 11:44:58'),(3196,'default','payment_edited',1701,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-12-04 12:31:04','2023-12-04 12:31:04'),(3197,'default','edited',1700,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":20800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13950.0000\"}}',NULL,'2023-12-04 12:54:01','2023-12-04 12:54:01'),(3198,'default','added',1703,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":460}}',NULL,'2023-12-04 13:41:24','2023-12-04 13:41:24'),(3199,'default','sell_deleted',1699,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1699,\"invoice_no\":\"ITH2023-12040\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"9550.0000\"}}',NULL,'2023-12-04 13:44:29','2023-12-04 13:44:29'),(3200,'default','payment_edited',1681,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2300.0000\"}}',NULL,'2023-12-04 13:48:43','2023-12-04 13:48:43'),(3201,'default','edited',1682,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1280},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2115.0000\"}}',NULL,'2023-12-04 13:54:59','2023-12-04 13:54:59'),(3202,'default','added',765,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-04 13:57:19','2023-12-04 13:57:19'),(3203,'default','added',1704,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":28100}}',NULL,'2023-12-04 14:04:31','2023-12-04 14:04:31'),(3204,'default','added',1706,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-04 14:55:33','2023-12-04 14:55:33'),(3205,'default','added',766,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-04 14:56:11','2023-12-04 14:56:11'),(3206,'default','edited',1706,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"}}',NULL,'2023-12-04 14:56:14','2023-12-04 14:56:14'),(3207,'default','edited',1696,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2850},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2150.0000\"}}',NULL,'2023-12-04 15:02:50','2023-12-04 15:02:50'),(3208,'default','edited',1680,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":990},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1100.0000\"}}',NULL,'2023-12-04 15:09:28','2023-12-04 15:09:28'),(3209,'default','edited',1669,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3050.0000\"}}',NULL,'2023-12-04 15:11:50','2023-12-04 15:11:50'),(3210,'default','payment_edited',1680,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"990.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"990.0000\"}}',NULL,'2023-12-04 15:12:20','2023-12-04 15:12:20'),(3211,'default','payment_edited',1669,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-12-04 15:12:38','2023-12-04 15:12:38'),(3212,'default','payment_edited',1640,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2500.0000\"}}',NULL,'2023-12-04 15:12:52','2023-12-04 15:12:52'),(3213,'default','edited',1700,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":20700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"20800.0000\"}}',NULL,'2023-12-04 16:11:32','2023-12-04 16:11:32'),(3214,'default','payment_edited',1700,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"20700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"20700.0000\"}}',NULL,'2023-12-04 16:13:16','2023-12-04 16:13:16'),(3215,'default','payment_edited',1567,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"240.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"240.0000\"}}',NULL,'2023-12-04 16:13:55','2023-12-04 16:13:55'),(3216,'default','payment_edited',1320,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2800.0000\"}}',NULL,'2023-12-04 16:14:13','2023-12-04 16:14:13'),(3217,'default','added',1707,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-05 06:03:01','2023-12-05 06:03:01'),(3218,'default','added',1708,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4050}}',NULL,'2023-12-05 07:00:41','2023-12-05 07:00:41'),(3219,'default','added',767,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-05 07:49:59','2023-12-05 07:49:59'),(3220,'default','added',1709,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3100}}',NULL,'2023-12-05 07:51:04','2023-12-05 07:51:04'),(3221,'default','added',1710,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":200}}',NULL,'2023-12-05 07:54:08','2023-12-05 07:54:08'),(3222,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-12-05 12:16:57','2023-12-05 12:16:57'),(3223,'default','sell_deleted',1710,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1710,\"invoice_no\":\"ITH2023-12048\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"200.0000\"}}',NULL,'2023-12-05 15:30:22','2023-12-05 15:30:22'),(3224,'default','edited',1708,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4050.0000\"}}',NULL,'2023-12-05 15:30:53','2023-12-05 15:30:53'),(3225,'default','added',1711,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2023-12-05 15:41:21','2023-12-05 15:41:21'),(3226,'default','added',1712,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4400}}',NULL,'2023-12-05 15:54:22','2023-12-05 15:54:22'),(3227,'default','edited',1711,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"}}',NULL,'2023-12-05 15:54:51','2023-12-05 15:54:51'),(3228,'default','added',1713,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":850}}',NULL,'2023-12-05 15:55:26','2023-12-05 15:55:26'),(3229,'default','sell_deleted',1688,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1688,\"invoice_no\":\"ITH2023-12033\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2023-12-05 16:23:39','2023-12-05 16:23:39'),(3230,'default','added',1714,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8100}}',NULL,'2023-12-06 05:57:08','2023-12-06 05:57:08'),(3231,'default','added',768,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-06 06:15:07','2023-12-06 06:15:07'),(3232,'default','added',1715,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2000}}',NULL,'2023-12-06 06:17:08','2023-12-06 06:17:08'),(3233,'default','added',1716,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-12-06 06:19:33','2023-12-06 06:19:33'),(3234,'default','sell_deleted',1460,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1460,\"invoice_no\":\"ITH2023-11841\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"119960.0000\"}}',NULL,'2023-12-06 06:24:57','2023-12-06 06:24:57'),(3235,'default','sell_deleted',1462,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1462,\"invoice_no\":\"ITH2023-11843\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"12510.0000\"}}',NULL,'2023-12-06 06:25:03','2023-12-06 06:25:03'),(3236,'default','payment_edited',1713,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"850.0000\"}}',NULL,'2023-12-06 07:23:11','2023-12-06 07:23:11'),(3237,'default','added',769,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-06 07:23:55','2023-12-06 07:23:55'),(3238,'default','added',1717,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1650}}',NULL,'2023-12-06 07:24:52','2023-12-06 07:24:52'),(3239,'default','added',770,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-06 07:32:53','2023-12-06 07:32:53'),(3240,'default','added',1718,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":22000}}',NULL,'2023-12-06 07:34:22','2023-12-06 07:34:22'),(3241,'default','added',771,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-06 07:58:06','2023-12-06 07:58:06'),(3242,'default','added',1719,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1300}}',NULL,'2023-12-06 07:58:38','2023-12-06 07:58:38'),(3243,'default','added',1720,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2900}}',NULL,'2023-12-06 08:32:13','2023-12-06 08:32:13'),(3244,'default','added',1721,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":46500}}',NULL,'2023-12-06 09:04:35','2023-12-06 09:04:35'),(3245,'default','payment_edited',1610,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5350.0000\"}}',NULL,'2023-12-06 09:20:19','2023-12-06 09:20:19'),(3246,'default','edited',1617,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6000.0000\"}}',NULL,'2023-12-06 09:55:37','2023-12-06 09:55:37'),(3247,'default','edited',1617,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"12800.0000\"}}',NULL,'2023-12-06 10:41:32','2023-12-06 10:41:32'),(3248,'default','added',1722,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1850}}',NULL,'2023-12-06 13:34:20','2023-12-06 13:34:20'),(3249,'default','payment_edited',1716,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2023-12-06 13:35:52','2023-12-06 13:35:52'),(3250,'default','edited',1722,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1850.0000\"}}',NULL,'2023-12-06 13:40:54','2023-12-06 13:40:54'),(3251,'default','sell_deleted',1722,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1722,\"invoice_no\":\"ITH2023-12059\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"750.0000\"}}',NULL,'2023-12-06 16:32:54','2023-12-06 16:32:54'),(3252,'default','payment_edited',1711,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1100.0000\"}}',NULL,'2023-12-06 16:33:06','2023-12-06 16:33:06'),(3253,'default','payment_edited',1547,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5050.0000\"}}',NULL,'2023-12-06 16:35:05','2023-12-06 16:35:05'),(3254,'default','payment_edited',1572,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"600.0000\"}}',NULL,'2023-12-06 16:35:05','2023-12-06 16:35:05'),(3255,'default','payment_edited',1593,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"900.0000\"}}',NULL,'2023-12-06 16:35:05','2023-12-06 16:35:05'),(3256,'default','edited',1617,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":13400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"12800.0000\"}}',NULL,'2023-12-07 06:24:15','2023-12-07 06:24:15'),(3257,'default','added',1723,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":12100}}',NULL,'2023-12-07 06:27:44','2023-12-07 06:27:44'),(3258,'default','added',1724,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":600}}',NULL,'2023-12-07 06:40:30','2023-12-07 06:40:30'),(3259,'default','added',1725,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3025}}',NULL,'2023-12-07 06:54:04','2023-12-07 06:54:04'),(3260,'default','edited',851,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":130000},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"123100.0000\"}}',NULL,'2023-12-07 07:43:56','2023-12-07 07:43:56'),(3261,'default','edited',851,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":130000},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"130000.0000\"}}',NULL,'2023-12-07 07:45:56','2023-12-07 07:45:56'),(3262,'default','added',1726,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4400}}',NULL,'2023-12-07 07:49:08','2023-12-07 07:49:08'),(3263,'default','edited',1725,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3025},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3025.0000\"}}',NULL,'2023-12-07 07:51:45','2023-12-07 07:51:45'),(3264,'default','added',1727,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":18400}}',NULL,'2023-12-07 07:59:15','2023-12-07 07:59:15'),(3265,'default','added',772,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-07 09:45:27','2023-12-07 09:45:27'),(3266,'default','edited',1712,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4400.0000\"}}',NULL,'2023-12-07 09:45:32','2023-12-07 09:45:32'),(3267,'default','payment_edited',1712,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4400.0000\"}}',NULL,'2023-12-07 09:45:47','2023-12-07 09:45:47'),(3268,'default','added',773,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-07 10:21:34','2023-12-07 10:21:34'),(3269,'default','added',1729,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":12000}}',NULL,'2023-12-07 10:25:32','2023-12-07 10:25:32'),(3270,'default','added',1730,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4150}}',NULL,'2023-12-07 10:34:58','2023-12-07 10:34:58'),(3271,'default','added',1731,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-12-07 10:36:44','2023-12-07 10:36:44'),(3272,'default','added',1732,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1250}}',NULL,'2023-12-07 10:40:56','2023-12-07 10:40:56'),(3273,'default','added',1733,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4100}}',NULL,'2023-12-07 11:04:29','2023-12-07 11:04:29'),(3274,'default','edited',1726,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":8500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4400.0000\"}}',NULL,'2023-12-07 11:15:23','2023-12-07 11:15:23'),(3275,'default','added',1734,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3}}',NULL,'2023-12-07 11:26:14','2023-12-07 11:26:14'),(3276,'default','added',1735,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3}}',NULL,'2023-12-07 11:29:20','2023-12-07 11:29:20'),(3277,'default','edited',1726,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":9100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"8500.0000\"}}',NULL,'2023-12-07 11:30:23','2023-12-07 11:30:23'),(3278,'default','added',1736,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2}}',NULL,'2023-12-07 11:31:43','2023-12-07 11:31:43'),(3279,'default','edited',1736,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2.0000\"}}',NULL,'2023-12-07 11:32:13','2023-12-07 11:32:13'),(3280,'default','edited',1726,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":9420},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"9100.0000\"}}',NULL,'2023-12-07 12:22:10','2023-12-07 12:22:10'),(3281,'default','payment_edited',789,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"600.0000\"}}',NULL,'2023-12-07 12:48:33','2023-12-07 12:48:33'),(3282,'default','payment_edited',1718,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"22000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"22000.0000\"}}',NULL,'2023-12-07 13:17:29','2023-12-07 13:17:29'),(3283,'default','added',774,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-09 04:45:33','2023-12-09 04:45:33'),(3284,'default','added',1737,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-12-09 04:46:40','2023-12-09 04:46:40'),(3285,'default','added',1738,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2023-12-09 15:12:38','2023-12-09 15:12:38'),(3286,'default','added',1739,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-12-09 15:13:37','2023-12-09 15:13:37'),(3287,'default','added',1740,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":210}}',NULL,'2023-12-10 06:38:42','2023-12-10 06:38:42'),(3288,'default','added',1741,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":870}}',NULL,'2023-12-10 07:39:13','2023-12-10 07:39:13'),(3289,'default','sell_deleted',1740,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1740,\"invoice_no\":\"ITH2023-12074\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"210.0000\"}}',NULL,'2023-12-10 07:49:39','2023-12-10 07:49:39'),(3290,'default','added',775,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-10 09:08:21','2023-12-10 09:08:21'),(3291,'default','added',1742,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":16822}}',NULL,'2023-12-10 09:31:21','2023-12-10 09:31:21'),(3292,'default','added',1743,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2000}}',NULL,'2023-12-10 09:36:37','2023-12-10 09:36:37'),(3293,'default','edited',1738,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2023-12-10 09:38:57','2023-12-10 09:38:57'),(3294,'default','added',1744,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4975}}',NULL,'2023-12-10 09:52:37','2023-12-10 09:52:37'),(3295,'default','edited',1744,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4975},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4975.0000\"}}',NULL,'2023-12-10 09:53:12','2023-12-10 09:53:12'),(3296,'default','added',1745,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400}}',NULL,'2023-12-10 10:20:12','2023-12-10 10:20:12'),(3297,'default','added',1746,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-12-10 10:49:16','2023-12-10 10:49:16'),(3298,'default','edited',1726,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":9100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"9420.0000\"}}',NULL,'2023-12-10 10:52:39','2023-12-10 10:52:39'),(3299,'default','edited',1691,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":12070},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10070.0000\"}}',NULL,'2023-12-10 10:54:23','2023-12-10 10:54:23'),(3300,'default','payment_edited',1646,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"12000.0000\"}}',NULL,'2023-12-10 11:00:23','2023-12-10 11:00:23'),(3301,'default','payment_edited',1646,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12000.0000\"}}',NULL,'2023-12-10 11:00:39','2023-12-10 11:00:39'),(3302,'default','payment_edited',1691,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"12070.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12070.0000\"}}',NULL,'2023-12-10 11:01:06','2023-12-10 11:01:06'),(3303,'default','payment_edited',1698,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2023-12-10 11:01:26','2023-12-10 11:01:26'),(3304,'default','added',1748,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3000}}',NULL,'2023-12-10 11:22:03','2023-12-10 11:22:03'),(3305,'default','edited',1746,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-12-10 15:28:34','2023-12-10 15:28:34'),(3306,'default','payment_edited',1684,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3100.0000\"}}',NULL,'2023-12-10 15:48:51','2023-12-10 15:48:51'),(3307,'default','payment_edited',1708,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2800.0000\"}}',NULL,'2023-12-10 15:48:51','2023-12-10 15:48:51'),(3308,'default','payment_edited',1725,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3025.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3025.0000\"}}',NULL,'2023-12-10 15:48:51','2023-12-10 15:48:51'),(3309,'default','payment_edited',1733,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4100.0000\"}}',NULL,'2023-12-10 15:48:52','2023-12-10 15:48:52'),(3310,'default','payment_edited',1743,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2000.0000\"}}',NULL,'2023-12-10 15:48:52','2023-12-10 15:48:52'),(3311,'default','payment_edited',1744,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4975.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4975.0000\"}}',NULL,'2023-12-10 15:48:52','2023-12-10 15:48:52'),(3312,'default','payment_edited',1744,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4975.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4975.0000\"}}',NULL,'2023-12-10 15:49:21','2023-12-10 15:49:21'),(3313,'default','added',1749,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":550}}',NULL,'2023-12-11 06:33:28','2023-12-11 06:33:28'),(3314,'default','added',1750,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-12-11 06:35:40','2023-12-11 06:35:40'),(3315,'default','added',1751,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3150}}',NULL,'2023-12-11 07:04:13','2023-12-11 07:04:13'),(3316,'default','added',1752,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1800}}',NULL,'2023-12-11 07:54:28','2023-12-11 07:54:28'),(3317,'default','added',1753,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6800}}',NULL,'2023-12-11 10:13:13','2023-12-11 10:13:13'),(3318,'default','edited',1751,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3650},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3150.0000\"}}',NULL,'2023-12-11 11:12:03','2023-12-11 11:12:03'),(3319,'default','edited',1748,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3000.0000\"}}',NULL,'2023-12-11 12:51:26','2023-12-11 12:51:26'),(3320,'default','payment_edited',1748,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3000.0000\"}}',NULL,'2023-12-11 13:03:03','2023-12-11 13:03:03'),(3321,'default','edited',1752,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1800.0000\"}}',NULL,'2023-12-11 13:04:29','2023-12-11 13:04:29'),(3322,'default','added',1754,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":650}}',NULL,'2023-12-11 14:58:20','2023-12-11 14:58:20'),(3323,'default','payment_edited',1754,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"650.0000\"}}',NULL,'2023-12-11 15:10:04','2023-12-11 15:10:04'),(3324,'default','edited',1751,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4988},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3650.0000\"}}',NULL,'2023-12-11 15:20:38','2023-12-11 15:20:38'),(3325,'default','payment_edited',1395,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1000.0000\"}}',NULL,'2023-12-11 15:56:12','2023-12-11 15:56:12'),(3326,'default','payment_edited',1751,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4988.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4988.0000\"}}',NULL,'2023-12-11 15:56:12','2023-12-11 15:56:12'),(3327,'default','edited',1668,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":53640},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"49844.0000\"}}',NULL,'2023-12-12 06:32:50','2023-12-12 06:32:50'),(3328,'default','edited',1668,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":53640},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"53640.0000\"}}',NULL,'2023-12-12 06:34:36','2023-12-12 06:34:36'),(3329,'default','added',1755,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-12-12 07:21:15','2023-12-12 07:21:15'),(3330,'default','added',1756,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2300}}',NULL,'2023-12-12 09:51:20','2023-12-12 09:51:20'),(3331,'default','added',1757,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2450}}',NULL,'2023-12-12 09:56:24','2023-12-12 09:56:24'),(3332,'default','added',1758,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2}}',NULL,'2023-12-12 10:06:37','2023-12-12 10:06:37'),(3333,'default','added',1759,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4660}}',NULL,'2023-12-12 10:35:40','2023-12-12 10:35:40'),(3334,'default','added',776,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-12 11:00:18','2023-12-12 11:00:18'),(3335,'default','added',1760,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2600}}',NULL,'2023-12-12 11:01:55','2023-12-12 11:01:55'),(3336,'default','edited',1757,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2450.0000\"}}',NULL,'2023-12-12 11:50:31','2023-12-12 11:50:31'),(3337,'default','added',1762,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2}}',NULL,'2023-12-12 12:29:33','2023-12-12 12:29:33'),(3338,'default','edited',1762,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2.0000\"}}',NULL,'2023-12-12 12:29:56','2023-12-12 12:29:56'),(3339,'default','added',1763,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2023-12-12 12:57:25','2023-12-12 12:57:25'),(3340,'default','edited',1757,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4100.0000\"}}',NULL,'2023-12-12 13:05:53','2023-12-12 13:05:53'),(3341,'default','added',1764,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":120}}',NULL,'2023-12-12 13:07:13','2023-12-12 13:07:13'),(3342,'default','edited',1759,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4600},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4660.0000\"}}',NULL,'2023-12-12 13:09:26','2023-12-12 13:09:26'),(3343,'default','payment_edited',1636,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2860.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2860.0000\"}}',NULL,'2023-12-12 13:15:55','2023-12-12 13:15:55'),(3344,'default','payment_edited',1703,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"460.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"460.0000\"}}',NULL,'2023-12-12 13:15:55','2023-12-12 13:15:55'),(3345,'default','payment_edited',1724,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"600.0000\"}}',NULL,'2023-12-12 13:15:55','2023-12-12 13:15:55'),(3346,'default','payment_edited',1759,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4600.0000\"}}',NULL,'2023-12-12 13:15:55','2023-12-12 13:15:55'),(3347,'default','added',777,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-12 13:37:54','2023-12-12 13:37:54'),(3348,'default','added',1765,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1800}}',NULL,'2023-12-12 13:40:03','2023-12-12 13:40:03'),(3349,'default','payment_edited',1756,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2300.0000\"}}',NULL,'2023-12-12 13:45:08','2023-12-12 13:45:08'),(3350,'default','sell_deleted',1753,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1753,\"invoice_no\":\"ITH2023-12085\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6800.0000\"}}',NULL,'2023-12-12 13:46:09','2023-12-12 13:46:09'),(3351,'default','payment_edited',1668,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"53640.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"53640.0000\"}}',NULL,'2023-12-12 14:45:32','2023-12-12 14:45:32'),(3352,'default','edited',1757,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4500.0000\"}}',NULL,'2023-12-12 15:48:42','2023-12-12 15:48:42'),(3353,'default','payment_edited',1642,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"800.0000\"}}',NULL,'2023-12-12 16:21:05','2023-12-12 16:21:05'),(3354,'default','payment_edited',1752,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-12-12 16:21:24','2023-12-12 16:21:24'),(3355,'default','payment_edited',1764,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"120.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"120.0000\"}}',NULL,'2023-12-12 16:21:37','2023-12-12 16:21:37'),(3356,'default','added',778,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-13 05:55:25','2023-12-13 05:55:25'),(3357,'default','added',1766,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-12-13 05:55:38','2023-12-13 05:55:38'),(3358,'default','added',1767,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":520}}',NULL,'2023-12-13 06:17:06','2023-12-13 06:17:06'),(3359,'default','payment_edited',1726,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"9100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"9100.0000\"}}',NULL,'2023-12-13 08:22:28','2023-12-13 08:22:28'),(3360,'default','payment_edited',1304,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"900.0000\"}}',NULL,'2023-12-13 08:57:22','2023-12-13 08:57:22'),(3361,'default','payment_edited',1729,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"12000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12000.0000\"}}',NULL,'2023-12-13 11:13:57','2023-12-13 11:13:57'),(3362,'default','payment_edited',1495,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4100.0000\"}}',NULL,'2023-12-13 11:37:59','2023-12-13 11:37:59'),(3363,'default','added',1768,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2700}}',NULL,'2023-12-13 11:38:20','2023-12-13 11:38:20'),(3364,'default','added',779,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-13 12:38:00','2023-12-13 12:38:00'),(3365,'default','added',1769,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}',NULL,'2023-12-13 12:38:21','2023-12-13 12:38:21'),(3366,'default','added',1770,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6904}}',NULL,'2023-12-13 13:53:15','2023-12-13 13:53:15'),(3367,'default','payment_edited',1693,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"700.0000\"}}',NULL,'2023-12-13 13:58:41','2023-12-13 13:58:41'),(3368,'default','edited',1609,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5000.0000\"}}',NULL,'2023-12-13 13:59:25','2023-12-13 13:59:25'),(3369,'default','added',1771,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11864}}',NULL,'2023-12-13 14:32:28','2023-12-13 14:32:28'),(3370,'default','payment_edited',1593,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"900.0000\"}}',NULL,'2023-12-13 15:52:46','2023-12-13 15:52:46'),(3371,'default','payment_edited',1621,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}',NULL,'2023-12-13 15:52:46','2023-12-13 15:52:46'),(3372,'default','payment_edited',1623,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"100.0000\"}}',NULL,'2023-12-13 15:52:46','2023-12-13 15:52:46'),(3373,'default','payment_edited',1647,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"540.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"540.0000\"}}',NULL,'2023-12-13 15:52:46','2023-12-13 15:52:46'),(3374,'default','payment_edited',1648,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2300.0000\"}}',NULL,'2023-12-13 15:52:46','2023-12-13 15:52:46'),(3375,'default','added',1772,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11200}}',NULL,'2023-12-14 05:23:50','2023-12-14 05:23:50'),(3376,'default','added',1773,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5200}}',NULL,'2023-12-14 06:05:53','2023-12-14 06:05:53'),(3377,'default','added',1774,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-12-14 07:22:04','2023-12-14 07:22:04'),(3378,'default','added',780,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-14 07:30:39','2023-12-14 07:30:39'),(3379,'default','added',1775,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6350}}',NULL,'2023-12-14 07:34:17','2023-12-14 07:34:17'),(3380,'default','added',781,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-14 10:09:27','2023-12-14 10:09:27'),(3381,'default','added',1776,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1500}}',NULL,'2023-12-14 10:10:23','2023-12-14 10:10:23'),(3382,'default','added',1777,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6900}}',NULL,'2023-12-14 10:24:25','2023-12-14 10:24:25'),(3383,'default','added',1778,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400}}',NULL,'2023-12-14 13:38:50','2023-12-14 13:38:50'),(3384,'default','added',1779,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4100}}',NULL,'2023-12-14 14:10:09','2023-12-14 14:10:09'),(3385,'default','added',1780,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900}}',NULL,'2023-12-14 14:38:00','2023-12-14 14:38:00'),(3386,'default','added',1781,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2023-12-14 14:57:26','2023-12-14 14:57:26'),(3387,'default','payment_edited',1768,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2700.0000\"}}',NULL,'2023-12-14 15:43:17','2023-12-14 15:43:17'),(3388,'default','edited',1772,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11200.0000\"}}',NULL,'2023-12-14 15:46:40','2023-12-14 15:46:40'),(3389,'default','payment_edited',1772,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10200.0000\"}}',NULL,'2023-12-14 15:46:56','2023-12-14 15:46:56'),(3390,'default','payment_edited',1700,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"20700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"20700.0000\"}}',NULL,'2023-12-14 15:47:13','2023-12-14 15:47:13'),(3391,'default','payment_edited',1714,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8100.0000\"}}',NULL,'2023-12-14 15:47:27','2023-12-14 15:47:27'),(3392,'default','added',1782,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":10200}}',NULL,'2023-12-14 16:12:11','2023-12-14 16:12:11'),(3393,'default','payment_edited',1651,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-12-16 05:37:46','2023-12-16 05:37:46'),(3394,'default','payment_edited',1782,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"10200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"10200.0000\"}}',NULL,'2023-12-16 05:37:46','2023-12-16 05:37:46'),(3395,'default','payment_edited',1620,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3700.0000\"}}',NULL,'2023-12-16 05:39:41','2023-12-16 05:39:41'),(3396,'default','payment_edited',1664,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"530.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"530.0000\"}}',NULL,'2023-12-16 05:39:41','2023-12-16 05:39:41'),(3397,'default','added',1784,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1050}}',NULL,'2023-12-16 05:42:22','2023-12-16 05:42:22'),(3398,'default','added',1785,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4600}}',NULL,'2023-12-16 05:49:59','2023-12-16 05:49:59'),(3399,'default','payment_edited',1744,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4975.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4975.0000\"}}',NULL,'2023-12-16 05:55:56','2023-12-16 05:55:56'),(3400,'default','payment_edited',1773,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5200.0000\"}}',NULL,'2023-12-16 05:55:56','2023-12-16 05:55:56'),(3401,'default','payment_edited',1785,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4600.0000\"}}',NULL,'2023-12-16 05:55:56','2023-12-16 05:55:56'),(3402,'default','added',1786,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4660}}',NULL,'2023-12-16 08:05:32','2023-12-16 08:05:32'),(3403,'default','added',1788,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}',NULL,'2023-12-16 13:00:01','2023-12-16 13:00:01'),(3404,'default','added',1789,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6600}}',NULL,'2023-12-17 06:11:51','2023-12-17 06:11:51'),(3405,'default','edited',1789,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6600},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6600.0000\"}}',NULL,'2023-12-17 06:12:41','2023-12-17 06:12:41'),(3406,'default','edited',1770,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10797},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6904.0000\"}}',NULL,'2023-12-17 07:17:02','2023-12-17 07:17:02'),(3407,'default','edited',1771,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7971},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11864.0000\"}}',NULL,'2023-12-17 07:19:42','2023-12-17 07:19:42'),(3408,'default','added',782,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-17 07:34:16','2023-12-17 07:34:16'),(3409,'default','added',1790,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":14400}}',NULL,'2023-12-17 07:35:32','2023-12-17 07:35:32'),(3410,'default','added',1791,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700}}',NULL,'2023-12-17 10:21:19','2023-12-17 10:21:19'),(3411,'default','added',1792,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":21200}}',NULL,'2023-12-17 10:42:58','2023-12-17 10:42:58'),(3412,'default','added',1793,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4000}}',NULL,'2023-12-17 10:44:13','2023-12-17 10:44:13'),(3413,'default','edited',1786,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4600},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4660.0000\"}}',NULL,'2023-12-17 11:00:14','2023-12-17 11:00:14'),(3414,'default','added',1794,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":870}}',NULL,'2023-12-17 13:05:28','2023-12-17 13:05:28'),(3415,'default','edited',1791,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"700.0000\"}}',NULL,'2023-12-17 14:11:20','2023-12-17 14:11:20'),(3416,'default','payment_edited',1792,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"21200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"21200.0000\"}}',NULL,'2023-12-17 14:33:34','2023-12-17 14:33:34'),(3417,'default','added',1795,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":7385}}',NULL,'2023-12-17 14:54:33','2023-12-17 14:54:33'),(3418,'default','edited',1789,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6600.0000\"}}',NULL,'2023-12-17 15:23:55','2023-12-17 15:23:55'),(3419,'default','payment_edited',1795,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7385.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7385.0000\"}}',NULL,'2023-12-17 15:24:46','2023-12-17 15:24:46'),(3420,'default','payment_edited',1759,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4600.0000\"}}',NULL,'2023-12-17 15:31:55','2023-12-17 15:31:55'),(3421,'default','edited',1668,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":57750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"53640.0000\"}}',NULL,'2023-12-18 04:49:47','2023-12-18 04:49:47'),(3422,'default','added',783,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-18 05:43:54','2023-12-18 05:43:54'),(3423,'default','added',1796,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":6600}}',NULL,'2023-12-18 05:52:10','2023-12-18 05:52:10'),(3424,'default','added',1797,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2150}}',NULL,'2023-12-18 06:16:15','2023-12-18 06:16:15'),(3425,'default','payment_edited',1605,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"78000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"78000.0000\"}}',NULL,'2023-12-18 06:17:40','2023-12-18 06:17:40'),(3426,'default','payment_edited',1790,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"14400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"14400.0000\"}}',NULL,'2023-12-18 06:37:23','2023-12-18 06:37:23'),(3427,'default','added',784,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-18 09:23:12','2023-12-18 09:23:12'),(3428,'default','added',1798,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6150}}',NULL,'2023-12-18 09:27:36','2023-12-18 09:27:36'),(3429,'default','added',1799,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4000}}',NULL,'2023-12-18 13:07:30','2023-12-18 13:07:30'),(3430,'default','added',1800,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3050}}',NULL,'2023-12-18 14:08:35','2023-12-18 14:08:35'),(3431,'default','payment_edited',1648,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2300.0000\"}}',NULL,'2023-12-18 14:20:47','2023-12-18 14:20:47'),(3432,'default','payment_edited',1648,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2300.0000\"}}',NULL,'2023-12-18 14:21:50','2023-12-18 14:21:50'),(3433,'default','added',1801,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2350}}',NULL,'2023-12-18 14:29:48','2023-12-18 14:29:48'),(3434,'default','payment_edited',1759,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4600.0000\"}}',NULL,'2023-12-18 14:51:55','2023-12-18 14:51:55'),(3435,'default','payment_edited',1779,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4100.0000\"}}',NULL,'2023-12-18 14:51:55','2023-12-18 14:51:55'),(3436,'default','payment_edited',1777,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6900.0000\"}}',NULL,'2023-12-18 15:08:52','2023-12-18 15:08:52'),(3437,'default','added',785,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-19 06:50:48','2023-12-19 06:50:48'),(3438,'default','added',1802,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-19 06:52:39','2023-12-19 06:52:39'),(3439,'default','payment_edited',1746,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2100.0000\"}}',NULL,'2023-12-19 07:42:32','2023-12-19 07:42:32'),(3440,'default','payment_edited',1800,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3050.0000\"}}',NULL,'2023-12-19 07:45:34','2023-12-19 07:45:34'),(3441,'default','added',1803,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5600}}',NULL,'2023-12-19 07:46:16','2023-12-19 07:46:16'),(3442,'default','added',1804,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6100}}',NULL,'2023-12-19 07:47:02','2023-12-19 07:47:02'),(3443,'default','edited',1803,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5600.0000\"}}',NULL,'2023-12-19 08:12:16','2023-12-19 08:12:16'),(3444,'default','added',786,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-19 08:40:09','2023-12-19 08:40:09'),(3445,'default','added',1805,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":23662}}',NULL,'2023-12-19 08:59:41','2023-12-19 08:59:41'),(3446,'default','edited',1805,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":23662},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"23662.0000\"}}',NULL,'2023-12-19 10:02:35','2023-12-19 10:02:35'),(3447,'default','edited',1803,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":2360},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8000.0000\"}}',NULL,'2023-12-19 11:49:10','2023-12-19 11:49:10'),(3448,'default','added',1806,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3950}}',NULL,'2023-12-19 12:58:14','2023-12-19 12:58:14'),(3449,'default','added',1807,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700}}',NULL,'2023-12-19 13:42:05','2023-12-19 13:42:05'),(3450,'default','added',1808,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400}}',NULL,'2023-12-19 14:08:06','2023-12-19 14:08:06'),(3451,'default','edited',1805,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":24960},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"23662.0000\"}}',NULL,'2023-12-19 15:37:38','2023-12-19 15:37:38'),(3452,'default','payment_edited',1805,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"24960.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"24960.0000\"}}',NULL,'2023-12-19 15:39:48','2023-12-19 15:39:48'),(3453,'default','added',1809,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3900}}',NULL,'2023-12-20 08:13:51','2023-12-20 08:13:51'),(3454,'default','added',1810,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8100}}',NULL,'2023-12-20 10:04:23','2023-12-20 10:04:23'),(3455,'default','added',1811,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2950}}',NULL,'2023-12-20 13:12:58','2023-12-20 13:12:58'),(3456,'default','added',1812,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5600}}',NULL,'2023-12-20 13:14:43','2023-12-20 13:14:43'),(3457,'default','sell_deleted',1798,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1798,\"invoice_no\":\"ITH2023-12127\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6150.0000\"}}',NULL,'2023-12-20 13:15:16','2023-12-20 13:15:16'),(3458,'default','payment_edited',1797,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2150.0000\"}}',NULL,'2023-12-20 13:15:35','2023-12-20 13:15:35'),(3459,'default','added',1813,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3800}}',NULL,'2023-12-20 13:28:45','2023-12-20 13:28:45'),(3460,'default','payment_edited',1804,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6100.0000\"}}',NULL,'2023-12-20 13:45:26','2023-12-20 13:45:26'),(3461,'default','added',1814,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6350}}',NULL,'2023-12-20 15:03:32','2023-12-20 15:03:32'),(3462,'default','added',1815,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3150}}',NULL,'2023-12-21 06:16:11','2023-12-21 06:16:11'),(3463,'default','payment_edited',1715,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2000.0000\"}}',NULL,'2023-12-21 09:39:35','2023-12-21 09:39:35'),(3464,'default','payment_edited',1808,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-12-21 10:26:04','2023-12-21 10:26:04'),(3465,'default','added',1816,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":1600}}',NULL,'2023-12-21 12:12:27','2023-12-21 12:12:27'),(3466,'default','added',1817,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2200}}',NULL,'2023-12-21 12:23:14','2023-12-21 12:23:14'),(3467,'default','added',1818,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3050}}',NULL,'2023-12-21 13:36:23','2023-12-21 13:36:23'),(3468,'default','added',1819,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2080}}',NULL,'2023-12-21 13:41:43','2023-12-21 13:41:43'),(3469,'default','added',787,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-21 13:43:48','2023-12-21 13:43:48'),(3470,'default','added',1820,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2850}}',NULL,'2023-12-21 13:45:53','2023-12-21 13:45:53'),(3471,'default','added',788,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-21 16:26:04','2023-12-21 16:26:04'),(3472,'default','added',1821,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1050}}',NULL,'2023-12-21 16:26:13','2023-12-21 16:26:13'),(3473,'default','edited',1819,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3850},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2080.0000\"}}',NULL,'2023-12-21 16:29:09','2023-12-21 16:29:09'),(3474,'default','sell_deleted',1730,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1730,\"invoice_no\":\"ITH2023-12064\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4150.0000\"}}',NULL,'2023-12-21 16:40:29','2023-12-21 16:40:29'),(3475,'default','added',789,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-23 04:32:55','2023-12-23 04:32:55'),(3476,'default','added',1822,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1150}}',NULL,'2023-12-23 04:33:54','2023-12-23 04:33:54'),(3477,'default','edited',1819,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3700},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3850.0000\"}}',NULL,'2023-12-23 05:25:37','2023-12-23 05:25:37'),(3478,'default','added',1823,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3950}}',NULL,'2023-12-23 06:03:17','2023-12-23 06:03:17'),(3479,'default','added',1824,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":900}}',NULL,'2023-12-23 07:03:34','2023-12-23 07:03:34'),(3480,'default','added',1825,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4700}}',NULL,'2023-12-23 09:38:57','2023-12-23 09:38:57'),(3481,'default','added',1826,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700}}',NULL,'2023-12-23 10:37:43','2023-12-23 10:37:43'),(3482,'default','edited',1826,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1075},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"700.0000\"}}',NULL,'2023-12-23 10:40:30','2023-12-23 10:40:30'),(3483,'default','added',1827,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1570}}',NULL,'2023-12-23 15:12:16','2023-12-23 15:12:16'),(3484,'default','added',790,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-24 10:13:39','2023-12-24 10:13:39'),(3485,'default','added',1828,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}',NULL,'2023-12-24 10:14:15','2023-12-24 10:14:15'),(3486,'default','edited',1825,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4700.0000\"}}',NULL,'2023-12-24 10:39:44','2023-12-24 10:39:44'),(3487,'default','payment_edited',1818,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3050.0000\"}}',NULL,'2023-12-24 10:40:01','2023-12-24 10:40:01'),(3488,'default','edited',1826,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":650},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1075.0000\"}}',NULL,'2023-12-24 10:43:08','2023-12-24 10:43:08'),(3489,'default','added',1829,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4975}}',NULL,'2023-12-24 15:00:49','2023-12-24 15:00:49'),(3490,'default','edited',1829,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2850},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4975.0000\"}}',NULL,'2023-12-24 15:07:39','2023-12-24 15:07:39'),(3491,'default','payment_edited',1664,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"530.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"530.0000\"}}',NULL,'2023-12-24 15:08:08','2023-12-24 15:08:08'),(3492,'default','payment_edited',1667,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2870.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2870.0000\"}}',NULL,'2023-12-24 15:08:08','2023-12-24 15:08:08'),(3493,'default','payment_edited',1767,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"520.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"520.0000\"}}',NULL,'2023-12-24 15:08:08','2023-12-24 15:08:08'),(3494,'default','payment_edited',1814,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6350.0000\"}}',NULL,'2023-12-24 15:08:08','2023-12-24 15:08:08'),(3495,'default','payment_edited',1785,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4600.0000\"}}',NULL,'2023-12-24 15:08:22','2023-12-24 15:08:22'),(3496,'default','payment_edited',1794,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"870.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"870.0000\"}}',NULL,'2023-12-24 15:08:22','2023-12-24 15:08:22'),(3497,'default','payment_edited',1806,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3950.0000\"}}',NULL,'2023-12-24 15:08:22','2023-12-24 15:08:22'),(3498,'default','payment_edited',1825,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3000.0000\"}}',NULL,'2023-12-24 15:08:39','2023-12-24 15:08:39'),(3499,'default','payment_edited',1819,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3700.0000\"}}',NULL,'2023-12-25 05:07:32','2023-12-25 05:07:32'),(3500,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2023-12-25 08:09:58','2023-12-25 08:09:58'),(3501,'default','added',1830,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-12-25 08:30:15','2023-12-25 08:30:15'),(3502,'default','edited',1830,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"}}',NULL,'2023-12-25 08:30:34','2023-12-25 08:30:34'),(3503,'default','payment_edited',1610,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5350.0000\"}}',NULL,'2023-12-25 08:36:18','2023-12-25 08:36:18'),(3504,'default','payment_edited',1830,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2023-12-25 08:36:18','2023-12-25 08:36:18'),(3505,'default','added',1831,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2080}}',NULL,'2023-12-25 08:40:51','2023-12-25 08:40:51'),(3506,'default','added',1832,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":970}}',NULL,'2023-12-25 09:04:12','2023-12-25 09:04:12'),(3507,'default','added',791,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-25 11:05:30','2023-12-25 11:05:30'),(3508,'default','added',1833,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":37450}}',NULL,'2023-12-25 11:30:06','2023-12-25 11:30:06'),(3509,'default','edited',1833,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":34550},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"37450.0000\"}}',NULL,'2023-12-25 12:35:01','2023-12-25 12:35:01'),(3510,'default','edited',1833,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":35150},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"34550.0000\"}}',NULL,'2023-12-25 14:02:48','2023-12-25 14:02:48'),(3511,'default','added',1835,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1500}}',NULL,'2023-12-25 14:03:49','2023-12-25 14:03:49'),(3512,'default','edited',1833,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":35150},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"35150.0000\"}}',NULL,'2023-12-25 14:53:48','2023-12-25 14:53:48'),(3513,'default','edited',1833,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":34200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"35150.0000\"}}',NULL,'2023-12-25 14:55:24','2023-12-25 14:55:24'),(3514,'default','payment_edited',1637,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2023-12-26 05:11:46','2023-12-26 05:11:46'),(3515,'default','payment_edited',1813,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3800.0000\"}}',NULL,'2023-12-26 05:29:45','2023-12-26 05:29:45'),(3516,'default','edited',1814,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4320},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6350.0000\"}}',NULL,'2023-12-26 07:35:56','2023-12-26 07:35:56'),(3517,'default','added',1836,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":16350}}',NULL,'2023-12-26 07:39:34','2023-12-26 07:39:34'),(3518,'default','edited',1836,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"16350.0000\"}}',NULL,'2023-12-26 07:40:36','2023-12-26 07:40:36'),(3519,'default','added',1837,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":5600}}',NULL,'2023-12-26 07:59:51','2023-12-26 07:59:51'),(3520,'default','added',792,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-26 09:52:59','2023-12-26 09:52:59'),(3521,'default','added',1838,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2023-12-26 09:55:06','2023-12-26 09:55:06'),(3522,'default','added',1839,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1350}}',NULL,'2023-12-26 10:18:57','2023-12-26 10:18:57'),(3523,'default','added',1840,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6600}}',NULL,'2023-12-26 10:43:33','2023-12-26 10:43:33'),(3524,'default','payment_edited',1811,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2950.0000\"}}',NULL,'2023-12-26 10:43:57','2023-12-26 10:43:57'),(3525,'default','added',793,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-26 11:46:39','2023-12-26 11:46:39'),(3526,'default','added',1841,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500}}',NULL,'2023-12-26 11:47:36','2023-12-26 11:47:36'),(3527,'default','edited',1841,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2500.0000\"}}',NULL,'2023-12-26 11:48:12','2023-12-26 11:48:12'),(3528,'default','added',1842,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3493}}',NULL,'2023-12-26 12:25:28','2023-12-26 12:25:28'),(3529,'default','added',794,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-26 14:13:17','2023-12-26 14:13:17'),(3530,'default','added',1843,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":9100}}',NULL,'2023-12-26 14:15:19','2023-12-26 14:15:19'),(3531,'default','added',795,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-26 14:20:06','2023-12-26 14:20:06'),(3532,'default','added',1844,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2800}}',NULL,'2023-12-26 14:21:11','2023-12-26 14:21:11'),(3533,'default','edited',1842,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1150},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3493.0000\"}}',NULL,'2023-12-26 15:39:22','2023-12-26 15:39:22'),(3534,'default','payment_edited',1668,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"57750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"57750.0000\"}}',NULL,'2023-12-26 15:40:39','2023-12-26 15:40:39'),(3535,'default','added',1845,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5300}}',NULL,'2023-12-26 15:48:23','2023-12-26 15:48:23'),(3536,'default','sell_deleted',1842,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1842,\"invoice_no\":\"ITH2023-12170\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1150.0000\"}}',NULL,'2023-12-27 05:35:06','2023-12-27 05:35:06'),(3537,'default','edited',1835,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":875},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2023-12-27 05:41:03','2023-12-27 05:41:03'),(3538,'default','payment_edited',1814,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4320.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4320.0000\"}}',NULL,'2023-12-27 05:41:57','2023-12-27 05:41:57'),(3539,'default','payment_edited',1829,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2850.0000\"}}',NULL,'2023-12-27 05:41:57','2023-12-27 05:41:57'),(3540,'default','added',1846,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1740}}',NULL,'2023-12-27 06:20:20','2023-12-27 06:20:20'),(3541,'default','edited',1846,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1740.0000\"}}',NULL,'2023-12-27 15:39:45','2023-12-27 15:39:45'),(3542,'default','payment_edited',1648,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2300.0000\"}}',NULL,'2023-12-27 15:43:33','2023-12-27 15:43:33'),(3543,'default','payment_edited',1675,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2050.0000\"}}',NULL,'2023-12-27 15:43:33','2023-12-27 15:43:33'),(3544,'default','payment_edited',1682,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1280.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1280.0000\"}}',NULL,'2023-12-27 15:43:33','2023-12-27 15:43:33'),(3545,'default','payment_edited',1696,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2850.0000\"}}',NULL,'2023-12-27 15:43:33','2023-12-27 15:43:33'),(3546,'default','added',1847,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":600}}',NULL,'2023-12-27 15:46:01','2023-12-27 15:46:01'),(3547,'default','added',1848,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4500}}',NULL,'2023-12-27 15:47:14','2023-12-27 15:47:14'),(3548,'default','edited',456,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-27 15:48:45','2023-12-27 15:48:45'),(3549,'default','added',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2023-12-27 16:02:15','2023-12-27 16:02:15'),(3550,'default','edited',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":190000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"0.0000\"}}',NULL,'2023-12-27 16:02:47','2023-12-27 16:02:47'),(3551,'default','edited',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":190000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"190000.0000\"}}',NULL,'2023-12-27 16:03:22','2023-12-27 16:03:22'),(3552,'default','edited',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":190000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"190000.0000\"}}',NULL,'2023-12-28 04:36:52','2023-12-28 04:36:52'),(3553,'default','payment_edited',1845,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5300.0000\"}}',NULL,'2023-12-28 04:40:27','2023-12-28 04:40:27'),(3554,'default','edited',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":190000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"190000.0000\"}}',NULL,'2023-12-28 04:49:10','2023-12-28 04:49:10'),(3555,'default','payment_edited',1007,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2023-12-28 11:48:29','2023-12-28 11:48:29'),(3556,'default','payment_edited',1046,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2023-12-28 11:48:29','2023-12-28 11:48:29'),(3557,'default','edited',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":190000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"190000.0000\"}}',NULL,'2023-12-28 15:41:18','2023-12-28 15:41:18'),(3558,'default','added',796,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-30 05:01:02','2023-12-30 05:01:02'),(3559,'default','added',1851,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":32040}}',NULL,'2023-12-30 05:24:17','2023-12-30 05:24:17'),(3560,'default','edited',1851,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":32322},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"32040.0000\"}}',NULL,'2023-12-30 05:55:51','2023-12-30 05:55:51'),(3561,'default','edited',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":192950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"190000.0000\"}}',NULL,'2023-12-30 05:57:53','2023-12-30 05:57:53'),(3562,'default','added',1853,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":600}}',NULL,'2023-12-30 06:16:19','2023-12-30 06:16:19'),(3563,'default','edited',1853,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":600},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"600.0000\"}}',NULL,'2023-12-30 06:16:34','2023-12-30 06:16:34'),(3564,'default','added',1854,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1400}}',NULL,'2023-12-30 06:17:38','2023-12-30 06:17:38'),(3565,'default','added',1855,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2023-12-30 06:35:44','2023-12-30 06:35:44'),(3566,'default','edited',1855,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1600.0000\"}}',NULL,'2023-12-30 06:35:58','2023-12-30 06:35:58'),(3567,'default','added',1857,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8200}}',NULL,'2023-12-30 08:07:44','2023-12-30 08:07:44'),(3568,'default','added',1858,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4900}}',NULL,'2023-12-30 08:52:07','2023-12-30 08:52:07'),(3569,'default','edited',1857,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8200},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8200.0000\"}}',NULL,'2023-12-30 09:15:11','2023-12-30 09:15:11'),(3570,'default','edited',1851,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":32340},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"32322.0000\"}}',NULL,'2023-12-30 11:33:06','2023-12-30 11:33:06'),(3571,'default','edited',1857,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8200.0000\"}}',NULL,'2023-12-30 11:34:57','2023-12-30 11:34:57'),(3572,'default','edited',1851,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":33212},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"32340.0000\"}}',NULL,'2023-12-30 11:38:01','2023-12-30 11:38:01'),(3573,'default','added',1859,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3800}}',NULL,'2023-12-30 13:09:21','2023-12-30 13:09:21'),(3574,'default','edited',1859,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3800.0000\"}}',NULL,'2023-12-30 13:46:17','2023-12-30 13:46:17'),(3575,'default','added',1860,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":500}}',NULL,'2023-12-30 14:21:37','2023-12-30 14:21:37'),(3576,'default','edited',1860,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"}}',NULL,'2023-12-30 14:21:56','2023-12-30 14:21:56'),(3577,'default','payment_edited',1858,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4900.0000\"}}',NULL,'2023-12-30 14:23:23','2023-12-30 14:23:23'),(3578,'default','added',1861,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2023-12-30 14:24:12','2023-12-30 14:24:12'),(3579,'default','added',797,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-30 14:33:16','2023-12-30 14:33:16'),(3580,'default','added',1862,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500}}',NULL,'2023-12-30 14:34:05','2023-12-30 14:34:05'),(3581,'default','edited',1858,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1450},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4900.0000\"}}',NULL,'2023-12-30 16:27:56','2023-12-30 16:27:56'),(3582,'default','edited',1859,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3050},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3800.0000\"}}',NULL,'2023-12-30 16:30:08','2023-12-30 16:30:08'),(3583,'default','payment_edited',1829,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2850.0000\"}}',NULL,'2023-12-30 16:36:08','2023-12-30 16:36:08'),(3584,'default','payment_edited',1837,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5600.0000\"}}',NULL,'2023-12-30 16:36:08','2023-12-30 16:36:08'),(3585,'default','added',1863,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1450}}',NULL,'2023-12-31 11:10:13','2023-12-31 11:10:13'),(3586,'default','added',798,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-31 11:31:13','2023-12-31 11:31:13'),(3587,'default','added',1864,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-12-31 11:31:33','2023-12-31 11:31:33'),(3588,'default','added',1865,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2950}}',NULL,'2023-12-31 13:53:20','2023-12-31 13:53:20'),(3589,'default','payment_edited',1848,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4500.0000\"}}',NULL,'2023-12-31 13:55:35','2023-12-31 13:55:35'),(3590,'default','payment_edited',1846,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1100.0000\"}}',NULL,'2023-12-31 13:55:45','2023-12-31 13:55:45'),(3591,'default','payment_edited',1857,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8000.0000\"}}',NULL,'2023-12-31 13:55:54','2023-12-31 13:55:54'),(3592,'default','payment_edited',1851,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"33212.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"33212.0000\"}}',NULL,'2023-12-31 13:56:02','2023-12-31 13:56:02'),(3593,'default','payment_edited',1840,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6600.0000\"}}',NULL,'2023-12-31 13:56:31','2023-12-31 13:56:31'),(3594,'default','added',1866,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2200}}',NULL,'2023-12-31 13:58:06','2023-12-31 13:58:06'),(3595,'default','added',799,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2023-12-31 14:28:17','2023-12-31 14:28:17'),(3596,'default','added',1867,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2023-12-31 14:28:49','2023-12-31 14:28:49'),(3597,'default','added',1868,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":29600}}',NULL,'2024-01-01 07:20:28','2024-01-01 07:20:28'),(3598,'default','payment_edited',1565,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2024-01-01 07:22:08','2024-01-01 07:22:08'),(3599,'default','payment_edited',1609,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5000.0000\"}}',NULL,'2024-01-01 07:22:23','2024-01-01 07:22:23'),(3600,'default','payment_edited',1861,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2024-01-01 07:28:17','2024-01-01 07:28:17'),(3601,'default','payment_edited',1863,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1450.0000\"}}',NULL,'2024-01-01 07:28:39','2024-01-01 07:28:39'),(3602,'default','payment_edited',956,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4800.0000\"}}',NULL,'2024-01-01 07:29:07','2024-01-01 07:29:07'),(3603,'default','payment_edited',1765,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1800.0000\"}}',NULL,'2024-01-01 08:14:43','2024-01-01 08:14:43'),(3604,'default','added',1869,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":800}}',NULL,'2024-01-01 08:15:29','2024-01-01 08:15:29'),(3605,'default','payment_edited',1750,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2024-01-01 08:28:20','2024-01-01 08:28:20'),(3606,'default','added',1870,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":4350}}',NULL,'2024-01-01 14:20:28','2024-01-01 14:20:28'),(3607,'default','sell_deleted',1870,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1870,\"invoice_no\":\"2024\\/0061\",\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"4350.0000\"}}',NULL,'2024-01-01 14:22:46','2024-01-01 14:22:46'),(3608,'default','added',1871,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1900}}',NULL,'2024-01-02 06:27:58','2024-01-02 06:27:58'),(3609,'default','added',1872,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2375}}',NULL,'2024-01-02 06:35:02','2024-01-02 06:35:02'),(3610,'default','added',1873,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":10600}}',NULL,'2024-01-02 06:38:12','2024-01-02 06:38:12'),(3611,'default','edited',1873,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6250},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10600.0000\"}}',NULL,'2024-01-02 06:51:42','2024-01-02 06:51:42'),(3612,'default','edited',1872,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2375.0000\"}}',NULL,'2024-01-02 06:52:05','2024-01-02 06:52:05'),(3613,'default','added',1874,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3700}}',NULL,'2024-01-02 07:31:19','2024-01-02 07:31:19'),(3614,'default','added',1875,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":450}}',NULL,'2024-01-02 07:56:35','2024-01-02 07:56:35'),(3615,'default','added',1876,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":600}}',NULL,'2024-01-02 08:49:55','2024-01-02 08:49:55'),(3616,'default','added',1877,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":700}}',NULL,'2024-01-02 10:10:54','2024-01-02 10:10:54'),(3617,'default','added',800,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-02 11:03:31','2024-01-02 11:03:31'),(3618,'default','added',1878,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2350}}',NULL,'2024-01-02 11:04:00','2024-01-02 11:04:00'),(3619,'default','added',1879,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":11550}}',NULL,'2024-01-02 11:09:41','2024-01-02 11:09:41'),(3620,'default','added',1880,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3350}}',NULL,'2024-01-02 11:21:36','2024-01-02 11:21:36'),(3621,'default','added',1881,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2024-01-02 12:35:40','2024-01-02 12:35:40'),(3622,'default','added',1882,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":25816}}',NULL,'2024-01-02 16:04:48','2024-01-02 16:04:48'),(3623,'default','edited',1879,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12050},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"11550.0000\"}}',NULL,'2024-01-02 16:11:36','2024-01-02 16:11:36'),(3624,'default','edited',1871,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1900.0000\"}}',NULL,'2024-01-02 16:15:46','2024-01-02 16:15:46'),(3625,'default','edited',1871,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1350.0000\"}}',NULL,'2024-01-02 16:16:14','2024-01-02 16:16:14'),(3626,'default','payment_edited',539,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"24750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"24750.0000\"}}',NULL,'2024-01-02 16:18:59','2024-01-02 16:18:59'),(3627,'default','payment_edited',516,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"34362.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"34362.0000\"}}',NULL,'2024-01-02 16:19:49','2024-01-02 16:19:49'),(3628,'default','added',1883,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300}}',NULL,'2024-01-02 16:39:29','2024-01-02 16:39:29'),(3629,'default','edited',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":192950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"192950.0000\"}}',NULL,'2024-01-02 16:43:03','2024-01-02 16:43:03'),(3630,'default','edited',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":170246},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"192950.0000\"}}',NULL,'2024-01-02 16:55:11','2024-01-02 16:55:11'),(3631,'default','edited',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":170246},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"170246.0000\"}}',NULL,'2024-01-02 16:58:58','2024-01-02 16:58:58'),(3632,'default','edited',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":177246},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"170246.0000\"}}',NULL,'2024-01-02 17:07:25','2024-01-02 17:07:25'),(3633,'default','edited',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":177546},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"177246.0000\"}}',NULL,'2024-01-02 17:18:45','2024-01-02 17:18:45'),(3634,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-01-03 06:06:02','2024-01-03 06:06:02'),(3635,'default','added',1884,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":32549}}',NULL,'2024-01-03 06:11:04','2024-01-03 06:11:04'),(3636,'default','edited',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":175696},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"177546.0000\"}}',NULL,'2024-01-03 06:17:38','2024-01-03 06:17:38'),(3637,'default','added',1885,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":16850}}',NULL,'2024-01-03 06:19:26','2024-01-03 06:19:26'),(3638,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-01-03 06:21:03','2024-01-03 06:21:03'),(3639,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-01-03 08:39:23','2024-01-03 08:39:23'),(3640,'default','added',1887,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8500}}',NULL,'2024-01-03 08:41:14','2024-01-03 08:41:14'),(3641,'default','added',1888,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":13500}}',NULL,'2024-01-03 08:56:09','2024-01-03 08:56:09'),(3642,'default','edited',1888,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":14850},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"13500.0000\"}}',NULL,'2024-01-03 08:58:47','2024-01-03 08:58:47'),(3643,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-01-03 08:59:21','2024-01-03 08:59:21'),(3644,'default','edited',1888,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":14850},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"14850.0000\"}}',NULL,'2024-01-03 09:15:47','2024-01-03 09:15:47'),(3645,'default','added',1889,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2950}}',NULL,'2024-01-03 12:33:29','2024-01-03 12:33:29'),(3646,'default','payment_edited',1696,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2850.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2850.0000\"}}',NULL,'2024-01-03 12:37:24','2024-01-03 12:37:24'),(3647,'default','payment_edited',1732,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1250.0000\"}}',NULL,'2024-01-03 12:37:24','2024-01-03 12:37:24'),(3648,'default','payment_edited',1738,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"900.0000\"}}',NULL,'2024-01-03 12:37:24','2024-01-03 12:37:24'),(3649,'default','edited',1889,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3350},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2950.0000\"}}',NULL,'2024-01-03 12:38:53','2024-01-03 12:38:53'),(3650,'default','added',1890,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":4200}}',NULL,'2024-01-03 12:54:26','2024-01-03 12:54:26'),(3651,'default','payment_edited',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"175696.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"175696.0000\"}}',NULL,'2024-01-03 13:41:02','2024-01-03 13:41:02'),(3652,'default','added',1891,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":799}}',NULL,'2024-01-03 13:42:24','2024-01-03 13:42:24'),(3653,'default','edited',1438,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2100.0000\"}}',NULL,'2024-01-03 13:48:55','2024-01-03 13:48:55'),(3654,'default','payment_edited',1438,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2000.0000\"}}',NULL,'2024-01-03 13:50:24','2024-01-03 13:50:24'),(3655,'default','edited',1888,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":15550},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"14850.0000\"}}',NULL,'2024-01-03 13:53:28','2024-01-03 13:53:28'),(3656,'default','payment_edited',1879,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"12050.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"12050.0000\"}}',NULL,'2024-01-03 15:11:52','2024-01-03 15:11:52'),(3657,'default','payment_edited',1779,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4100.0000\"}}',NULL,'2024-01-03 15:13:08','2024-01-03 15:13:08'),(3658,'default','payment_edited',1786,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4600.0000\"}}',NULL,'2024-01-03 15:13:08','2024-01-03 15:13:08'),(3659,'default','payment_edited',1617,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"13400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"13400.0000\"}}',NULL,'2024-01-03 15:22:06','2024-01-03 15:22:06'),(3660,'default','sell_deleted',1770,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1770,\"invoice_no\":\"ITH2023-12101\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"10797.0000\"}}',NULL,'2024-01-03 15:22:17','2024-01-03 15:22:17'),(3661,'default','sell_deleted',1771,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1771,\"invoice_no\":\"ITH2023-12102\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"7971.0000\"}}',NULL,'2024-01-03 15:22:23','2024-01-03 15:22:23'),(3662,'default','payment_edited',1876,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"600.0000\"}}',NULL,'2024-01-03 15:23:37','2024-01-03 15:23:37'),(3663,'default','added',1892,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2250}}',NULL,'2024-01-04 06:01:37','2024-01-04 06:01:37'),(3664,'default','added',1893,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2024-01-04 06:03:00','2024-01-04 06:03:00'),(3665,'default','payment_edited',489,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6420.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6420.0000\"}}',NULL,'2024-01-04 06:05:45','2024-01-04 06:05:45'),(3666,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-01-04 06:39:48','2024-01-04 06:39:48'),(3667,'default','logout',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-01-04 06:43:45','2024-01-04 06:43:46'),(3668,'default','added',1894,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2750}}',NULL,'2024-01-04 06:57:39','2024-01-04 06:57:39'),(3669,'default','payment_edited',1738,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"900.0000\"}}',NULL,'2024-01-04 07:48:40','2024-01-04 07:48:40'),(3670,'default','payment_edited',1745,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"400.0000\"}}',NULL,'2024-01-04 07:48:40','2024-01-04 07:48:40'),(3671,'default','payment_edited',1757,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2024-01-04 07:48:40','2024-01-04 07:48:40'),(3672,'default','payment_edited',1778,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"400.0000\"}}',NULL,'2024-01-04 07:48:40','2024-01-04 07:48:40'),(3673,'default','payment_edited',1791,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"400.0000\"}}',NULL,'2024-01-04 07:48:40','2024-01-04 07:48:40'),(3674,'default','payment_edited',1812,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5600.0000\"}}',NULL,'2024-01-04 07:48:40','2024-01-04 07:48:40'),(3675,'default','added',1896,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3900}}',NULL,'2024-01-04 08:06:34','2024-01-04 08:06:34'),(3676,'default','added',1897,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":12600}}',NULL,'2024-01-04 08:44:38','2024-01-04 08:44:38'),(3677,'default','edited',1897,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":13100},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"12600.0000\"}}',NULL,'2024-01-04 08:45:59','2024-01-04 08:45:59'),(3678,'default','edited',1897,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":12800},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"13100.0000\"}}',NULL,'2024-01-04 08:46:17','2024-01-04 08:46:17'),(3679,'default','edited',1897,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":14700},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"12800.0000\"}}',NULL,'2024-01-04 08:58:55','2024-01-04 08:58:55'),(3680,'default','sell_deleted',1894,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1894,\"invoice_no\":\"ITH2024-12214\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2750.0000\"}}',NULL,'2024-01-04 10:43:49','2024-01-04 10:43:49'),(3681,'default','payment_edited',1576,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"36488.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"36488.0000\"}}',NULL,'2024-01-04 10:59:06','2024-01-04 10:59:06'),(3682,'default','added',1898,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4800}}',NULL,'2024-01-04 11:40:17','2024-01-04 11:40:17'),(3683,'default','edited',1898,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4800.0000\"}}',NULL,'2024-01-04 11:49:33','2024-01-04 11:49:33'),(3684,'default','edited',1898,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2400.0000\"}}',NULL,'2024-01-04 11:50:21','2024-01-04 11:50:21'),(3685,'default','added',1899,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2950}}',NULL,'2024-01-04 12:35:32','2024-01-04 12:35:32'),(3686,'default','sell_deleted',1899,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1899,\"invoice_no\":\"ITH2024-12217\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2950.0000\"}}',NULL,'2024-01-04 12:42:12','2024-01-04 12:42:12'),(3687,'default','added',1900,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}',NULL,'2024-01-04 12:48:47','2024-01-04 12:48:47'),(3688,'default','added',1901,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3350}}',NULL,'2024-01-04 13:08:33','2024-01-04 13:08:33'),(3689,'default','added',801,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-04 13:29:22','2024-01-04 13:29:22'),(3690,'default','added',1902,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":600}}',NULL,'2024-01-04 13:29:45','2024-01-04 13:29:45'),(3691,'default','added',802,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-04 13:44:29','2024-01-04 13:44:29'),(3692,'default','added',1903,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2024-01-04 13:44:57','2024-01-04 13:44:57'),(3693,'default','payment_edited',1850,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"175696.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"175696.0000\"}}',NULL,'2024-01-04 14:30:58','2024-01-04 14:30:58'),(3694,'default','added',1904,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":6400}}',NULL,'2024-01-04 15:09:47','2024-01-04 15:09:47'),(3695,'default','added',1905,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3950}}',NULL,'2024-01-04 15:37:20','2024-01-04 15:37:20'),(3696,'default','edited',1900,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1750},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1750.0000\"}}',NULL,'2024-01-04 16:51:52','2024-01-04 16:51:52'),(3697,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-01-06 05:32:57','2024-01-06 05:32:57'),(3698,'default','added',1906,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1350}}',NULL,'2024-01-06 05:37:25','2024-01-06 05:37:25'),(3699,'default','added',803,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-06 07:45:17','2024-01-06 07:45:17'),(3700,'default','added',1907,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2024-01-06 07:46:32','2024-01-06 07:46:32'),(3701,'default','added',1908,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3920}}',NULL,'2024-01-06 08:23:23','2024-01-06 08:23:23'),(3702,'default','payment_edited',1908,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3920.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3920.0000\"}}',NULL,'2024-01-06 10:20:52','2024-01-06 10:20:52'),(3703,'default','added',1909,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1350}}',NULL,'2024-01-06 10:21:19','2024-01-06 10:21:19'),(3704,'default','added',1910,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1160}}',NULL,'2024-01-06 10:58:52','2024-01-06 10:58:52'),(3705,'default','edited',1909,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1450},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1350.0000\"}}',NULL,'2024-01-06 11:44:06','2024-01-06 11:44:06'),(3706,'default','added',1911,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":20620}}',NULL,'2024-01-06 12:56:31','2024-01-06 12:56:31'),(3707,'default','payment_edited',1806,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3950.0000\"}}',NULL,'2024-01-06 13:01:19','2024-01-06 13:01:19'),(3708,'default','payment_edited',1823,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3950.0000\"}}',NULL,'2024-01-06 13:01:19','2024-01-06 13:01:19'),(3709,'default','added',1912,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2024-01-06 14:07:27','2024-01-06 14:07:27'),(3710,'default','edited',1646,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":12000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12000.0000\"}}',NULL,'2024-01-08 05:29:51','2024-01-08 05:29:51'),(3711,'default','payment_edited',1646,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"12000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"12000.0000\"}}',NULL,'2024-01-08 05:33:54','2024-01-08 05:33:54'),(3712,'default','payment_edited',1902,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"600.0000\"}}',NULL,'2024-01-08 05:35:46','2024-01-08 05:35:46'),(3713,'default','added',1913,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1800}}',NULL,'2024-01-08 05:38:58','2024-01-08 05:38:58'),(3714,'default','added',1914,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":29720}}',NULL,'2024-01-08 06:25:19','2024-01-08 06:25:19'),(3715,'default','added',1915,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":41000}}',NULL,'2024-01-08 06:29:56','2024-01-08 06:29:56'),(3716,'default','added',1916,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1750}}',NULL,'2024-01-08 06:39:50','2024-01-08 06:39:50'),(3717,'default','added',1917,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1600}}',NULL,'2024-01-08 06:40:40','2024-01-08 06:40:40'),(3718,'default','added',804,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-08 07:42:04','2024-01-08 07:42:04'),(3719,'default','added',1918,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2450}}',NULL,'2024-01-08 07:42:30','2024-01-08 07:42:30'),(3720,'default','added',1920,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3800}}',NULL,'2024-01-08 07:53:38','2024-01-08 07:53:38'),(3721,'default','added',1921,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2887}}',NULL,'2024-01-08 08:41:50','2024-01-08 08:41:50'),(3722,'default','added',1922,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2250}}',NULL,'2024-01-08 09:57:16','2024-01-08 09:57:16'),(3723,'default','edited',1914,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":16372},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"29720.0000\"}}',NULL,'2024-01-08 10:28:45','2024-01-08 10:28:45'),(3724,'default','edited',1922,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2250.0000\"}}',NULL,'2024-01-08 10:29:09','2024-01-08 10:29:09'),(3725,'default','edited',1914,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":20488},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"16372.0000\"}}',NULL,'2024-01-08 13:23:09','2024-01-08 13:23:09'),(3726,'default','edited',1914,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":20558},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"20488.0000\"}}',NULL,'2024-01-08 13:25:50','2024-01-08 13:25:50'),(3727,'default','edited',1921,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2887},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2887.0000\"}}',NULL,'2024-01-08 13:41:04','2024-01-08 13:41:04'),(3728,'default','added',1923,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300}}',NULL,'2024-01-08 13:49:53','2024-01-08 13:49:53'),(3729,'default','added',805,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-08 14:41:21','2024-01-08 14:41:21'),(3730,'default','added',1924,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":36850}}',NULL,'2024-01-08 15:02:31','2024-01-08 15:02:31'),(3731,'default','edited',1924,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":40120},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"36850.0000\"}}',NULL,'2024-01-08 15:05:28','2024-01-08 15:05:28'),(3732,'default','edited',1924,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":40120},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"40120.0000\"}}',NULL,'2024-01-08 15:09:42','2024-01-08 15:09:42'),(3733,'default','edited',1921,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5137},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2887.0000\"}}',NULL,'2024-01-08 15:11:58','2024-01-08 15:11:58'),(3734,'default','payment_edited',1869,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"800.0000\"}}',NULL,'2024-01-08 15:26:42','2024-01-08 15:26:42'),(3735,'default','added',1925,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1800}}',NULL,'2024-01-09 06:38:26','2024-01-09 06:38:26'),(3736,'default','edited',1921,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":6264},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"5137.0000\"}}',NULL,'2024-01-09 06:41:47','2024-01-09 06:41:47'),(3737,'default','payment_edited',1396,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"400.0000\"}}',NULL,'2024-01-09 06:45:49','2024-01-09 06:45:49'),(3738,'default','payment_edited',1657,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"586.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"586.0000\"}}',NULL,'2024-01-09 06:45:49','2024-01-09 06:45:49'),(3739,'default','payment_edited',1921,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6264.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6264.0000\"}}',NULL,'2024-01-09 06:45:49','2024-01-09 06:45:49'),(3740,'default','added',806,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-09 07:25:07','2024-01-09 07:25:07'),(3741,'default','added',1926,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3400}}',NULL,'2024-01-09 07:27:34','2024-01-09 07:27:34'),(3742,'default','edited',1926,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":3300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3400.0000\"}}',NULL,'2024-01-09 07:28:44','2024-01-09 07:28:44'),(3743,'default','edited',1926,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":4500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3300.0000\"}}',NULL,'2024-01-09 07:30:06','2024-01-09 07:30:06'),(3744,'default','added',1927,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3100}}',NULL,'2024-01-09 08:04:53','2024-01-09 08:04:53'),(3745,'default','payment_edited',1812,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5600.0000\"}}',NULL,'2024-01-09 08:07:33','2024-01-09 08:07:33'),(3746,'default','payment_edited',1812,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5600.0000\"}}',NULL,'2024-01-09 08:08:41','2024-01-09 08:08:41'),(3747,'default','payment_edited',1826,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"650.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"650.0000\"}}',NULL,'2024-01-09 08:08:41','2024-01-09 08:08:41'),(3748,'default','payment_edited',1865,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2950.0000\"}}',NULL,'2024-01-09 08:08:41','2024-01-09 08:08:41'),(3749,'default','payment_edited',1605,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"78000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"78000.0000\"}}',NULL,'2024-01-09 08:24:35','2024-01-09 08:24:35'),(3750,'default','payment_edited',1718,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"22000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"22000.0000\"}}',NULL,'2024-01-09 08:25:20','2024-01-09 08:25:20'),(3751,'default','payment_edited',1328,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2024-01-09 08:28:17','2024-01-09 08:28:17'),(3752,'default','payment_edited',1824,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"900.0000\"}}',NULL,'2024-01-09 08:28:29','2024-01-09 08:28:29'),(3753,'default','added',1928,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":0}}',NULL,'2024-01-09 08:35:06','2024-01-09 08:35:06'),(3754,'default','edited',1927,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1550},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3100.0000\"}}',NULL,'2024-01-09 08:53:44','2024-01-09 08:53:44'),(3755,'default','added',1929,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":14310}}',NULL,'2024-01-09 09:19:26','2024-01-09 09:19:26'),(3756,'default','edited',1922,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4540},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4500.0000\"}}',NULL,'2024-01-09 10:25:50','2024-01-09 10:25:50'),(3757,'default','added',1930,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1200}}',NULL,'2024-01-09 10:27:13','2024-01-09 10:27:13'),(3758,'default','added',1931,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2950}}',NULL,'2024-01-09 13:36:59','2024-01-09 13:36:59'),(3759,'default','payment_edited',1866,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2200.0000\"}}',NULL,'2024-01-09 13:50:14','2024-01-09 13:50:14'),(3760,'default','added',1933,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1480}}',NULL,'2024-01-09 14:19:57','2024-01-09 14:19:57'),(3761,'default','edited',1933,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3430},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1480.0000\"}}',NULL,'2024-01-09 14:43:35','2024-01-09 14:43:35'),(3762,'default','payment_edited',1923,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2024-01-09 15:28:23','2024-01-09 15:28:23'),(3763,'default','added',1934,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2024-01-10 05:22:13','2024-01-10 05:22:13'),(3764,'default','payment_edited',1823,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3950.0000\"}}',NULL,'2024-01-10 06:18:23','2024-01-10 06:18:23'),(3765,'default','payment_edited',1835,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"875.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"875.0000\"}}',NULL,'2024-01-10 06:18:23','2024-01-10 06:18:23'),(3766,'default','payment_edited',1900,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1750.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1750.0000\"}}',NULL,'2024-01-10 06:18:23','2024-01-10 06:18:23'),(3767,'default','payment_edited',1910,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1160.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1160.0000\"}}',NULL,'2024-01-10 06:18:23','2024-01-10 06:18:23'),(3768,'default','payment_edited',1931,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2950.0000\"}}',NULL,'2024-01-10 06:18:23','2024-01-10 06:18:23'),(3769,'default','added',1935,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1200}}',NULL,'2024-01-10 07:12:20','2024-01-10 07:12:20'),(3770,'default','payment_edited',1925,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1800.0000\"}}',NULL,'2024-01-10 07:47:14','2024-01-10 07:47:14'),(3771,'default','added',1936,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":700}}',NULL,'2024-01-10 12:21:47','2024-01-10 12:21:47'),(3772,'default','edited',1936,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":700},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"final_total\":\"700.0000\"}}',NULL,'2024-01-10 12:23:06','2024-01-10 12:23:06'),(3773,'default','payment_edited',1901,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3350.0000\"}}',NULL,'2024-01-10 12:24:36','2024-01-10 12:24:36'),(3774,'default','edited',2,'App\\User',NULL,1,1,'App\\User','{\"name\":\" abdul ahad\"}',NULL,'2024-01-10 13:13:51','2024-01-10 13:13:51'),(3775,'default','edited',1,'App\\User',NULL,1,1,'App\\User','{\"name\":\"Md Faysal Islam Rupu\"}',NULL,'2024-01-10 13:15:14','2024-01-10 13:15:14'),(3776,'default','added',807,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-10 13:21:59','2024-01-10 13:21:59'),(3777,'default','added',1937,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2024-01-10 13:22:28','2024-01-10 13:22:28'),(3778,'default','payment_edited',1922,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4540.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4540.0000\"}}',NULL,'2024-01-10 14:12:38','2024-01-10 14:12:38'),(3779,'default','payment_edited',1865,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2950.0000\"}}',NULL,'2024-01-10 14:16:33','2024-01-10 14:16:33'),(3780,'default','payment_edited',1873,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"6250.0000\"}}',NULL,'2024-01-10 14:16:33','2024-01-10 14:16:33'),(3781,'default','payment_edited',1909,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1450.0000\"}}',NULL,'2024-01-10 14:41:09','2024-01-10 14:41:09'),(3782,'default','added',1938,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1950}}',NULL,'2024-01-10 14:55:12','2024-01-10 14:55:12'),(3783,'default','edited',1938,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1950.0000\"}}',NULL,'2024-01-10 14:55:31','2024-01-10 14:55:31'),(3784,'default','payment_edited',1905,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3950.0000\"}}',NULL,'2024-01-10 15:25:16','2024-01-10 15:25:16'),(3785,'default','payment_edited',1873,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6250.0000\"}}',NULL,'2024-01-10 15:37:57','2024-01-10 15:37:57'),(3786,'default','edited',1920,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":12300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3800.0000\"}}',NULL,'2024-01-11 06:39:33','2024-01-11 06:39:33'),(3787,'default','sell_deleted',1887,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1887,\"invoice_no\":\"ITH2024-12208\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"8500.0000\"}}',NULL,'2024-01-11 06:39:49','2024-01-11 06:39:49'),(3788,'default','added',1939,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1550}}',NULL,'2024-01-11 08:00:09','2024-01-11 08:00:09'),(3789,'default','payment_edited',1934,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1700.0000\"}}',NULL,'2024-01-11 08:38:01','2024-01-11 08:38:01'),(3790,'default','added',1940,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1800}}',NULL,'2024-01-11 09:17:36','2024-01-11 09:17:36'),(3791,'default','added',1941,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2}}',NULL,'2024-01-11 11:45:44','2024-01-11 11:45:44'),(3792,'default','added',1942,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1700}}',NULL,'2024-01-11 11:52:21','2024-01-11 11:52:21'),(3793,'default','added',808,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-11 12:00:31','2024-01-11 12:00:31'),(3794,'default','added',1943,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1}}',NULL,'2024-01-11 12:05:04','2024-01-11 12:05:04'),(3795,'default','edited',1941,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2.0000\"}}',NULL,'2024-01-11 12:05:49','2024-01-11 12:05:49'),(3796,'default','edited',1933,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1950},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3430.0000\"}}',NULL,'2024-01-11 13:08:54','2024-01-11 13:08:54'),(3797,'default','payment_edited',1921,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6264.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6264.0000\"}}',NULL,'2024-01-11 13:14:04','2024-01-11 13:14:04'),(3798,'default','added',1944,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":5400}}',NULL,'2024-01-11 13:18:35','2024-01-11 13:18:35'),(3799,'default','added',1945,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1150}}',NULL,'2024-01-11 13:19:40','2024-01-11 13:19:40'),(3800,'default','payment_edited',1837,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"5600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"5600.0000\"}}',NULL,'2024-01-11 13:47:01','2024-01-11 13:47:01'),(3801,'default','payment_edited',1855,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1800.0000\"}}',NULL,'2024-01-11 13:47:01','2024-01-11 13:47:01'),(3802,'default','payment_edited',1858,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1450.0000\"}}',NULL,'2024-01-11 13:47:01','2024-01-11 13:47:01'),(3803,'default','added',1946,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":480}}',NULL,'2024-01-11 13:47:35','2024-01-11 13:47:35'),(3804,'default','added',809,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-11 14:25:39','2024-01-11 14:25:39'),(3805,'default','added',1947,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3600}}',NULL,'2024-01-11 14:26:20','2024-01-11 14:26:20'),(3806,'default','added',1948,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2800}}',NULL,'2024-01-11 15:03:01','2024-01-11 15:03:01'),(3807,'default','edited',767,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-11 15:25:41','2024-01-11 15:25:41'),(3808,'default','edited',767,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-11 15:26:25','2024-01-11 15:26:25'),(3809,'default','added',1949,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":92200}}',NULL,'2024-01-11 15:50:06','2024-01-11 15:50:06'),(3810,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-01-11 16:13:46','2024-01-11 16:13:46'),(3811,'default','payment_edited',1858,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1450.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1450.0000\"}}',NULL,'2024-01-11 16:15:15','2024-01-11 16:15:15'),(3812,'default','payment_edited',1860,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"500.0000\"}}',NULL,'2024-01-11 16:15:15','2024-01-11 16:15:15'),(3813,'default','payment_edited',1871,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1400.0000\"}}',NULL,'2024-01-11 16:15:15','2024-01-11 16:15:15'),(3814,'default','added',1950,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2900}}',NULL,'2024-01-13 06:40:51','2024-01-13 06:40:51'),(3815,'default','edited',1948,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2300},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2800.0000\"}}',NULL,'2024-01-13 06:53:13','2024-01-13 06:53:13'),(3816,'default','added',1951,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1700}}',NULL,'2024-01-13 07:40:42','2024-01-13 07:40:42'),(3817,'default','added',1952,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2800}}',NULL,'2024-01-13 12:34:31','2024-01-13 12:34:31'),(3818,'default','added',1953,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":900}}',NULL,'2024-01-13 13:40:25','2024-01-13 13:40:25'),(3819,'default','added',1954,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300}}',NULL,'2024-01-13 13:53:18','2024-01-13 13:53:18'),(3820,'default','added',1957,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":27450}}',NULL,'2024-01-13 15:17:07','2024-01-13 15:17:07'),(3821,'default','added',810,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-13 15:46:58','2024-01-13 15:46:58'),(3822,'default','added',1958,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2024-01-13 15:47:56','2024-01-13 15:47:56'),(3823,'default','edited',1958,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"}}',NULL,'2024-01-13 15:49:11','2024-01-13 15:49:11'),(3824,'default','added',811,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-14 07:17:36','2024-01-14 07:17:36'),(3825,'default','added',1959,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":14500}}',NULL,'2024-01-14 07:18:37','2024-01-14 07:18:37'),(3826,'default','added',812,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-14 09:25:35','2024-01-14 09:25:35'),(3827,'default','added',1960,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3900}}',NULL,'2024-01-14 09:58:32','2024-01-14 09:58:32'),(3828,'default','added',1961,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18780}}',NULL,'2024-01-14 10:10:56','2024-01-14 10:10:56'),(3829,'default','edited',1961,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18780},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"18780.0000\"}}',NULL,'2024-01-14 10:11:30','2024-01-14 10:11:30'),(3830,'default','edited',1961,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":18780},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"18780.0000\"}}',NULL,'2024-01-14 10:14:17','2024-01-14 10:14:17'),(3831,'default','edited',1960,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":7800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3900.0000\"}}',NULL,'2024-01-14 10:48:23','2024-01-14 10:48:23'),(3832,'default','added',1962,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4320}}',NULL,'2024-01-14 11:09:22','2024-01-14 11:09:22'),(3833,'default','added',1963,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1100}}',NULL,'2024-01-14 11:25:36','2024-01-14 11:25:36'),(3834,'default','added',1964,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300}}',NULL,'2024-01-14 12:04:10','2024-01-14 12:04:10'),(3835,'default','edited',1960,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3900},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"7800.0000\"}}',NULL,'2024-01-14 12:08:42','2024-01-14 12:08:42'),(3836,'default','payment_edited',1950,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2900.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2900.0000\"}}',NULL,'2024-01-14 13:03:01','2024-01-14 13:03:01'),(3837,'default','edited',1954,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":2500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3300.0000\"}}',NULL,'2024-01-14 13:06:36','2024-01-14 13:06:36'),(3838,'default','added',813,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-14 13:08:40','2024-01-14 13:08:40'),(3839,'default','added',1965,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1900}}',NULL,'2024-01-14 13:09:40','2024-01-14 13:09:40'),(3840,'default','added',1966,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000}}',NULL,'2024-01-14 13:13:13','2024-01-14 13:13:13'),(3841,'default','login',1,'App\\User',NULL,1,1,'App\\User','[]',NULL,'2024-01-14 13:16:42','2024-01-14 13:16:42'),(3842,'default','edited',1966,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2000.0000\"}}',NULL,'2024-01-14 13:18:02','2024-01-14 13:18:02'),(3843,'default','sell_deleted',1965,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1965,\"invoice_no\":\"ITH2024-12275\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1900.0000\"}}',NULL,'2024-01-14 13:18:27','2024-01-14 13:18:27'),(3844,'default','payment_edited',1871,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1400.0000\"}}',NULL,'2024-01-14 14:30:21','2024-01-14 14:30:21'),(3845,'default','payment_edited',1938,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1950.0000\"}}',NULL,'2024-01-14 14:30:21','2024-01-14 14:30:21'),(3846,'default','added',1967,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4600}}',NULL,'2024-01-14 16:04:15','2024-01-14 16:04:15'),(3847,'default','payment_edited',1949,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"92200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"92200.0000\"}}',NULL,'2024-01-15 05:12:56','2024-01-15 05:12:56'),(3848,'default','payment_edited',1967,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4600.0000\"}}',NULL,'2024-01-15 05:30:00','2024-01-15 05:30:00'),(3849,'default','added',1969,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18000}}',NULL,'2024-01-15 08:17:24','2024-01-15 08:17:24'),(3850,'default','edited',1969,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18120},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"18000.0000\"}}',NULL,'2024-01-15 08:18:26','2024-01-15 08:18:26'),(3851,'default','edited',1969,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18510},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"18120.0000\"}}',NULL,'2024-01-15 08:20:01','2024-01-15 08:20:01'),(3852,'default','added',1970,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4200}}',NULL,'2024-01-15 08:43:51','2024-01-15 08:43:51'),(3853,'default','added',1972,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":11000}}',NULL,'2024-01-15 09:23:44','2024-01-15 09:23:44'),(3854,'default','edited',1972,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":26000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"11000.0000\"}}',NULL,'2024-01-15 09:24:03','2024-01-15 09:24:03'),(3855,'default','added',814,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-15 11:55:16','2024-01-15 11:55:16'),(3856,'default','added',1973,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3700}}',NULL,'2024-01-15 11:56:13','2024-01-15 11:56:13'),(3857,'default','edited',1969,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":18670},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"18510.0000\"}}',NULL,'2024-01-15 12:27:16','2024-01-15 12:27:16'),(3858,'default','added',1974,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":500}}',NULL,'2024-01-15 12:55:33','2024-01-15 12:55:33'),(3859,'default','sell_deleted',879,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":879,\"invoice_no\":\"ITH2023-11335\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2700.0000\"}}',NULL,'2024-01-15 13:59:22','2024-01-15 13:59:22'),(3860,'default','payment_edited',1033,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"400.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"400.0000\"}}',NULL,'2024-01-15 13:59:28','2024-01-15 13:59:28'),(3861,'default','added',1975,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":800}}',NULL,'2024-01-15 14:00:20','2024-01-15 14:00:20'),(3862,'default','added',1976,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3950}}',NULL,'2024-01-15 14:31:52','2024-01-15 14:31:52'),(3863,'default','payment_edited',1931,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"2950.0000\"}}',NULL,'2024-01-15 14:32:34','2024-01-15 14:32:34'),(3864,'default','payment_edited',1945,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1150.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1150.0000\"}}',NULL,'2024-01-15 14:32:34','2024-01-15 14:32:34'),(3865,'default','payment_edited',1976,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3950.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3950.0000\"}}',NULL,'2024-01-15 14:32:34','2024-01-15 14:32:34'),(3866,'default','added',1977,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":9326}}',NULL,'2024-01-15 14:35:48','2024-01-15 14:35:48'),(3867,'default','edited',1969,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":17530},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"18670.0000\"}}',NULL,'2024-01-15 14:40:58','2024-01-15 14:40:58'),(3868,'default','payment_edited',1969,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"17530.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"17530.0000\"}}',NULL,'2024-01-15 14:41:55','2024-01-15 14:41:55'),(3869,'default','added',1978,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":15683}}',NULL,'2024-01-15 14:43:17','2024-01-15 14:43:17'),(3870,'default','payment_edited',1873,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"6250.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"6250.0000\"}}',NULL,'2024-01-16 05:56:37','2024-01-16 05:56:37'),(3871,'default','payment_edited',1889,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3350.0000\"}}',NULL,'2024-01-16 05:56:37','2024-01-16 05:56:37'),(3872,'default','added',1979,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":800}}',NULL,'2024-01-16 05:57:48','2024-01-16 05:57:48'),(3873,'default','added',1980,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":960}}',NULL,'2024-01-16 05:58:49','2024-01-16 05:58:49'),(3874,'default','payment_edited',1972,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"26000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"26000.0000\"}}',NULL,'2024-01-16 05:59:28','2024-01-16 05:59:28'),(3875,'default','payment_edited',1889,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3350.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3350.0000\"}}',NULL,'2024-01-16 06:53:24','2024-01-16 06:53:24'),(3876,'default','payment_edited',1654,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1100.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1100.0000\"}}',NULL,'2024-01-16 07:18:50','2024-01-16 07:18:50'),(3877,'default','payment_edited',1694,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1500.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1500.0000\"}}',NULL,'2024-01-16 07:18:50','2024-01-16 07:18:50'),(3878,'default','sell_deleted',1929,'App\\Transaction',NULL,1,1,'App\\User','{\"id\":1929,\"invoice_no\":\"ITH2024-12242\",\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"14310.0000\"}}',NULL,'2024-01-16 07:19:05','2024-01-16 07:19:05'),(3879,'default','payment_edited',1952,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"2800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"2800.0000\"}}',NULL,'2024-01-16 07:40:55','2024-01-16 07:40:55'),(3880,'default','payment_edited',1847,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"600.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"600.0000\"}}',NULL,'2024-01-16 07:54:14','2024-01-16 07:54:14'),(3881,'default','payment_edited',1922,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4540.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4540.0000\"}}',NULL,'2024-01-16 08:04:03','2024-01-16 08:04:03'),(3882,'default','payment_edited',1930,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1200.0000\"}}',NULL,'2024-01-16 08:04:03','2024-01-16 08:04:03'),(3883,'default','added',1981,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":860}}',NULL,'2024-01-16 08:13:15','2024-01-16 08:13:15'),(3884,'default','added',815,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-16 08:35:40','2024-01-16 08:35:40'),(3885,'default','added',1982,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":1750}}',NULL,'2024-01-16 08:36:53','2024-01-16 08:36:53'),(3886,'default','added',1983,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4550}}',NULL,'2024-01-16 09:00:18','2024-01-16 09:00:18'),(3887,'default','added',1984,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3300}}',NULL,'2024-01-16 10:15:50','2024-01-16 10:15:50'),(3888,'default','added',1986,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17800}}',NULL,'2024-01-16 10:35:14','2024-01-16 10:35:14'),(3889,'default','edited',1986,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":17800},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"17800.0000\"}}',NULL,'2024-01-16 10:35:29','2024-01-16 10:35:29'),(3890,'default','added',816,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-16 11:59:31','2024-01-16 11:59:31'),(3891,'default','added',1987,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2400}}',NULL,'2024-01-16 11:59:38','2024-01-16 11:59:38'),(3892,'default','added',817,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-16 12:18:01','2024-01-16 12:18:01'),(3893,'default','added',1988,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":750}}',NULL,'2024-01-16 12:19:30','2024-01-16 12:19:30'),(3894,'default','added',1990,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":4300}}',NULL,'2024-01-16 12:33:08','2024-01-16 12:33:08'),(3895,'default','added',1991,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1300}}',NULL,'2024-01-16 12:35:03','2024-01-16 12:35:03'),(3896,'default','payment_edited',1970,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4200.0000\"}}',NULL,'2024-01-16 12:35:23','2024-01-16 12:35:23'),(3897,'default','payment_edited',1991,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"1300.0000\"}}',NULL,'2024-01-16 12:50:34','2024-01-16 12:50:34'),(3898,'default','payment_edited',956,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4800.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4800.0000\"}}',NULL,'2024-01-16 12:52:18','2024-01-16 12:52:18'),(3899,'default','edited',1972,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":26000},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"26000.0000\"}}',NULL,'2024-01-16 13:25:50','2024-01-16 13:25:50'),(3900,'default','payment_edited',1972,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"26000.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"26000.0000\"}}',NULL,'2024-01-16 13:28:41','2024-01-16 13:28:41'),(3901,'default','added',1993,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":7800}}',NULL,'2024-01-16 13:36:53','2024-01-16 13:36:53'),(3902,'default','edited',1993,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":8400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"7800.0000\"}}',NULL,'2024-01-16 13:59:50','2024-01-16 13:59:50'),(3903,'default','edited',1993,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":8400},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"8400.0000\"}}',NULL,'2024-01-16 14:05:56','2024-01-16 14:05:56'),(3904,'default','added',1994,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":26820}}',NULL,'2024-01-16 14:21:38','2024-01-16 14:21:38'),(3905,'default','edited',1994,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":25820},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"final_total\":\"26820.0000\"}}',NULL,'2024-01-16 14:23:18','2024-01-16 14:23:18'),(3906,'default','added',818,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-16 14:24:34','2024-01-16 14:24:34'),(3907,'default','edited',1994,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":27320},\"old\":{\"type\":\"sell\",\"status\":\"draft\",\"sub_status\":\"quotation\",\"payment_status\":\"due\",\"final_total\":\"25820.0000\"}}',NULL,'2024-01-16 14:24:40','2024-01-16 14:24:40'),(3908,'default','payment_edited',1930,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"1200.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"1200.0000\"}}',NULL,'2024-01-16 15:41:09','2024-01-16 15:41:09'),(3909,'default','payment_edited',1983,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"4550.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4550.0000\"}}',NULL,'2024-01-16 15:41:09','2024-01-16 15:41:09'),(3910,'default','payment_edited',1819,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"3700.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"partial\",\"final_total\":\"3700.0000\"}}',NULL,'2024-01-16 16:00:55','2024-01-16 16:00:55'),(3911,'default','added',1995,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":2100}}',NULL,'2024-01-16 16:42:52','2024-01-16 16:42:52'),(3912,'default','added',1996,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":1750}}',NULL,'2024-01-17 05:14:55','2024-01-17 05:14:55'),(3913,'default','added',1997,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":3500}}',NULL,'2024-01-17 05:33:24','2024-01-17 05:33:24'),(3914,'default','added',819,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-17 07:45:26','2024-01-17 07:45:26'),(3915,'default','added',1998,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":260}}',NULL,'2024-01-17 07:46:31','2024-01-17 07:46:31'),(3916,'default','added',820,'App\\Contact',NULL,1,1,'App\\User','[]',NULL,'2024-01-17 07:52:34','2024-01-17 07:52:34'),(3917,'default','edited',1997,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":3500},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"3500.0000\"}}',NULL,'2024-01-17 07:52:40','2024-01-17 07:52:40'),(3918,'default','payment_edited',1990,'App\\Transaction',NULL,1,1,'App\\User','{\"attributes\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"paid\",\"final_total\":\"4300.0000\"},\"old\":{\"type\":\"sell\",\"status\":\"final\",\"payment_status\":\"due\",\"final_total\":\"4300.0000\"}}',NULL,'2024-01-17 07:52:53','2024-01-17 07:52:53'),(3919,'default','sell_deleted',1962,'App\\Transaction',NULL,1,1,'App\\U